using System;
using System.Collections;
using com.oucsoft.WSORM;

namespace com.oucsoft.WSORM
{

	public class MemberMapCollectionEnumerator : IEnumerator
	{
		private IEnumerator internalEnumerator = null;
 
		public MemberMapCollectionEnumerator(Hashtable internalHashtable)
		{
			this.internalEnumerator = internalHashtable.GetEnumerator();
		}
		public Object Current
		{
			get
			{
				return ((DictionaryEntry)this.internalEnumerator.Current).Value;
			}
		}
		public bool MoveNext()
		{
			return this.internalEnumerator.MoveNext();
		}
		public void Reset()
		{
			this.internalEnumerator.Reset();
		}
	}

	/// <summary>
	/// MemberMapļ
	/// </summary>
	public class MemberMapCollection : IEnumerable
	{

		private System.Collections.Hashtable members = null;

		/// <summary>
		/// 캯
		/// </summary>
		public MemberMapCollection()
		{
			this.members = new Hashtable();
			//this.enumerator = new MemberMapCollectionEnumerator(this.members);
		}

		public IEnumerator GetEnumerator()
		{
			return new MemberMapCollectionEnumerator(this.members);//this.members.GetEnumerator() );
			//return this.enumerator;
		}
											
		public void Clear()
		{
			//if ( this.members != null )
			this.members.Clear();
		}

		public MemberMap Add(MemberMap memberMap) 
		{
			if ( this.members.ContainsKey( memberMap.MemberName ) )
				this.members.Remove( memberMap.MemberName );
			
			this.members.Add( memberMap.MemberName, memberMap );
			return memberMap;
		}

		public MemberMap Add(string member, string field, DbFieldTypes type, MemberMapTypes mapType)
		{
			if ( this.members.ContainsKey( member ) )
				this.members.Remove( member );
			
			this.members.Add( member , new MemberMap(member,field,type,mapType) );
			return this[member];
		}

		public MemberMap Add(string member, string field, DbFieldTypes type, System.Type externalType, string externalField, MemberMapTypes mapType)
		{
			//public void Add(string member, string field, DbFieldTypes type, string externalType, string externalField, MemberMapTypes mapType)	
		
			if ( this.members.ContainsKey( member ) )
				this.members.Remove( member );
			
			this.members.Add( member , new MemberMap(member, field, type, externalType, externalField, mapType) );
			return this[member];
		}

		public void Remove(string membername)
		{
			this.members.Remove(membername);
		}

		public MemberMap this[string membername]
		{
			get{ return (MemberMap)this.members[membername]; }
		}
		

		public bool Contains(string membername)
		{
			return this.members.Contains( membername );
		}
		
		/// <summary>
		/// һ
		/// </summary>
		/// <returns></returns>
		public MemberMapCollection Clone()
		{
			MemberMapCollection newMaps = new MemberMapCollection();
			foreach ( MemberMap mmap in this )
			{
				newMaps.Add( mmap.Clone() );
			}
			return newMaps;
		}
	}


}
