using System;
using System.Data;
using System.Collections;

namespace com.oucsoft.WSORM
{
	/// <summary>
	/// SessionĻ
	/// </summary>
	internal class ObjectCache
	{

		public ObjectCache(ObjectMapCollection maps)
		{
			//this.factory = factory;
			this.objectMaps = maps;
		}


		#region ...

		private ObjectMapCollection objectMaps;
		private ObjectMapCollection ObjectMaps
		{
			get
			{
				return this.objectMaps;
			}
		}
		/*
		private SessionFactory factory;
		public SessionFactory Factory
		{
			get{ return this.factory; }
			set{ this.factory = value; }
		}
		*/
	
		/// <summary>
		/// ʵֵCacheģ
		/// һԶSystem.TypeFullNameʹ棬
		/// ʹͬ͵ĶڲͬıУ
		/// ڶʹID棬ûIDֱʹö
		/// </summary>
		private Hashtable typeCache = new Hashtable();
		
		#endregion


		/*
		/// <summary>
		/// ȡӦñĳԱֵ
		/// </summary>
		/// <param name="map">ӳϢ</param>
		/// <param name="obj">ҪĶ</param>
		/// <returns>ԳԱıԱֵHash</returns>
		private Hashtable getMemberValues(ObjectMap map, object obj)
		{
			Hashtable table = new Hashtable();
			foreach ( MemberMap mmap in map.MemberMaps )
			{
				if ( mmap.MemberMapType == MemberMapTypes.One2Many )
				{
					ArrayList templist = new ArrayList();
					IEnumerable en = (IEnumerable)MemberHelper.GetMemberValue(mmap.MemberName,obj);
					if( en != null )
					{
						foreach ( object tempobj in en )
						{
							templist.Add( tempobj );
						}
					}
					table.Add(mmap.MemberName, templist);
				}
				else
				{
					table.Add( mmap.MemberName, MemberHelper.GetMemberValue(mmap.MemberName,obj) );
				}
			}
			//#if DEBUG
			//			System.Diagnostics.Debug.WriteLine( "--------CACHE OBJECT--------");
			//			foreach(DictionaryEntry de in table)
			//				System.Diagnostics.Debug.WriteLine( "Member:\t" + de.Key.ToString() + ",\tValue:\t" + de.Value.ToString() );
			//#endif
			return table;
		}
		*/

		/// <summary>
		/// ¡һڻ
		/// </summary>
		/// <param name="map"></param>
		/// <param name="obj"></param>
		/// <returns></returns>
		private object cloneObject(ObjectMap map, object obj)
		{
			System.Type type = map.ObjectType;//obj.GetType();
			object newObj = Activator.CreateInstance(type);

			foreach ( MemberMap mmap in map.MemberMaps )
			{
				if ( mmap.MemberMapType != MemberMapTypes.One2Many && mmap.MemberMapType != MemberMapTypes.Many2One )
				{
					//MemberHelper.SetMemberValue( mmap.MemberName, newObj, MemberHelper.GetMemberValue(mmap.MemberName,obj) );
					System.Reflection.MemberInfo memberInfo = type.GetMember(mmap.MemberName)[0];
					if ( memberInfo.MemberType == System.Reflection.MemberTypes.Field )
					{
						System.Reflection.FieldInfo fieldInfo = ((System.Reflection.FieldInfo)memberInfo);
						//System.Type fieldType = fieldInfo.FieldType;//ֶ
						fieldInfo.SetValue( newObj , fieldInfo.GetValue(obj) );
					}
					else if ( memberInfo.MemberType == System.Reflection.MemberTypes.Property )
					{
						System.Reflection.PropertyInfo propertyInfo = ((System.Reflection.PropertyInfo)memberInfo);
						//System.Type propertyType = propertyInfo.PropertyType;
						propertyInfo.SetValue(newObj, propertyInfo.GetValue(obj,null) ,null);
					}
					//else
					//	throw new MemberTypeException("Ա" + memberInfo.Name +"FieldProperty");
				}
			}
			return newObj;
		}
	

		/// <summary>
		/// ĳĻϢ
		/// </summary>
		/// <param name="obj"></param>
		public void Add(object obj)
		{
			System.Type type = obj.GetType();

			ObjectMap map = this.ObjectMaps[type];//ObjectMap map = this.factory.ObjectMaps[typename];
			
			string typename = map.TypeFullName;
			
			if ( map.IsView == true )
				return;

			Hashtable objectCache;
			if ( ! this.typeCache.Contains(typename) )
			{
				objectCache = new Hashtable();
				this.typeCache.Add(typename, objectCache);
			}else
			{
				objectCache = ((Hashtable)this.typeCache[typename]);
			}

			if ( map.IDMemberMap != null )
			{
				string key = MemberHelper.GetMemberValue(map.IDMemberMap.MemberName, obj).ToString();
				if ( objectCache.Contains(key) )
					objectCache.Remove(key);
				
				objectCache.Add(key, this.cloneObject(map, obj));//objectCache.Add(key, this.getMemberValues(map,obj));
				System.Diagnostics.Debug.WriteLine( "----CACHE ADD OBJECT---- Type:\t" + typename + ", \tKey:\t" + key );  	
			}
			else if ( map.PrimaryKeyMemberMaps != null && map.PrimaryKeyMemberMaps.Length > 0 )
			{
				if ( objectCache.Contains(obj) )
					objectCache.Remove(obj);
				
				objectCache.Add(obj, this.cloneObject(map, obj));//objectCache.Add(obj, this.getMemberValues(map,obj));
				System.Diagnostics.Debug.WriteLine( "----CACHE ADD OBJECT---- Type:\t" + typename );  
			}
		}

		/// <summary>
		/// ڻƳĳĻϢ
		/// </summary>
		/// <param name="obj"></param>
		public void Remove(object obj)
		{
			System.Type type = obj.GetType();

			ObjectMap map = this.ObjectMaps[type];//ObjectMap map = this.factory.ObjectMaps[typename];
			
			string typename = map.TypeFullName;

			if ( map.IsView == true )
				return;
			if ( ! this.typeCache.Contains(typename) )
				return;
			Hashtable objectCache = ((Hashtable)this.typeCache[typename]);
			
			if ( map.IDMemberMap != null )
			{
				string key = MemberHelper.GetMemberValue(map.IDMemberMap.MemberName, obj).ToString();
				if ( objectCache.Contains(key) )
				{
					objectCache.Remove(key);
					System.Diagnostics.Debug.WriteLine( "----CACHE REMOVE OBJECT---- Type:\t" + typename + ", \tKey:\t" + key );  
				}
			}
			else if ( map.PrimaryKeyMemberMaps != null && map.PrimaryKeyMemberMaps.Length > 0 )
			{
				if ( objectCache.Contains(obj) )
				{
					objectCache.Remove(obj);
					System.Diagnostics.Debug.WriteLine( "----CACHE REMOVE OBJECT---- Type:\t" + typename );  
				}
			}
		}

		/// <summary>
		/// ǷĳĻϢ
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public bool Contains(object obj)
		{
			System.Type type = obj.GetType();

			ObjectMap map = this.ObjectMaps[type];//ObjectMap map = this.factory.ObjectMaps[typename];
			
			string typename = map.TypeFullName;

			if ( ! this.typeCache.Contains(typename) )
				return false;
			Hashtable objectCache = ((Hashtable)this.typeCache[typename]);
			
			if ( map.IDMemberMap != null )
			{
				string key = MemberHelper.GetMemberValue(map.IDMemberMap.MemberName, obj).ToString();
				return objectCache.Contains(key);
			}
			else if ( map.PrimaryKeyMemberMaps != null && map.PrimaryKeyMemberMaps.Length > 0 ) 
			{
				return objectCache.Contains(obj);
			}
			else
			{
				return false;
			}
		}


		/// <summary>
		/// Ѿ˵ֶ
		/// </summary>
		/// <param name="obj">Ķ</param>
		/// <returns></returns>
		public DbFieldCollection CheckChangedFields(object obj)
		{
			System.Type type = obj.GetType();

			ObjectMap map = this.ObjectMaps[type];//ObjectMap map = this.factory.ObjectMaps[typename];
			
			string typename = map.TypeFullName;

			if ( ! this.typeCache.Contains(typename) )
				throw new CacheObjectNotFoundException("ûзֻ" + typename + "");
			Hashtable objectCache = ((Hashtable)this.typeCache[typename]);
			
			if ( map.IDMemberMap != null )
			{
				string key = MemberHelper.GetMemberValue(map.IDMemberMap.MemberName, obj).ToString();
				if ( ! objectCache.Contains(key) )
					throw new CacheObjectNotFoundException("ûзֻ" + typename + "󣡸öID:" + key +"");
				//Hashtable members = (Hashtable)objectCache[key];
				//ȡûĶ
				object cachedObj = objectCache[key];
				DbFieldCollection changedFields = new DbFieldCollection();
				foreach(MemberMap mmap in map.MemberMaps)
				{
					if(mmap.MemberMapType == MemberMapTypes.One2Many)
					{}//do nothing
					else if(mmap.MemberMapType == MemberMapTypes.Many2One)
					{}//do nothing
					else
					{
						if (!mmap.Ignored)
						{
							//object cachedVal = members[mmap.MemberName];
							//ֵ
							object cachedVal = MemberHelper.GetMemberValue(mmap.MemberName,cachedObj);
							if( ! MemberHelper.MemberEquals(mmap.MemberName,obj,cachedVal) )
							{
								object currentVal = MemberHelper.GetMemberValue(mmap.MemberName,obj);//ǰֵ
								changedFields.Add( new DbField(mmap.FieldName,mmap.FieldType,currentVal) );
							}
						}
					}
				}
				return changedFields;
			}
			else if ( map.PrimaryKeyMemberMaps != null && map.PrimaryKeyMemberMaps.Length > 0 )
			{
				if ( ! objectCache.Contains(obj) )
					throw new CacheObjectNotFoundException("ûзֻ" + typename + "");
				//Hashtable members = (Hashtable)objectCache[obj];
				//ȡûĶ
				object cachedObj = objectCache[obj];
				DbFieldCollection changedFields = new DbFieldCollection();
				foreach(MemberMap mmap in map.PrimaryKeyMemberMaps)
				{
					//object cachedVal = members[mmap.MemberName];
					//ֵ
					object cachedVal = MemberHelper.GetMemberValue( mmap.MemberName, cachedObj);
					if( ! MemberHelper.MemberEquals(mmap.MemberName,obj,cachedVal) )//( ! currentVal.Equals( cachedVal ) )
					{
						throw new ChangedPrimaryKeyException("ܸı" + mmap.MemberName + "ֵ");
					}
				}
				foreach(MemberMap mmap in map.MemberMaps)
				{
					if(mmap.MemberMapType == MemberMapTypes.One2Many)
					{}//do nothing
					else if(mmap.MemberMapType == MemberMapTypes.Many2One)
					{}//do nothing
					else if(mmap.MemberMapType == MemberMapTypes.PrimaryKey)
					{}//do nothing
					else
					{
						if (!mmap.Ignored)
						{
							//object cachedVal = members[mmap.MemberName];
							//ֵ
							object cachedVal = MemberHelper.GetMemberValue( mmap.MemberName, cachedObj);
							if( ! MemberHelper.MemberEquals(mmap.MemberName,obj,cachedVal) )
							{
								object currentVal = MemberHelper.GetMemberValue(mmap.MemberName,obj);//ǰֵ
								changedFields.Add( new DbField(mmap.FieldName,mmap.FieldType,currentVal) );
							}
						}
					}
				}
				return changedFields;
			}
			else
			{
				throw new CacheObjectNotFoundException(""+ typename + "ûIDܻ棡");
			}
			
		}



	}
}
