using System;
using System.Collections;
using com.oucsoft.WSORM;

namespace com.oucsoft.WSORM
{

	public class ObjectMapCollectionEnumerator : IEnumerator
	{
		private IEnumerator internalEnumerator = null; 
		
		public ObjectMapCollectionEnumerator(Hashtable internalHashtable)
		{
			this.internalEnumerator = internalHashtable.GetEnumerator();
		}
		public Object Current
		{
			get
			{
				return ((DictionaryEntry)this.internalEnumerator.Current).Value;
			}
		}
		public bool MoveNext()
		{
			return this.internalEnumerator.MoveNext();
		}
		public void Reset()
		{
			this.internalEnumerator.Reset();
		}
	}

	/// <summary>
	/// ObjectMapļ
	/// </summary>
	public class ObjectMapCollection : IEnumerable
	{

		//private ObjectMapCollectionEnumerator enumerator = null;
		private System.Collections.Hashtable members = null;//new Hashtable();

		/// <summary>
		/// 캯
		/// </summary>
		public ObjectMapCollection()
		{
			this.members = new Hashtable();
			//this.enumerator = new ObjectMapCollectionEnumerator(this.members);
		}

		/*
		private ObjectMapCollection _sourceMaps = null;

		/// <summary>
		/// 캯
		/// </summary>
		/// <param name="sourceMaps"></param>
		public ObjectMapCollection(ObjectMapCollection sourceMaps)
		{
			this._sourceMaps = sourceMaps;
		}
		*/

		public IEnumerator GetEnumerator()
		{
			//return this.members.GetEnumerator();
			//return this.enumerator; //this.members.GetEnumerator() );
			return new ObjectMapCollectionEnumerator(this.members);
		}
											
		public void Clear()
		{
			//if ( this.members != null )
			this.members.Clear();
		}

		public void Add(ObjectMap omap)
		{
			//if( this.members == null )
			//	this.members = new Hashtable();

			if ( this.members.ContainsKey( omap.TypeFullName ) )
				this.members.Remove( omap.TypeFullName );
			
			this.members.Add( omap.TypeFullName , omap );
		}

		/*
		public void Remove(string typename)
		{
			this.members.Remove(typename);
		}
		*/

		public void Remove(System.Type type)
		{
			this.members.Remove(type.FullName);
		}

		public void Remove(ObjectMap omap)
		{
			this.members.Remove(omap.TypeFullName);
		}

		/*
		public ObjectMap this[string typename]
		{
			get{ return (ObjectMap)this.members[typename]; }
		}
		*/
		public ObjectMap this[System.Type type]
		{
			get
			{
				if ( this.members.Contains( type.FullName) )
				{
					return (ObjectMap)this.members[type.FullName]; 
				}
				else
				{
					foreach (DictionaryEntry entry in this.members)
					{
						ObjectMap map = (ObjectMap)entry.Value ;
						if ( type.IsSubclassOf( map.ObjectType ) )
						{
							return map;
						}
					}
					return null;//ҲӦ׳쳣Ȳ
				}
			}
		}

		/*
		public bool Contains(string typename)
		{
			return this.members.Contains( typename );
		}
		*/
		public bool Contains(System.Type type)
		{
			if ( this.members.Contains( type.FullName) )
			{
				return true;//(ObjectMap)this.members[type.FullName]; 
			}
			else
			{
				foreach (DictionaryEntry entry in this.members)
				{
					ObjectMap map = (ObjectMap)entry.Value ;
					if ( type.IsSubclassOf( map.ObjectType ) )
					{
						return true;//return map;
					}
				}
				return false;
			}
		}
		
	}


	/// <summary>
	/// ӰϢĻֻ࣬Ҫʹõʱ򣬲ŻԴϿ
	/// </summary>
	public class ObjectMapCache 
	{

		private ObjectMapCollection sourceObjectMaps = null;

		private ObjectMapCollection cachedObjectMaps = new ObjectMapCollection();

		/// <summary>
		/// 캯
		/// </summary>
		/// <param name="sourceMaps"></param>
		public ObjectMapCache(ObjectMapCollection sourceMaps)
		{
			this.sourceObjectMaps = sourceMaps;
		}

		/// <summary>
		/// ĶӰϢ
		/// </summary>
		/// <returns></returns>
		internal ObjectMapCollection CachedObjectMaps
		{
			get
			{
				return this.cachedObjectMaps;
			}
		}

		public ObjectMap this[System.Type type]
		{
			get
			{
				if ( ! this.cachedObjectMaps.Contains(type) )
				{
					//õʱ򿽱һ
					this.cachedObjectMaps.Add( this.sourceObjectMaps[type].Clone() );
					System.Diagnostics.Debug.WriteLine( "********  Clone Object Map to Session Cache, Type : " + type.FullName + "  ********" );
				}
				return (ObjectMap)this.cachedObjectMaps[type]; 
			}
		}

		public void Clear()
		{
			this.cachedObjectMaps.Clear();
		}

		public void Add(ObjectMap omap)
		{
			this.cachedObjectMaps.Add( omap );
		}

		/// <summary>
		/// Ƿĳ͵ӰϢԴϰһTrue
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public bool Contains(System.Type type)
		{
			return ( this.sourceObjectMaps.Contains(type) || this.cachedObjectMaps.Contains(type) );
		}

	}

}
