using System;
using System.Data;
using System.Data.OracleClient;
using com.oucsoft.WSORM.OSql;

namespace com.oucsoft.WSORM
{
	/// <summary>
	/// OracleSession ժҪ˵
	/// </summary>
	public class OracleSession:SessionBase
	{
		public OracleSession(SessionFactory factory):base(factory)
		{
			//Oracle Sqlвǰ׺Ϊ:AddвҪ:һSql Serverͬ
			ParameterToken=":";
		}
		private OracleConnection currentConn=null;
		private OracleTransaction currentTrans=null;

		/// <summary>
		/// ԶȡOralce
		/// </summary>
		/// <param name="fieldType"></param>
		/// <returns></returns>
		private OracleType getOracleType(DbFieldTypes fieldType)
		{
			switch(fieldType)
			{
				case DbFieldTypes.AnsiString:
					return OracleType.VarChar;
				case DbFieldTypes.String:
					return OracleType.NVarChar;
				case DbFieldTypes.Int :
					return OracleType.Int32;
				case DbFieldTypes.Boolean :
					return OracleType.SByte;
				case DbFieldTypes.DateTime :
					return OracleType.DateTime;
				case DbFieldTypes.Decimal :
					return OracleType.Number;
				case DbFieldTypes.Money :
					return OracleType.Number;
				case DbFieldTypes.Real :
					return OracleType.Number;
				case DbFieldTypes.BigInt :
					return OracleType.Number;
				case DbFieldTypes.Unknown :
				default :
					throw new WSORMException("ʹ˲ͣ");//break;
			}
		}


		/// <summary>
		/// ȡ뱾ݿصĶԲͬ͵ֵıʾʽ
		/// </summary>
		/// <param name="type"></param>
		/// <param name="val">ֵ</param>
		/// <returns>ݿֵıʾַ</returns>
		protected override string getNativeDbValueExpression(DbFieldTypes type, object val)
		{	
			string strtemp = val.ToString();
			if ( type == DbFieldTypes.DateTime )
			{
				DateTime timetemp = (DateTime) val;
				strtemp = timetemp.Year.ToString() + "-" + timetemp.Month.ToString() + "-" + timetemp.Day.ToString() + " " 
					+ timetemp.Hour.ToString() + ":" + timetemp.Minute.ToString() + ":" + timetemp.Second.ToString();
				strtemp = "to_date('"+strtemp+",'yyyy-MM-dd HH24:mi:ss')";
				System.Diagnostics.Debug.WriteLine(strtemp);
			}
			else if ( type == DbFieldTypes.String || type == DbFieldTypes.AnsiString )
			{
				strtemp = "'" + this.filterString(strtemp) + "'";
			}
			return strtemp;
		}

		/*
		/// <summary>
		/// ֵַ
		/// </summary>
		/// <param name="str1"></param>
		/// <returns></returns>
		internal string filterString(string str1)
		{
			return str1.Replace("'","''");
		}
		*/

		#region ʵ

		protected override void openConnection()
		{
			// ½һݿ
			this.currentConn = new OracleConnection(this.ConnectionString);
			this.currentConn.Open();
		}
		protected override void beginTransaction()
		{
			this.currentTrans = this.currentConn.BeginTransaction(IsolationLevel.ReadCommitted);// Start a local transaction
		}
		protected override void commitTransaction()
		{
			this.currentTrans.Commit();//ύ
			System.Diagnostics.Debug.WriteLine("============================================");
			System.Diagnostics.Debug.WriteLine("Oracle Database Transaction has commited!");
		}
		protected override void rollbackTransaction()
		{
			this.currentTrans.Rollback();
		}
		protected override void closeConnection()
		{
			this.currentConn.Close();
			this.currentTrans = null;
			this.currentConn = null;
		}

		#endregion

		#region ѯʵ ...

		private string queryPageCommandText = "SELECT * FROM " + 
			"(SELECT t0.*,ROWNUM AS count_id FROM " + 
			"({0}) t0) t1 " + 
			"WHERE count_id BETWEEN {1} AND {2}";

		/// <summary>
		///  Oracle ҳSql
		/// </summary>
		/// <param name="baseQuery"></param>
		/// <param name="offset"></param>
		/// <param name="limitCount"></param>
		/// <returns></returns>
		private string prepareQueryPageCommand(string baseQuery, int offset, int limitCount)
		{
			string baseQ = "";
			string cmdText = String.Format(this.queryPageCommandText, 
				baseQ,						// {0} --> base query
				offset,						// {1} --> offset
				offset+limitCount-1			// {2} --> base query
				);
			return cmdText;
		}

		protected override string CombineSelectSql(ObjectMap map, string nativeSearchCondition, int offset, int limitCount)
		{
			string strS = nativeSearchCondition;
			string tableName = map.TableName;
			string strW = strS;

			if ( strW == null ) 
				strW = "";
			else
				strW = strW.Trim();

			if ( strW != "" )//ѯ
				if ( ! (strW.ToLower().IndexOf("where ") == 0) )
					strW = "where " + strW;

			string sql = "";
			//sql = "select * from " + getSafeIdentifier(tableName) + " " + strW;
			sql = "select " + this.getAllFieldNames(map) + " from " + getSafeIdentifier(tableName) + " " + strW;

			if ( limitCount > 0 )
			{
				if ( offset <= 0 )
					offset = 1;
				return this.prepareQueryPageCommand( sql, offset, limitCount );
			}	
			else
			{
				return sql;
			}
		}

		protected override string GetNativeSelectSql(ObjectMap map, string searchCondition, int offset, int limitCount)
		{
			string strS = this.getNativeSearchCondition(searchCondition, map);	
			return this.CombineSelectSql(map, strS, offset, limitCount);
		}

		protected override string GetNativeQueryCountSql(ObjectMap map, string searchCondition)
		{
			string tableName = map.TableName;
			string strS = this.getNativeSearchCondition(searchCondition, map);
			string strW = strS;

			if ( strW == null ) 
				strW = "";
			else
				strW = strW.Trim();

			if ( strW != "" )//ѯ
				if ( ! (strW.ToLower().IndexOf("where ") == 0) )
					strW = "where " + strW;

			string sql = "";
			sql = "select count(*) from " + getSafeIdentifier(tableName) + " " + strW;

			return sql;
		}

		/// <summary>
		/// ȡݿSqlѯӾ
		/// </summary>
		/// <param name="searchCondition"></param>
		/// <param name="map"></param>
		/// <returns></returns>
		private string getNativeSearchCondition(string searchCondition,ObjectMap map)
		{
			if( searchCondition == null)
				return "";

			string str = "";
			Lexical lex = new Lexical(new System.IO.StringReader(searchCondition));
			Symbol[] syms = lex.SymbolTable;
			foreach(Symbol sym in syms)
			{
				if( sym.Type == SymbolTypes.Identifier )
				{
					if( map.MemberMaps.Contains(sym.Content) )
						str += map.MemberMaps[sym.Content].FieldName;// + " ";
					else
						str += sym.Content;// + " ";
				}
				else if( sym.Type == SymbolTypes.String )
				{
					str += "'" + this.filterString(sym.Content) + "'";// + " ";		
				}
				else
				{
					str += sym.Content;// + " ";
				}
			}
			return str;		
		}

		public override DataTable QureyTableByNativeSql(string nativeSql)
		{
			OracleCommand command = new OracleCommand(nativeSql );	
			OracleConnection conn = new OracleConnection( this.ConnectionString );
			command.Connection = conn;
			OracleDataAdapter da = new OracleDataAdapter( command );
			DataTable tbl = new DataTable();
			da.Fill( tbl );
			return tbl;
		}


		public override object ExecuteScalarByNativeSql(string nativeSql)
		{
			object ret;
			OracleCommand command = new OracleCommand( nativeSql );	
			OracleConnection conn = new OracleConnection( this.ConnectionString );
			command.Connection = conn;
			//command.CommandTimeout = this.queryTimeout;
			conn.Open();
			try
			{
				ret = command.ExecuteScalar();
			}
			finally
			{
				conn.Close();
			}
			return ret;
		}

		#endregion

		#region Deleteʵ
		
		protected override int dbDelete(string tableName,DbFieldCollection keyFields)
		{
			string sql = this.getDeleteNativeSql(tableName, keyFields.ToArray());
			return this.deleteByNativeSql(sql);
		}

		/// <summary>
		/// ȡDeleteSQL
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="keyFields">ֵ</param>
		/// <returns></returns>
		private string getDeleteNativeSql(string tableName, DbField[] keyFields)
		{
			string deletesql = "delete from " + this.getSafeIdentifier(tableName);
			string strW = "";
			foreach(DbField keyField in keyFields)
			{
				if ( strW == "" )
					strW = keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value);
				else
					strW = strW + " and " + keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value);	
			}
			deletesql = deletesql + " where " + strW;//System.Diagnostics.Debug.WriteLine( deletesql);
			return deletesql;
		}

		/// <summary>
		/// ִDelete
		/// </summary>
		/// <param name="deletesql">Delete Sql</param>
		/// <returns>Ӱ</returns>
		private int deleteByNativeSql(string deletesql)
		{
			System.Diagnostics.Debug.WriteLine(deletesql);//Ե SQL 
	
			int effect = 0;
			string sql = deletesql;
			OracleCommand cmd = this.currentConn.CreateCommand();
			cmd.CommandText = sql;
			cmd.Connection = this.currentConn;	
			cmd.Transaction = this.currentTrans;		//conn.Open();
			effect = cmd.ExecuteNonQuery();//System.Diagnostics.Debug.WriteLine( ret.ToString() );
			return effect;//Ӱ
		}

		#endregion

		#region Updateʵ
		
		
		protected override int dbUpdate(string tableName, DbFieldCollection fields, DbFieldCollection keyFields)
		{
			string updatesql = this.getUpdateSql(tableName, fields, keyFields.ToArray());//ȡUpdate
			int effect = this.sqlUpdate(updatesql, fields);//ִUpdate
			return effect;
		}

		/// <summary>
		/// زUpdate SQL
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="fields">ҪUpdateֶ</param>
		/// <param name="keyFields">IDֶ</param>
		/// <returns>Update SQL</returns>
		private string getUpdateSql(string tableName, DbFieldCollection fields, DbField[] keyFields)
		{
			string updatesql = "update " + this.getSafeIdentifier(tableName) ;
			string strF = "";
			foreach(DbField field in fields)
			{
				if(strF == "")
					strF = field.Name + "=" + ParameterToken + field.Name;
				else
					strF = strF + "," + field.Name + "=" + ParameterToken + field.Name;
			}
			string strW = "";
			foreach(DbField keyField in keyFields)
			{
				if ( strW == "" )
					strW = keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value);
				else
					strW = strW + " and " + keyField.Name + "=" + this.getNativeDbValueExpression(keyField.Type, keyField.Value); 
			}
			updatesql = updatesql + " set " + strF + " where " + strW;
			//System.Diagnostics.Debug.WriteLine(updatesql);
			return updatesql;
		}

		/// <summary>
		/// ִвUpdate SQL
		/// </summary>
		/// <param name="insertsql">Update</param>
		/// <param name="fields">ҪUpdateֶ</param>
		private int sqlUpdate(string updatesql, DbFieldCollection fields)
		{
			System.Diagnostics.Debug.WriteLine(updatesql);//Ե SQL 
#if DEBUG
			foreach(DbField f in fields)
				System.Diagnostics.Debug.WriteLine(f.Name + "\t:\t" + (f.Value==null ? "null" : f.Value.ToString()));
#endif
			int ieffect = 0;
			string sql = updatesql;
			OracleCommand cmd = this.currentConn.CreateCommand();
			cmd.CommandText = sql;					//SqlConnection conn = new SqlConnection(this.ConnectionString);
			cmd.Connection = this.currentConn;		//conn;
			cmd.Transaction = this.currentTrans;	//conn.Open();
			foreach(DbField field in fields)
			{
				cmd.Parameters.Add(field.Name,getOracleType(field.Type)).Value 
					= getSafeValue(field.Type, field.Value);
			}
			ieffect = cmd.ExecuteNonQuery();
			//System.Diagnostics.Debug.WriteLine( ret.ToString() );
			return ieffect;//Ӱ
		}

		#endregion

		#region Insertʵ
		
		protected override object dbInsert(string tableName , DbFieldCollection fields, bool returnID)
		{
			string insertsql = this.getInsertSql(tableName, fields);//ȡInsert
			object idret = this.sqlInsert(insertsql,fields,true);//ִInsert
			return idret;
		}
		
		/// <summary>
		/// ȡôInsert SQL
		/// </summary>
		/// <param name="tablename">ҪInsertı</param>
		/// <param name="fields">ҪInsertֶ</param>
		/// <returns>Insert SQL</returns>
		private string getInsertSql(string tablename, DbFieldCollection fields)
		{
			string insertsql = "insert into " + getSafeIdentifier(tablename) + " ";//"insert into [" + tablename + "] ";
			string strF = "" ;
			string strP = "" ;
			foreach(DbField field in fields)
			{
				if(strF=="")
				{
					strF = strF + "(" + field.Name;
					strP = strP + "(" + ParameterToken + field.Name;
				}
				else
				{
					strF = strF + "," + field.Name;
					strP = strP + "," + ParameterToken + field.Name;
				}
			}
			if(strF!="")
			{
				strF = strF + ")";
				strP = strP + ")";
				insertsql = insertsql + strF + " values " + strP ;//+ " SELECT @@IDENTITY";
			}
			return insertsql;
		}

			
		/// <summary>
		/// ʹôInsert SQLִһ
		/// </summary>
		/// <param name="insertsql">Insert SQL</param>
		/// <param name="fields">ֶεֵ</param>
		/// <param name="returnID">еIdentity</param>
		/// <returns></returns>
		private object sqlInsert(string insertsql, DbFieldCollection fields, bool returnID)
		{
			System.Diagnostics.Debug.WriteLine(insertsql);//Ե SQL 
#if DEBUG
			foreach(DbField f in fields)
				System.Diagnostics.Debug.WriteLine(f.Name + "\t:\t" + (f.Value==null ? "null" : f.Value.ToString()));
#endif
			string sql = insertsql;
			if ( returnID )
			{
				//sql += " SELECT @@IDENTITY";
			}
			OracleCommand cmd = this.currentConn.CreateCommand();
			cmd.CommandText = sql;					
			cmd.Connection = this.currentConn;		
			cmd.Transaction = this.currentTrans;	
			foreach(DbField field in fields)
			{
				cmd.Parameters.Add(field.Name,this.getOracleType(field.Type)).Value 
					= getSafeValue(field.Type, field.Value);	
			}
			object ret = cmd.ExecuteScalar();
			return ret;
		}
 

		#endregion
	}
}
