using System;
using com.oucsoft.WSORM;

namespace com.oucsoft.WSORM.Sample
{
	/// <summary>
	/// Order  
	/// </summary>
	public class Order
	{
		
		public static ObjectMap GetObjectMap()
		{
			
			ObjectMap omap = new ObjectMap(typeof(Order),"Orders");

			omap.MemberMaps.Add("ID","OrderID", DbFieldTypes.Int, MemberMapTypes.Identity);//[OrderID] [int] IDENTITY (1, 1) NOT NULL ,
			omap.MemberMaps.Add("CustomerID", "CustomerID", DbFieldTypes.String, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("EmployeeID", "EmployeeID", DbFieldTypes.Int, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("OrderDate", "OrderDate", DbFieldTypes.DateTime, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("RequiredDate", "RequiredDate", DbFieldTypes.DateTime, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShippedDate", "ShippedDate", DbFieldTypes.DateTime, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShipVia", "ShipVia", DbFieldTypes.Int, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("Freight", "Freight", DbFieldTypes.Money, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShipName", "ShipName", DbFieldTypes.String, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShipAddress", "ShipAddress", DbFieldTypes.String, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShipCity", "ShipCity", DbFieldTypes.String, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShipRegion", "ShipRegion", DbFieldTypes.String, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShipPostalCode", "ShipPostalCode", DbFieldTypes.String, MemberMapTypes.NormalField);
			omap.MemberMaps.Add("ShipCountry", "ShipCountry", DbFieldTypes.String, MemberMapTypes.NormalField);
			//omap.MemberMaps.Add("Details","OrderID", DbFieldTypes.Int, "com.oucsoft.WSORM.Sample.OrderDetail", "OrderID", MemberMapTypes.One2Many);
			omap.MemberMaps.Add("Details","OrderID", DbFieldTypes.Int, typeof(OrderDetail), "OrderID", MemberMapTypes.One2Many);
			
			return omap;
		}

		//[OrderID] [int] IDENTITY (1, 1) NOT NULL ,
		private int id;
		public int ID 
		{
			get{ return this.id; }
			set{ this.id = value; }
		}
		
		//[CustomerID] [nchar] (5) COLLATE Chinese_PRC_CI_AS NULL ,
		public string CustomerID ;
		//[EmployeeID] [int] NULL ,
		public int EmployeeID ;
		//[OrderDate] [datetime] NULL ,
		public DateTime OrderDate;
		//[RequiredDate] [datetime] NULL ,
		public DateTime RequiredDate;
		//[ShippedDate] [datetime] NULL ,
		public DateTime ShippedDate;
		//[ShipVia] [int] NULL ,
		public int ShipVia;
		//[Freight] [money] NULL ,
		public decimal Freight;
		//[ShipName] [nvarchar] (40) COLLATE Chinese_PRC_CI_AS NULL ,
		public string ShipName;
		//[ShipAddress] [nvarchar] (60) COLLATE Chinese_PRC_CI_AS NULL ,
		public string ShipAddress;
		//[ShipCity] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
		public string ShipCity;
		//[ShipRegion] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
		public string ShipRegion;
		//[ShipPostalCode] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
		public string ShipPostalCode;
		//[ShipCountry] [nvarchar] (15) COLLATE Chinese_PRC_CI_AS NULL 
		public string ShipCountry;

		public OrderDetail[] Details;
		//public System.Collections.ArrayList Details;

		public Order()
		{
			//
			// TODO: ڴ˴ӹ캯߼
			//
		}
	}
}
