using System;
using com.oucsoft.WSORM;

namespace com.oucsoft.WSORM.Sample
{
	/// <summary>
	/// OrderDetail  ϸ
	/// </summary>
	public class OrderDetail
	{

		public static ObjectMap GetObjectMap()
		{
			//CREATE TABLE [dbo].[Order Details] (
			//ObjectMap omap = new ObjectMap("com.oucsoft.WSORM.Sample.OrderDetail","Order Details");
			ObjectMap omap = new ObjectMap( typeof(OrderDetail),"Order Details");
			//	[OrderID] [int] NOT NULL ,			
			omap.MemberMaps.Add("OrderID", "OrderID", DbFieldTypes.Int, MemberMapTypes.PrimaryKey);		//
			//	[ProductID] [int] NOT NULL ,
			omap.MemberMaps.Add("ProductID", "ProductID", DbFieldTypes.Int, MemberMapTypes.PrimaryKey);	//
			//	[UnitPrice] [money] NOT NULL ,
			omap.MemberMaps.Add("UnitPrice", "UnitPrice", DbFieldTypes.Money, MemberMapTypes.NormalField);
			//	[Quantity] [smallint] NOT NULL ,
			omap.MemberMaps.Add("Quantity", "Quantity", DbFieldTypes.Int, MemberMapTypes.NormalField);
			//	[Discount] [real] NOT NULL 
			omap.MemberMaps.Add("Discount", "Discount", DbFieldTypes.Real, MemberMapTypes.NormalField);
			//Many 2 One
			//omap.MemberMaps.Add("Product", "ProductID", DbFieldTypes.Int, "com.oucsoft.WSORM.Sample.Product", "ProductID", MemberMapTypes.Many2One);
			omap.MemberMaps.Add("Product", "ProductID", DbFieldTypes.Int, typeof(Product), "ProductID", MemberMapTypes.Many2One);
			return omap;
		}

		//	[OrderID] [int] NOT NULL ,
		public int OrderID;
		//	[ProductID] [int] NOT NULL ,
		public int ProductID;
		//	[UnitPrice] [money] NOT NULL ,
		public Decimal UnitPrice;
		//	[Quantity] [smallint] NOT NULL ,
		public int Quantity;
		//	[Discount] [real] NOT NULL 
		public float Discount; 
		//Many 2 One
		public Product Product;

		public OrderDetail()
		{
			//
			// TODO: ڴ˴ӹ캯߼
			//
		}
	}
}
