using System;
using System.Reflection;
using System.Data;
using System.Collections;

namespace com.oucsoft.WSORM
{
	/// <summary>
	/// ʵISeesionSessionĳ࣬ṩ˴󲿷ݿ޹صʵ
	/// </summary>
	public abstract class SessionBase : ISession
	{

		#region  ...
		
		protected string ParameterToken = "@";//ǰ׺

		protected int queryTimeout = 30;
		/// <summary>
		/// ѯʱʱ䣬Ϊλ
		/// </summary>
		public int QueryTimeout
		{
			get{return this.queryTimeout;}
			set{this.queryTimeout = value;}
		}

		//private string connString = null;
		public string ConnectionString
		{
			get{ return this._factory.ConnectionString; }
			//set{ this.connString = value; }
		}

		protected SessionFactory _factory = null;
		public SessionFactory Factory
		{
			get
			{
				return this._factory; 
			}
			/*
			set
			{
				this.factory = value;//this.cache.Factory = this.factory;
			}
			*/
		}

		/// <summary>
		/// ҪִеĶ
		/// </summary>
		protected DbActionCollection actionList = new DbActionCollection();

		/// <summary>
		/// Ķֵ
		/// </summary>
		private ObjectCache cache = null;// new ObjectCache();


		private ObjectMapCache objectMapsCache = null; //new ObjectMapCollection();
		
		/// <summary>
		/// ӰϢ
		/// </summary>
		public ObjectMapCache ObjectMaps
		{
			get
			{
				return this.objectMapsCache;//if ( this.objectMapsCopy.Contains(key)
			}
		}

		#endregion


		public SessionBase(SessionFactory factory)
		{
			this._factory = factory;

			this.objectMapsCache = new ObjectMapCache( factory.ObjectMaps );//this.objectMapsCache = new ObjectMapCollection( this._factory.ObjectMaps );
			
			this.cache = new ObjectCache( this.ObjectMaps.CachedObjectMaps );
		}
		
		#region ISession Ա

		/// <summary>
		/// ѯ
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public object[] Query(System.Type type)
		{
			return this.Query(type, null, -1);
		}

		/// <summary>
		/// ѯ
		/// </summary>
		/// <param name="type"></param>
		/// <param name="searchCondition">ѯ</param>
		/// <returns></returns>
		public object[] Query(System.Type type, string searchCondition)
		{
			return this.Query(type, searchCondition, -1);
		}

		public object[] Query(System.Type type, string searchCondition, int limitCount)
		{
			return this.Query(type, searchCondition, -1, limitCount);
		}

		public object[] Query(System.Type type, string searchCondition, int offset, int limitCount)
		{
			ObjectMap map = this.confirmObjectMap( type );
			try
			{
				string nativeSql = this.GetNativeSelectSql( map, searchCondition, offset, limitCount);
				System.Diagnostics.Debug.WriteLine( nativeSql );
				DataTable tbl = this.QureyTableByNativeSql( nativeSql );
				return this.ConvertDataTable2Objects(type, tbl);
			}
			catch(Exception e)
			{
				throw new WSORMException("ѯΪ" + type.FullName + "Ķʱ", e);
			}
		}

		public object[] QueryByNativeSearchCondition(System.Type type, string nativeSearchCondition, int offset, int limitCount)
		{
			ObjectMap map = this.confirmObjectMap( type );
			try
			{
				string nativeSql = this.CombineSelectSql( map, nativeSearchCondition, offset, limitCount);
				System.Diagnostics.Debug.WriteLine( nativeSql );
				DataTable tbl = this.QureyTableByNativeSql( nativeSql );
				return this.ConvertDataTable2Objects(type, tbl);
			}
			catch(Exception e)
			{
				throw new WSORMException("ѯΪ" + type.FullName + "Ķʱ", e);
			}
		}

		public virtual int QueryCount(System.Type type, string searchCondition)
		{
			ObjectMap map = this.confirmObjectMap( type );
			try
			{
				string nativeSql = this.GetNativeQueryCountSql(map, searchCondition);
				System.Diagnostics.Debug.WriteLine( nativeSql );
				int ret = (int) this.ExecuteScalarByNativeSql( nativeSql );
				return ret;
			}
			catch(Exception e)
			{
				throw new WSORMException("ѯΪ" + type.FullName + "Ķʱ", e);
			}
		}

		public virtual void Save(object obj)
		{
			this.actionList.Add( new DbAction( DbActionTypes.Save , obj ) );
		}

		public virtual void Delete(object obj)
		{
			this.actionList.Add( new DbAction( DbActionTypes.Delete , obj ) );
		}

		public virtual void Cancel()
		{
			this.actionList.Clear();
		}

		public virtual void Execute()
		{
			bool bBeginTrans = false;
			this.openConnection();	
			//֮ݿѾ򿪣һҪעfinallyر
			try
			{
				try
				{
					this.beginTransaction();
					bBeginTrans = true;
				}
				catch(Exception exB)
				{
					throw new WSORMException("ʼʱ", exB);
				}
				foreach(DbAction action in this.actionList)
				{
					if(action.Type == DbActionTypes.Save)
						this.executeSave(action.Object);
					else if(action.Type == DbActionTypes.Delete)
						this.executeDelete(action.Object);
				}
				this.commitTransaction();
			}
			catch(Exception e)
			{
				if(bBeginTrans == true)
				{
					try
					{
						this.rollbackTransaction();//this.currentTrans.Rollback();
					}
					catch (Exception exR)
					{
						//if (this.currentTrans.Connection != null)
						//System.Diagnostics.Debug.WriteLine("An exception of type " + ex.GetType()	+ " was encountered while attempting to roll back the transaction.");
						throw new WSORMException("عʱ", exR);
					}
				}
				//System.Diagnostics.Debug.WriteLine("An exception of type " + e.GetType() + " was encountered while persistance the data.");
				throw new WSORMException("ִгʱ", e);
			}
			finally
			{
				this.closeConnection();
			}
			this.actionList.Clear();

		}

		#endregion

		#region 񲿷Ҫʵֵĳ

		protected abstract void openConnection();
		protected abstract void beginTransaction();
		protected abstract void commitTransaction();
		protected abstract void rollbackTransaction();
		protected abstract void closeConnection();
		
		#endregion

		#region ѯҪʵֵĳ

		//		/// <summary>
		//		/// ӶԱĲѯȡñSQLѯ
		//		/// </summary>
		//		/// <param name="searchCondition"></param>
		//		/// <param name="map"></param>
		//		/// <returns></returns>
		//		protected abstract string getNativeSearchCondition(string searchCondition,ObjectMap map);

		/// <summary>
		/// ȡѯҪʹõıSql
		/// </summary>
		/// <param name="map">ӰϢ</param>
		/// <param name="searchCondition">ѯ</param>
		/// <param name="offset">ӵڼ¼ʼ</param>
		/// <param name="limitCount">޶صĶ</param>
		/// <returns>رSql</returns>
		protected abstract string GetNativeSelectSql(ObjectMap map, string searchCondition, int offset, int limitCount);

		/// <summary>
		/// زѯϳıSelect
		/// </summary>
		/// <param name="map">ӰϢ</param>
		/// <param name="nativeSearchCondition">زѯ</param>
		/// <param name="offset"></param>
		/// <param name="limitCount"></param>
		/// <returns></returns>
		protected abstract string CombineSelectSql(ObjectMap map, string nativeSearchCondition, int offset, int limitCount);

		protected abstract string GetNativeQueryCountSql(ObjectMap map, string searchCondition);
		
		/// <summary>
		/// ͨһSQL䷵زѯ
		/// </summary>
		/// <param name="nativeSql"></param>
		/// <returns></returns>
		public abstract DataTable QureyTableByNativeSql(string nativeSql);
		
		public abstract object ExecuteScalarByNativeSql(string nativeSql);

		#endregion

		#region SaveҪʵֵĳ

		protected abstract object dbInsert(string tableName , DbFieldCollection fields, bool returnID);
		
		protected abstract int dbUpdate(string tableName, DbFieldCollection fields, DbFieldCollection keyFields);

		#endregion

		#region DeleteҪʵֵĳ

		/// <summary>
		/// ɾ¼
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="keyFields">ֶεֵ</param>
		/// <returns></returns>
		protected abstract int dbDelete(string tableName,DbFieldCollection keyFields);
		
		#endregion

		
		#region ʵֵĸ߿Ըǵ麯

		/// <summary>
		/// ȡ뱾ݿصĶԲͬ͵ֵıʾʽ
		/// </summary>
		/// <param name="type"></param>
		/// <param name="val">ֵ</param>
		/// <returns>ݿֵıʾַ</returns>
		protected abstract string getNativeDbValueExpression(DbFieldTypes type, object val);

		/// <summary>
		/// ȡðȫıʶǰİ汾SQL Server
		/// </summary>
		/// <param name="origin"></param>
		/// <returns></returns>
		protected virtual string getSafeIdentifier(string origin)
		{
			if ( origin.IndexOf(" ") != -1)//ڿո
			{
				return "[" + origin + "]";
			}
			return origin;
		}

		#endregion

		/// <summary>
		/// ȷȡĳ͵ĶӳϢ
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		protected ObjectMap confirmObjectMap(System.Type type)
		{
			//if( ! this.ObjectMaps.Contains( type.FullName ) )
			if( ! this.ObjectMaps.Contains( type ) )
			{
				throw new WSORMException("޷ҵ"+ type.FullName + "ӳϢ");//, new ArgumentException());
			}
			ObjectMap map = this.ObjectMaps[ type ];
			return map;
		}


		#region ѯʵ

		//private object[] queryByNativeSql(System.Type type, string nativeSql)
		//System.Diagnostics.Debug.WriteLine( nativeSql );
		//DataTable tbl = this.qureyTableByNativeSql( nativeSql );
		/// <summary>
		/// tableеļ¼תɶ
		/// </summary>
		/// <param name="type"></param>
		/// <param name="tbl"></param>
		/// <returns></returns>
		public virtual object[] ConvertDataTable2Objects(System.Type type, DataTable tbl)
		{
			System.Collections.ArrayList arrayList = new System.Collections.ArrayList();	
			
			foreach( DataRow row in tbl.Rows ) //while( rd.Read() )
			{
				object obj = Activator.CreateInstance(type);

				ObjectMap map = this.ObjectMaps[ type ];

				foreach ( MemberMap memberMap in map.MemberMaps )//foreach ( MemberInfo memberInfo in memberInfos)
				{
					MemberInfo memberInfo = MemberHelper.GetMemberInfo(type, memberMap.MemberName);					
					string strCondition = null;	
					string sql = null;
					object[] temps = null;

					switch( memberMap.MemberMapType )
					{
						case MemberMapTypes.One2Many:	//һԶӳ
							
							if ( ! memberMap.CascadedQuery )
								break;
							
							strCondition = this.getSafeIdentifier(memberMap.ExternalField) + "="  + this.getNativeDbValueExpression(memberMap.FieldType, row[memberMap.FieldName]);
							sql = "select " + this.getAllFieldNames(this.ObjectMaps[memberMap.ExternalType]) 
								+ " from " + getSafeIdentifier(this.ObjectMaps[memberMap.ExternalType].TableName) + " where " + strCondition ;
							//temps = queryByNativeSql(  memberMap.ExternalType , sql);
							temps = this.ConvertDataTable2Objects(  memberMap.ExternalType , this.QureyTableByNativeSql(sql) );
							if ( temps != null && temps.Length > 0 )
							{
								if ( MemberHelper.IsMemberArray(memberInfo) )//Ա
								{
									MemberHelper.SetMemberValue(memberInfo, obj, temps);
								}
								else if ( MemberHelper.HasMemberInterface(memberInfo,typeof(IList)) )//ԱʵIListӿ
								{
									IList list = (IList)Activator.CreateInstance(MemberHelper.GetMemberType(memberInfo));
									foreach(object temp in temps)
										list.Add(temp);
									MemberHelper.SetMemberValue(memberInfo, obj, list);	
								}
								else
									throw new MemberTypeException("Ա" + memberInfo.Name + "One2Manyֵ֧ͣ");
							}
							break;

						case MemberMapTypes.Many2One:
							
							if ( ! memberMap.CascadedQuery )
								break;
							
							strCondition = this.getSafeIdentifier(memberMap.ExternalField) + "=" + this.getNativeDbValueExpression(memberMap.FieldType, row[memberMap.FieldName]);
							sql = "select " + this.getAllFieldNames(this.ObjectMaps[memberMap.ExternalType]) 
								+ " from " + getSafeIdentifier(this.ObjectMaps[memberMap.ExternalType].TableName) + " where " + strCondition ;
							//temps = queryByNativeSql(  memberMap.ExternalType , sql);
							temps = this.ConvertDataTable2Objects(  memberMap.ExternalType , this.QureyTableByNativeSql(sql) );
							if ( temps == null || temps.Length != 1 )
							{
								//do nothing
							}	
							else
							{
								MemberHelper.SetMemberValue(memberInfo, obj, temps[0]);
							}
							break;
						default:
							//ֶӳ
							if ( ! memberMap.Ignored )
								this.setMemberValue(memberMap.FieldType, memberInfo, obj, row[memberMap.FieldName]);		
							break;
					}

				}//foreach ( MemberMap memberMap in map.MemberMaps )
				
				arrayList.Add( obj );
				
				this.cache.Add(obj);//עӵ
				
			}//foreach( DataRow row in tbl.Rows ) //while( rd.Read() )
				
			//rd.Close();//this.conn.Close();
			return (object[]) arrayList.ToArray( type );
		}

		#endregion


		#region Deleteʵ

		/// <summary>
		/// ִDelete
		/// </summary>
		/// <param name="obj"></param>
		private void executeDelete(object obj)
		{
			System.Type type = obj.GetType();
			ObjectMap map = this.confirmObjectMap( type );
			
			//ݹɾOne2ManyĳԱ
			MemberMap[] one2manyMaps = map.One2ManyMemberMaps;
			foreach(MemberMap one2manyMap in one2manyMaps)
			{
				if ( one2manyMap.CascadedDelete )
				{
					IEnumerable childs = (IEnumerable)MemberHelper.GetMemberValue(one2manyMap.MemberName, obj);
					if(childs!=null)
					{
						foreach(object child in childs)
						{
							this.executeDelete( child );
						}
					}
				}
			}

			DbFieldCollection keyFields = new DbFieldCollection();
			if( map.IDMemberMap != null )//ݿIDֶ
			{
				MemberInfo memberInfo = MemberHelper.GetMemberInfo(type, map.IDMemberMap.MemberName);//ȡóԱϢ
				string idfieldname = map.IDMemberMap.FieldName;					//IDֶ
				DbFieldTypes idfieldtype = map.IDMemberMap.FieldType;			//IDֶ
				object idfieldvalue = MemberHelper.GetMemberValue( memberInfo, obj);	//ȡIDֵ
				if( ! this.isIDNull(idfieldvalue) )//IDǿյ
				{
					keyFields.Add(new DbField(idfieldname,idfieldtype,idfieldvalue));
				}
			}
			else if( map.PrimaryKeyMemberMaps != null && map.PrimaryKeyMemberMaps.Length > 0 )//ݿд
			{
				foreach(MemberMap pkmap in map.PrimaryKeyMemberMaps)
				{
					keyFields.Add(new DbField(pkmap.FieldName,pkmap.FieldType,MemberHelper.GetMemberValue(pkmap.MemberName,obj)));
				}		
			}
			if( keyFields.Count > 0 )
			{
				//string deletesql = this.GetDeleteNativeSql(map.TableName, keyFields.ToArray());//ȡDelete
				//int effect = this.DeleteByNativeSql(deletesql);//ִ
				//ȡð汾Ϣ汾
				DbField versionField = this.getVesionField(map,obj);
				if ( versionField != null )//ڰ汾
				{
					//fields.Add(new DbField[]{new DbField(versionField.Name,versionField.Type,Convert.ToInt32(versionField.Value)+1)},true);
					keyFields.Add(new DbField[]{new DbField(versionField.Name,versionField.Type,versionField.Value)},true);
				}
				int effect = this.dbDelete(map.TableName, keyFields);
				if( effect == 1 )
				{
					//
				}
				else if( effect == 0 )
					throw new WSORMException( "ɾʧܣ˶Ѿɾ" );
				else 
					throw new WSORMException( "ɾʧܣIDģ" );
			}
			this.cache.Remove(obj); //Ӧø»Ϣ
		}

		#endregion


		#region Saveʵ

		/// <summary>
		/// ִбĲ
		/// </summary>
		/// <param name="obj">ҪĶ</param>
		private void executeSave(object theObject)
		{
			this.executeSave(theObject, null);
		}
		
		/// <summary>
		/// ִбĲ
		/// </summary>
		/// <param name="theObject">ҪĶ</param>
		/// <param name="addedFields">⸽ӵֶ</param>
		private void executeSave(object theObject, DbField[] addedFields)
		{
			object obj = theObject;
			DbFieldCollection addedfs = new DbFieldCollection(addedFields);//DbField[] addedfs = addedFields;
			System.Type type = obj.GetType();
			ObjectMap map = this.confirmObjectMap(type);
			
			//ҪȱMany2OneĳԱ
			MemberMap[] many2oneMaps = map.Many2OneMemberMaps;
			foreach(MemberMap many2oneMap in many2oneMaps)
			{
				if ( many2oneMap.CascadedSave )
				{
					//ȡOneһ
					object oneObject = MemberHelper.GetMemberValue( many2oneMap.MemberName, obj );
					if ( oneObject != null )
					{
						this.executeSave(oneObject, null);
						//ȡOneһӳϢ
						ObjectMap oneMap = this.confirmObjectMap(oneObject.GetType());//factory.ObjectMaps[ oneObject.GetType().FullName ];
						//ȡOneһֶȡֶζӦĳԱ
						MemberMap oneNormalMemberMap = oneMap.GetNormalMemberMapFromFieldName(many2oneMap.ExternalField);
						if(oneNormalMemberMap == null)
							throw new WSORMException("OneһĶ޷ȡӳ䵽ֶ" + many2oneMap.ExternalField + "ֵ");
						//ȡøOneһĸóԱֵNewһDbField
						DbField oneKeyField = new DbField( many2oneMap.FieldName , many2oneMap.FieldType,
							MemberHelper.GetMemberValue(oneNormalMemberMap.MemberName,oneObject));
						//ҪֶεֵӵManyһԱ
						addedfs.Add(oneKeyField);
					}
				}
			}

			//ҪӱֶڶдڶӦĳԱôӦԱֵ
			DbFieldCollection tempfs = new DbFieldCollection();
			if( addedfs != null && addedfs.Count > 0)
			{
				for(int i=0; i<addedfs.Count; i++)
				{
					DbField af = addedfs[i];
					MemberMap mmap = map.GetNormalMemberMapFromFieldName(af.Name);
					if(mmap != null)
						MemberHelper.SetMemberValue(mmap.MemberName,obj,af.Value);
						//System.Diagnostics.Debug.WriteLine("----" + map.TypeName + "ĳԱ" + mmap.MemberName + "ֵΪ:\t" + af.Value.ToString());	
					else
						tempfs.Add(af);
				}
			}
			addedfs = tempfs;

			bool insertOrUpdate = true;//trueInsertfalseUpdate
			DbFieldCollection fields = null;//Ҫֶ
			DbFieldCollection keyFields = new DbFieldCollection();//ڸµ

			if( map.IDMemberMap != null )//ݿIDֶ
			{
				MemberInfo memberInfo = MemberHelper.GetMemberInfo(type, map.IDMemberMap.MemberName);	//ȡóԱϢ
				string idFieldName = map.IDMemberMap.FieldName;//IDֶ
				DbFieldTypes idFieldType = map.IDMemberMap.FieldType;//IDֶ
				object idFieldValue = MemberHelper.GetMemberValue( memberInfo, obj);//ȡIDֵ
				if( isIDNull(idFieldValue) )//IDǿյģôInsert
				{
					fields = getAllFields(map, obj, new string[]{idFieldName}, true);//ȡзǿյֶ
					insertOrUpdate = true;
				}
				else//IDǿյ
				{
					if( this.cache.Contains(obj) )//дڶ
					{
						fields = this.cache.CheckChangedFields(obj);
					}
					else
					{
						fields = getAllFields(map, obj, new string[]{idFieldName}, false);//ȡֶεֵ	
					}
					insertOrUpdate = false;
					keyFields.Add( new DbField(idFieldName,idFieldType,idFieldValue) );
				}
			}
			else if( map.PrimaryKeyMemberMaps != null && map.PrimaryKeyMemberMaps.Length > 0 )//ݿд
			{
				if( this.cache.Contains(obj) )//дڶ
				{
					//fields = getAllFields(map, obj, null, true);//ȡзǿյֶ
					fields = this.cache.CheckChangedFields( obj );
					foreach( MemberMap mmap in map.PrimaryKeyMemberMaps )
					{
						keyFields.Add( new DbField(mmap.FieldName, mmap.FieldType, 
							MemberHelper.GetMemberValue(mmap.MemberName,obj)) ) ;
					}
					insertOrUpdate = false;
				}
				else
				{
					fields = getAllFields(map, obj, null, true);//ȡзǿյֶ
					insertOrUpdate = true;
				}
			}
			else//ûIDҲûֱInsert
			{
				fields = getAllFields(map, obj, null, true);//ȡзǿյֶ
				insertOrUpdate = true;
			}
			
			//ȡð汾Ϣ汾
			//DbField versionField = this.getVesionField(map,obj);
			if(insertOrUpdate == true)//Ҫ¼¼
			{
				if(addedfs != null && addedfs.Count > 0)
					fields.Add(addedfs.ToArray(), true);
				//if ( versionField != null )//ڰ汾
				//	fields.Add(new DbField[]{versionField},true);
				object idret = this.dbInsert(map.TableName, fields, true);
				if(map.IDMemberMap != null)
				{
					MemberHelper.SetMemberValue(map.IDMemberMap.MemberName, obj, idret);//IDֵ	
				}
				this.cache.Add( obj );//»
			}
			else
			{
				if(addedfs != null && addedfs.Count > 0)
					fields.Add(addedfs.ToArray(), true);
				if( fields.Count > 0 )
				{
					//ȡð汾Ϣ汾
					DbField versionField = this.getVesionField(map,obj);
					if ( versionField != null )//ڰ汾
					{
						//ôʱҪѰ汾ֶμ1
						fields.Add(new DbField[]{new DbField(versionField.Name,versionField.Type,Convert.ToInt32(versionField.Value)+1)},true);
						//Ѱ汾ֶεֵΪһ
						keyFields.Add(new DbField[]{new DbField(versionField.Name,versionField.Type,versionField.Value)},true);
					}
					int effect = this.dbUpdate(map.TableName, fields, keyFields);
					if( effect == 1 )
					{
						if ( versionField != null )//ڰ汾ƣ°汾ֵ
							MemberHelper.SetMemberValue(map.VersionMemberMap.MemberName, obj,Convert.ToInt32(versionField.Value)+1);//Versionֵ					
					}	
					else
					{
						throw new WSORMException("ݿпѾ߱ɾ");		
					}
					this.cache.Add( obj );//»
				}
			}

			//ݹ鱣One2ManyĳԱ
			MemberMap[] one2manyMaps = map.One2ManyMemberMaps;
			foreach(MemberMap one2manyMap in one2manyMaps)
			{
				if ( one2manyMap.CascadedSave )
				{
					MemberMap normalMemberMap = map.GetNormalMemberMapFromFieldName(one2manyMap.FieldName);
					if(normalMemberMap == null)
						throw new WSORMException("޷ȡֶ" + one2manyMap.FieldName + "ֵ");
					DbField keyField = new DbField( one2manyMap.ExternalField , normalMemberMap.FieldType,
						MemberHelper.GetMemberValue(normalMemberMap.MemberName,obj));
					IEnumerable childs = (IEnumerable)MemberHelper.GetMemberValue(one2manyMap.MemberName, obj);
					if( childs != null )
					{
						foreach(object child in childs)
						{
							this.executeSave( child , new DbField[]{keyField} );
						}
					}
				}
			}

		}

		/// <summary>
		/// ȡð汾ֶ
		/// </summary>
		/// <param name="map">Ӱ</param>
		/// <param name="obj"></param>
		/// <returns>ڰ汾ֶ򷵻null</returns>
		private DbField getVesionField(ObjectMap map, Object obj)
		{
			if ( map.VersionMemberMap != null )
			{
				//MemberInfo memberInfo = MemberHelper.GetMemberInfo(type, map.VersionMemberMap.MemberName);//ȡóԱϢ
				string versionFieldName = map.VersionMemberMap.FieldName;//ֶ
				DbFieldTypes versionFieldType = map.VersionMemberMap.FieldType;//ֶ
				object versionFieldValue = MemberHelper.GetMemberValue(map.VersionMemberMap.MemberName,obj);//ȡֵ
				return new DbField(versionFieldName,versionFieldType,versionFieldValue);
			}
			return null;
		}


		#endregion

		
		#region ķ ...

		/// <summary>
		/// ֵַ
		/// </summary>
		/// <param name="str1"></param>
		/// <returns></returns>
		protected string filterString(string str1)
		{
			return str1.Replace("'","''");
		}


		protected string getAllFieldNames(ObjectMap omap ) 
		{
			string strFs = "";
			string[] fieldNames = omap.GetAllFiledNames();
			foreach( string f in fieldNames )
			{
				if ( strFs == "" )
					strFs = this.getSafeIdentifier(f);
				else 
					strFs = strFs + "," + this.getSafeIdentifier(f);
			}
			return strFs;
		}

		/// <summary>
		/// ȡöݿжӦеֶ
		/// </summary>
		/// <param name="map">ӳϢ</param>
		/// <param name="obj">ӳĶ</param>
		/// <param name="ignoreFields">ҪԵֶ</param>
		/// <param name="ignoreNull">ǷҪԿյֶ</param>
		/// <returns></returns>
		protected DbFieldCollection getAllFields(ObjectMap map, object obj, string[] ignoreFields, bool ignoreNull)
		{
			DbFieldCollection fields = new DbFieldCollection();
			foreach(MemberMap mmap in map.MemberMaps)
			{
				if(ignoreFields != null)//ҪԵĳЩֶ
				{
					bool ig = false;
					for(int i=0; i<ignoreFields.Length; i++)
					{
						if(mmap.FieldName == ignoreFields[i])//ǱԵֶ
						{
							ig = true;
							break;
						}
					}
					if(ig)//ҪԵֶ
						continue;
				}
				if(mmap.MemberMapType == MemberMapTypes.One2Many)
				{
					//һԶĳԱ
				}
				else if (mmap.MemberMapType == MemberMapTypes.Many2One)
				{
					//ǶһĳԱ
				}
				else
				{
					DbField field = new DbField();
					field.Type = mmap.FieldType;//ֶ
					field.Name = mmap.FieldName;//ֶ
					field.Value = MemberHelper.GetMemberValue(mmap.MemberName, obj);//Աֵ
					if(ignoreNull)//ҪԿյֶ
					{
						if(field.Value == null)//ֶǿյ
							continue;
						if(field.Type == DbFieldTypes.DateTime)//ǡաDateTimeֵ
							if(isDateTimeNull((DateTime)field.Value))
								continue;
					}
					fields.Add(field);
					//System.Diagnostics.Debug.WriteLine(field.Name + " - " + field.Type.ToString() + " : " + field.Value.ToString());
				}
			}
			return fields;
		}


		/// <summary>
		/// жIDǷǿյ
		/// </summary>
		/// <param name="id"></param>
		/// <returns></returns>
		protected virtual bool isIDNull(object id)
		{
			if( id == null || id == DBNull.Value || int.Parse(id.ToString()) == this._factory.IntNullValue )
				return true;
			else
				return false;
		}

		/// <summary>
		/// жDateTimeǷǿյ
		/// </summary>
		/// <param name="dt"></param>
		/// <returns></returns>
		protected virtual bool isDateTimeNull(DateTime dt)
		{
			if( dt <= this._factory.MinDateTime )
				return true;
			else
				return false;
		}

		/// <summary>
		/// ȡáȫֵڸݿʱ쳣
		/// </summary>
		/// <param name="type"></param>
		/// <param name="obj"></param>
		/// <returns></returns>
		protected object getSafeValue(DbFieldTypes type, object obj)
		{
			//ǿ
			if( obj==null )
				return DBNull.Value;
			//DateTimeͣDateTimeֵǺϷֵ
			if( type==DbFieldTypes.DateTime && obj.GetType().Equals(typeof(DateTime)))
			{
				if( isDateTimeNull((DateTime)obj) )
					return DBNull.Value;
			}
			//ȱʡֱӷδתֵ
			return obj;
		}

		#endregion

		/// <summary>
		/// ݿֵֶԱ
		/// </summary>
		/// <param name="fieldType">ݿֶ</param>
		/// <param name="memberInfo">ԱϢ</param>
		/// <param name="obj">ֵĳԱ</param>
		/// <param name="fieldVal">ֵֶ</param>
		protected virtual void setMemberValue(DbFieldTypes fieldType, MemberInfo memberInfo, object obj, object fieldVal)
		{		
			if ( fieldVal == null || fieldVal == DBNull.Value )
			{
				//ǿյģֱӷ
				return;
			}		
			switch( fieldType )//memberMap.FieldType )
			{
				case DbFieldTypes.AnsiString:
				case DbFieldTypes.String:
					MemberHelper.SetMemberValue(memberInfo, obj, Convert.ToString(fieldVal));
					break;
				case DbFieldTypes.DateTime:
					MemberHelper.SetMemberValue(memberInfo, obj, Convert.ToDateTime(fieldVal));
					break;
				default:
					MemberHelper.SetMemberValue(memberInfo, obj, fieldVal);		
					break;
			}
		}

	}
}
