using System;
using System.Collections;

namespace com.oucsoft.WSORM
{
	public enum SessionFactoryTypes : int
	{
		SqlServer = 1,
		Oracle = 2,
		Accesss = 3
	}

	/// <summary>
	/// SessionFactory
	/// </summary>
	public class SessionFactory
	{

		#region  ...

		private SessionFactoryTypes factoryType = SessionFactoryTypes.SqlServer;
		/// <summary>
		/// ͣǰ֧Sql ServerOracle
		/// </summary>
		public SessionFactoryTypes FactoryType
		{
			get { return this.factoryType; }
			set { factoryType=value; }
		}

		private string connStr = null;
		public string ConnectionString
		{
			get { return this.connStr; }
			set { this.connStr = value; }
		}

		private ObjectMapCollection maps = new ObjectMapCollection();//private System.Collections.Hashtable maps = null;
		public ObjectMapCollection ObjectMaps
		{
			get
			{
				return this.maps;
			}
		}

		private DateTime minDateTime = new DateTime(1900,1,1);
		/// <summary>
		/// ϵͳСDateTime
		/// </summary>
		public DateTime MinDateTime
		{
			get{ return this.minDateTime; }
			set{ this.minDateTime = value; }
		}

		private int intNullValue = 0;
		/// <summary>
		/// ʲôֵֵ
		/// </summary>
		public int IntNullValue
		{
			get{ return this.intNullValue; }
			set{ this.intNullValue=value; }
		}

		#endregion


		/// <summary>
		/// 캯
		/// </summary>
		public SessionFactory()
		{
		}


		public ISession CreateSession()
		{
			if(this.factoryType==SessionFactoryTypes.SqlServer)
			{
				ISession session=new SqlSession(this);
				//session.Factory=this;
				return session;
			}
			else if(this.factoryType==SessionFactoryTypes.Oracle)
			{
				ISession session=new OracleSession(this);
				//session.Factory=this;
				return session;
			}
			else if ( this.factoryType==SessionFactoryTypes.Accesss)
			{
				ISession session=new AccessSession(this);
				return session;
			}
			else
			{
				throw new WSORMException("ֵ֧ݿ!");
			}
		
		}

//		public ISession CreateSession(SessionFactoryTypes sessionFactoryType)
//		{
//			this.factoryType = sessionFactoryType;
//			return this.CreateSession();
//		}
		
	}
}
