﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.UI;
using COCOWO.COMP;

namespace COCOWO.DB
{
    public class Users :SqlDataBase
    {
        string strSql = null;
        /// <summary>
        /// 验证用户名是否存在
        /// </summary>
        /// <param name="username">用户名</param>
        /// <returns></returns>
        public bool Vld_UserName(string username)
        {
            strSql = "SELECT COUNT(User_Id) FROM Users WHERE User_Name='" + username + "'";
            string str = RunSqlReturn(strSql);
            return (Equals(RunSqlReturn(strSql), "0")) ? true:false;                
        }

        /// <summary>
        /// 验证用户登录信息
        /// </summary>
        /// <param name="username">用户名</param>
        /// <param name="password">密码</param>
        /// <returns></returns>
        public DataView Vld_User(string username, string password)
        {
            string strSql = "SELECT Top 1 mem_Name,stat_title,stat_Code,stat_attSize,stat_attType FROM V_blog_member WHERE mem_Name='" + username + "' AND mem_Password='" + StringUtil.EncryptPassword(password, "MD5") + "'";//StringUtil.EncryptPassword(password, "MD5")
            return GetDv(strSql);
        }

        /// <summary>
        /// 验证后台登录信息
        /// </summary>
        /// <param name="password">密码</param>
        /// <returns></returns>
        public DataView Vld_Admin(string username, string password)
        {
            string strSql = "SELECT Top 1 mem_Name FROM blog_member WHERE mem_Name='" + username + "' AND mem_password='" + StringUtil.EncryptPassword(password, "MD5") + "'";//StringUtil.EncryptPassword(password, "MD5")
            return GetDv(strSql);
        }

        /// <summary>
        /// 用户登录
        /// </summary>
        /// <param name="strUserName">用户名</param>
        /// <param name="strPassWord">密码</param>
        /// <param name="day">保存登录信息天数</param>
        /// <param name="ip">IP地址</param>
        public void VldUserLogin(string strUserName, string strPassWord, int day)
        {
            DataView mydv = Vld_User(StringUtil.InputText(strUserName, 10), StringUtil.InputText(strPassWord, 20));
            if (mydv.Count<=0)
            {
                Jscript.Alert("用户名或密码不正确！");
                Jscript.GoHistory(-1);
            }
            else
            {
                HttpContext.Current.Response.Cookies.Add(new HttpCookie("username", HttpUtility.UrlEncode(mydv[0]["mem_Name"].ToString())));
                HttpContext.Current.Response.Cookies.Add(new HttpCookie("usercode", mydv[0]["stat_Code"].ToString()));
                if (!Equals(day, 0))
                {
                    HttpContext.Current.Request.Cookies["username"].Expires = DateTime.Now.AddDays(day);
                    HttpContext.Current.Request.Cookies["usercode"].Expires = DateTime.Now.AddDays(day);
                }
            }
        }

        /// <summary>
        /// 管理员后台登录
        /// </summary>
        /// <param name="strUserName">用户名</param>
        /// <param name="strPassWord">密码</param>
        public void VldAminLogin(string strUserName, string strPassWord)
        {
            DataView mydv = Vld_Admin(StringUtil.InputText(strUserName, 10), StringUtil.InputText(strPassWord, 20));
            if (mydv.Count <= 0)
            {
                Jscript.Alert("用户名或密码不正确！");
                Jscript.GoHistory(-1);
            }
            else
            {
                HttpContext.Current.Response.Cookies.Add(new HttpCookie("memhashKey", mydv[0][0].ToString()));
            }
        }

        /// <summary>
        /// 用户注册
        /// </summary>
        /// <param name="Username">用户名</param>
        /// <param name="Password">密码</param>
        /// <param name="Gender">性别</param>
        /// <param name="Email">电子邮件</param>
        /// <param name="Homepage">个人主页</param>
        /// <param name="Qq">QQ</param>
        /// <returns></returns>
        public void Add_blog_Member(string Username, string Password, string Gender, string Email, string Homepage, string Qq)
        {
            Username = StringUtil.InputText(Username,10);
            Password = StringUtil.InputText(Password, 20);
            Email = StringUtil.InputText(Email, 50);
            Homepage = StringUtil.InputText(Homepage, 100);
            Qq = StringUtil.InputText(Qq, 10);
            if (Vld_UserName(Username))
            {
                Jscript.Alert("用户名以存在请更换！");
                Jscript.GoHistory(-1);
            }
            else
            {
                try
                {
                    strSql = "INSERT INTO blog_Member (mem_Name, mem_Password, mem_Sex, mem_Email, mem_HomePage, mem_QQ) VALUES ('" + Username + "', '" + StringUtil.EncryptPassword(Password, "MD5") + "','" + Gender + "', '" + Email + "', '" + Homepage + "', '" + Qq + "')";
                    RunSql(strSql);
                    HttpContext.Current.Response.Cookies.Add(new HttpCookie("username", HttpUtility.UrlEncode(Username)));
                    Jscript.JavaScriptLocationHref("default.aspx");
                }
                catch
                {
                    Jscript.Alert("注册失败");
                    Jscript.GoHistory(-1);
                }
            }
        }

        /// <summary>
        /// 用户资料修改
        /// </summary>
        /// <param name="Username">用户名</param>
        /// <param name="Password">密码</param>
        /// <param name="Gender">性别</param>
        /// <param name="Email">电子邮件</param>
        /// <param name="HideEmail">隐藏邮箱</param>
        /// <param name="Homepage">个人主页</param>
        /// <param name="Qq">QQ</param>
        /// <returns></returns>
        public void UP_blog_Member(string Username, string Password, string Gender, string Email, string HideEmail, string Homepage, string Qq)
        {
            Username = StringUtil.InputText(Username, 10);
            Password = StringUtil.InputText(Password, 20);
            Email = StringUtil.InputText(Email, 50);
            Homepage = StringUtil.InputText(Homepage, 100);
            Qq = StringUtil.InputText(Qq, 10);
            try
            {
                strSql = "update blog_member set ";
                if (Password!="")
                    strSql += "mem_Password='" + StringUtil.EncryptPassword(Password, "MD5") + "',";
                strSql += "mem_Sex=" + Gender + ",mem_Email='" + Email + "',mem_HideEmail=" + HideEmail + ",mem_HomePage='" + Homepage + "',mem_QQ='" + Qq + "' where  mem_Name='" + Username + "'";
                RunSql(strSql);
                HttpContext.Current.Response.Cookies.Add(new HttpCookie("username", Username));
                Jscript.JavaScriptLocationHref("default.aspx");
            }
            catch
            {
                Jscript.Alert("修改失败");
                Jscript.GoHistory(-1);
            }
        }

        /// <summary>
        /// 获取回复总条数--后台
        /// </summary>
        /// <returns></returns>
        public string Member_Count(string blogcommpage)
        {
            return RunSqlReturn("SELECT int(count(mem_ID)/" + blogcommpage + "+1) FROM blog_Member");
        }

        /// <summary>
        /// 带条件-获取回复总条数--后台
        /// </summary>
        /// <returns></returns>
        public string Member_Count(string blogcommpage,string SQL)
        {
            return RunSqlReturn("SELECT int(count(mem_ID)/" + blogcommpage + "+1) FROM blog_Member where "+SQL+"");
        }

        /// <summary>
        /// 查看用户信息
        /// </summary>
        /// <param name="SearchCondition">查询条件</param>
        /// <param name="OrderList">排序列表</param>
        /// <param name="PageSize">每页的大小</param>
        /// <param name="PageIndex">要显示的页码</param>
        /// <param name="ViewType">0为传统，1为列表</param>
        /// <returns></returns>
        public DataView Member_SELECT(string SearchCondition, string OrderList, string PageSize, string PageIndex)
        {
            string @SQL;
            string @SQL2;
            string @strSQL;
            int @MinID;
            @MinID = (Convert.ToInt32(@PageIndex) - 1) * Convert.ToInt32(@PageSize); //获取上一页的最大ID

            @strSQL = "*";
            //------
            if (@SearchCondition != "")
            {
                @SQL = "WHERE " + @SearchCondition;
                @SQL2 = "AND " + @SearchCondition;
            }
            else
            {
                @SQL = "";
                @SQL2 = "";
            }
            //------
            if (@OrderList != "")
            {
                @SQL = @SQL + " ORDER BY " + @OrderList + " ";
                @SQL2 = @SQL2 + " ORDER BY " + @OrderList + " ";
            }
            //------
            if (@PageSize == "")
                @PageSize = "10";

            if (Convert.ToInt32(@PageIndex) > 1)
                return GetDv("SELECT TOP " + @PageSize + " " + @strSQL + " FROM blog_Member	 WHERE (mem_ID < (SELECT Min(mem_ID) FROM (SELECT TOP " + @MinID + " mem_ID FROM blog_Member  " + @SQL + ") AS T)) " + @SQL2 + "");
            else
                return GetDv("SELECT TOP " + @PageSize + " " + @strSQL + " FROM blog_Member " + @SQL + "");
        }

        /// <summary>
        /// 查看用户信息
        /// </summary>
        /// <param name="mem_Name">用户名</param>
        /// <returns></returns>
        public DataView Member_SELECT(string mem_Name)
        {
            string strSql = "SELECT * FROM blog_Member where mem_Name like '%" + mem_Name + "%'";
            return GetDv(strSql);
        }

        /// <summary>
        /// 删除用户信息
        /// </summary>
        public void Member_DELETE(string mem_ID)
        {
            RunSql("DELETE FROM blog_Member where mem_ID=" + mem_ID + "");
        }

        /// <summary>
        /// 修改用户信息
        /// </summary>
        public void Member_UPDATE(string mem_ID, string mem_Status)
        {
            RunSql("UPDATE blog_Member SET mem_Status = '" + mem_Status + "' where mem_ID=" + mem_ID + "");
        }

        /// <summary>
        /// 通过用户名查看用户信息
        /// </summary>
        /// <param name="username">用户名</param>
        /// <returns></returns>
        public DataView blog_Mem(string username)
        {
            username = StringUtil.InputText(username, 10);
            string strSql = "SELECT * FROM blog_Member where mem_Name='" + username + "'";
            return GetDv(strSql);
        }
    }
}
