﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Web;
using System.Web.SessionState;
using COCOWO.COMP;



namespace COCOWO.DB
{
    public class library
    {
        blog_module Blog_module = new blog_module();
        blog_Content Blog_Content = new blog_Content();
         public string side_html_default = "";//首页侧栏代码
         public string side_html = "";//普通页面侧栏代码
         public string content_html_Top_default ="";//首页内容代码顶部
         public string content_html_Top = "";//普通页面内容代码顶部
         public string content_html_Bottom_default = "";//首页内容代码底部
         public string content_html_Bottom = "";//普通页面内容代码底部

        /// <summary>
        /// 各部分框架
        /// </summary>
        /// <returns></returns>
        public void Side_Module()
        {
            DataView mydv;
            if(QueryString.strHttp.ToLower()=="default.aspx")
                mydv = Blog_module.module_Side_Category("1");
            else
                mydv = Blog_module.module_Side_Category("0");

            for (int i = 0; i < mydv.Count; i++)
            {
                if (mydv[i]["type"].ToString() == "sidebar")
                {
                    side_html_default += @"<div id=""Side_" + mydv[i]["name"].ToString() + @""" class=""sidepanel"">";
                    if (mydv[i]["title"].ToString().Length > 0)
                    {
                        side_html_default += @"<h4 class=""Ptitle"">" + mydv[i]["title"].ToString() + @"</h4>";
                    }
                    side_html_default += @"<div class=""Pcontent"">" + mydv[i]["HtmlCode"].ToString() + @"</div><div class=""Pfoot""></div></div>";
                }

                if (mydv[i]["type"].ToString() == "content" && mydv[i]["name"].ToString() != "ContentList")
                {
                    if (Convert.ToInt32(mydv[i]["SortID"].ToString()) < 0)
                    {
                        content_html_Top_default += @"<div id=""Content_" + mydv[i]["name"].ToString() + @""" class=""content-width"">" + mydv[i]["HtmlCode"].ToString() + @"</div>";
                    }
                    content_html_Bottom_default += @"<div id=""Content_" + mydv[i]["name"].ToString() + @""" class=""content-width"">" + mydv[i]["HtmlCode"].ToString() + @"</div>";

                }
            }

            //日历处理
                side_html_default = side_html_default.Replace("$calendar_code$", Calendar(QueryString.GetC_Year, QueryString.GetC_Month, QueryString.GetC_Day));
                
            //用户面板处理
                side_html_default = side_html_default.Replace("$user_code$", UserPanel());
                
            //归档面板处理
                side_html_default = side_html_default.Replace("$archive_code$", archive());
                
            //树形分类处理
                side_html_default = side_html_default.Replace("$Category_code$", CategoryList(1));

            //显示统计信息
                side_html_default=info_code(side_html_default);

            //处理最新评论内容
                side_html_default = side_html_default.Replace("$comment_code$", NewComment());
                
            //处理友情链接内容
                side_html_default = side_html_default.Replace("$Link_Code$", Bloglinks());

                side_html_default = StringUtil.UnCheckStr(side_html_default);//首页侧栏代码
                content_html_Top_default = StringUtil.UnCheckStr(content_html_Top_default);//首页内容代码顶部
                content_html_Bottom_default = StringUtil.UnCheckStr(content_html_Bottom_default);//首页内容代码底部
        }

        /// <summary>
        /// 返回日历处理
        /// </summary>
        public string Calendar(string C_Year, string C_Month, string C_Day)
        {
            #region
            string StrCalendar;
            if (C_Year == null) C_Year = DateTime.Now.Year.ToString();
            if (C_Month == null) C_Month = DateTime.Now.Month.ToString();
            if (C_Day == null) C_Day = DateTime.Now.Day.ToString();
            //得到上个月的年和月
            string On_Year = Convert.ToDateTime("" + C_Year + "-" + C_Month + "-" + C_Day + "").AddMonths(-1).Year.ToString();
            string On_Month = Convert.ToDateTime("" + C_Year + "-" + C_Month + "-" + C_Day + "").AddMonths(-1).Month.ToString();
            //得到下个月的年和月
            string Off_Year = Convert.ToDateTime("" + C_Year + "-" + C_Month + "-" + C_Day + "").AddMonths(1).Year.ToString();
            string Off_Month = Convert.ToDateTime("" + C_Year + "-" + C_Month + "-" + C_Day + "").AddMonths(1).Month.ToString();

            StrCalendar = @"<div id=""Calendar_Body""><div id=""Calendar_Top""><div id=""LeftB"" onclick=""location.href='default.aspx?C_Year=" + On_Year + @"&C_Month=" + On_Month + @"'""></div><div id=""RightB"" onclick=""location.href='default.aspx?C_Year=" + Off_Year + @"&C_Month=" + Off_Month + @"'""></div>" + C_Year + @"年" + C_Month + @"月</div>";
            StrCalendar += @"<div id=""Calendar_week""><ul class=""Week_UL""><li><font color=""#FF0000"">日</font></li><li>一</li><li>二</li><li>三</li><li>四</li><li>五</li><li>六</li></ul></div>";

            //--->计算当前月份的日期 
            int m = Convert.ToInt32(Convert.ToDateTime(C_Year + "-" + C_Month + "-1").DayOfWeek);
            string S_Date = Convert.ToDateTime(C_Year + " - " + C_Month + " - 1").AddDays(-m).ToShortDateString();
            string E_Date="";
            if ((DateTime.DaysInMonth(DateTime.Now.Year, DateTime.Now.Month)+m-1)>35)
                E_Date = Convert.ToDateTime(S_Date).AddDays(42).ToShortDateString();
            else
                E_Date = Convert.ToDateTime(S_Date).AddDays(35).ToShortDateString();

            //--->保存日志日历缓存 
            string TempTitle = "";
            int TempCount = 0;
            int DayCount = 0;//星期统计
            string Dclass = "";//样式表
            DataView mydv = Blog_module.Content_Side_Calendar(S_Date, E_Date);
            StrCalendar += @"<div class=""Calendar_Day""><ul class=""Day_UL"">";
            while (Convert.ToDateTime(S_Date) < Convert.ToDateTime(E_Date))
            {
                if (DayCount > 6)
                {
                    StrCalendar += @"</ul></div><div class=""Calendar_Day""><ul class=""Day_UL"">";
                    DayCount = 0;
                }
                for (int i = 0; i < mydv.Count; i++)
                {
                    if (Convert.ToDateTime(mydv[i]["log_PostTime"]).ToShortDateString() == S_Date)
                    {
                        TempCount++;
                        if (mydv[i]["log_IsShow"].ToString() == "1")
                            TempTitle += "&#13" + " - " + mydv[i]["log_title"].ToString();
                        else
                            TempTitle += "&#13" + " - [隐藏日志]";
                    }
                }
                if (DateTime.Now.ToShortDateString() == S_Date)
                    Dclass = @"class=""today""";
                else if (Convert.ToDateTime(S_Date).Month.ToString() != C_Month)
                    Dclass = @"class=""otherday""";
                else if (S_Date == DateTime.Now.ToShortDateString())
                    Dclass = @"class=""click""";
                else if (C_Year == DateTime.Now.Year.ToString() && C_Month == DateTime.Now.Month.ToString() && Convert.ToDateTime(S_Date).Day.ToString() == DateTime.Now.Day.ToString())
                    Dclass = @"class=""DayD""";
                else
                    Dclass = @"class=""haveD""";
                //---------------------------------
                if (TempTitle !=String.Empty)
                    StrCalendar += @"<li class=""DayA""><a " + Dclass + @" href=""default.aspx?C_Year=" + Convert.ToDateTime(S_Date).Year.ToString() + @"&C_Month=" + Convert.ToDateTime(S_Date).Month.ToString() + @"&C_Day=" + Convert.ToDateTime(S_Date).Day.ToString() + @""" title=""当天共写了" + TempCount + @"篇日志" + TempTitle + @""">" + Convert.ToDateTime(S_Date).Day.ToString() + @"</a></li>";
                else
                    StrCalendar += @"<li class=""DayA""><a " + Dclass + @">" + Convert.ToDateTime(S_Date).Day.ToString() + @"</a></li>";
                //----------------------------------
                S_Date = Convert.ToDateTime(S_Date).AddDays(1).ToShortDateString();//天数加一天
                TempTitle = "";//提示文本清空
                TempCount = 0;//当天条数清空
                DayCount++;

            }
            StrCalendar += @"</ul></div></div>";
            return StrCalendar;
            #endregion
        }

        /// <summary>
        /// 返回用户面板处理
        /// </summary>
        /// <returns></returns>
        public string UserPanel()
        { 
            string userPanel="";
            string stat_title="普通用户";
            //int stat_AddAll = 1;
            //int stat_Add = 1;
            //int stat_EditAll = 1;
            //int stat_Edit = 1;
            if (UsersInfo.GetUserName != null)
                userPanel = userPanel + " <b>" + UsersInfo.GetUserName + "</b>，欢迎你!<br/>你的权限: " + stat_title + "<br/><br/>";
            if (UsersInfo.GetUserCode.Substring(10, 1) == "1")
                userPanel = userPanel + @"<a href=""control.aspx"" class=""sideA"" accesskey=""3"" target=""_blank"">系统管理</a>";
            if (UsersInfo.GetUserCode.Substring(0, 2) == "11")
                userPanel = userPanel + @"<a href=""blogpost.aspx"" class=""sideA"" accesskey=""N"">发表新日志</a>";
             string draft = Blog_Content.DataList_Count("log_IsDraft = 1 and log_Author='" + UsersInfo.GetUserName + "'", "1");
             if (UsersInfo.GetUserName != null && draft != "0")
                 userPanel = userPanel + @"<a href=""default.aspx?distype=draft"" class=""sideA"" accesskey=""D""><strong>编辑草稿 [" + draft + @"]</strong></a>";

              if (UsersInfo.GetUserName != null)
                userPanel=userPanel+@"<a href=""member.aspx?action=edit"" class=""sideA"" accesskey=""M"">修改个人资料</a><a href=""login.aspx?action=logout"" class=""sideA"" accesskey=""Q"">退出系统</a>";
              else
                userPanel=userPanel+@"<a href=""login.aspx"" class=""sideA"" accesskey=""L"">登录</a><a href=""register.aspx"" class=""sideA"" accesskey=""U"">用户注册</a>";
            return userPanel;
        }

        /// <summary>
        /// 返回日志归档
        /// </summary>
        /// <returns></returns>
        public string archive()
        {
            DataView mydv = Blog_module.Content_archive();
            string Archive="";
            for (int i = 0; i < mydv.Count; i++)
            {
                Archive += @"<a class=""sideA"" href=""default.aspx?C_Year=" + mydv[i][1].ToString() + @"&amp;C_Month=" + mydv[i][2].ToString() + @""" title=""查看当前日期的日志"">" + mydv[i][1].ToString() + @"年" + mydv[i][2].ToString() + @"月 [" + mydv[i][0].ToString() + @"]</a>";
            }
            return Archive;
        }

        /// <summary>
        /// 返回分类菜单
        /// </summary>
        /// <param name="action"></param>
        /// <returns></returns>
        public string CategoryList(int action)//action=0 横向菜单 action=1 树状菜单 
        { 
		    DataView mydv = Blog_module.Category_CategoryList();
            string Category_code = "";
	        //--------------输出日志横向菜单------------------
	        if (action==0)
            {
                    Category_code += @"<div id=""menu""><div id=""Left""></div><div id=""Right""></div><ul><li class=""menuL""></li>";

                    for (int i = 0; i < mydv.Count; i++)
                    {
                        if (mydv[i][9].ToString() == "0" || mydv[i][9].ToString() == "1")
                            {
                            if (i>0)
				            Category_code += @"<li class=""menuDiv""></li>";
                            if (mydv[i][4].ToString() == "1")
                              {
                                Category_code += @"<li><a class=""menuA"" href=""" + mydv[i][5].ToString() + @""" title=""" + mydv[i][3].ToString() + @""">" + mydv[i][1].ToString() + @"</a></li>";
                              }
				  	          else
                              {
                                Category_code += @"<li><a class=""menuA"" href=""default.aspx?cateID=" + mydv[i][0].ToString() + @""" title=""" + mydv[i][3].ToString() + @""">" + mydv[i][1].ToString() + @"</a></li>";
                              }
				            }
                    }
                    Category_code += @"<li class=""menuR""></li></ul></div>";
	        }

            if (action == 1)
            {
                for (int i = 0; i < mydv.Count; i++)
                {
                    if (mydv[i][9].ToString() == "0" || mydv[i][9].ToString() == "1")
                    {
                        if (mydv[i][4].ToString() == "1")
                                Category_code += @"<img src=""" + mydv[i][6].ToString() + @""" border=""0"" style=""margin:3px 4px -4px 0px;"" alt=""" + mydv[i][3].ToString() + @"""/><a class=""CategoryA"" href=""" + mydv[i][5].ToString() + @""" title=""" + mydv[i][3].ToString() + @""">" + mydv[i][1].ToString() + @"</a><br/>";
                        else
                                Category_code += @"<img src=""" + mydv[i][6].ToString() + @""" border=""0"" style=""margin:3px 4px -4px 0px;"" alt=""" + mydv[i][3].ToString() + @"""/><a class=""CategoryA"" href=""default.aspx?cateID=" + mydv[i][0].ToString() + @""" title=""" + mydv[i][3].ToString() + @""">" + mydv[i][1].ToString() + @" [" + mydv[i][7].ToString() + @"]</a> <a href=""feed.aspx?cateID=" + mydv[i][0].ToString() + @""" title=""订阅该分类内容""><img src=""images/rss.png"" border=""0"" style=""margin:3px 4px -1px 0px;"" alt=""""/></a><br/>";
                    }
                }
               
            }
         return Category_code;
        }

        /// <summary>
        /// 返回统计信息
        /// </summary>
        /// <returns></returns>
        public string info_code(string str)
        {
            DataView mydv = Blog_module.Content_archive();
            str = str.Replace("$blog_LogNums$", HttpContext.Current.Application["blog_LogNums"].ToString());
            str = str.Replace("$blog_CommNums$", HttpContext.Current.Application["blog_CommNums"].ToString());
            str = str.Replace("$blog_TbCount$", HttpContext.Current.Application["blog_TbCount"].ToString());
            str = str.Replace("$blog_MessageNums$", HttpContext.Current.Application["blog_MessageNums"].ToString());
            str = str.Replace("$blog_MemNums$", HttpContext.Current.Application["blog_MemNums"].ToString());
            str = str.Replace("$blog_VisitNums$", HttpContext.Current.Application["blog_VisitNums"].ToString());
            str = str.Replace("$blog_OnlineNums$", HttpContext.Current.Application["user_sessions"].ToString());//在线人数
            return str;
        }

        /// <summary>
        /// 返回最新评论
        /// </summary>
        /// <returns></returns>
        public string NewComment()
        {
            DataView mydv = Blog_module.Comment_New();
            string NewComment = "";
            for (int i = 0; i < mydv.Count; i++)
            {
                NewComment += @"<a class=""sideA"" href=""article.aspx?id=" + mydv[i][1].ToString() + @""" title=""" + mydv[i][2].ToString() + @" 于 " + mydv[i][4].ToString() + @" 发表评论&#13;" + StringUtil.GetSubString(mydv[i][3].ToString(), 100) + @""">" + StringUtil.GetSubString(mydv[i][3].ToString(), 25) + @"</a>";
            }
            return NewComment;
        }

        /// <summary>
        /// 返回友情链接
        /// </summary>
        /// <returns></returns>
        public string Bloglinks()
        {
            DataView mydv = Blog_module.log_BlogLinks();
            string Bloglinks = "";
            for (int i = 0; i < mydv.Count; i++)
            {
                if (mydv[i][2].ToString() == "")
                    Bloglinks += @"<a class=""sideA"" href=""" + mydv[i][1].ToString() + @""" target=""_blank"" title=""" + mydv[i][0].ToString() + @""">" + mydv[i][0].ToString() + @"</a>";
                else
                    Bloglinks += @"<a href=""" + mydv[i][1].ToString() + @""" target=""_blank"" title=""" + mydv[i][0].ToString() + @"""><img src=""" + mydv[i][2].ToString() + @""" border=""0"" alt=""""/></a> ";
            }
            return Bloglinks;
        }
    }
}
