/*
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2005 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 * 		http://www.fckeditor.net/
 * 
 * "Support Open Source software. What about a donation today?"
 * 
 * File Name: FileWorkerBase.cs
 * 	Base class used by the FileBrowserConnector and Uploader.
 * 
 * File Authors:
 * 		Frederico Caldeira Knabben (fredck@fckeditor.net)
 */

using System;

namespace FredCK.FCKeditorV2
{
    public abstract class FileWorkerBase : System.Web.UI.Page
    {
        private const string DEFAULT_USER_FILES_PATH = "/UserFiles/";
        private const string DEFAULT_UPLOAD_DENIED_EXTENSIONS = ".php|.php3|.php5|.phtml|.asp|.aspx|.ascx|.jsp|.cfm|.cfc|.pl|.bat|.exe|.dll|.reg|.cgi|.cs|.vb|.asa|.cer|c.dx|.ascx|.asax|.ashx|.asmx|.java|.jsl";

        private string sUserFilesPath;
        private string sUserFilesDirectory;
        private string sUploadDeniedExtensions;

        protected string UserFilesPath
        {
            get
            {
                if (sUserFilesPath == null)
                {
                    // Try to get from the "Application".
                    sUserFilesPath = (string)Application["FCKeditor:UserFilesPath"];

                    // Try to get from the "Session".
                    if (sUserFilesPath == null || sUserFilesPath.Length == 0)
                    {
                        sUserFilesPath = (string)Session["FCKeditor:UserFilesPath"];

                        // Try to get from the Web.config file.
                        if (sUserFilesPath == null || sUserFilesPath.Length == 0)
                        {
                            sUserFilesPath = System.Configuration.ConfigurationSettings.AppSettings["FCKeditor:UserFilesPath"];

                            // Otherwise use the default value.
                            if (sUserFilesPath == null || sUserFilesPath.Length == 0)
                                sUserFilesPath = DEFAULT_USER_FILES_PATH;

                            // Try to get from the URL.
                            if (sUserFilesPath == null || sUserFilesPath.Length == 0)
                            {
                                sUserFilesPath = Request.QueryString["ServerPath"];
                            }
                        }
                    }

                    // Check that the user path ends with slash ("/")
                    if (!sUserFilesPath.EndsWith("/"))
                        sUserFilesPath += "/";
                    ////ResolveUrl  add by tupunco 2006-10-9
                    if (sUserFilesPath.StartsWith("~"))
                        sUserFilesPath = this.ResolveUrl(sUserFilesPath);
                }
                return sUserFilesPath;
            }
        }

        /// <summary>
        /// The absolution path (server side) of the user files directory. It 
        /// is based on the <see cref="FileWorkerBase.UserFilesPath"/>.
        /// </summary>
        protected string UserFilesDirectory
        {
            get
            {
                if (sUserFilesDirectory == null)
                {
                    // Get the local (server) directory path translation.
                    sUserFilesDirectory = Server.MapPath(this.UserFilesPath);
                }
                return sUserFilesDirectory;
            }
        }

        /// <summary>
        /// Denied File's Extensions
        /// ļչ
        /// AppSettings["FCKeditor:UploadDeniedExtensions"]
        /// ÷ԲοUserFilesPath÷
        /// </summary>
        public string UploadDeniedExtensions
        {
            get
            {
                if (sUploadDeniedExtensions == null)
                {
                    // Try to get from the "Application".
                    sUploadDeniedExtensions = (string)Application["FCKeditor:UploadDeniedExtensions"];

                    // Try to get from the "Session".
                    if (sUploadDeniedExtensions == null || sUploadDeniedExtensions.Length == 0)
                    {
                        sUploadDeniedExtensions = (string)Session["FCKeditor:UploadDeniedExtensions"];

                        // Try to get from the Web.config file.
                        if (sUploadDeniedExtensions == null || sUploadDeniedExtensions.Length == 0)
                        {
                            sUploadDeniedExtensions = System.Configuration.ConfigurationSettings.AppSettings["FCKeditor:UploadDeniedExtensions"];

                            // Otherwise use the default value.
                            if (sUploadDeniedExtensions == null || sUploadDeniedExtensions.Length == 0)
                                sUploadDeniedExtensions = DEFAULT_UPLOAD_DENIED_EXTENSIONS;
                        }
                    }
                }
                return sUploadDeniedExtensions;
            }
        }
        /// <summary>
        /// Check Can Upload this file
        /// жļǷϴ
        /// </summary>
        /// <param name="sFileName">will upload file's nameҪϴļ</param>
        /// <returns></returns>
        public bool CheckUploadFileExtension(string sFileName)
        {
            //Denied Extensions Array
            //ļչ
            string[] aExtensions = this.UploadDeniedExtensions.Split(new char[] { '|' });
            //Ҫϴļչ
            string fileEx = System.IO.Path.GetExtension(sFileName);
            foreach (string ex in aExtensions)
            {
                if (ex == fileEx)
                    return false;
            }
            return true;
        }
    }
}
