﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using COCOWO.DB;
using COCOWO.COMP;

public partial class common_MultiPage : System.Web.UI.UserControl
{
    private int _CountSum;

    /// <summary>
    /// 每页显示条数
    /// </summary>
    public int CountSum
    {
        get { return _CountSum; }

        set { _CountSum = value; }
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            BindGrid();
    }
    private void BindGrid()
    {
        //定义变量用来保存当前页索引
        int CurPage;
        //判断是否具有页面跳转的请求
        if (QueryString.IntPage != 0)
            CurPage = QueryString.IntPage;
        else
            CurPage = 1;
        string FileName = Request.Url.ToString();//CurrentExecutionFilePath是获取文件名
        if (FileName.IndexOf( "page=") > 0) //FileName.Substring(0, FileName.IndexOf("page="));
            FileName = FileName.Substring(0, FileName.IndexOf("page=")-1);
        FileName += (FileName.IndexOf("?")>0) ? "&" : "?";
        //如果当前页面不是首页
        if (CurPage > 1)
        {
            //定义"上一页"超级链接的URL为：当前执行页面的虚拟路径,并传递下一页面的索引值
            lnkPrev.NavigateUrl = FileName + "page=" + Convert.ToString(CurPage - 1);
            lnkFirst.NavigateUrl = FileName + "page=1";
        }

        //如果当前页面不是最后一页
        if (CurPage < CountSum)
        {
            //定义"下一页"超级链接的URL为：当前执行页面的虚拟路径,并传递下一页面的索引值
            lnkNext.NavigateUrl = FileName + "page=" + Convert.ToString(CurPage + 1);
            lnkEnd.NavigateUrl = FileName + "page=" + Convert.ToString(CountSum);
        }
        int lnkOn, lnkOff;
        if (CurPage > CountSum - 5 && CountSum > 10)
        {
            lnkOn = CountSum - 9;
            lnkOff = CountSum;
        }
        else if (CurPage > 5 && CountSum > 10)
        {
            lnkOn = CurPage - 4;
            lnkOff = CurPage + 5;
        }
        else
        {
            lnkOn = 1;
            lnkOff = (CountSum > 10 ? 10 : CountSum);
        }
        //当总页数大于1时显示页码
        if (CountSum > 1)
            lnkLabel.Visible = true;
        //显示快退导航
        if (CurPage > 5 && CountSum > 10)
        {
            lnkFirst.Visible = true;
            lnkPrev.Visible = true;
        }
        //显示快进导航
        if (CurPage < CountSum - 5 && CountSum > 10)
        {
            lnkNext.Visible = true;
            lnkEnd.Visible = true;
        }
        for (int i = lnkOn; i <= lnkOff; i++)
        {
            if (i == CurPage)
            {
                lnkLabel.Text += "<STRONG>" + i.ToString() + "</STRONG> | ";
            }
            else
            {
                lnkLabel.Text += "<A href=" + FileName + "page=" + i.ToString() + ">" + i.ToString() + "</A> | ";
            }
        }
    }
}
