﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using COCOWO.COMP;
using COCOWO.DB;

public partial class guestbook : System.Web.UI.Page
{
    MyControl Ctrl = new MyControl();
    Users users = new Users();
    SqlDataBase SQLDB = new SqlDataBase();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            BindGrid();
        if (UsersInfo.GetUserName != null)
        {
            tr1.Visible = false;
            username.Text = UsersInfo.GetUserName;
        }
        else
        {
            tr1.Visible = true;
        }
        if (Application["blog_validate"].ToString() == "False")
        {
            tr2.Visible = false;
        }
        if (UsersInfo.GetUserCode.Substring(6, 2) != "11")
            MsgComment.Visible = false;
        else
        {
            UBBconfigl1.UBB_Form = "Message";
            UBBconfigl1.UBB_AutoHidden = true;
            if (Application["blog_commUBB"].ToString() == "True")
                UBBconfigl1.UBB_Tools_Items = "smiley";
            else
                UBBconfigl1.UBB_Tools_Items = "bold,italic,underline|image,link,mail,quote,smiley";

        }
    }
    private void BindGrid()
    {
        //进行数据绑定,返回评论信息
        int PageCount = Convert.ToInt32(Book_Count(Application["blogcommpage"].ToString()));
        if (PageCount > 1)
        {
            MultiPage1.CountSum = PageCount;
            MultiPage2.CountSum = PageCount;
        }
        else
        {
            PageDIV.Visible = false;
            PageDIV2.Visible = false;
        }

        DataView Comment = Book_List("", "book_ID desc", Application["blogcommpage"].ToString(), QueryString.IntPage.ToString());
        for (int i = 0; i < Comment.Count; i++)
        {
            string ff= Comment[i]["book_HiddenReply"].ToString();
            if (Comment[i]["book_HiddenReply"].ToString() == "False")
                Comment[i]["book_Content"] = "留言已隐藏";
        }
        Ctrl.BindDataList(DataList1, Comment);
        for (int i = 0; i < Comment.Count; i++)
        {
            if (UsersInfo.GetUserCode.Substring(8, 1) == "1")
            {
                ((Label)DataList1.Items[i].FindControl("PostIP")).Visible = true;
                ((ImageButton)DataList1.Items[i].FindControl("DELETEBut")).Visible = true;
            }
        }

    }
    protected void DELETEBut_Command(object sender, CommandEventArgs e)
    {
        Book_DELETE(e.CommandArgument.ToString());
        BindGrid();
    }
    protected void userbutton_Click(object sender, EventArgs e)
    {
        if (Request.Form["Message"].ToString() == "")
        {
            Jscript.Alert("内容不能为空!");
            Jscript.GoHistory(-1);
            return;
        }
        if (!Equals(UsersInfo.GetcommTimerout, null))
        {
            Jscript.Alert("发言太快请等" + Application["blog_commTimerout"].ToString() + "秒！");
            Jscript.GoHistory(-1);
            return;
        }
        if (Application["blog_validate"].ToString() == "True")
        {
            if (Request.Cookies["CheckCode"] == null)
            {
                Jscript.Alert("您的浏览器设置已被禁用 Cookies，您必须设置浏览器允许使用 Cookies 选项后才能使用本系统!");
                Jscript.GoHistory(-1);
                return;
            }
            if (String.Compare(Request.Cookies["CheckCode"].Value, validate.Text, true) != 0)
            {
                Jscript.Alert("验证码错误，请输入正确的验证码!");
                Jscript.GoHistory(-1);
                return;
            }
            else
                BindMessage();
        }
        else
        {
            BindMessage();

        }
    }
    private void BindMessage()
    {
        try
        {
            Request.Cookies["blog_commTimerout"].Expires = DateTime.Now.AddSeconds(Convert.ToInt32(Application["blog_commTimerout"]));
        }
        catch
        {
            Response.Cookies.Add(new HttpCookie("blog_commTimerout"));
            Request.Cookies["blog_commTimerout"].Expires = DateTime.Now.AddSeconds(Convert.ToInt32(Application["blog_commTimerout"]));
        }

        string Message = StringUtil.CheckStr(Request.Form["Message"].ToString());//回复内容
        if (password.Text != string.Empty)
            users.VldUserLogin(username.Text, password.Text, 30);
        Book_INSERT(username.Text, Request["book_face"], Request.UserHostAddress, Message, (book_HiddenReply.Checked) ? "0" : "1");
        // Jscript.AlertAndRedirect("提交成功", Request.Url.ToString());
        BindGrid();
    }

    /// <summary>
    /// 获取book列表
    /// </summary>
    public DataView Book_List()
    {
        return SQLDB.GetDv("SELECT * FROM blog_book order by book_ID desc");
    }
    /// <summary>
    /// 获取book列表
    /// </summary>
    /// <param name="SearchCondition">查询条件</param>
    /// <param name="OrderList">排序列表</param>
    /// <param name="PageSize">每页的大小</param>
    /// <param name="PageIndex">要显示的页码</param>
    /// <returns></returns>
    public DataView Book_List(string @SearchCondition, string @OrderList, string @PageSize, string @PageIndex)
    {
        string @SQL;
        string @SQL2;
        string @strSQL;
        int @MinID;
        @MinID = (Convert.ToInt32(@PageIndex) - 1) * Convert.ToInt32(@PageSize); //获取上一页的最大ID

        @strSQL = "book_ID,book_Messager,book_face,book_IP,book_Content,book_HiddenReply,book_PostTime";
        //------
        if (@SearchCondition != "")
        {
            @SQL = "WHERE " + @SearchCondition;
            @SQL2 = "AND " + @SearchCondition;
        }
        else
        {
            @SQL = "";
            @SQL2 = "";
        }
        //------
        if (@OrderList != "")
        {
            @SQL = @SQL + " ORDER BY " + @OrderList + " ";
            @SQL2 = @SQL2 + " ORDER BY " + @OrderList + " ";
        }
        //------
        if (@PageSize == "")
            @PageSize = "10";

        if (Convert.ToInt32(@PageIndex) > 1)
            return SQLDB.GetDv("SELECT TOP " + @PageSize + " " + @strSQL + " FROM blog_book	 WHERE (book_ID < (SELECT Min(book_ID) FROM (SELECT TOP " + @MinID + " book_ID FROM blog_book  " + @SQL + ") AS T)) " + @SQL2 + "");
        else
            return SQLDB.GetDv("SELECT TOP " + @PageSize + " " + @strSQL + " FROM blog_book " + @SQL + "");

    }
    /// <summary>
    /// 这一部分是修改前台显示10条部分的
    /// </summary>
    public void book_MODULE()
    {
        DataView mydv = SQLDB.GetDv("SELECT TOP 10 * FROM blog_book where book_HiddenReply<>0 order by book_replyTime desc");
        string NewComment = "";
        for (int i = 0; i < mydv.Count; i++)
        {
            NewComment += @"<a class=""sideA"" href=""guestbook.aspx"" title=""" + mydv[i]["book_Messager"].ToString() + @" 于 " + mydv[i]["book_replyTime"].ToString() + @" 发表评论&#13;" + StringUtil.GetSubString(mydv[i]["book_content"].ToString(), 100) + @""">" + StringUtil.GetSubString(mydv[i]["book_content"].ToString(), 25) + @"</a>";
        }
        NewComment = StringUtil.CheckStr(@"<div class=""commentTable"">" + NewComment + @"</div>");
        SQLDB.RunSql("UPDATE blog_module SET HtmlCode='" + NewComment + "' WHERE name='GuestBookForCOCOWO_Blog'");
    }
    /// <summary>
    /// 添加book
    /// </summary>
    public void Book_INSERT(string book_Messager, string book_face, string book_IP, string book_Content, string book_HiddenReply)
    {
        SQLDB.RunSql("INSERT INTO blog_book (book_Messager,book_face,book_IP,book_Content,book_HiddenReply) VALUES ('" + book_Messager + "','" + book_face + "','" + book_IP + "','" + book_Content + "','" + book_HiddenReply + "')");
        book_MODULE();
    }
    /// <summary>
    /// 删除book
    /// </summary>
    public void Book_DELETE(string book_ID)
    {
        SQLDB.RunSql("DELETE FROM blog_book where book_ID=" + book_ID + "");
        book_MODULE();
    }
    /// <summary>
    /// 修改book
    /// </summary>
    public void Book_UPDATE(string book_ID, string book_Messager, string book_face, string book_IP, string book_Content, string book_HiddenReply)
    {
        SQLDB.RunSql("UPDATE blog_book SET book_Messager = '" + book_Messager + "', book_face = " + book_face + ", book_IP = " + book_IP + ", book_Content = " + book_Content + ", book_HiddenReply = " + book_HiddenReply + " where book_ID=" + book_ID + "");
        book_MODULE();
    }
    /// <summary>
    /// 获取总分页数--后台
    /// </summary>
    /// <returns></returns>
    public string Book_Count(string blogcommpage)
    {
        return SQLDB.RunSqlReturn("SELECT int(count(book_ID)/" + blogcommpage + ".0) FROM blog_book");
    }
}
