﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.IO;
using COCOWO.COMP;
using COCOWO.DB;

public partial class ConContent : System.Web.UI.Page
{
    blog_module Blog_module = new blog_module();
    MyControl Ctrl = new MyControl();
    blog_Category Blog_Category = new blog_Category();
    blog_Content Blog_Content = new blog_Content();
    blog_tag Blog_tag = new blog_tag();
    blog_spam Blog_spam = new blog_spam();
    blog_Comment Blog_Comment = new blog_Comment();
    blog_status Blog_status = new blog_status();
    Users Blog_Users = new Users();
    blog_Links Blog_Links = new blog_Links();
    blog_Smilies Blog_Smilies = new blog_Smilies();
    blog_Keywords Blog_Keywords = new blog_Keywords();
    blog_Trackback Blog_Trackback = new blog_Trackback();
    SQL_DB SQL_db = new SQL_DB();
    SqlDataBase sqldatabase = new SqlDataBase();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            if (UsersInfo.GetUserCode.Substring(10, 1) != "1" && UsersInfo.GetmemhashKey != "")
            {
                Jscript.Alert("您不是管理员，不可以使用本功能!");
                BindLogout();
            }
            else if (UsersInfo.GetmemhashKey == null || UsersInfo.GetmemhashKey == "")
            {
                BindLogout();
            }
            else if (QueryString.GetFmenu == "welcome" && QueryString.GetSmenu == null)
                welcome.Visible = true;
            else if (QueryString.GetFmenu == "General" && QueryString.GetSmenu == null)
                BindGeneral();
            else if (QueryString.GetFmenu == "General" && QueryString.GetSmenu == "Misc")
                General_Misc.Visible = true;
            else if (QueryString.GetFmenu == "Categories" && QueryString.GetSmenu == null)
                BindCategories();
            else if (QueryString.GetFmenu == "Categories" && QueryString.GetSmenu == "move")
                BindCategories_move();
            else if (QueryString.GetFmenu == "Categories" && QueryString.GetSmenu == "del")
                BindCategories_del();
            else if (QueryString.GetFmenu == "Categories" && QueryString.GetSmenu == "tag")
                BindCategories_Tag();
            else if (QueryString.GetFmenu == "Comment" && QueryString.GetSmenu == null)
                BindComment();
            else if (QueryString.GetFmenu == "Comment" && QueryString.GetSmenu == "trackback")
                BindComment_trackback();
            else if (QueryString.GetFmenu == "Comment" && QueryString.GetSmenu == "spam")
                BindComment_spam();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == null)
                BindSkins();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "module")
                BindSkins_module();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "editModuleNormal")
                BindSkins_editModuleNormal();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "editModule")
                BindSkins_editModule();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "PluginsInstall")//界面设置 - 安装模块插件
                BindSkins_PluginsInstall();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "InstallPlugins")//界面设置 - 安装插件
                BindSkins_InstallPlugins();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "Plugins")//界面设置 - 已装插件管理
                BindSkins_Plugins();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "DelPlugins")//界面设置 - 删除插件
                BindSkins_DelPlugins();
            else if (QueryString.GetFmenu == "Skins" && QueryString.GetSmenu == "PluginsOptions")//界面设置 - 插件基本设置
                BindSkins_PluginsOptions();
            else if (QueryString.GetFmenu == "Members" && QueryString.GetSmenu == null)
                BindMembers();
            else if (QueryString.GetFmenu == "Members" && QueryString.GetSmenu == "EditRight")
                BindMembers_EditRight();
            else if (QueryString.GetFmenu == "Members" && QueryString.GetSmenu == "Users")
                BindMembers_Users();
            else if (QueryString.GetFmenu == "Members" && QueryString.GetSmenu == "Search")
                BindMembers_Search();
            else if (QueryString.GetFmenu == "Link" && QueryString.GetSmenu == null)
                BindLink();
            else if (QueryString.GetFmenu == "smilies" && QueryString.GetSmenu == null)
                BindSmilies();
            else if (QueryString.GetFmenu == "smilies" && QueryString.GetSmenu == "KeyWord")
                BindSmilies_KeyWord();
            else if (QueryString.GetFmenu == "Status" && QueryString.GetSmenu == null)
                BindStatus();
            else if (QueryString.GetFmenu == "SQLFile" && QueryString.GetSmenu == null)
                BindSQLFile();
            else if (QueryString.GetFmenu == "Logout")
                BindLogout();
        }
    }

    /// <summary>
    /// SQL数据管理
    /// </summary>
    private void BindSQLFile()
    {
        SQLFile.Visible = true;
        //读取blogDB文件夹下的全部文件名称
        //DataTable testDT = new DataTable("SQLSet");//创建一个DataTable
        //DataColumn testDC = new DataColumn("FileName", Type.GetType("System.String"));//添加列
        //testDT.Columns.Add(testDC);
        DirectoryInfo d = new DirectoryInfo(Request.PhysicalApplicationPath + @"DB_51aspx");
        FileInfo[] files = d.GetFiles();
        DataTable testDT = new DataTable("SQLSet");//创建一个DataTable
        DataColumn testDC = new DataColumn("FileName", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        DataRow testDR;
        foreach (FileInfo fi in files)     
        {
            testDR = testDT.NewRow();
            testDR["FileName"] = fi.Name;
            testDT.Rows.Add(testDR);
        }   

        testDT.AcceptChanges();
        DataView SQLdv = new DataView(testDT);
        Ctrl.BindGridView(SQLFiles, SQLdv);
        string ConnectionString=ConfigurationManager.ConnectionStrings["ConnectionString"].ConnectionString;
        for (int i = 0; i < SQLdv.Count; i++)
        { 
            if (SQLdv[i][0].ToString()==ConnectionString.Substring(ConnectionString.IndexOf("/")+1))
            {
                SQLFiles.Rows[i].Cells[1].Visible = false;
                SQLFiles.Rows[i].Cells[2].Visible = false;
            }
        }
    }

    /// <summary>
    /// 退出后台管理
    /// </summary>
    private void BindLogout()
    {
        Response.Cookies["memhashKey"].Value = "";
        Jscript.RefreshParent("Default.aspx");
    }

    /// <summary>
    /// 服务器配置信息
    /// </summary>
    private void BindStatus()
    {
        Status.Visible = true;
        Response.Expires = 0;
        Response.CacheControl = "no-cache";
        if (!Page.IsPostBack)
        {

            //取得页面执行开始时间
            DateTime stime = DateTime.Now;

            //取得服务器相关信息
            servername.Text = Server.MachineName;
            serverip.Text = Request.ServerVariables["LOCAL_ADDR"];
            server_name.Text = Request.ServerVariables["SERVER_NAME"];

            //以下就是取值不准的地方，因为用了HTTP_USER_AGENT当做服务器信息。
            //1.0 final 使用Environment类属性，彻底解决了这一问题
            //char[] de = {';'};
            //string allhttp=Request.ServerVariables["HTTP_USER_AGENT"].ToString();
            //string[] myFilename = allhttp.Split(de);
            //servernet.Text=myFilename[myFilename.Length-1].Replace(")"," ");
            int build, major, minor, revision;
            build = Environment.Version.Build;
            major = Environment.Version.Major;
            minor = Environment.Version.Minor;
            revision = Environment.Version.Revision;
            servernet.Text = ".NET CLR  " + major + "." + minor + "." + build + "." + revision;
            serverms.Text = Environment.OSVersion.ToString();
            //服务器端浏览器版本暂时不知道怎么取得，原有不准，故删除
            //1.0 final 修改
            //serverie.Text=myFilename[1];

            serversoft.Text = Request.ServerVariables["SERVER_SOFTWARE"];
            serverport.Text = Request.ServerVariables["SERVER_PORT"];
            serverout.Text = Server.ScriptTimeout.ToString();
            //语言应该是浏览者信息，1.0 final 修改
            cl.Text = Request.ServerVariables["HTTP_ACCEPT_LANGUAGE"];
            servertime.Text = DateTime.Now.ToString();
            serverppath.Text = Request.ServerVariables["APPL_PHYSICAL_PATH"];
            servernpath.Text = Request.ServerVariables["PATH_TRANSLATED"];
            serverhttps.Text = Request.ServerVariables["HTTPS"];

            if (chkobj("ADODB.RecordSet"))
            {
                serveraccess.Text = "支持";
            }
            else
            {
                serveraccess.Text = "不支持";
            }

            if (chkobj("Scripting.FileSystemObject"))
            {
                serverfso.Text = "支持";
            }
            else
            {
                serverfso.Text = "不支持";
            }

            if (chkobj("CDONTS.NewMail"))
            {
                servercdonts.Text = "支持";
            }
            else
            {
                servercdonts.Text = "不支持";
            }

            servers.Text = Session.Contents.Count.ToString();
            servera.Text = Application.Contents.Count.ToString();

            //0.1版添加的组件验证，原有组件并未转移过来，请原谅。 
            if (chkobj("JMail.SmtpMail"))
            {
                jmail.Text = "支持";
            }
            else
            {
                jmail.Text = "不支持";
            }

            if (chkobj("Persits.MailSender"))
            {
                aspemail.Text = "支持";
            }
            else
            {
                aspemail.Text = "不支持";
            }

            if (chkobj("Geocel.Mailer"))
            {
                geocel.Text = "支持";
            }
            else
            {
                geocel.Text = "不支持";
            }

            if (chkobj("SmtpMail.SmtpMail.1"))
            {
                smtpmail.Text = "支持";
            }
            else
            {
                smtpmail.Text = "不支持";
            }

            if (chkobj("Persits.Upload.1"))
            {
                aspup.Text = "支持";
            }
            else
            {
                aspup.Text = "不支持";
            }

            if (chkobj("aspcn.Upload"))
            {
                aspcnup.Text = "支持";
            }
            else
            {
                aspcnup.Text = "不支持";
            }

            if (chkobj("LyfUpload.UploadFile"))
            {
                lyfup.Text = "支持";
            }
            else
            {
                lyfup.Text = "不支持";
            }

            if (chkobj("SoftArtisans.FileManager"))
            {
                soft.Text = "支持";
            }
            else
            {
                soft.Text = "不支持";
            }

            if (chkobj("w3.upload"))
            {
                dimac.Text = "支持";
            }
            else
            {
                dimac.Text = "不支持";
            }

            if (chkobj("W3Image.Image"))
            {
                dimacimage.Text = "支持";
            }
            else
            {
                dimacimage.Text = "不支持";
            }

            //取得用户浏览器信息
            HttpBrowserCapabilities bc = Request.Browser;
            ie.Text = bc.Browser.ToString();
            cookies.Text = bc.Cookies.ToString();
            frames.Text = bc.Frames.ToString();
            javaa.Text = bc.JavaApplets.ToString();
            javas.Text = bc.JavaScript.ToString();
            ms.Text = bc.Platform.ToString();
            vbs.Text = bc.VBScript.ToString();
            vi.Text = bc.Version.ToString();

            //取得浏览者ip地址,1.0 final 加入
            //cip.Text = Request.ServerVariables["REMOTE_ADDR"];
            //考虑到代理服务器影响，１.1修正
            cip.Text = getip();

            //取得页面执行结束时间
            DateTime etime = DateTime.Now;


            //计算页面执行时间
            runtime.Text = ((etime - stime).TotalMilliseconds).ToString();

            //以下几个功能由dvnews4.0看来的。v１.1加入
            cpuc.Text = Environment.GetEnvironmentVariable("NUMBER_OF_PROCESSORS");
            cputype.Text = Environment.GetEnvironmentVariable("PROCESSOR_IDENTIFIER");
            aspnetn.Text = getaspnetn();
            aspnetcpu.Text = getaspnetcpu();
            serverstart.Text = ((Double)System.Environment.TickCount / 3600000).ToString("N2");
            prstart.Text = getprstart();
            serverarea.Text = (DateTime.Now - DateTime.UtcNow).TotalHours > 0 ? "+" + (DateTime.Now - DateTime.UtcNow).TotalHours.ToString() : (DateTime.Now - DateTime.UtcNow).TotalHours.ToString();
            //以上几个功能由dvnews4.0看来的。
        }

    }

    /// <summary>
    /// 表情与关键字 - 关键字管理
    /// </summary>
    private void BindSmilies_KeyWord()
    {
        smilies_KeyWord.Visible = true;
        DataView mydv = Blog_Keywords.Keywords_List();
        Ctrl.BindGridView(KeywordsView, mydv);
    }

    /// <summary>
    /// 表情与关键字 - 表情管理
    /// </summary>
    private void BindSmilies()
    {
        smilies.Visible = true;
        DataView mydv = Blog_Smilies.Smilies_List();
        Ctrl.BindGridView(SmiliesView, mydv);
    }

    /// <summary>
    /// 友情链接管理
    /// </summary>
    private void BindLink()
    {
        Link.Visible = true;
        DataView mydv = Blog_Links.Links_List();
        Ctrl.BindGridView(LinkView, mydv);
    }

    /// <summary>
    /// 帐户与权限管理 - 帐户管理
    /// </summary>
    private void BindMembers_Users()
    {
        Members_Users.Visible = true;
        MultiPage5.CountSum = Convert.ToInt32(Blog_Users.Member_Count("30").ToString());
        MultiPage6.CountSum = Convert.ToInt32(Blog_Users.Member_Count("30").ToString());
        DataView mydv = Blog_Users.Member_SELECT("", "mem_ID desc", "30", QueryString.IntPage.ToString());
        Ctrl.BindGridView(MemberView, mydv);
        for (int i = 0; i < mydv.Count; i++)
        {
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataSource = Blog_status.Status_List();
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataTextField = "stat_title";
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataValueField = "stat_name";
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataBind();
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).SelectedValue = mydv[i]["mem_Status"].ToString();

        }

    }


    /// <summary>
    /// 帐户与权限管理 - 编辑权限细节
    /// </summary>
    private void BindMembers_EditRight()
    {
        Members_EditRight.Visible = true;
        DataView mydv = Blog_status.Status_List(QueryString.GetId);
        Administrator_name.Text = mydv[0]["stat_name"].ToString();
        Adminstatus_title.Text = mydv[0]["stat_title"].ToString();
        AddArticle.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(0, 2);
        AdminAddArticle.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(2, 2);
        AdminDelArticle.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(4, 2);
        AdminAddComment.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(6, 2);
        AdminDelComment.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(8, 1);
        AdminShowHiddenCate.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(9, 1);
        IsAdmin.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(10, 1);
        AdminCanUpload.SelectedValue = mydv[0]["stat_Code"].ToString().Substring(11, 1);
        UploadSize.Text = mydv[0]["stat_attSize"].ToString();
        UploadType.Text = mydv[0]["stat_attType"].ToString();
    }

    /// <summary>
    /// 帐户与权限管理 - 权限管理
    /// </summary>
    private void BindMembers()
    {
        Members.Visible = true;
        DataView mydv = Blog_status.Status_List();
        Ctrl.BindGridView(statusView, mydv);
    }

    /// <summary>
    /// 界面设置 - 可视化编辑HTML代码
    /// </summary>
    private void BindSkins_editModule()
    {
        Skins_editModule.Visible = true;
        DataView mydv = Blog_module.module_Select(QueryString.GetId);
        blog_Emodule_Type.ImageUrl = "images/" + mydv[0]["type"].ToString() + ".gif";
        blog_Emodule_Title.Text = mydv[0]["title"].ToString();
        FCKeditor1.Value = StringUtil.UnCheckStr(mydv[0]["HtmlCode"].ToString());
    }

    /// <summary>
    /// 界面设置 - 编辑HTML源代码
    /// </summary>
    private void BindSkins_editModuleNormal()
    {
        Skins_editModuleNormal.Visible = true;
        DataView mydv = Blog_module.module_Select(QueryString.GetId);
        blog_module_Type.ImageUrl = "images/" + mydv[0]["type"].ToString() + ".gif";
        blog_Emodule_Title.Text = mydv[0]["title"].ToString();
        HtmlCode.Text = StringUtil.UnCheckStr(mydv[0]["HtmlCode"].ToString());
    }

    /// <summary>
    /// 界面设置 - 设置模块
    /// </summary>
    private void BindSkins_module()
    {
        Skins_module.Visible = true;
        DataView mydv = Blog_module.module_Select();
        Ctrl.BindGridView(SmenuView, mydv);
        for (int i = 0; i < mydv.Count; i++)
        {
            ((DropDownList)SmenuView.Rows[i].FindControl("mType")).Attributes.Add("onchange", "document.images['" + ((Image)SmenuView.Rows[i].FindControl("Mimg")).UniqueID.Replace("$", "_") + "'].src='images/'+this.value +'.gif'");
            if (mydv[i]["IsSystem"].ToString() == "True")
                SmenuView.Rows[i].Cells[9].Visible = false;

        }
    }
    /// <summary>
    /// 插件基本设置
    /// </summary>
    private void BindSkins_PluginsOptions()
    {
        Skins_PluginsOptions.Visible = true;
        DataView mydv = Blog_module.module_Select(QueryString.GetId);
        Label3.Text = mydv[0]["title"].ToString();
    }
    /// <summary>
    /// 删除插件
    /// </summary>
    private void BindSkins_DelPlugins()
    {
        string CateID = Blog_module.module_Select(QueryString.GetId)[0]["CateID"].ToString();
        if (CateID != null)
            Blog_Category.Category_DELETE(Blog_module.module_Select(QueryString.GetId)[0]["CateID"].ToString());
        Blog_module.module_DELETE(QueryString.GetId);
        //删除指定文件夹对应其他文件夹里的文件
        FilesIO.DeleteFiles(Request.PhysicalApplicationPath + @"Plugins\" + QueryString.GetTag + @"\Files\", Request.PhysicalApplicationPath);
        BindSkins_Plugins();
    }
    /// <summary>
    /// 界面设置 - 已装插件管理
    /// </summary>
    private void BindSkins_Plugins()
    {
        Skins_Plugins.Visible = true;
        DataView mydv = Blog_module.module_Select_Plugins();
        Ctrl.BindGridView(lPlugins, mydv);
        for (int i = 0; i < mydv.Count; i++)
        {

            if (mydv[i]["ConfigPath"].ToString().Length > 0)
            {
                ((HyperLink)lPlugins.Rows[i].FindControl("HyperLink1")).NavigateUrl = mydv[i]["ConfigPath"].ToString();
                ((HyperLink)lPlugins.Rows[i].FindControl("HyperLink1")).Text = "设置管理";
            }
            else
            {
                ((HyperLink)lPlugins.Rows[i].FindControl("HyperLink1")).Text = @"<span style=""color:#999"">设置管理</span>";
            }
            ((HyperLink)lPlugins.Rows[i].FindControl("HyperLink3")).Text = "反安装此插件";
            ((HyperLink)lPlugins.Rows[i].FindControl("HyperLink3")).NavigateUrl = "?Fmenu=Skins&Smenu=DelPlugins&id=" + mydv[i]["id"].ToString() + "&Tag=" + mydv[i]["InstallFolder"].ToString();
                
        }
    }

    /// <summary>
    /// 
    /// 界面设置 - 安装插件
    /// </summary>
    private void BindSkins_InstallPlugins()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(Server.MapPath("Plugins/" + QueryString.GetTag + "/install.xml"));
        DataView mydv=ds.Tables[0].DefaultView;

        string C_Max=Blog_Category.Category_Max();

        if (mydv[0]["PluginPath"].ToString().Length > 0)//插入插件菜单
        {
            Blog_Category.Category_INSERT(mydv[0]["PluginTitle"].ToString(), C_Max, mydv[0]["PluginTitle"].ToString(),"1",
                 mydv[0]["PluginPath"].ToString(), "images/icons/1.gif", "0", "0");
        }
        //安装插件配置文件
        Blog_module.module_INSERT(mydv[0]["PluginName"].ToString(), mydv[0]["PluginTitle"].ToString(), mydv[0]["PluginType"].ToString(),
            Blog_module.module_Min(), mydv[0]["PluginHtmlCode"].ToString(), mydv[0]["PluginPath"].ToString(), "1", QueryString.GetTag,
            mydv[0]["ConfigPath"].ToString(), mydv[0]["SettingFile"].ToString(), Blog_Category.Category_Max_ID());


        //写入模块所需要的SQL语句
        if (mydv[0]["CreateTableSQL"].ToString().Length > 0)
            sqldatabase.RunSql(mydv[0]["CreateTableSQL"].ToString());
        if (mydv[0]["UpdateTableSQL"].ToString().Length > 0)
            sqldatabase.RunSql(mydv[0]["UpdateTableSQL"].ToString());
        //复制文件到系统中
        FilesIO.CopyFiles(Request.PhysicalApplicationPath +@"Plugins\" + QueryString.GetTag + @"\Files\", Request.PhysicalApplicationPath);
        BindSkins_PluginsInstall();
    }

    /// <summary>
    /// 界面设置 - 安装模块插件
    /// </summary>
    private void BindSkins_PluginsInstall()
    {
        Skins_PluginsInstall.Visible = true;
        DataTable testDT = new DataTable("SkinSet");//创建一个DataTable
        DataColumn testDC = new DataColumn("FileName", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("PluginName", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("PluginTitle", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("PluginType", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("PluginPath", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("SettingFile", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("Author", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("pubDate", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("About", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        //读取SKIN文件夹下的全部文件夹名称
        DirectoryInfo[] dirs = new DirectoryInfo(Request.PhysicalApplicationPath + @"Plugins").GetDirectories();
        DataRow testDR;
        for (int i = 0; i < dirs.Length; i++)
        {
            if (Blog_module.module_SELECT(dirs[i].Name) == "0")
            {
                string strXmlFile = dirs[i].FullName.ToString() + @"\install.xml";
                XmlControl xmlTool = new XmlControl(strXmlFile);
                DataView SkinXML = xmlTool.GetData(@"PluginInstall");//XML文件里的一级名称

                testDR = testDT.NewRow();
                testDR["FileName"] = dirs[i].Name;
                testDR["PluginName"] = SkinXML[0]["PluginName"];
                testDR["PluginTitle"] = SkinXML[0]["PluginTitle"];
                testDR["PluginType"] = SkinXML[0]["PluginType"];
                testDR["PluginPath"] = SkinXML[0]["PluginPath"];
                testDR["SettingFile"] = SkinXML[0]["SettingFile"];
                testDR["Author"] = SkinXML[0]["Author"];
                testDR["pubDate"] = SkinXML[0]["pubDate"];
                testDR["About"] = SkinXML[0]["About"];
                testDT.Rows.Add(testDR);
            }
        }
        testDT.AcceptChanges();
        DataView SkinXMLS = new DataView(testDT);
        Ctrl.BindGridView(lPluginsInstall, SkinXMLS);
    }

    /// <summary>
    /// 界面设置 - 设置外观
    /// </summary>
    private void BindSkins()
    {
        Skins.Visible = true;
        DataTable testDT = new DataTable("SkinSet");//创建一个DataTable
        DataColumn testDC = new DataColumn("FileName", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("SkinName", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("SkinDesigner", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("pubDate", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("DesignerURL", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("DesignerMail", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("ImageUrl", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("ButtonText", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("listCssClass", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        testDC = new DataColumn("selectImage", Type.GetType("System.String"));//添加列
        testDT.Columns.Add(testDC);
        //读取SKIN文件夹下的全部文件夹名称
        DirectoryInfo[] dirs = new DirectoryInfo(Request.PhysicalApplicationPath + @"skins").GetDirectories();
        DataRow testDR;
        for (int i = 0; i < dirs.Length; i++)
        {
            string strXmlFile = dirs[i].FullName.ToString() + @"\skin.xml";
            XmlControl xmlTool = new XmlControl(strXmlFile);
            DataView SkinXML = xmlTool.GetData(@"SkinSet");

            testDR = testDT.NewRow();
            testDR["FileName"] = dirs[i].Name;
            testDR["SkinName"] = SkinXML[0]["SkinName"];
            testDR["SkinDesigner"] = SkinXML[0]["SkinDesigner"];
            testDR["pubDate"] = SkinXML[0]["pubDate"];
            testDR["DesignerURL"] = SkinXML[0]["DesignerURL"];
            testDR["DesignerMail"] = SkinXML[0]["DesignerMail"];
            if (File.Exists(dirs[i].FullName.ToString() + @"\Preview.jpg"))
            {
                testDR["ImageUrl"] = "skins/" + dirs[i].Name.ToString() + "/Preview.jpg";
            }
            else
            {
                testDR["ImageUrl"] = "images/Control/skin.jpg";
            }
            if (dirs[i].Name.ToString() == Application["blog_DefaultSkin"].ToString())
            {
                testDR["ButtonText"] = "当前使用界面";
                testDR["listCssClass"] = "selectskin";
                testDR["selectImage"] = @"<div class=""cskin""><img src=""images/Control/select.gif"" alt="""" border=""0"" /></div>";
            }
            else
            {
                testDR["ButtonText"] = "设置为当前主题 ";
                testDR["listCssClass"] = "unselectskin";
                testDR["selectImage"] = "";
            }
            testDT.Rows.Add(testDR);
        }
        testDT.AcceptChanges();
        DataView SkinXMLS = new DataView(testDT);
        Ctrl.BindDataList(lListPanel, SkinXMLS);
    }

    /// <summary>
    /// 评论留言管理 - 垃圾关键字过滤黑名单
    /// </summary>
    private void BindComment_spam()
    {
        Comment_spam.Visible = true;
        DataView mydv = Blog_spam.Spam_List();
        Ctrl.BindGridView(spamList, mydv);
    }

    /// <summary>
    /// 评论留言管理 - 引用管理
    /// </summary>
    private void BindComment_trackback()
    {
        Comment_trackback.Visible = true;
        DataView mydv = Blog_Trackback.Trackback_List();
        Ctrl.BindDataList(trackbacklist, mydv);
    }

    /// <summary>
    /// 评论留言管理 - 评论管理
    /// </summary>
    private void BindComment()
    {
        Comment.Visible = true;
        DataView mydv = Blog_Comment.blog_Comment_list("", "comm_ID desc", Application["blogcommpage"].ToString(), QueryString.IntPage.ToString());
        MultiPage3.CountSum = Convert.ToInt32(Blog_Comment.Comment_Count(Application["blogcommpage"].ToString()));
        MultiPage4.CountSum = Convert.ToInt32(Blog_Comment.Comment_Count(Application["blogcommpage"].ToString()));
        Ctrl.BindDataList(Commend_List, mydv);
    }

    /// <summary>
    /// 日志分类管理 - Tag管理
    /// </summary>
    private void BindCategories_Tag()
    {
        Categories_Tag.Visible = true;
        DataView mydv = Blog_tag.Tag_List();
        Ctrl.BindGridView(BTag, mydv);
    }

    /// <summary>
    /// 日志分类管理 - 批量删除日志
    /// </summary>
    private void BindCategories_del()
    {
        if (!this.IsPostBack)
        {
            Categories_del.Visible = true;
            filter.Items.Add(new ListItem("显示所有日志", "A"));
            DataView mydv = Blog_Category.Category_List();
            for (int i = 0; i < mydv.Count; i++)
            {
                filter.Items.Add(new ListItem(mydv[i]["cate_Name"].ToString(), mydv[i]["cate_ID"].ToString())); ;
            }
            filter.Items.Add(new ListItem("显示所有隐藏日志", "B"));
            filter.Items.Add(new ListItem("显示所有草稿", "C"));
        }
        string Filter = (QueryString.GetCateID == null) ? "A" : QueryString.GetCateID;
        if (Filter != null)
            filter.SelectedValue = Filter;
        string SQL = "";
        if (Filter == "A")
            SQL = "";
        else if (Filter == "B")
            SQL = "log_IsDraft=1";
        else if (Filter == "C")
            SQL = "log_IsShow=0";
        else
            SQL = "log_CateID=" + Filter + "";

        int Page = Convert.ToInt32(Application["blogPerPage"]);
        if (QueryString.GetSmenu == "del")
            Page = Convert.ToInt32(Application["blogPerPage"]) * 4;
        MultiPage1.CountSum = Convert.ToInt32(Blog_Content.DataList_Count(SQL, Page.ToString()));
        MultiPage2.CountSum = Convert.ToInt32(Blog_Content.DataList_Count(SQL, Page.ToString()));
        DataView myCon = Blog_Content.GetContentList(SQL, "log_IsTop DESC, log_ID DESC", Page.ToString(), QueryString.IntPage.ToString(), "1");
        Ctrl.BindGridView(DelContent, myCon);
    }

    /// <summary>
    /// 日志分类管理 - 批量移动日志
    /// </summary>
    private void BindCategories_move()
    {
        Categories_move.Visible = true;
        DataView mydv = Blog_Category.Category_List();
        source.DataSource = mydv;
        source.DataTextField = "cate_Name";
        source.DataValueField = "cate_ID";
        source.DataBind();

        target.DataSource = mydv;
        target.DataTextField = "cate_Name";
        target.DataValueField = "cate_ID";
        target.DataBind();
    }

    /// <summary>
    /// 日志分类管理 - 设置日志分类
    /// </summary>
    private void BindCategories()
    {
        Categories.Visible = true;
        DataView mydv = Blog_Category.Category_Con();
        Ctrl.BindGridView(GridView1, mydv);
        Cate_icons.DataSource = Blog_Category.Category_icon();
        Cate_icons.DataTextField = "FileName";
        Cate_icons.DataValueField = "icon";
        Cate_icons.DataBind();
        Cate_Image.ImageUrl = Cate_icons.SelectedValue;
        for (int i = 0; i < mydv.Count; i++)
        {
            ((DropDownList)GridView1.Rows[i].FindControl("Cate_icons")).DataSource = Blog_Category.Category_icon();
            ((DropDownList)GridView1.Rows[i].FindControl("Cate_icons")).DataTextField = "FileName";
            ((DropDownList)GridView1.Rows[i].FindControl("Cate_icons")).DataValueField = "icon";
            ((DropDownList)GridView1.Rows[i].FindControl("Cate_icons")).DataBind();
            ((DropDownList)GridView1.Rows[i].FindControl("Cate_icons")).SelectedValue = mydv[i]["cate_icon"].ToString();
            ((DropDownList)GridView1.Rows[i].FindControl("Cate_icons")).Attributes.Add("onchange", "document.images['" + ((Image)GridView1.Rows[i].FindControl("Cate_icons_Image")).UniqueID.Replace("$", "_") + "'].src=this.value");

        }
        //DirectoryInfo d = new DirectoryInfo(Request.PhysicalApplicationPath + @"images\icons");
        //FileInfo[] dirs = d.GetFiles("*.gif");  //获取目录下全部文件名

    }

    /// <summary>
    /// 站点基本设置-设置基本信息
    /// </summary>
    private void BindGeneral()
    {
        General.Visible = true;
        SiteName.Text = StringUtil.UnCheckStr(Application["SiteName"].ToString());
        blog_Title.Text = StringUtil.UnCheckStr(Application["blog_Title"].ToString());
        blog_master.Text = StringUtil.UnCheckStr(Application["blog_master"].ToString());
        blog_email.Text = StringUtil.UnCheckStr(Application["blog_email"].ToString());
        SiteURL.Text = StringUtil.UnCheckStr(Application["SiteURL"].ToString());
        blog_about.Text = StringUtil.UnCheckStr(Application["blogabout"].ToString());
        blogPerPage.Text = StringUtil.UnCheckStr(Application["blogPerPage"].ToString());
        blog_DisMod.SelectedValue = Application["blog_DisMod"].ToString();
        blog_ImgLink.Checked = Convert.ToBoolean(Application["blog_ImgLink"]);
        blog_postFile.Checked = Convert.ToBoolean(Application["blog_postFile"]);
        blog_SplitType.SelectedValue = Application["blog_SplitType"].ToString();
        blog_introChar.Text = StringUtil.UnCheckStr(Application["blog_introChar"].ToString());
        blog_introLine.Text = StringUtil.UnCheckStr(Application["blog_introLine"].ToString());
        blogcommpage.Text = StringUtil.UnCheckStr(Application["blogcommpage"].ToString());
        blog_commTimerout.Text = StringUtil.UnCheckStr(Application["blog_commTimerout"].ToString());
        blog_commLength.Text = StringUtil.UnCheckStr(Application["blog_commLength"].ToString());
        blog_validate.Checked = Convert.ToBoolean(Application["blog_validate"]);
        blog_commUBB.Checked = Convert.ToBoolean(Application["blog_commUBB"]);
        blog_commIMG.Checked = Convert.ToBoolean(Application["blog_commIMG"]);
        blog_wap.Checked = Convert.ToBoolean(Application["blog_wap"]);
        blog_wapHTML.Checked = Convert.ToBoolean(Application["blog_wapHTML"]);
        blog_wapImg.Checked = Convert.ToBoolean(Application["blog_wapImg"]);
        blog_wapURL.Checked = Convert.ToBoolean(Application["blog_wapURL"]);
        blog_wapLogin.Checked = Convert.ToBoolean(Application["blog_wapLogin"]);
        blog_wapComment.Checked = Convert.ToBoolean(Application["blog_wapComment"]);
        blog_wapNum.Text = StringUtil.UnCheckStr(Application["blog_wapNum"].ToString());
        blog_Disregister.Checked = Convert.ToBoolean(Application["blog_Disregister"]);
        blog_CountNum.Text = StringUtil.UnCheckStr(Application["blog_CountNum"].ToString());
        Register_UserNames.Text = StringUtil.UnCheckStr(Application["Register_UserNames"].ToString());
        FilterIPs.Text = StringUtil.UnCheckStr(Application["FilterIPs"].ToString());
    }
    private void BindGrid()
    {
        Blog_module.UPApplication();
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        string Blog_Name = StringUtil.CheckStr(SiteName.Text);
        string Blog_URL = StringUtil.CheckStr(SiteURL.Text);
        string Blog_PerPage = StringUtil.CheckStr(blogPerPage.Text);
        string Blog_commPage = StringUtil.CheckStr(blogcommpage.Text);
        string Blog_about = StringUtil.CheckStr(blog_about.Text);
        string Blog_FilterName = StringUtil.CheckStr(Register_UserNames.Text);
        string Blog_FilterIP = StringUtil.CheckStr(FilterIPs.Text);
        string Blog_commTimerout = StringUtil.CheckStr(blog_commTimerout.Text);
        string Blog_commUBB = Convert.ToInt32(blog_commUBB.Checked).ToString();
        string Blog_commImg = Convert.ToInt32(blog_commIMG.Checked).ToString();
        string Blog_postFile = Convert.ToInt32(blog_postFile.Checked).ToString();
        string Blog_SplitType = blog_SplitType.SelectedValue;
        string Blog_introChar = StringUtil.CheckStr(blog_introChar.Text);
        string Blog_introLine = StringUtil.CheckStr(blog_introLine.Text);
        string Blog_validate = Convert.ToInt32(blog_validate.Checked).ToString();
        string Blog_Title = StringUtil.CheckStr(blog_Title.Text);
        string Blog_ImgLink = Convert.ToInt32(blog_ImgLink.Checked).ToString();
        string Blog_commLength = StringUtil.CheckStr(blog_commLength.Text);
        string Blog_DisMod = blog_DisMod.SelectedValue;
        string Blog_Disregister = Convert.ToInt32(blog_Disregister.Checked).ToString();
        string Blog_master = StringUtil.CheckStr(blog_master.Text);
        string Blog_email = StringUtil.CheckStr(blog_email.Text);
        string Blog_CountNum = StringUtil.CheckStr(blog_CountNum.Text) == "" ? "0" : StringUtil.CheckStr(blog_CountNum.Text);
        string Blog_wapNum = StringUtil.CheckStr(blog_wapNum.Text);
        string Blog_wapImg = Convert.ToInt32(blog_wapImg.Checked).ToString();
        string Blog_wapHTML = Convert.ToInt32(blog_wapHTML.Checked).ToString();
        string Blog_wapLogin = Convert.ToInt32(blog_wapLogin.Checked).ToString();
        string Blog_wapComment = Convert.ToInt32(blog_wapComment.Checked).ToString();
        string Blog_wap = Convert.ToInt32(blog_wap.Checked).ToString();
        string Blog_wapURL = Convert.ToInt32(blog_wapURL.Checked).ToString();

        Blog_module.blog_Info_UP(Blog_Name, Blog_URL, Blog_PerPage, Blog_commPage, Blog_about,
            Blog_FilterName, Blog_FilterIP, Blog_commTimerout, Blog_commUBB, Blog_commImg,
            Blog_postFile, Blog_SplitType, Blog_introChar, Blog_introLine, Blog_validate, Blog_Title, Blog_ImgLink,
            Blog_commLength, Blog_DisMod, Blog_Disregister, Blog_master, Blog_email, Blog_CountNum,
            Blog_wapNum, Blog_wapImg, Blog_wapHTML, Blog_wapLogin, Blog_wapComment, Blog_wap, Blog_wapURL);
        BindGrid();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        if (ReBulid.Checked == true)
        {
            BindGrid();
        }
        if (ReTatol.Checked == true)
        {
            try
            {
                Blog_module.blog_Info_ReTatol();
                Jscript.Alert("数据统计完成! ");
            }
            catch
            {
                Jscript.Alert("请检查存储过程，过程错误! ");
            }
        }
        if (ReBulidArticle.Checked == true)
        { }
        if (ReBulidIndex.Checked == true)
        { }
        if (CleanVisitor.Checked == true)
        {
            Application["user_sessions"] = 0;
        }
    }
    protected void Button3_Click(object sender, EventArgs e)
    {
        //((DropDownList)GridView1.Rows[1].Cells[1].FindControl("Cate_icons")).SelectedIndex = 2;
        string cate_ID = "";
        string cate_Name = "";
        string cate_Order = "";
        string cate_Intro = "";
        string cate_URL = "";
        string cate_icon = "";
        string cate_count = "";
        string cate_local = "";
        string cate_Secret = "";
        for (int i = 0; i < GridView1.Rows.Count; i++)
        {
            cate_ID = GridView1.DataKeys[i]["cate_ID"].ToString();
            cate_Name = ((TextBox)GridView1.Rows[i].FindControl("Cate_Name")).Text;
            cate_Order = ((TextBox)GridView1.Rows[i].FindControl("cate_Order")).Text;
            cate_Intro = ((TextBox)GridView1.Rows[i].FindControl("Cate_Intro")).Text;
            cate_URL = ((TextBox)GridView1.Rows[i].FindControl("cate_URL")).Text;
            cate_icon = ((DropDownList)GridView1.Rows[i].FindControl("Cate_icons")).SelectedValue;
            cate_count = ((TextBox)GridView1.Rows[i].FindControl("cate_count")).Text;
            cate_local = ((DropDownList)GridView1.Rows[i].FindControl("Cate_local")).SelectedValue;
            cate_Secret = ((DropDownList)GridView1.Rows[i].FindControl("cate_Secret")).SelectedValue;
            Blog_Category.Category_UPDATE(cate_ID, cate_Name, cate_Order, cate_Intro, cate_URL, cate_icon, cate_count, cate_local, cate_Secret);
        }
        if (Cate_Name.Text != "")
        {
            cate_Name = Cate_Name.Text;
            cate_Order = (Cate_Order.Text == "" ? "0" : Cate_Order.Text);
            cate_Intro = Cate_Intro.Text;
            cate_URL = Cate_URL.Text;
            cate_icon = Cate_icons.SelectedValue;
            cate_local = Cate_local.SelectedValue;
            cate_Secret = Cate_Secret.SelectedValue;
            Blog_Category.Category_INSERT(cate_Name, cate_Order, cate_Intro, "0",cate_URL, cate_icon, cate_local, cate_Secret);
            Cate_Name.Text = "";
        }
        BindCategories();
    }

    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Blog_Category.Category_DELETE(GridView1.DataKeys[e.RowIndex]["cate_ID"].ToString());
        BindCategories();
    }

    protected void Button4_Click(object sender, EventArgs e)
    {
        try
        {
            Blog_Content.source_target(source.SelectedValue, target.SelectedValue);
            Blog_module.blog_Info_ReTatol();
            Blog_module.UPApplication();
            Jscript.Alert("数据移动完成! ");
        }
        catch
        {
            Jscript.Alert("请检查存储过程，过程错误! ");
        }
    }
    protected void filter_SelectedIndexChanged(object sender, EventArgs e)
    {
        //BindCategories_del();
        string FileName = Request.Url.ToString();//CurrentExecutionFilePath是获取文件名
        if (FileName.IndexOf("CateID=") > 0) //FileName.Substring(0, FileName.IndexOf("page="));
            FileName = FileName.Substring(0, FileName.IndexOf("CateID=") - 1);
        FileName += (FileName.IndexOf("?") > 0) ? "&" : "?";
        FileName += "CateID=" + filter.SelectedValue;
        Jscript.JavaScriptLocationHref(FileName);
    }
    protected void Button5_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < DelContent.Rows.Count; i++)
        {
            if (((CheckBox)DelContent.Rows[i].FindControl("Log_ID")).Checked)
                Blog_Content.Con_DELETE(((CheckBox)DelContent.Rows[i].FindControl("Log_ID")).Text);
        }
        BindCategories_del();
        Blog_module.blog_Info_ReTatol();
        Blog_module.UPApplication();
    }
    protected void Button6_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < BTag.Rows.Count; i++)
        {
            if (((CheckBox)BTag.Rows[i].FindControl("selectTagID")).Checked)
                Blog_tag.Tag_DELETE(BTag.DataKeys[i]["tag_id"].ToString());
            else
                Blog_tag.Tag_UPDATE(BTag.DataKeys[i]["tag_id"].ToString(), ((TextBox)BTag.Rows[i].FindControl("tagName")).Text, ((TextBox)BTag.Rows[i].FindControl("tagCount")).Text);
        }
        if (tagName.Text != "")
            Blog_tag.Tag_INSERT(tagName.Text);
        tagName.Text = "";
        BindCategories_Tag();

    }
    protected void Button8_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < Commend_List.Items.Count; i++)
        {
            TextBox message = ((TextBox)Commend_List.Items[i].FindControl("message"));
            string Comm_id = Commend_List.DataKeys[i].ToString();
            Blog_Comment.comm_UPDATE(Comm_id, message.Text);
        }
    }
    protected void Button9_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < Commend_List.Items.Count; i++)
        {
            CheckBox selectCommentID = ((CheckBox)Commend_List.Items[i].FindControl("selectCommentID"));
            if (selectCommentID.Checked)
                Blog_Comment.comm_DELETE(Commend_List.DataKeys[i].ToString());
        }
        BindComment();
    }
    protected void Button11_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < spamList.Rows.Count; i++)
        {
            if (((CheckBox)spamList.Rows[i].FindControl("spamID")).Checked)
                Blog_spam.Spam_DELETE(spamList.DataKeys[i]["spam_id"].ToString());
            else
                Blog_spam.Spam_UPDATE(spamList.DataKeys[i]["spam_id"].ToString(), ((TextBox)spamList.Rows[i].FindControl("spamName")).Text);
        }
        if (keyWord.Text != "")
            Blog_spam.Spam_INSERT(keyWord.Text);
        keyWord.Text = "";
        Blog_module.blog_Info_ReTatol();
        Blog_module.UPApplication();
        BindComment_spam();
    }

    protected void LinkButton1_Command(object sender, CommandEventArgs e)
    {
        Application["blog_DefaultSkin"] = e.CommandArgument;
        Blog_module.blog_Info_Skin(Application["blog_DefaultSkin"].ToString());
        BindSkins();
    }

    protected void SmenuView_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Blog_module.module_DELETE(SmenuView.DataKeys[e.RowIndex]["id"].ToString());
        BindSkins_module();
    }
    protected void Button12_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < SmenuView.Rows.Count; i++)
        {

            Blog_module.module_UPDATE(SmenuView.DataKeys[i]["id"].ToString(), ((TextBox)SmenuView.Rows[i].FindControl("mName")).Text, ((TextBox)SmenuView.Rows[i].FindControl("mTitle")).Text,
                ((DropDownList)SmenuView.Rows[i].FindControl("mType")).SelectedValue, ((DropDownList)SmenuView.Rows[i].FindControl("dohidden")).SelectedValue,
                ((DropDownList)SmenuView.Rows[i].FindControl("doIndex")).SelectedValue, ((TextBox)SmenuView.Rows[i].FindControl("mOrder")).Text);
        }
        if (mTitle.Text != "")
            Blog_module.module_INSERT(mName.Text, mTitle.Text, mType.SelectedValue, mOrder.Text == "" ? Blog_module.module_Min() : mOrder.Text);
        mTitle.Text = "";
        BindSkins_module();
    }
    protected void Button13_Click(object sender, EventArgs e)
    {
        Blog_module.module_UPDATE(QueryString.GetId, StringUtil.CheckStr(HtmlCode.Text));
    }
    protected void Button14_Click(object sender, EventArgs e)
    {
        Blog_module.module_UPDATE(QueryString.GetId, this.FCKeditor1.Value);
    }
    protected void Button15_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < statusView.Rows.Count; i++)
        {

            Blog_status.Status_UPDATE(statusView.DataKeys[i]["stat_id"].ToString(), ((TextBox)statusView.Rows[i].FindControl("status_name")).Text, ((TextBox)statusView.Rows[i].FindControl("status_title")).Text);
        }
        if (status_name.Text != "")
            Blog_status.Status_INSERT(status_name.Text, status_title.Text);
        status_name.Text = "";
        BindMembers();
    }
    protected void Button17_Click(object sender, EventArgs e)
    {
        string stat_Code = AddArticle.SelectedValue.ToString();
        stat_Code += AdminAddArticle.SelectedValue.ToString();
        stat_Code += AdminDelArticle.SelectedValue.ToString();
        stat_Code += AdminAddComment.SelectedValue.ToString();
        stat_Code += AdminDelComment.SelectedValue.ToString();
        stat_Code += AdminShowHiddenCate.SelectedValue.ToString();
        stat_Code += IsAdmin.SelectedValue.ToString();
        stat_Code += AdminCanUpload.SelectedValue.ToString();
        Blog_status.Status_UPDATE(QueryString.GetId, Adminstatus_title.Text, stat_Code, UploadSize.Text, UploadType.Text);
        Application["GuestCode"] = Blog_status.Status_Code("Guest").ToString();
    }
    protected void MemberView_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Blog_Users.Member_DELETE(MemberView.DataKeys[e.RowIndex]["mem_ID"].ToString());
        BindMembers_Users();
    }

    protected void MemberView_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "RowUpdating")
        {
            Blog_Users.Member_UPDATE(MemberView.DataKeys[Convert.ToInt32(e.CommandArgument)]["mem_ID"].ToString(), ((DropDownList)MemberView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("mem_Status")).SelectedValue.ToString());
            BindMembers_Users();
        }
    }
   protected void Button16_Click(object sender, EventArgs e)
    {
        Jscript.JavaScriptLocationHref("?Fmenu=Members&Smenu=Search&Search=" + StringUtil.Strencode(mem_Name.Text));
    }

    //用户搜索返回搜索结果
    private void BindMembers_Search()
    {
        Members_Users.Visible = true;
        MultiPage5.CountSum = Convert.ToInt32(Blog_Users.Member_Count("30", "mem_name like '%" + QueryString.GetSearch + "%'").ToString());
        MultiPage6.CountSum = Convert.ToInt32(Blog_Users.Member_Count("30", "mem_name like '%" + QueryString.GetSearch + "%'").ToString());
        DataView mydv = Blog_Users.Member_SELECT("mem_name like '%" + QueryString.GetSearch + "%'", "mem_ID desc", "30", QueryString.IntPage.ToString());
        Ctrl.BindGridView(MemberView, mydv);
        for (int i = 0; i < mydv.Count; i++)
        {
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataSource = Blog_status.Status_List();
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataTextField = "stat_title";
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataValueField = "stat_name";
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).DataBind();
            ((DropDownList)MemberView.Rows[i].FindControl("mem_Status")).SelectedValue = mydv[i]["mem_Status"].ToString();

        }
    }

    protected void LinkView_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Blog_Links.Links_DELETE(LinkView.DataKeys[e.RowIndex]["link_ID"].ToString());
        BindLink();
    }
    protected void LinkView_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "RowUpdating")
        {
            Blog_Links.Links_UPDATE(LinkView.DataKeys[Convert.ToInt32(e.CommandArgument)]["link_ID"].ToString(),
                ((TextBox)LinkView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("LinkName")).Text.ToString(),
                ((TextBox)LinkView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("LinkURL")).Text.ToString(),
                ((TextBox)LinkView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("LinkLogo")).Text.ToString(),
                ((TextBox)LinkView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("LinkOrder")).Text.ToString(),
                ((DropDownList)LinkView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("LinkShow")).SelectedValue.ToString(),
                ((DropDownList)LinkView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("urlInTop")).SelectedValue.ToString());
            BindLink();
        }
    }
    protected void Button18_Click(object sender, EventArgs e)
    {
        if (LinkName.Text != "")
            Blog_Links.Links_INSERT(LinkName.Text, LinkURL.Text, LinkLogo.Text, LinkOrder.Text);
        LinkName.Text = "";
        BindLink();
    }
    protected void SmiliesView_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Blog_Smilies.Smilies_DELETE(SmiliesView.DataKeys[e.RowIndex]["sm_ID"].ToString());
        BindSmilies();
    }
    protected void SmiliesView_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "RowUpdating")
        {
            Blog_Smilies.Smilies_UPDATE(SmiliesView.DataKeys[Convert.ToInt32(e.CommandArgument)]["sm_ID"].ToString(),
                ((TextBox)SmiliesView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("smilesURL")).Text.ToString(),
                ((TextBox)SmiliesView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("smiles")).Text.ToString());
            BindSmilies();
        }
    }
    protected void Button19_Click(object sender, EventArgs e)
    {
        if (smiles.Text != "")
            Blog_Smilies.Smilies_INSERT(smilesURL.Text, smiles.Text);
        smiles.Text = "";
        BindSmilies();
    }
    protected void KeywordsView_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Blog_Keywords.Keywords_DELETE(KeywordsView.DataKeys[e.RowIndex]["key_ID"].ToString());
        BindSmilies_KeyWord();
    }
    protected void KeywordsView_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "RowUpdating")
        {
            Blog_Keywords.Keywords_UPDATE(KeywordsView.DataKeys[Convert.ToInt32(e.CommandArgument)]["key_ID"].ToString(),
                ((TextBox)KeywordsView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("KeyWordURL")).Text.ToString(),
                ((TextBox)KeywordsView.Rows[Convert.ToInt32(e.CommandArgument)].FindControl("KeyWordID")).Text.ToString());
            BindSmilies_KeyWord();
        }
    }
    protected void Button20_Click(object sender, EventArgs e)
    {
        if (KeyWordID.Text != "")
            Blog_Keywords.Keywords_INSERT(KeyWordURL.Text, KeyWordID.Text);
        KeyWordID.Text = "";
        BindSmilies_KeyWord();
    }

    //-----下面部分是服务器探针使用-------------------------------------------------------------------------------------
    //组件支持验证代码

    bool chkobj(string obj)
    {
        try
        {
            object meobj = Server.CreateObject(obj);
            return (true);
        }
        catch
        {
            return (false);
        }
    }

    //100万次循环测试，由0.1sn bulid 021203开始加入

    public void turn_chk(Object Sender, EventArgs e)
    {
        DateTime ontime = DateTime.Now;
        int sum = 0;
        for (int i = 1; i <= 10000000; i++)
        {
            sum = sum + i;
        }
        DateTime endtime = DateTime.Now;
        l1000.Text = ((endtime - ontime).TotalMilliseconds).ToString() + "毫秒";
    }

    //自定义组件检测0.1版加入

    public void chkzujian(Object Sender, EventArgs e)
    {
        string obj = zujian.Text;
        if (chkobj(obj))
        {
            l001.Text = "检测结果：支持组件" + obj;
        }
        else
        {
            l001.Text = "检测结果：不支持组件" + obj;
        }
    }
    string getaspnetn()
    {
        string temp;
        try
        {
            temp = ((Double)System.Diagnostics.Process.GetCurrentProcess().WorkingSet / 1048576).ToString("N2");
        }
        catch
        {
            temp = "未知";
        }
        return temp;
    }
    string getaspnetcpu()
    {
        string temp;
        try
        {
            temp = ((TimeSpan)System.Diagnostics.Process.GetCurrentProcess().TotalProcessorTime).TotalSeconds.ToString("N0");
        }
        catch
        {
            temp = "未知";
        }
        return temp;
    }

    string getprstart()
    {
        string temp;
        try
        {
            temp = System.Diagnostics.Process.GetCurrentProcess().StartTime.ToString();
        }
        catch
        {
            temp = "未知";
        }
        return temp;
    }

    string getip()
    {
        string test = Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
        if (test == null || test == "")
        {
            test = Request.ServerVariables["REMOTE_ADDR"];
        }
        return test;
    }
    protected void Button23_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < trackbacklist.Items.Count; i++)
        {
            CheckBox selectCommentID = ((CheckBox)trackbacklist.Items[i].FindControl("selectCommentID"));
            if (selectCommentID.Checked)
                Blog_Trackback.Trackback_DELETE(trackbacklist.DataKeys[i].ToString());
        }
        BindComment_trackback();
    }
    protected void Button22_Click(object sender, EventArgs e)
    {
        System.Random myRd = new Random();
        string SQLFile = Request.MapPath("blogDB/") + DateTime.Now.ToString().Replace("-", "").Replace(":", "").Replace(" ", "") + myRd.Next(1000) + ".DAK";
        try
        {
            SQL_db.backup_db("", SQLFile);
            Jscript.Alert("成功！");
        }
        catch
        {
            Jscript.Alert("失败！");
        }
        BindSQLFile();
    }
    protected void SQLFiles_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        File.Delete(Request.PhysicalApplicationPath + @"blogDB\" + SQLFiles.DataKeys[e.RowIndex]["FileName"].ToString());
        BindSQLFile();
    }
    protected void SQLFiles_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        //还原数据库使用的方法，但是不能还原自己本身的数据库
        if (e.CommandName == "RowUpdating")
        {
            string SQLFile = Request.PhysicalApplicationPath + @"blogDB\" + SQLFiles.DataKeys[Convert.ToInt32(e.CommandArgument)]["FileName"].ToString();

            try
            {
                SQL_db.restore_db(SQLFile, "");
                Jscript.Alert("成功！");
            }
            catch
            {
                Jscript.Alert("失败！");
            }

            BindSQLFile();
        }
    }
    protected void Button24_Click(object sender, EventArgs e)
    {
        try
        {
            SQL_db.Compact("");
            Jscript.Alert("成功！");
        }
        catch
        {
            Jscript.Alert("失败！");
        }

        BindSQLFile();
    }
}
