﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Security;
using System.Xml;
using COCOWO.COMP;

public partial class File_Default : System.Web.UI.Page
{
    private string rootPath = ConfigurationSettings.AppSettings["FCKeditor:UserFilesPath"].ToString(); //设置根目录

    protected void Page_Load(object sender, EventArgs e)
    {
        if (UsersInfo.GetUserCode.Substring(10, 1) != "1" && UsersInfo.GetmemhashKey != "")
        {
            Jscript.Alert("您不是管理员，不可以使用本功能!");
            Response.Cookies["memhashKey"].Value = "";
            Jscript.RefreshParent("../Default.aspx");
        }
        else
        {
            if (!rootPath.EndsWith("/"))
                rootPath += "/";
            if (rootPath.StartsWith("~"))
                rootPath = this.ResolveUrl(rootPath);

            if (Session["Path"] == null || Session["Path"].ToString() == "")
            {
                if (Request.QueryString["Path"] + "a" != "a")
                {
                    if (Request.QueryString["Path"] == "/")
                    {
                        Session["Path"] = rootPath;
                    }
                    else
                    {
                        Session["Path"] = Request.QueryString["Path"].ToString();
                    }
                }
                else
                {
                    Session["Path"] = rootPath;
                }
            }
            if (Session["Path"].ToString() != rootPath)
                Header.Text = Session["Path"].ToString();
            else
            {
                Header.Text = "";
                UpBtn.Visible = false;
                GoRoot.Visible = false;
            }

            showFiles();
        }
    }

    //将文件或文件夹加载到前台页面中
    public void showFiles()
    {        
        DirectoryInfo mainDir = checkValidSessionPath();
        if (mainDir == null) return;	// bail out

        int alternate = 0;	// used for alternating background color in table rows

        foreach (DirectoryInfo d in mainDir.GetDirectories())
        {
            // build up some literal controls, and buttons for the row of the table representing the directory
            Literal newColumn1 = new Literal();
            newColumn1.Text = "</td> <td align=\"center\">&nbsp;";
            Literal newColumn2 = new Literal();
            newColumn2.Text = "</td> <td align=\"center\">&nbsp;";
            Literal newColumn3 = new Literal();
            newColumn3.Text = "</td> <td align=\"center\">";

            // display a folder icon
            Literal picColumn = new Literal();
            if (alternate % 2 == 1)	// alternate back-colour of rows
                picColumn.Text = "<TR style=\"height:22px;\"><td align=\"center\"><img src=images/folder.gif style=\"cursor:pointer;\" OnClick=\"javascript:getPath('" + Request.ServerVariables["SERVER_NAME"].ToString() + Session["Path"].ToString() + d.Name.ToString() + "')\"></td><td>";
            else
                picColumn.Text = "<TR bgcolor='#e8e8e8' style=\"height:22px;\"><td align=\"center\"><img src=images/folder.gif style=\"cursor:pointer;\" OnClick=\"javascript:getPath('" + Request.ServerVariables["SERVER_NAME"].ToString() + Session["Path"].ToString() + d.Name.ToString() + "')\"></td><td>";

            // this link changes the path to the directory being clicked
            LinkButton changePathBtn = new LinkButton();
            changePathBtn.Text = "&nbsp;&nbsp;&nbsp;" + d.Name.ToString();
            changePathBtn.CommandArgument = d.Name.ToString();
            changePathBtn.Command += new CommandEventHandler(ChangePath);

            // this link deletes the directory, but it must be empty for the delete to be successful
            HyperLink deleteBtn = new HyperLink();
            deleteBtn.ImageUrl = "images/delete_icon.gif";
            deleteBtn.NavigateUrl = "javascript:confirmDelete('DelFile.aspx?Type=Folder&Name=" + Session["Path"].ToString() + d.Name.ToString() + "','"+d.Name.ToString()+"');";	// use client-side confirm function for deleting

            Literal endRow = new Literal();
            endRow.Text = "</td></tr>";

            // add the controls to the container in the webform
            this.FilesFolders.Controls.Add(picColumn);
            this.FilesFolders.Controls.Add(changePathBtn);
            this.FilesFolders.Controls.Add(newColumn1);
            this.FilesFolders.Controls.Add(newColumn2);
            this.FilesFolders.Controls.Add(newColumn3);
            this.FilesFolders.Controls.Add(deleteBtn);
            this.FilesFolders.Controls.Add(endRow);

            alternate++;	// bump the int for back-colour alternation
        }

        foreach (FileInfo f in mainDir.GetFiles())
        {
            // build up some literal controls, and buttons for the row of the table representing the file
            Literal newColumn1 = new Literal();
            newColumn1.Text = "</td> <td align=\"center\">";
            Literal newColumn2 = new Literal();
            newColumn2.Text = "</td> <td >";
            Literal newColumn3 = new Literal();
            newColumn3.Text = "</td> <td align=\"center\">";

            Literal newColumn = new Literal();
            newColumn.Text = "</td> <td align=\"center\">";

            // display a file icon
            Literal picColumn = new Literal();
            if (alternate % 2 == 1)
                picColumn.Text = "<TR style=\"height:22px;\"><td align=\"center\"><img src=images/file.gif style=\"cursor:pointer;\" OnClick=\"javascript:getPath('" + Request.ServerVariables["SERVER_NAME"].ToString() + Session["Path"].ToString() + f.Name.ToString() + "')\" /></td><td>";
            else
                picColumn.Text = "<TR bgcolor='#e8e8e8' style=\"height:22px;\"><td align=\"center\"><img src=images/file.gif style=\"cursor:pointer;\" OnClick=\"javascript:getPath('" + Request.ServerVariables["SERVER_NAME"].ToString() + Session["Path"].ToString() + f.Name.ToString() + "')\" /></td><td>";

            // this link goes directly to the file (not edit mode)
            HyperLink goToBtn = new HyperLink();
            goToBtn.Text = "&nbsp;&nbsp;&nbsp;"+f.Name.ToString();
            goToBtn.Target = "_Blank";
            goToBtn.NavigateUrl =  Session["Path"].ToString() + f.Name.ToString();

            Literal gap = new Literal();
            gap.Text = " &nbsp; - &nbsp; ";

            // this link edits the file when clicked
            HyperLink editBtn = new HyperLink();
            editBtn.Text = "编辑";
            editBtn.ToolTip = f.Name.ToString();
            editBtn.NavigateUrl = "EditFile.aspx?File=" + Session["Path"].ToString() + f.Name.ToString();

            // work out what string to display for the file, e.g. bytes, kilobytes, or megabytes
            long fileSize = f.Length;
            string fileSizeStr;
            if (fileSize > 1000000) fileSizeStr = fileSize / 1000000 + " MB";
            else if (fileSize > 1000) fileSizeStr = fileSize / 1000 + " KB";
            else fileSizeStr = fileSize + " B";

            // size of file
            Label sizeLbl = new Label();
            sizeLbl.Text = fileSizeStr;

            // last modified datetime of file
            Label modLbl = new Label();
            modLbl.Text = "&nbsp;&nbsp;&nbsp;" + f.LastWriteTime.ToString();

            // set up delete button
            HyperLink deleteBtn = new HyperLink();
            deleteBtn.ImageUrl = "images/delete_icon.gif";
            deleteBtn.NavigateUrl = "javascript:confirmDelete('DelFile.aspx?Type=File&Name=" + Session["Path"].ToString() + f.Name.ToString() + "','" + f.Name.ToString() + "');";

            Literal endRow = new Literal();
            endRow.Text = "</td></tr>";

            // add controls to container
            this.FilesFolders.Controls.Add(picColumn);
            this.FilesFolders.Controls.Add(goToBtn);
            this.FilesFolders.Controls.Add(gap);
            this.FilesFolders.Controls.Add(editBtn);
            this.FilesFolders.Controls.Add(newColumn1);
            this.FilesFolders.Controls.Add(sizeLbl);
            this.FilesFolders.Controls.Add(newColumn2);
            this.FilesFolders.Controls.Add(modLbl);
            this.FilesFolders.Controls.Add(newColumn3);
            this.FilesFolders.Controls.Add(deleteBtn);
            this.FilesFolders.Controls.Add(endRow);
            alternate++;
        }
    }

    private void ChangePath(object sender, CommandEventArgs e)
    {
        Session["Path"] = Session["Path"].ToString() + e.CommandArgument.ToString() + "/";
        Response.Redirect("default.aspx");

    }

    //错误处理
    private DirectoryInfo checkValidSessionPath()
    {

        DirectoryInfo mainDir;
        try
        {
            mainDir = new DirectoryInfo(Server.MapPath(Session["Path"].ToString()));
            if (mainDir.Exists == true)
                return mainDir;
            else
                Session["Path"] = rootPath; Response.Write("<script>alert('对不起,您输入的目录不存在.请检查是否正确!');window.location.href='Default.aspx'</script>");//FTP.FTP.ReportError("The directory " + Server.MapPath(Session["Path"].ToString()) + " does not exist.", "Could not find a part of the path \"" + Server.MapPath(Session["Path"].ToString()) + "\".", "If you set the site root manually, try resetting it to the current directory: ./");
        }
        catch (DirectoryNotFoundException DirNotFoundEx)
        {
            Session["Path"] = rootPath; 
            Response.Write("<script>alert('对不起,系统找不到您所需要的文件或目录信息.');window.location.href='Default.aspx'</script>");
        }
        catch (SecurityException SecEx)
        {
            Session["Path"] = rootPath;
            Response.Write("<script>alert('对不起,系统检测到不安全信息.必须终止此进程.');window.location.href='Default.aspx'</script>");
        }
        catch (ArgumentException ArgEx)
        {
            Session["Path"] = rootPath;
            Response.Write("<script>alert('您的某些操作发生严重错误.系统终止此进程.');window.locationi.href='Default.aspx'</script>");
        }
        catch (Exception Ex)
        {
            Session["Path"] = rootPath;
            Response.Write("<script>alert('出错了!!!请返回重新操作.');window.locationi.href='Default.aspx'</script>");
        }
        //以上异常处理操作都不会将系统错误信息输出到页面
        return null;
    }

    //新建文件
    protected void NewFileBtn_Click(object sender, System.EventArgs e)
    {
        if (this.NewFileText.Text == "")
            Response.Write("<script>alert(\"对不起,您没有输入正确的文件名称,请输入文件名称.\");</script>");
        else
        {
            try
            {
                FileInfo file = new FileInfo(Server.MapPath(Session["Path"].ToString() + this.NewFileText.Text.ToString()));
                file.Create();
                Response.Redirect("default.aspx");
            }
            catch (Exception ex)
            {
                Response.Write("<script>alert('对不起,新建文件[" + this.NewFileText.Text.ToString() + "]时发生系统错误.请重新操作.')</script>");
                //此处不输出系统错误信息.
            }
        }
    }

    //新建目录
    protected void NewFolderBtn_Click(object sender, System.EventArgs e)
    {
        if (this.NewFolderText.Text == "")
            Response.Write("<script>alert(\"对不起,您还没有输入正确的目录名称.请重新输入.\");</script>");
        else
        {
            try
            {
                DirectoryInfo dir = new DirectoryInfo(Server.MapPath(Session["Path"].ToString() + this.NewFolderText.Text.ToString()));
                dir.Create();
                Response.Redirect("default.aspx");
            }
            catch (Exception ex)
            {
                Response.Write("<script>alert('对不起,新建目录[" + Request.Form["NewFileText"] + "]时发生系统错误.请重新操作.')</script>");
                //此处不输出系统信息.
            }
        }
    }

    //上传文件
    protected void UploadBtn_Click(object sender, System.EventArgs e)
    {
        if (fileToUpload.PostedFile.FileName == "")
            Response.Write("<script>alert(\"对不起,您还没有选择要上传的文件,请选择文件.\");</script>");
        else
        {
            try
            {
                string filename = fileToUpload.PostedFile.FileName;
                string togo ="";

                if (System.Convert.ToBoolean(this.AutoName.Checked))
                {
                    string fileExtension = System.IO.Path.GetExtension(filename);

                    string DataText = DateTime.Now.Year.ToString() +
                            DateTime.Now.Month.ToString() +
                            DateTime.Now.Day.ToString() +
                            DateTime.Now.Hour.ToString() +
                            DateTime.Now.Minute.ToString() +
                            DateTime.Now.Second.ToString();

                    togo += Session["Path"].ToString() + DataText + fileExtension;
                }
                else
                {
                    togo += Session["Path"].ToString() + filename.Remove(0, filename.LastIndexOf("\\") + 1);
                }

                fileToUpload.PostedFile.SaveAs(Server.MapPath(togo));


                long fileSize = fileToUpload.PostedFile.ContentLength;
                string fileSizeStr;
                if (fileSize > 1000000) fileSizeStr = fileSize / 1000000 + " MB";
                else if (fileSize > 1000) fileSizeStr = fileSize / 1000 + " KB";
                else fileSizeStr = fileSize + " B";

                Response.Write("<script>alert(\"文件上传成功!...\\n文件路径: " + togo + "\\n文件大小: " + fileSizeStr + "\"); document.location=\"default.aspx\";</script>");
            }
            catch (Exception ex)
            {
                Response.Write("<script>alert('文件上传时发生错误,你上传的文件不符合系统要求或文件太大.');</script>");
                //此处不输出系统出错误信息.
            }
        }
    }

    //转到目录
    protected void setRootBtn_Click(object sender, System.EventArgs e)
    {
        if (this.setRootTxt.Text == "")
            Response.Write("<script>alert(\"对不起,请填写正确的目录名称.\"); document.location=\"default.aspx\";</script>");
        else
        {
            string rootText = this.setRootTxt.Text;

            if (rootText.LastIndexOf("/") != rootText.Length - 1)
                rootText += "/";
            Session["Path"] = rootText;
            Response.Redirect("default.aspx");
        }
    }
    protected void TopPath(object sender, ImageClickEventArgs e)
    {
        string path = Session["Path"].ToString();
        if (path.LastIndexOf("/") == path.Length - 1)
        {
            path = path.Remove(path.LastIndexOf("/"), (path.Length - path.LastIndexOf("/")));
        }
        path = path.Remove(path.LastIndexOf("/"), (path.Length - path.LastIndexOf("/")));
        Session["Path"] = path + "/";
        Response.Redirect("default.aspx");
    }
    protected void HomePath(object sender, ImageClickEventArgs e)
    {
        Session["Path"] = rootPath;
        Response.Redirect("default.aspx");
    }
}
