﻿<%@ Application Language="C#" %>
<%@ Import Namespace="COCOWO.DB" %>
<%@ Import Namespace="COCOWO.COMP" %>
<%@ Import Namespace="System.Data" %>
<script runat="server">

    void Application_Start(object sender, EventArgs e) 
    {
        // 在应用程序启动时运行的代码
        Application["user_sessions"] = 0; //在线人数
        blog_module Blog_module = new blog_module();
        blog_status Blog_status = new blog_status();
        DataView Blog_Info = Blog_module.blog_Info();
        Application["SiteName"] = StringUtil.UnCheckStr(Blog_Info[0][0].ToString());//站点名字
        Application["SiteURL"] = StringUtil.UnCheckStr(Blog_Info[0][1].ToString());//站点地址
        Application["blogPerPage"] = Blog_Info[0][2].ToString();//每页日志数
        Application["blog_LogNums"] = Blog_Info[0][3].ToString();//日志总数
        Application["blog_CommNums"] = Blog_Info[0][4].ToString();//评论总数
        Application["blog_MemNums"] = Blog_Info[0][5].ToString();//会员总数
        Application["blog_VisitNums"] = Blog_Info[0][6].ToString();//访问量
        Application["blogBookPage"] = Blog_Info[0][7].ToString();//每页留言数(备用)
        Application["blog_MessageNums"] = Blog_Info[0][8].ToString();//留言总数(备用)
        Application["blogcommpage"] = Blog_Info[0][9].ToString();//每页评论数
        Application["blogaffiche"] = StringUtil.UnCheckStr(Blog_Info[0][10].ToString());//公告
        Application["blogabout"] = StringUtil.UnCheckStr(Blog_Info[0][11].ToString());//备案信息
        Application["blogcolsize"] = Blog_Info[0][12].ToString();//每页书签数(备用)
        Application["blog_colNums"] = Blog_Info[0][13].ToString();//书签总数(备用)
        Application["blog_TbCount"] = Blog_Info[0][14].ToString();//引用通告总数
        Application["blog_showtotal"] = Blog_Info[0][15].ToString();//是否显示统计(备用)
        Application["Register_UserNames"] = StringUtil.UnCheckStr(Blog_Info[0][16].ToString());//注册名字过滤
        Application["FilterIPs"] = StringUtil.UnCheckStr(Blog_Info[0][17].ToString());//IP地址过滤
        Application["blog_commTimerout"] = Blog_Info[0][18].ToString();//发表评论时间间隔
        Application["blog_commUBB"] = Blog_Info[0][19].ToString();//是否禁用评论UBB代码
        Application["blog_commIMG"] = Blog_Info[0][20].ToString();//是否禁用评论贴图
        Application["blog_postFile"] = Blog_Info[0][21].ToString();//动态输出日志文件
        Application["blog_postCalendar"] = Blog_Info[0][22].ToString();//动态输出日志日历文件
        Application["blog_DefaultSkin"] = Blog_Info[0][23].ToString();//默认界面
        Application["blog_SkinName"] = StringUtil.UnCheckStr(Blog_Info[0][24].ToString());//界面名称
        Application["blog_SplitType"] = Blog_Info[0][25].ToString();//日志分割类型
        Application["blog_introChar"] = Blog_Info[0][26].ToString();//日志预览最大字符数
        Application["blog_introLine"] = Blog_Info[0][27].ToString();//日志预览切割行数
        Application["blog_validate"] = Blog_Info[0][28].ToString();//发表评论是否都需要验证
        Application["blog_Title"] = StringUtil.UnCheckStr(Blog_Info[0][29].ToString());//Blog副标题
        Application["blog_ImgLink"] = Blog_Info[0][30].ToString();//是否在首页显示图片友情链接
        Application["blog_commLength"] = Blog_Info[0][31].ToString();//评论长度
        Application["blog_downLocal"] = Blog_Info[0][32].ToString();//是否使用防盗链下载
        Application["blog_DisMod"] = Blog_Info[0][33].ToString();//默认显示内容
        Application["blog_Disregister"] = Blog_Info[0][34].ToString();//是否允许注册
        Application["blog_master"] = StringUtil.UnCheckStr(Blog_Info[0][35].ToString());//blog管理员姓名
        Application["blog_email"] = StringUtil.UnCheckStr(Blog_Info[0][36].ToString());//blog管理员邮件地址
        Application["blog_CountNum"] = Blog_Info[0][37].ToString();//访客统计最大次数

        Application["blog_wapNum"] = Blog_Info[0][38].ToString();//Wap 文章列表数量
        Application["blog_wapImg"] = Blog_Info[0][39].ToString();//Wap 文章显示图片
        Application["blog_wapHTML"] = Blog_Info[0][40].ToString();//Wap 文章使用简单HTML
        Application["blog_wapLogin"] = Blog_Info[0][41].ToString();//Wap 允许登录
        Application["blog_wapComment"] = Blog_Info[0][42].ToString();//Wap 允许评论	
        Application["blog_wap"] = Blog_Info[0][43].ToString();//使用 wap
        Application["blog_wapURL"] = Blog_Info[0][44].ToString();//使用 wap 转换文章超链接
        Application["blog_tbKey"] = Blog_Info[0][45].ToString();//引用验证Key
        
        Application["blog_version"] ="2.6 build 03";//当前PJBlog版本号
	    Application["blog_UpdateDate"] ="2006-7-2";//PJBlog最新更新时间
        
        //浏览用户的权限
        Application["GuestCode"] = Blog_status.Status_Code("Guest").ToString();//浏览用户的权限
        
    }
    
    void Application_End(object sender, EventArgs e) 
    {
        //  在应用程序关闭时运行的代码

    }
        
    void Application_Error(object sender, EventArgs e) 
    { 
        // 在出现未处理的错误时运行的代码

    }

    void Session_Start(object sender, EventArgs e) 
    {
        // 在新会话启动时运行的代码
        Application.Lock(); 
　　    Application["user_sessions"] = (int)Application["user_sessions"] + 1; 
　　    Application.UnLock(); 
    }

    void Session_End(object sender, EventArgs e) 
    {
        // 在会话结束时运行的代码。 
        // 注意: 只有在 Web.config 文件中的 sessionstate 模式设置为
        // InProc 时，才会引发 Session_End 事件。如果会话模式设置为 StateServer 
        // 或 SQLServer，则不会引发该事件。
        Application.Lock(); 
　　    Application["user_sessions"] = (int)Application["user_sessions"] - 1; 
　　    Application.UnLock(); 
    }
       
</script>
