﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using COCOWO.DB;
using COCOWO.COMP;

public partial class UpFiles : System.Web.UI.Page
{
    blog_status Blog_status = new blog_status();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (this.IsPostBack) this.SaveImages();
    }
    private Boolean SaveImages()
    {
        ///'遍历File表单元素
        HttpFileCollection files = HttpContext.Current.Request.Files;

        /// '状态信息
        System.Text.StringBuilder strMsg = new System.Text.StringBuilder();
        DataView mydv = Blog_status.Status_SELECT(UsersInfo.GetUserName);
        string stat_attType = mydv[0]["stat_attType"].ToString();//文件类型
        string stat_attSize = mydv[0]["stat_attSize"].ToString();//文件大小
        string stat_Code = mydv[0]["stat_Code"].ToString();//权限限制
        strMsg.Append("上传的文件分别是：<hr color=red>");
        try
        {
            for (int iFile = 0; iFile < files.Count; iFile++)
            {
                ///'检查文件扩展名字
                HttpPostedFile postedFile = files[iFile];
                string fileName, fileExtension, strFileName;
                fileName = System.IO.Path.GetFileName(postedFile.FileName);
                if (fileName != "")
                {
                    System.Random myRd = new Random();
                    fileExtension = System.IO.Path.GetExtension(fileName);//文件拓展名
                    strFileName = DateTime.Now.ToString().Replace("-", "").Replace(":", "").Replace(" ", "") + myRd.Next(1000) + fileExtension;
                    strMsg.Append("上传的文件类型：" + postedFile.ContentType.ToString() + "<br>");
                    strMsg.Append("客户端文件地址：" + postedFile.FileName + "<br>");
                    strMsg.Append("上传文件的文件名：" + fileName + "<br>");
                    fileExtension = fileExtension.Substring(1).ToUpperInvariant();//文件拓展名去"."大写
                    if (stat_attType.Contains(fileExtension))
                    {
                        if (postedFile.ContentLength < Convert.ToInt32(stat_attSize))
                        {
                            strMsg.Append("服务器文件的路径：" + Application["SiteURL"] + "Files/" + strFileName + "<br><hr>");
                            postedFile.SaveAs(System.Web.HttpContext.Current.Request.MapPath("Files/") + strFileName);//开始上传
                        }
                        else
                            strMsg.Append("服务器文件的路径： 文件太大清选择小于" + stat_attSize + "K的文件<br><hr>");
                    }
                    else
                        strMsg.Append("服务器文件的路径： 您没有权限上传此类型文件<br><hr>");
                }
            }
            strStatus.Text = strMsg.ToString();
            return true;
        }
        catch (System.Exception Ex)
        {
            strStatus.Text = Ex.Message;
            return false;
        }
    }
}
