﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.OleDb;
public partial class _Default : System.Web.UI.Page
{
    DB DBManage = new DB();
    string strSql = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["admin"] == null)
            strSql = "select * from Messages where ispass=true order by mid desc";
        else
        { 
            strSql = "select * from Messages order by mid desc";
        } 
            
        if (!IsPostBack) 
        {
            getDataList(strSql, "Messages");
        }
    }
    public void getDataList(string strSql, string tableName)
    {
        PagedDataSource objPds = new PagedDataSource();
        DataSet ds = new DataSet();
        ds = DBManage.getDs(strSql, tableName);
        objPds.DataSource = ds.Tables[0].DefaultView;
        objPds.AllowPaging = true;
        objPds.PageSize = 10;
        int PageSum=objPds.PageCount;
        if (PageSum == 1)
        {
            PageView.Text = "";
        }
        else 
        {
            int CurPage;

            //当前页面从Page查询参数获取
            if (Request.QueryString["Page"] != null)
                CurPage = Convert.ToInt32(Request.QueryString["Page"]);
            else
                CurPage = 1;
            objPds.CurrentPageIndex = CurPage - 1;
            //循环上限
            int totale;
            if (PageSum<10)
                totale=PageSum;
            else
                totale=10;
            if (CurPage>PageSum)
                totale=PageSum%10;

            PageView.Text = "<a class='nolink'>当前：" + CurPage + "页,共" + PageSum + "页</a>";
            PageView.Text += "<a class='page' href='?'>首页</a>";
            if (!objPds.IsFirstPage)
                PageView.Text += "<a class='page' href='?Page=" + (CurPage - 1) + "'>上一页</a>";
            else
                PageView.Text += "<a class='nolink'>上一页</a>";
            for (int i = 1; i <= totale; i++)
            {
                int pageid;
                if (CurPage%10==0)
                    pageid = i + (CurPage / 10) * 10 -1;
                else
                    pageid=i + (CurPage / 10) * 10;
                if (pageid > PageSum)
                    break;
                if (i!=CurPage%10)
                    PageView.Text += ("<a class='page' href='?Page=" + pageid + "'>" + pageid + "</a>");
                else
                    PageView.Text += ("<a class='thispage' href='?Page=" + pageid + "'>" + pageid + "</a>");
            }
            if (!objPds.IsLastPage)
                PageView.Text += "<a class='page' href='?Page=" + (CurPage + 1) + "'>下一页</a>";
            else
                PageView.Text += "<a class='nolink'>下一页</a>";

            PageView.Text += "<a class='page' href='?Page=" + PageSum + "'>尾页</a>";
        }


        //把PagedDataSource 对象赋给DataList控件 
        msgList.DataSource = objPds;
        msgList.DataBind(); 
    }
    public bool chkLogin()
    {
        if (Session["admin"] == null)
        {
            Response.Write("<script>alert('尚未登录，无法执行该操作');history.back(-1)</script>");
            return false;
        }
        else
            return true;
    }
    protected void Delete_Command(object sender, CommandEventArgs e)
    {
        if (chkLogin())
        { 
            Response.Write("<script>confirm('确认删除吗？')</script>");
            string delSql="delete from Messages where mid="+e.CommandArgument;
            if(DBManage.getReturnNum(delSql)>0)
                Response.Redirect("?result=删除成功！");        
        }

    }
    protected void Review_Command(object sender, CommandEventArgs e)
    {
        if (chkLogin())
            Response.Redirect("review.aspx?mid="+e.CommandArgument+"");
    }
    protected void IsPass_Command(object sender, CommandEventArgs e)
    {
        if (chkLogin())
        {
            string chkSql = "update Messages set ispass=abs(ispass-1) where mid=" + e.CommandArgument;
            if (DBManage.getReturnNum(chkSql) > 0)
                Response.Redirect("?result=审核成功！");
        }
    }
}
