﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;
//5_1_a_s_p_x.c_o_m

namespace NChat.Common
{
    public class StaticHelper
    {
        static StaticHelper()
        {
            MsgListStatic = new List<string>();
            UserListStatic = new List<string>();
            CurrentMsg = new Hashtable();
            ActiveTime = new List<ActiveUserModel>();
        }

        public static List<string> MsgListStatic { get; set; }
        public static List<string> UserListStatic { get; set; }
        public static Hashtable CurrentMsg { get; set; }
        public static List<ActiveUserModel> ActiveTime { get; set; }

        static StaticHelper MsgLock = new StaticHelper();
        static StaticHelper UserLock = new StaticHelper();
        static StaticHelper CurrentLock = new StaticHelper();
        static StaticHelper ActiveLock = new StaticHelper();

        public static void MsgListAdd(string item)
        {
            lock (MsgLock)
            {
                if (MsgListStatic.Count > 100)
                {
                    MsgListStatic.Clear();
                    CurrentClear();
                }
                MsgListStatic.Add(item);
            }
        }

        public static void UserListAdd(string item)
        {
            lock (UserLock)
            {
                if (!UserListStatic.Contains(item))
                    UserListStatic.Add(item);
            }
        }

        public static void UserListRemove(string item)
        {
            lock (UserLock)
            {
                UserListStatic.Remove(item);
            }
        }

        public static void CurrentAdd(object key, object value)
        {
            lock (CurrentLock)
            {
                CurrentMsg.Add(key, value);
            }
        }

        public static void CurrentUpdate(object key, object value)
        {
            lock (CurrentLock)
            {
                CurrentMsg[key] = value;
            }
        }

        public static void CurrentClear()
        {
            lock (CurrentLock)
            {
                CurrentMsg.Clear();
            }
        }

        public static void ActiceUserAdd(ActiveUserModel um)
        {
            lock (ActiveLock)
            {
                if (!ActiveTime.Contains(um))
                    ActiveTime.Add(um);
            }
        }

        public static void ActiveUserUpdate(ActiveUserModel um)
        {
            lock (ActiveLock)
            {
                ActiveTime.Remove(ActiveTime.Single(i => i.Name == um.Name));
                ActiveTime.Add(um);
            }
        }

        public static void OnlineUserClear()
        {
            for (int i = 0; i < ActiveTime.Count; i++)
			{
                ActiveUserModel item = ActiveTime[i];
			    if (item.Time.AddMinutes(20) < DateTime.Now)
                {
                    UserListRemove(item.Name);
                    lock (ActiveLock)
                    {
                        ActiveTime.Remove(item);
                    }
                }
			}
        }

        public static IEnumerable<string> MsgList(int userid)
        {
            if (CurrentMsg.Count > 0 && CurrentMsg.ContainsKey(userid))
            {
                int current = (int)CurrentMsg[userid];
                IEnumerable<string> results = MsgListStatic.Skip(current);
                current = MsgListStatic.Count;
                CurrentUpdate(userid, current);
                return results;
            }
            else
            {
                int current = MsgListStatic.Count;
                CurrentAdd(userid, current);
                return (IEnumerable<string>)MsgListStatic;
            }
        }
    }
}
