﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

using DB = NChart.DBHelper;
using System.Collections.Generic;
using NChat.Common;
//该源码下载自www.51aspx.com(５１ａｓｐｘ．ｃｏｍ)

namespace NChat.Web
{
    public partial class Room : System.Web.UI.Page
    {
        DB::User u;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session.Count > 0 && Session["SUser"] != null)
            {
                u = (DB::User)Session["SUser"];
                if (u.ID < 1)
                {
                    Session.RemoveAll();
                    Response.Redirect("Default.aspx");
                }
            }
            else
                Response.Redirect("Default.aspx");

            if (!Page.IsPostBack)
            {
                StaticHelper.OnlineUserClear();
                ListInit();
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            StaticHelper.ActiveUserUpdate(new ActiveUserModel(u.Name, DateTime.Now));
            if (!string.IsNullOrEmpty(TextBox1.Text))
            {
                string msg = TextBox1.Text.Trim();
                msg = msg.Replace("|", "&{/}$");
                string to = "大家";
                if (UserList.SelectedItem != null && !string.IsNullOrEmpty(UserList.SelectedItem.Text))
                {
                    to = UserList.SelectedItem.Text;
                    UserList.SelectedItem.Selected = false;
                }
                msg = u.Name + "|" + to + "|" + msg; 
                StaticHelper.MsgListAdd(msg);

                TextBox1.Text = "";
            }
        }

        protected void Timer1_Tick(object sender, EventArgs e)
        {
            IEnumerable<string> list = StaticHelper.MsgList(u.ID);

            foreach (var item in list)
            {
                string[] items = item.Split('|');
                items[2] = items[2].Replace("&{/}$", "|");
                if (items[1] == u.Name || items[1] == "大家" || items[0] == u.Name)
                {
                    if (items[0] == u.Name)
                        items[0] = "<font color=\"blue\">你</font>";
                    if (items[1] == u.Name)
                        items[1] = "<font color=\"blue\">你</font>";
                    MsgText.Text = "<strong>" + items[0] + "</strong>对<strong>" + items[1] + "</strong>说：" + items[2] + "<br/>" + MsgText.Text;
                }
            }
        }

        protected void Timer2_Tick(object sender, EventArgs e)
        {
            if (!StaticHelper.UserListStatic.Contains(u.Name))
                Session.RemoveAll();

            ListInit();
        }

        void ListInit()
        {
            UserList.Items.Clear();
            UserList.Items.Add("大家");
            foreach (var item in StaticHelper.UserListStatic)
            {
                //string temp = "<a href=\"javascript:;\" onserverclick=\"BulletedList1_Click\" runat=\"server\">" + item + "</a>";
                UserList.Items.Add(item);
            }
        }


        protected void UserList_SelectedIndexChanged(object sender, EventArgs e)
        {
            //CheckBoxList list = (CheckBoxList)sender;
            //if (list.SelectedItem != null)
            //    DropDownListAdd(list.SelectedItem.Text);
        }
    }
}
