using System;
using System.Data;
using System.Data.OleDb;
//Դwww.51aspx.com(a)


/// <summary>
/// Written:	[China] Zhao Zhe
/// Date:		Sep. 2004
/// Version		1.0
/// Support		MyBask<see cref="http://www.mybask.net"/>
/// Looking for the latest version or similar implentation of this function, please visit:<see cref="http://www.mybask.net"/>
/// 
/// Purpose:
/// To make connection to access easier.a Access version of SqlHelper.
/// Describe:
/// - Add several overload functions, which made it easy to use.
/// - only for DataReader
/// 
/// </summary>
public abstract class SqlHelper
{

    public SqlHelper()
    {

    }

    /// <summary>
    /// ִһSQL䣬ֻıҪʡȥcommandtype
    /// To excute a SQL statement, which reuturns a integer stand for effect line number.
    /// default Command type is text
    /// </summary>
    /// <param name="connString">ַ (Conntection String)</param>
    /// <param name="cmdText">commandַ (SQL Statement)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>Ӱ (effect line number)</returns>
    public static int ExecuteNonQuery(string connString, string cmdText, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();

        using (OleDbConnection conn = new OleDbConnection(connString))
        {
            PrepareCommand(cmd, conn, null, CommandType.Text, cmdText, cmdParms);

            int val = cmd.ExecuteNonQuery();
            cmd.Parameters.Clear();
            return val;

        }
    }

    /// <summary>
    /// ִһSQL䡣
    /// To excute a SQL statement, which reuturns a integer stand for effect line number.
    /// </summary>
    /// <param name="connString">ַ (Connection String)</param>
    /// <param name="cmdType">commandַ (SQL Statement)</param>
    /// <param name="cmdText">commandͣCommandType (Command type)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>Ӱ (effect line number)</returns>
    public static int ExecuteNonQuery(string connString, CommandType cmdType, string cmdText, params OleDbParameter[] cmdParms)
    {

        OleDbCommand cmd = new OleDbCommand();

        using (OleDbConnection conn = new OleDbConnection(connString))
        {
            PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
            int val = cmd.ExecuteNonQuery();
            cmd.Parameters.Clear();
            return val;
        }
    }

    /// <summary>
    /// ִһSQL䡣ֵconnection.
    /// To excute a SQL statement, which reuturns a integer stand for effect line number.
    /// a connection is passed in instead of a connection string
    /// </summary>
    /// <param name="conn">һԳʼõOleDbConnection (a Conncection)</param>
    /// <param name="connString">ַ (Conntection String)</param>
    /// <param name="cmdText">commandַ (SQL Statement)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>Ӱ (effect line number)</returns>
    public static int ExecuteNonQuery(OleDbConnection conn, CommandType cmdType, string cmdText, params OleDbParameter[] cmdParms)
    {

        OleDbCommand cmd = new OleDbCommand();

        PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
        int val = cmd.ExecuteNonQuery();
        cmd.Parameters.Clear();
        return val;
    }

    /// <summary>
    /// ִһSQL䡣ҪһTransaction.
    /// To excute a SQL statement, which reuturns a integer stand for effect line number.
    /// a transaction is reqired
    /// </summary>
    /// <param name="trans">һTrasaction (Trasaction)</param>
    /// <param name="cmdType">commandַ (SQL Statement)</param>
    /// <param name="cmdText">commandͣCommandType (Command type)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>Ӱ (effect line number)</returns>
    public static int ExecuteNonQuery(OleDbTransaction trans, CommandType cmdType, string cmdText, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();
        PrepareCommand(cmd, trans.Connection, trans, cmdType, cmdText, cmdParms);
        int val = cmd.ExecuteNonQuery();
        cmd.Parameters.Clear();
        return val;
    }

    /// <summary>
    /// ִһSelect䷵һdatareaderʡcommandtype
    /// To excute a SQL statement, and reuturns a dataReader.
    /// default command type is text
    /// </summary>
    /// <param name="connString">ַ (Conntection String)</param>
    /// <param name="cmdText">commandַ (SQL Statement)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>datareader</returns>
    public static OleDbDataReader ExecuteReader(string connString, string cmdText, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();
        OleDbConnection conn = new OleDbConnection(connString);

        // we use a try/catch here because if the method throws an exception we want to 
        // close the connection throw code, because no datareader will exist, hence the 
        // commandBehaviour.CloseConnection will not work
        try
        {
            PrepareCommand(cmd, conn, null, CommandType.Text, cmdText, cmdParms);
            OleDbDataReader rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
            //				cmd.Parameters.Clear();
            return rdr;
        }
        catch
        {
            conn.Close();
            throw;
        }
    }

    /// <summary>
    /// ִһSelect䷵һdatareader
    /// To excute a SQL statement, and reuturns a dataReader.
    /// </summary>
    /// <param name="connString">ַ (Connection String)</param>
    /// <param name="cmdType">commandַ (SQL Statement)</param>
    /// <param name="cmdText">commandͣCommandType (Command type)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>dataReader</returns>
    public static OleDbDataReader ExecuteReader(string connString, CommandType cmdType, string cmdText, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();
        OleDbConnection conn = new OleDbConnection(connString);

        // we use a try/catch here because if the method throws an exception we want to 
        // close the connection throw code, because no datareader will exist, hence the 
        // commandBehaviour.CloseConnection will not work
        try
        {
            PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
            OleDbDataReader rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
            //				cmd.Parameters.Clear();
            return rdr;//1a
        }
        catch
        {
            conn.Close();
            throw;
        }
    }

    /// <summary>
    /// ڶȡһֵѯصǽеһеĵһУʡȥcommandtype
    /// To excute a SQL statement, and returns the first column of the first line
    /// Default command type is text
    /// </summary>
    /// <param name="connString">ַ (Conntection String)</param>
    /// <param name="cmdText">commandַ (SQL Statement)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>the first column of the first line</returns>
    public static object ExecuteScalar(string connString, string cmdText, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();

        using (OleDbConnection conn = new OleDbConnection(connString))
        {
            PrepareCommand(cmd, conn, null, CommandType.Text, cmdText, cmdParms);
            object val = cmd.ExecuteScalar();
            cmd.Parameters.Clear();
            return val;
        }
    }

    /// <summary>
    /// ڶȡһֵѯصǽеһеĵһ
    /// To excute a SQL statement, and returns the first column of the first line
    /// </summary>
    /// <param name="connString">ַ (Connection String)</param>
    /// <param name="cmdType">commandַ (SQL Statement)</param>
    /// <param name="cmdText">commandͣCommandType (Command type)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>the first column of the first line</returns>
    public static object ExecuteScalar(string connString, CommandType cmdType, string cmdText, params OleDbParameter[] cmdParms)
    {
        OleDbCommand cmd = new OleDbCommand();

        using (OleDbConnection conn = new OleDbConnection(connString))
        {
            PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
            object val = cmd.ExecuteScalar();
            cmd.Parameters.Clear();
            return val;
        }
    }


    /// <summary>
    /// ڶȡһֵѯصǽеһеĵһ
    /// To excute a SQL statement, and returns the first column of the first line
    /// a connection is passed in instead of a connection string
    /// </summary>
    /// <param name="conn">һԳʼõOleDbConnection (a Conncection)</param>
    /// <param name="connString">ַ (Conntection String)</param>
    /// <param name="cmdText">commandַ (SQL Statement)</param>
    /// <param name="cmdParms">б (Paramters)</param>
    /// <returns>the first column of the first line</returns>
    public static object ExecuteScalar(OleDbConnection conn, CommandType cmdType, string cmdText, params OleDbParameter[] cmdParms)
    {

        OleDbCommand cmd = new OleDbCommand();

        PrepareCommand(cmd, conn, null, cmdType, cmdText, cmdParms);
        object val = cmd.ExecuteScalar();
        cmd.Parameters.Clear();
        return val;
    }

    /// <summary>
    /// ִSQL֮ǰ׼
    /// </summary>
    /// <param name="cmd">command</param>
    /// <param name="conn">connection</param>
    /// <param name="trans">trasaction</param>
    /// <param name="cmdType">command</param>
    /// <param name="cmdText">commandַ</param>
    /// <param name="cmdParms">б</param>
    private static void PrepareCommand(OleDbCommand cmd, OleDbConnection conn, OleDbTransaction trans, CommandType cmdType, string cmdText, OleDbParameter[] cmdParms)
    {

        if (conn.State != ConnectionState.Open)
            conn.Open();

        cmd.Connection = conn;
        cmd.CommandText = cmdText;

        if (trans != null)
            cmd.Transaction = trans;

        cmd.CommandType = cmdType;

        if (cmdParms != null)
        {
            foreach (OleDbParameter parm in cmdParms)
                cmd.Parameters.Add(parm);
        }
    }

}

