﻿///**************************
/// 创 建 者:Bonnibell
/// 创建日期:2008-11-20
/// 所属模块:留言板
/// 功　　能: 
/// 接受参数: 
/// 含数据表: 
///**************************
using System;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

public partial class Book_Get : System.Web.UI.Page
{
    string strConn = System.Web.Configuration.WebConfigurationManager.ConnectionStrings["connStr"].ConnectionString;

    string s_CurrentPage = string.Empty;
    string s_PageCount = string.Empty;
    string s_RecordCount = string.Empty;

    int i_CurrentPage = 0;
    int i_PageCount = 0;
    int i_RecordCount = 0;


    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.Params["PageIndex"] != null)
        {
            if (!string.IsNullOrEmpty(Request.Params["PageIndex"]))
            {
                s_CurrentPage = Request.Params["PageIndex"].ToString();
                i_CurrentPage = Int32.Parse(s_CurrentPage);
            }
        }
        BindDateList();
    }

    string GetName(string strIN)
    {
        string strTemp = strIN;

        if (strTemp.Length > 10)
        {
            strTemp = strTemp.Substring(0, 10);
        }
        return strTemp;
    }

    void BindDateList()
    {
        string strSql_Count = "Select Count(*) from T_Book";
        s_RecordCount = SqlHelper.ExecuteScalar(strConn, strSql_Count, null).ToString();
        i_RecordCount = Convert.ToInt32(s_RecordCount);

        if (i_RecordCount % 10 > 0)
        {
            i_PageCount = i_RecordCount / 10 + 1;
        }
        else
        {
            i_PageCount = i_RecordCount / 10;
        }

        s_PageCount = i_PageCount.ToString();

        string strRecordTemp = string.Empty;
        strRecordTemp = Convert.ToString(i_CurrentPage * 10);
        string strSql = string.Empty;

        if (s_CurrentPage == "0")
        {
            strSql = "select top 10 F_Name,F_Title,F_AddTime,F_Book  from T_Book order by F_Code DESC";
        }
        else
        {
            strSql = "select top 10 F_Name,F_Title,F_AddTime,F_Book from T_Book  where F_Code not in (select top " + strRecordTemp + " F_Code from T_Book order by F_Code DESC) order by F_Code DESC";
        }
        OleDbDataReader Rdlist = SqlHelper.ExecuteReader(strConn, strSql, null);
        DataTable Dt = new DataTable();
        DataRow dr;
        Dt.Columns.Add("F_Name", typeof(string));
        Dt.Columns.Add("F_Title", typeof(string));
        Dt.Columns.Add("F_AddTime", typeof(string));
        Dt.Columns.Add("F_Book", typeof(string));

        while (Rdlist.Read())
        {
            dr = Dt.NewRow();
            dr[0] = Rdlist[0].ToString();
            dr[1] = Rdlist[1].ToString();
            dr[2] = Rdlist[2].ToString();
            dr[3] = Rdlist[3].ToString();
            Dt.Rows.Add(dr);
        }
        Rdlist.Close();
        this.ImageList.DataSource = new DataView(Dt);
        this.ImageList.DataBind();
    }
    protected override void Render(HtmlTextWriter writer)
    {

        if (i_RecordCount > 0)
        {
            StringBuilder sp = new StringBuilder();
            sp.AppendLine("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"300px\" >");
            sp.AppendLine("<tr>");
            sp.AppendLine("	<td>&nbsp;&nbsp;&nbsp;&nbsp;共&nbsp;");
            sp.Append(s_RecordCount);
            sp.AppendLine("&nbsp;条记录");
            sp.AppendLine("	  </td>");
            sp.AppendLine("	<td style=\"padding-top:3px;\">");
            if (i_PageCount > 1)
            {
                if (i_CurrentPage == 0)
                {
                    sp.AppendLine("<a  href=\"javascript:Paging(" + Convert.ToString(i_CurrentPage + 1) + ")\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">下一页</a>");
                    sp.AppendLine("&nbsp;");
                    sp.AppendLine("<a  href=\"javascript:Paging(" + Convert.ToString(i_PageCount - 1) + ")\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">末页</a>");
                    sp.AppendLine("&nbsp;&nbsp;");
                }
                else
                {
                    if (Convert.ToInt32(i_CurrentPage + 1) == i_PageCount)
                    {
                        sp.AppendLine("<a  href=\"javascript:Paging(0)\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">首页</a>");
                        sp.AppendLine("&nbsp;");
                        sp.AppendLine("<a  href=\"javascript:Paging(" + Convert.ToString(i_CurrentPage - 1) + ")\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">上一页</a>");
                        sp.AppendLine("&nbsp;");
                    }
                    else
                    {
                        sp.AppendLine("<a  href=\"javascript:Paging(0)\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">首页</a>");
                        sp.AppendLine("&nbsp;");
                        sp.AppendLine("<a  href=\"javascript:Paging(" + Convert.ToString(i_CurrentPage - 1) + ")\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">上一页</a>");
                        sp.AppendLine("&nbsp;");
                        sp.AppendLine("<a  href=\"javascript:Paging(" + Convert.ToString(i_CurrentPage + 1) + ")\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">下一页</a>");
                        sp.AppendLine("&nbsp;");
                        sp.AppendLine("<a  href=\"javascript:Paging(" + Convert.ToString(i_PageCount - 1) + ")\" style=\"display:inline-block;color:#ffffff;text-decoration:none;height:17px;\">末页</a>");
                        sp.AppendLine("&nbsp;&nbsp;");
                    }
                }
            }
            sp.AppendLine("	</td>");
            sp.AppendLine("	<td>");
            sp.AppendLine("<span >共" + s_PageCount + "页,当前第" + Convert.ToString(i_CurrentPage + 1) + "页</span>");
            sp.AppendLine("	</td>");
            sp.AppendLine("</tr>");
            sp.AppendLine("</table>");

            writer.Write(sp.ToString());
        }
        this.ImageList.RenderControl(writer);
    }
}
