            // Add a new ListItem to the ListBosID_ADDED HiddenField
            function AddListItem(listName, text, value)
            { 
                var hiddenField = GetHiddenField(listName.id + '_ADDED');

                if (hiddenField != null)
                {
		            // Add a separator
		            var tmp = hiddenField.value;
		            if (tmp != '')
		               hiddenField.value += ',';

		            // Add the item to the hidden field
		            hiddenField.value += text + '|' + value; 
            		
		            // if present in the REMOVED hidden field, remove it
		            var removeHiddenField = GetHiddenField(listName.id + '_REMOVED');
		            if (removeHiddenField != null)
		            {
			            var removedItems = removeHiddenField.value.split(',');
			            removeHiddenField.value = '';
			            for (var i=0;i<removedItems.length;i++)
			            {
				            if (value != removedItems[i])
				            {
					            // Add a separator
					            var tmp1 = removeHiddenField.value;
					            if (tmp1 != '')
						            removeHiddenField.value += ',';

					            removeHiddenField.value += removedItems[i]; 
				            }
			            }			
		            }
	            }
            }

            // Removes an item from the ListBoxID_REMOVED HiddenField
            function RemoveListItem(listName, value)
            {   
                var hiddenField = GetHiddenField(listName.id + '_REMOVED');

                if (hiddenField != null)
                {
		            // Add a separator
		            var tmp = hiddenField.value;
		            if (tmp != '')
		               hiddenField.value += ',';

		            hiddenField.value += value; 
            		
		            // if present in the ADDED hidden field, remove it
		            var addHiddenField = GetHiddenField(listName.id + '_ADDED');
		            if (addHiddenField != null)
		            {
			            var addedItems = addHiddenField.value.split(',');
			            addHiddenField.value = '';
			            for (var i=0;i<addedItems.length;i++)
			            {
				            if (addedItems[i].match(value) == null)
				            {
					            // Add a separator
					            var tmp1 = addHiddenField.value;
					            if (tmp1 != '')
						            addHiddenField.value += ',';

					            addHiddenField.value += addedItems[i]; 
				            }
			            }			
		            }
                }
            }

            // Finds a hidden field on the page
            function GetHiddenField(fieldName)
            {
                var hiddenField;
                hiddenField = document.getElementById(fieldName);
                
                if (hiddenField != null)
                    return hiddenField;
                    
                return null;
            }          





            function bhMover_MoveItem(ctrlSource, ctrlTarget) {
                var Source = document.getElementById(ctrlSource);
                var Target = document.getElementById(ctrlTarget);

                // Make sure both Listboxs are present
                if ((Source != null) && (Target != null)) {
                    // Loop through all the items selected
                    // since the ListBoxes are configured to have
                    // multiple selection mode
                    while (Source.options.selectedIndex >= 0) {
                        // Create a new instance of ListItem
                        var newOption = new Option();
                        newOption.text = Source.options[Source.options.selectedIndex].text;
                        newOption.value = Source.options[Source.options.selectedIndex].value;

                        //Append the item in Target    
                        Target.options[Target.length] = newOption;

                        // Add the new text|value to the Hidden Field _ADDED of the Target Listbox
                        AddListItem(Target, newOption.text, newOption.value);

                        //Remove the item from Source
                        Source.remove(Source.options.selectedIndex);

                        // Add the index of the item to be removed into the 
                        // Hidden Field _REMOVED
                        RemoveListItem(Source, newOption.value);

                    }
                }
            }