﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="List.aspx.cs" Inherits="List" %>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>50CMS后台框架</title>
    <link rel="shortcut icon" href="favicon.ico"> 
    <link href="../css/bootstrap.min.css?v=3.3.6" rel="stylesheet">
    <link href="../css/font-awesome.css?v=4.4.0" rel="stylesheet">
    <link href="../css/animate.css" rel="stylesheet">
    <link href="../css/style.css?v=4.1.0" rel="stylesheet">

    <link href="../css/plugins/footable/footable.core.css" rel="stylesheet" />

    <link href="../50/style.css" rel="stylesheet" />


        
    <link href="../css/plugins/sweetalert/sweetalert.css" rel="stylesheet" />
    <script src="../Js/plugins/sweetalert/sweetalert.min.js"></script>
 <style>
 .msgtable td{
	padding:0px;
}
</style>
</head>

<body class="gray-bg">
     <form id="form1" runat="server">
           <div class="wrapper wrapper-content animated fadeInRight">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5><b>分类管理 &gt; 分类列表</b></h5>                      
                                  
                                    <div class="ibox-tools">
                                      <a href="List.aspx" class="btn btn-primary btn-xs"><i class="fa fa-refresh"> &nbsp;&nbsp; 刷 新</i></a>
                                   
                                          <a href="#" id="Add" class="btn btn-primary btn-xs"><i class="fa fa-plus"></i>&nbsp;&nbsp; 新增</a>
                                    </div>
                            </div>
                            <div class="ibox-content">

   <asp:Repeater ID="rptList" runat="server" onitemcommand="rptList_ItemCommand">
    <HeaderTemplate>
 <table class="footable table  toggle-arrow-tiny"  >
          <thead>
      <tr>
    
        <th>编号</th>
        <th >分类标题</th>
        <th >内容统计</th>
        <th >属性</th>
        <th >操作</th>
      </tr>
              </thead>
      </HeaderTemplate>
      <ItemTemplate>
      <tr>       
      
        <td ><asp:Label ID="lb_id" runat="server" Text='<%#Eval("Classid")%>'></asp:Label></td>
        <td><a href="add.aspx?id=<%#Eval("Classid") %>"><%#Eval("ClassName")%></a></td>
   
        <td ><%#Eval("ClassCount")%>&nbsp;篇</td>
        <td ><%#Eval("lb")%></td>
        <td ><span><a onclick="EditTag(<%#Eval("Classid")%>)"  class="btn btn-info btn-xs"><i class="fa fa-pencil"></i>修改&nbsp;&nbsp;</a></span>
             <asp:LinkButton ID="LinkButton1" runat="server" CommandName="del"  CssClass="btn btn-warning btn-xs">删除</asp:LinkButton>		

         
		</td>
      </tr>
      </ItemTemplate>

      <FooterTemplate>
      </table>
      </FooterTemplate>
      </asp:Repeater>    

                            </div>
                        </div>
                    </div>          
    </div>
</div>

    <!-- 全局js -->
    <script src="../js/jquery.min.js?v=2.1.4"></script>
    <script src="../js/bootstrap.min.js?v=3.3.6"></script>
     <!-- 自定js -->

  
    <script src="../js/content.js" type="text/javascript"></script>
    <script type="text/javascript" src="../js/layer/layer.js"></script>


          <script type="text/javascript">
 

        $(function () {
            $("#Add").click(function () {

                layer.open({
                    type: 2,
                    title: '添加分类',
                    shadeClose: true,
                    shade: 0.8,
                    area: ['90%', '90%'],
                    content: 'Add.aspx',  //iframe的url
                    end: function () {

                        location.reload();

                    }
                });

            });

        });

        function EditTag(ID)
       {
           layer.open({
               type: 2,
               title: '修改分类',
               shadeClose: true,
               shade: 0.8,
               area: ['90%', '80%'],
               content: 'Add.aspx?id=' + ID,  //iframe的url
               end: function () {

                   location.reload();

               }
           });
       }


      
        if (typeof (myError) != "undefined") 
           {
            swal({ title: "出错", text: Msg, type: "error",  html: true, showConfirmButton: false, timer: 5000 });
           };

       
    
    </script>
</form>
</body>
</html>


