﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="TagList.aspx.cs" Inherits="TagList" %>
<!DOCTYPE html>
<html>
<head>

   <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>50CMS后台框架</title>
    <link rel="shortcut icon" href="favicon.ico">
     <link href="../css/bootstrap.min.css?v=3.3.6" rel="stylesheet">
    <link href="../css/font-awesome.css?v=4.4.0" rel="stylesheet">
    <link href="../css/animate.css" rel="stylesheet">
    <link href="../css/style.css?v=4.1.0" rel="stylesheet">
    <link href="../css/plugins/footable/footable.core.css" rel="stylesheet" />

</head>

<body class="gray-bg">
<form id="form1" runat="server" class="form-horizontal">
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-sm-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>
                            标签管理</h5>
                        
                       
                        <div class="ibox-tools">

                             <a href="TagList.aspx" class="btn btn-primary btn-xs"><i class="fa fa-refresh"> &nbsp;&nbsp; 刷 新</i></a>
                          
                            <a href="#" id="Add" class="btn btn-primary btn-xs"><i class="fa fa-plus"></i>&nbsp;&nbsp; 新增</a>

                      </div>
                    </div>
                    <div class="ibox-content">
                       
                         <asp:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                            <HeaderTemplate>
                                <table class="footable table table-stripped toggle-arrow-tiny"  data-page-size="15" >
                                    <thead>
                                        <tr>
                                            <th align="center">编号</th>
                                            <th align="center">标题</th>
                                            <th align="left">调用代码</th>
                                            <th align="center">操作 </th>                                                                           
                                        </tr>
                                    </thead>
                                    <tbody>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr class="gradeX">
                                    
                                    <td ><asp:Label ID="lb_id" runat="server" Text='<%#Eval("TID")%>'></asp:Label></td>                            
                                    <td><a onclick=EditTag('<%#Eval("TID")%>')><%#Eval("TName")%></a></td>
                                    <td>$use_<%#Eval("TName")%>$</td>

                                
                                    <td >
                                        <a onclick=EditTag('<%#Eval("TID")%>') class="btn btn-info btn-xs"><i class="fa fa-pencil"></i>&nbsp;&nbsp;  修改</a>       
                                         <asp:LinkButton ID="LinkButton1" runat="server" CommandName="del" CssClass="btn btn-warning btn-xs" ><i class="fa fa-remove"></i>&nbsp;&nbsp;  删除</asp:LinkButton> 
                                    </td>

                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="4">
                                            <ul class="pagination pull-right">
                                            </ul>
                                        </td>
                                    </tr>
                                </tfoot>
                                </table>
                            </FooterTemplate>
                        </asp:Repeater>
                   
                   </div>
                </div>
            </div>
        </div>
    </div>
    </form>



      <!-- 全局js -->
    <script src="../js/jquery.min.js?v=2.1.4"></script>
    <script src="../js/bootstrap.min.js?v=3.3.6"></script>

      <!-- 自定js -->

    <script src="../js/plugins/footable/footable.all.min.js" type="text/javascript"></script>
    <script src="../js/content.js" type="text/javascript"></script>
    <script type="text/javascript" src="../js/layer/layer.js"></script>

    <script type="text/javascript">
        $(document).ready(function () { $(".footable").footable(); });
    </script>
    <script type="text/javascript">
 

        $(function () {
            $("#Add").click(function () {

                layer.open({
                    type: 2,
                    title: '添加自定义标签',
                    shadeClose: true,
                    shade: 0.8,
                    area: ['90%', '90%'],
                    content: 'TagAdd.aspx',  //iframe的url
                    end: function () {

                        location.reload();

                    }
                });

            });

        });

        function EditTag(ID)
       {
           layer.open({
               type: 2,
               title: '修改自定义标签',
               shadeClose: true,
               shade: 0.8,
               area: ['90%', '80%'],
               content: 'TagAdd.aspx?id=' + ID,  //iframe的url
               end: function () {

                   location.reload();

               }
           });
       }

    </script>
 
</body>
</html>

