﻿var whir = window.whir || {};
whir.global = {
    basePath: "/",
    getNewObj: function (oldObj, newObj) {
        var ops = oldObj;
        if (oldObj != undefined) {
            ops = $.extend(oldObj, newObj);
            //oldObj = ops;
        }
        return ops;
    },
    initQQ: function (options) {
        var opt = this.getNewObj(whir.qq, options);


        switch (opt.qqRegion) {
            case "gz":
            case "sh":
            case "xm":
            case "sz":
            case "hz":
            case "nj":
            case "wh":
            case "hf":
            case "cs":
            case "quanwangzhancn":
                this.getNewObj(whir.qq, {
                    homeFixedShowCount: 1,
                    homeFixedSecondShow: 14,
                    qqShowCount: 4,
                    qqSecondShow: [23,18,18,18],
                    qqtkClass: ".qqtk",
                    qqkfClass: ".qqkf"
                });
                opt.showQQcustomer();
                opt.showQQ();
                opt.showHomeFixed();
                break;
            case "sh2":
                opt.show53();
                break;
            case "quanwangzhanCom":
            case "quanwangNetCn":
                this.getNewObj(whir.qq, {
                    homeFixedShowCount: 1,
                    homeFixedSecondShow: 14,
                    qqShowCount: 1000,
                    qqSecondShow: 13,
                    qqtkClass: ".qqtk",
                    qqkfClass: ".qqkf"
                });
                opt.showQQcustomer();
                opt.showQQ();
                break;
            case "csd":
                $('.QQcustomer img').click(function () {
                    whir.qq.showQQIframe();
                });
                break;
            case "hznetcn":
            case "njnetcn":
            case "hfnetcn":
                this.getNewObj(whir.qq, {
                    homeFixedShowCount: 1,
                    homeFixedSecondShow: 14,
                    qqShowCount: 3,
                    qqSecondShow: [23, 18, 18]
                });
                opt.showHomeFixed();
                opt.showQQcustomer();
                opt.showQQ();
                break;
        }
    },
    initBootom: function (options) {
        if (whir.bottom != undefined) {
            var ops = this.getNewObj(whir.bottom, options);

            ops.showFootLink();
            ops.shopFastNav();
            $(window).scroll(function () {
                if ($(window).scrollTop() > 10) {
                    $(".toTop").fadeIn(500);
                } else {
                    $(".toTop").fadeOut(500);
                }

                ops.shopFastNav();
            });


            //当点击跳转链接后，回到页面顶部位置
            $(".toTop").click(function () {
                $('body,html').animate({ scrollTop: 0 }, 1000);
                return false;
            });

            //样式
            $(".divFoot .links dl:last").css("margin-right", "0");

            $(".fast_nav li").click(function () {
                var index = $(this).index(),
                    istop = $(".fast_nav_fixed").eq(index).offset().top;

                $("html,body").stop().animate({ scrollTop: istop }, 500);
            });

            $(".phones .city b").each(function () {
                str = $(this).text();

                var strs = new Array();
                strs = str.split("•");

                for (i = 0; i < strs.length; i++) {
                    if (strs[1] == "" || strs[1] == undefined) {
                        $(this).html(strs[0]);
                    } else {
                        $(this).html(strs[0] + "<i>•" + strs[1] + "</i>");
                    }
                }
            });

            //整站无图处理
            jQuery.each(jQuery("img"), function (i, n) {
                jQuery(n).error(function () { n.src = whir.global.basePath + 'uploadfiles/nopic.jpg'; });
                n.src = n.src;
            });
        }
    },
    initTop: function (options) {
        if (whir.top != undefined) {
            var ops = this.getNewObj(whir.top, options);

            //导航选中
            $("#nav" + navID).addClass("onnav");

            //样式
            $(".website_list dl dd:last").css("border-bottom", "0");

            $(".Top .slide .a").hover(function () {
                $(this).removeClass("a");
            }, function () {
                $(this).addClass("a");
            });

            $(".Top .slide_bg .slide").each(function () {
                $(this).attr("data-height", $(this).outerHeight(true));
            });

            $(".MainNav ul li").hover(function () {
                var _index = $(this).index(),
                    dataheight = $(".Top .slide_bg .slide" + _index).attr("data-height");
                $(".Top .slide_bg .slide").stop().animate({ height: 0 }, 500)
                $(".Top .slide_bg .slide" + _index).stop().animate({ height: dataheight }, 500);
                $(".Top .slide_bg").stop().animate({ height: dataheight }, 500);
            }, function () {
                $(".Top .slide").hover(function () {
                    var dataheight = $(this).attr("data-height");
                    $(".Top .slide_bg .slide").stop().animate({ height: 0 }, 500)
                    $(this).stop().animate({ height: dataheight }, 500);
                    $(".Top .slide_bg").stop().animate({ height: dataheight }, 500);
                    return false;
                }, function () {
                    $(".Top .slide_bg .slide").stop().animate({ height: 0 }, 500);
                    $(".Top .slide_bg").stop().animate({ height: 0 }, 500);
                })
                $(".Top .slide_bg .slide").stop().animate({ height: 0 }, 500);
                $(".Top .slide_bg").stop().animate({ height: 0 }, 500);
            })

            $(".Top .slide2 .left a").hover(function () {
                var _index = $(this).index();
                $(this).addClass("a_bg").siblings("a").removeClass("a_bg");
                $(".Top .slide2 .right .list").hide().eq(_index).show();
            })
            $(".Top .slide3 .left a").hover(function () {
                var _index = $(this).index();
                $(this).addClass("a_bg").siblings("a").removeClass("a_bg");
                $(".Top .slide3 .right").hide().eq(_index).show();
            })
            $(".Top .slide6 .left a").hover(function () {
                var _index = $(this).index();
                $(this).addClass("a_bg").siblings("a").removeClass("a_bg");
                $(".Top .slide6 .right .list").hide().eq(_index).show();
            })
            $(".Top .slide7 .left a").hover(function () {
                var _index = $(this).index();
                $(this).addClass("a_bg").siblings("a").removeClass("a_bg");
                $(".Top .slide7 .right .list").hide().eq(_index).show();
            })
            $(".Top .slide8 .left a").hover(function () {
                var _index = $(this).index();
                $(this).addClass("a_bg").siblings("a").removeClass("a_bg");
                $(".Top .slide8 .right .list").hide().eq(_index).show();
            })

        }
    },
    initMenu: function (options) {
        if (whir.menu != undefined) {
            var ops = this.getNewObj(whir.menu, options);
            ops.selectMenu();
            if (ops.isListCenter) {
                ops.listCenter();
            }
        }
    },
    initAboutMenu: function (options) {
        if (whir.aboutMenu != undefined) {
            var ops = this.getNewObj(whir.aboutMenu, options);
            ops.aboutMenuLiHover();

            $(".about_menu li").addClass("li");
            $("#third_menu" + third_menu).removeClass("li");

            whir.menu.selectMenu();
            whir.menu.listCenter();
        }
    },
    initNewsMenu: function (options) {
        if (whir.newsMenu != undefined) {
            var ops = this.getNewObj(whir.newsMenu, options);
            var menuId = window.menuID;
            var cateName = ops.cateName;
            if (ops.cateName == "") {
                cateName = "公司新闻";
            }

            switch (cateName) {
                case "公司新闻":
                    cateName = "万户新闻";
                    menuId = 1;
                    break;
                case "业务动态":
                    menuId = 2;
                    break;
                case "客户评价":
                    cateName = "客户反响";
                    menuId = 3;
                    $(".news li .txt .t").attr({ "href": "javascript:void(0)", "style": "cursor:default" });
                    $(".news li .txt .more,.news li .time").hide();
                    $(".news li .txt").css("width", "820px");
                    break;
                case "媒体报道":
                    menuId = 4;
                    break;

                case "公司活动":
                    menuId = 5;
                    break;
                default:
                    menuId = 1; break;
            }
            $("#menu" + menuId).addClass("onmenu");


            var tempSubTitle = "万户新闻";
            for (var i in ops.showSubTitles) {
                if (ops.showSubTitles[i] == cateName) {
                    tempSubTitle = cateName;
                    break;
                }
            }
            $("#subTitle").text(cateName);

            whir.aboutMenu.aboutMenuLiHover();
        }
    },
    //服务领域
    initServerAreas: function (options) {
        if (whir.serverAreas != undefined) {
            var ops = this.getNewObj(whir.serverAreas, options);

            ops.servicesBoxSpanShow();
            ops.servicesBoxHeight();
            ops.webSiteImgClass();
            $(window).unbind().bind("resize", function () {
                ops.servicesBoxHeight();
                ops.webSiteImgClass();
            })
        }
    },
    //创意设计
    initCreative: function (options) {
        if (whir.creative != undefined) {
            var ops = this.getNewObj(whir.creative, options);
            //banner
            jQuery(".DesignBan").slide({ mainCell: ".BanList ul", titCell: ".TabList li", effect: "fold", autoPlay: true, interTime: 2000 });

            var num = $(".DesignBan .BanList ul li").size();
            var width = $(".DesignBan .TabList ul li:first").outerWidth(true);
            $(".DesignBan .TabList ul").width(num * width);

            //团队成员
            jQuery(".memberBox .memberContent").slide({ mainCell: ".BanList ul", effect: "leftLoop", autoPlay: true, interTime: 2000 });

        }
    },
    //网站策划
    initWebSitePlan: function (options) {
        var ops = this.getNewObj(whir.webSitePlan, options);
        if (ops != undefined) {
            //案例
            $(".Contain .Site_Box").each(function () {
                $(this).find(".down ul li").each(function () {
                    $(this).hover(function () {
                        $(this).find("span").show();
                    }, function () {
                        $(this).find("span").hide();
                    });
                });
            });

            $(".Site_Box").each(function () {
                $(this).find(".Site_Box").find(".down ul li:last").css("margin-left", "0");
            });

            $(".backgroung1 .Site_btn").click(function () {
                var index = $(this).index() - 1,
                    isTop = $(".fast_nav_fixed").eq(index).offset().top;
                $("html,body").stop().animate({ scrollTop: isTop }, 500);
            })
        }
    },
    //解决方案
    initSolution: function (options) {
        var ops = this.getNewObj(whir.solution, options);

        for (var i in ops.types) {
            switch (ops.types[i]) {
                case "上市公司":
                case "金融":
                case "商业中心":
                case "政府":
                case "家电":
                case "医院":
                case "外贸":
                    var width = $(".Solution_Column .title").outerWidth(true);
                    $(".Solution_Column .title").css("margin-left", "-" + width * 0.5 + "px");
                    break;
                case "主栏目":
                    $(".Solution_list ul li").eq(0).addClass("on");
                    $(".Solution_content .box").eq(0).show();

                    //解决方案 划过效果
                    $(".Solution_list ul li").each(function (i) {
                        $(this).hover(function () {
                            $(this).siblings("li").removeClass("on");
                            $(this).addClass("on");
                            $(".Solution_content .box").eq(i).siblings(".box").hide();
                            $(".Solution_content .box").eq(i).show();
                        });
                    });
                    break;
            }
        }
    },
    //建站优势
    initAdvantage: function (options) {
        var ops = this.getNewObj(whir.advantage, options);

        for (var i in ops.types) {
            switch (Number(ops.types[i])) {
                case 0:
                    $(".station_nav ul li:eq(0)").addClass("on");
                    break;
                case 8:
                    $(".station8 .list li").each(function (i) {
                        if ((i + 1) % 4 == 0) {
                            $(this).css("margin-right", "0").after("<div class='clear'></div>")
                        }
                    });
                    break;
            }
        }
    },
    //网站建设
    initWebBuild: function (options) {
        var thisObj = this;
        var ops = thisObj.getNewObj(whir.webBuild, options);
        for (var i in ops.types) {
            switch (ops.types[i]) {
                case "网站改版":
                    //网站改版服务优势切换
                    $(".site_revision_list .li .div").mousemove(function () {
                        ops.tab(this);
                    })

                    $(".station_nav ul li:eq(1)").addClass("on");
                    if (window.location.hash != "" && window.location.hash != "#") {
                        ops.tab($(".site_revision_list li[data='" + window.location.hash + "']").find(".div"));
                    }
                    break;
                case "全网站建设":
                    $(".whole .con2_bg .con2 .list .r .li:first").show();
                    $(".whole .con3_bg .con .list li").mousemove(function () {
                        var _index = $(this).index();
                        $(this).addClass("li").siblings().removeClass("li");
                        $(".whole .con3_bg .con .txt").hide().eq(_index).show();
                    })
                    $(".station_nav ul li:eq(2)").addClass("on");
                    break;
                case "微信网站":
                    $(".station_nav ul li:eq(4)").addClass("on");

                    $(".micro .con2 .list .ul li").mousemove(function () {
                        var _index = $(this).index();
                        $(this).addClass("li").siblings().removeClass()
                        $(".micro .con2 .img img").hide().eq(_index).show();
                        $(".micro .con2 .list .text").hide().eq(_index).show();
                    });

                    $(".micro .con3 .t .list .ul li").each(function (i) {
                        if ((i + 1) % 8 == 0) {
                            $(this).css("margin-right", "0");
                        }
                        $(this).mousemove(function () {
                            $(this).addClass("li").siblings("li").removeClass("li");
                            var _index = $(this).index();
                            $(".micro .con3 .t .list .list_txt li").hide().eq(_index).show();
                        })
                    });

                    $(".micro .con4 .list:first").show();

                    $(".micro .con4 .list").each(function () {
                        $(this).find("li").first().css("margin", "0").addClass("li");
                    });

                    $(".micro .con4 .list li").mousemove(function () {
                        $(this).addClass("li").siblings().removeClass();
                    });

                    $(".micro .con4 .tab .bd li:first").addClass("on")
                    $(".micro .con4 .tab .bd li").mousemove(function () {
                        var _index = $(this).index();
                        $(this).addClass("on").siblings().removeClass("on");
                        $(".micro .con4 .list li").removeClass("li").eq(_index).addClass("li");
                    });
                    break;
                case "手机网站":
                    if ($(".mobile_station .con6 .box .bd li").length > 4) {
                        jQuery(".mobile_station .con6 .box").slide({ titCell: ".hd ul", mainCell: ".bd ul", autoPage: true, effect: "left", autoPlay: true, vis: 4, interTime: 4000 });
                    } else {
                        $(".mobile_station .con6 .box .bd li:last").css("margin-right", "0")
                    }
                    $(".station_nav ul li:eq(3)").addClass("on");
                    break;
            }
        }
    },
    //技术开发
    initDevelop: function (options) {
        var ops = this.getNewObj(whir.develop, options);
        for (var i in ops.types) {
            switch (ops.types[i]) {
                case "ezMobi":
                    $(".technology_mobi .con2 .list li").each(function (i) {
                        if ((i + 1) % 4 == 0) {
                            $(this).addClass("li");
                        }
                    });
                    break;
                default:
                    $(".technology .technology_c").mousemove(function () {
                        $(".technology .technology_c_hover").show();
                    })
                    $(".technology .technology_c_hover").mouseleave(function () {
                        $(this).hide();
                    })
                    break;
            }
        }
    },
    //案例列表
    initCase: function (options) {
        var ops = this.getNewObj(whir.caseinfo, options);

        $(".case_list .list li").each(function (i) {
            if ((i + 1) % 3 == 0) {
                $(this).css("margin-right", "0");
            }
        });

        $(".case_list .list li").hover(function () {
            $(this).addClass("li");
        }, function () {
            $(this).removeClass("li");
        });

        var city = ops.city;
        $(".city").removeClass("onmenu");
        $("[city='" + city + "']").addClass("onmenu");

        var industry = ops.industry;
        $(".industry").removeClass("onmenu");
        $("[industry='" + industry + "']").addClass("onmenu");

        $(".btnGoPage").click(function () {
            var page = $(this).prev().val();
            if (/\d+/.test(page)) {
                page = parseInt(page) > 0 ? parseInt(page) : 1;
                window.location = whir.request.appendUrlArg("page", page);
            } else {
                $(this).prev().focus();
                alert("请输入正确的数字！");
            }
        });

        //图片放大
        $(".case_list .list li .img span").hover(function () {
            $(this).siblings("img").stop().animate({ width: 418, height: 275, marginTop: -138, marginLeft: -209 }, 500);
        }, function () {
            $(this).siblings("img").stop().animate({ width: 380, height: 250, marginTop: -125, marginLeft: -190 }, 500);
        })


    },
    //案例详细
    initCaseInfo: function (options) {
        var ops = this.getNewObj(whir.caseinfo, options);


        $(".case_info .conten .con span").click(function () {
            var _index = $(this).index();
            $(".case_info .conten .con span").removeClass("span").eq(_index).addClass("span")
            $(".case_info .right > .con").hide().eq(_index).show();
        })

        if ($(window).width() > 1800) {
            $(".case_info_mobilebg1").addClass("case_info_mobilebg1_big");
            $(".case_info_mobilebg2").addClass("case_info_mobilebg2_big");
        } else {
            $(".case_info_mobilebg1").removeClass("case_info_mobilebg1_big");
            $(".case_info_mobilebg2").removeClass("case_info_mobilebg2_big");
        }

        var leftwidth = $(".case_info .left").width();
        var rightwidth = $(".case_info").width() - $(".case_info .left").width() - $(".case_info .conten").width();
        $(".case_info .conten").css("left", leftwidth);
        $(".case_info .right").width(rightwidth - 20);

        $(".case_info .left .con").height($(window).height() - 94 - 121 - 35);

        $(window).scroll(function () {
            var casebantop = $(".case_info_banbox").height(),
                scrolltop = $(window).scrollTop();

            if (scrolltop > casebantop) {
                $(".case_info_ban").css("position", "fixed");
                $(".case_fixed").css({ "position": "fixed", "top": casebantop, "height": $(".case_info").outerHeight(true) });
                $(".case_info .left .con").height($(window).height() - 94 - 35);
            } else {
                $(".case_info_ban").css("position", "relative");
                $(".case_fixed").attr("style", "")
                $(".case_info .left .con").height($(window).height() - 94 - 121 - 35);
            }
        });

        $(window).resize(function () {
            $(".case_info .left .con").height($(window).height() - 94 - 121 - 35);
            var leftwidth = $(".case_info .left").width();
            var rightwidth = $(".case_info").width() - $(".case_info .left").width() - $(".case_info .conten").width();
            $(".case_info .conten").css("left", leftwidth);
            $(".case_info .right").width(rightwidth - 20)
            var casebantop = $(".case_info_banbox").height(),
                scrolltop = $(window).scrollTop();
            if (scrolltop > casebantop) {
                $(".case_info_ban").css("position", "fixed");
                $(".case_fixed").css({ "position": "fixed", "top": casebantop, "height": $(".case_info").outerHeight(true) });
            } else {
                $(".case_info_ban").css("position", "relative");
                $(".case_fixed").attr("style", "")
            }
            if ($(window).width() > 1800) {
                $(".case_info_mobilebg1").addClass("case_info_mobilebg1_big");
                $(".case_info_mobilebg2").addClass("case_info_mobilebg2_big");
            } else {
                $(".case_info_mobilebg1").removeClass("case_info_mobilebg1_big");
                $(".case_info_mobilebg2").removeClass("case_info_mobilebg2_big");
            }
        });

        ops.mobileShow();
    },
    //关于万户
    initAbout: function (options) {
        var ops = this.getNewObj(whir.about, options);
        ops.aboutchanHover();
        ops.aboutchanBanLiFirst();
        ops.aboutchanFindUlLiCss();
        ops.aboutchanAClick();
        ops.aboutchanLiHover();
        ops.aboutAlertbgSelect();
        ops.bdAnimate.init();
    },
    //荣誉资质
    initHonor: function (options) {
        var ops = this.getNewObj(whir.honor, options);
        $(".horon li").each(function (i) {
            if ((i + 1) % 4 == 0) {
                $(this).css("padding-right", "0");
            }
        });
    },
    //发展历程
    initCourse: function (options) {
        var ops = this.getNewObj(whir.course, options);
        $(".course .list li:odd").addClass("li");
    },
    //联系我们
    initContact: function (options) {
        var ops = this.getNewObj(whir.contact, options);

        $(".contact .table .span:odd").css("background-position", "left top");
        $(".contactmap .clear").click(function () {
            $(this).parent().css("z-index", "-99");
        });
        $(".contact_map").click(function () {
            var index = $('.contact .table').find('.contact_map').index($(this))
            $(".contactmap").css("z-index", "9999").children("ul").stop().animate({ left: -index * 796 }, 500);
        });

        if (ops.maps instanceof Array) {
            ops.showMaps(ops.maps);
        }
    },
    //万户新闻
    initNews: function (options) {
        var ops = this.getNewObj(whir.news, options);
        var city = (ops.city == "" ? "全国" : ops.city);
        $(".city").removeClass("onmenu");
        $("." + city).addClass("onmenu").removeClass("li");

        var cateName = ops.cateName;
        if (cateName == "业务动态") {
            $(".about_menu").show();
        }
    },
    initNewsInfo: function (options) {
        var ops = this.getNewObj(whir.news, options);
        $(".news_info .info_time span").click(function () {
            var datasize = $(this).attr("data-size");
            $(".news_info .info_txt").css("font-size", datasize + "px");
            $(".news_info .info_txt *").css("font-size", datasize + "px");
        })
    },
    //搜索结果
    initSeach: function (options) {
        var ops = this.getNewObj(whir.seach, options);
        $(".search .con1 .c .text .select").each(function () {
            $(this).find("span").click(function () {
                var _block = $(this).siblings("dl");
                if (_block.css("display") == "none") {
                    _block.show();
                } else {
                    _block.hide();
                }
            })
            $(this).find("a").click(function () {
                var _txt = $(this).text();
                $(this).parents("dl").hide().siblings("span").text(_txt);
            })
            $(this).mouseleave(function () {
                $(this).find("dl").hide();
            })
        });


        var type = whir.request.get("type");
        type = type == "" ? "news" : type;
        $("[name='type']").removeClass("onmenu").addClass("a");
        $("[val='" + type + "']").addClass("onmenu").removeClass("a");

        var keyword = decodeURIComponent(whir.request.get("title"));
        $(".searchKeyword").val(keyword);

        $("[name='type']").click(function () {
            var val = $(this).attr("val");
            var url = whir.request.appendUrlArg("type", val);
            window.location = url;
        });

        $(".btn").click(function () {
            Search();
        });

        $(".searchKeyword").bind("keydown", function (e) {
            if (e.which == 13) {
                Search();
            }
        });

        $(".btnGoPage").click(function (e) {
            var page = $(this).prev().val();
            if (/\d+/.test(page)) {
                page = parseInt(page) > 0 ? parseInt(page) : 1;
                window.location = whir.request.appendUrlArg("page", page);
            } else {
                $(this).prev().val("").focus();
                alert("请输入正确的数字！");
                e.preventDefault();
            }
        });
    },
    //万户员工
    initStaff: function (options) {
        var ops = this.getNewObj(whir.staff, options);

        //公司活动
        $(".Company_Activities_content .TabList .List ul li").eq(0).addClass("on");
        $(".Company_Activities_content .BanList ul li").eq(0).show();
        $(".Company_Activities_content .TabList .List ul li").each(function (i) {
            $(this).hover(function () {
                $(this).siblings("li").removeClass("on");
                $(this).addClass("on");
                $(".Company_Activities_content .BanList ul li").eq(i).siblings("li").hide();
                $(".Company_Activities_content .BanList ul li").eq(i).show();
            });
        });

        //文体活动
        jQuery(".Sports_activities .cont").slide({ mainCell: ".BanList ul", titCell: ".TabList li", effect: "left", autoPlay: true, mouseOverStop: false });

        //年会视频
        jQuery(".Annual_Video .videolist").slide({ mainCell: ".TabList ul", autoPage: true, effect: "top", autoPlay: false, vis: 3 });

        //办公室生活、室外生活
        //tab切换
        $(".divlife .divlife_tab a").eq(0).addClass("on");
        $(".divlife .box").eq(0).show();
        $(".divlife .divlife_tab a").each(function (i) {
            $(this).click(function () {
                $(this).siblings("a").removeClass("on");
                $(this).addClass("on");
                $(".divlife .box").eq(i).siblings(".box").hide();
                $(".divlife .box").eq(i).show();
            });
        });

        //box
        $(".divlife  .divlife_Content .box").each(function (index, element) {
            $(this).find("ul li:last").css("margin-right", "0");
        });

        //样式
        $(".Recruitment_content ul li:last .p").css("border-bottom", "0");
        $(".divlife .divlife_tab a").eq(0).css("border-right", "0");
    },
    //人才招聘
    initTakeJob: function (options) {
        var ops = this.getNewObj(whir.takeJob, options);
        //banner切换
        jQuery(".banner_Recruitment").slide({ mainCell: ".BanList ul", effect: "fold", autoPlay: true, interTime: 2000 });

        //招贤纳士
        $(".divRecruitment .divRecruitment_content ul li:even").css("background-color", "#f9f9f9");
        $(".divRecruitment .divRecruitment_content ul li:first").css("background-color", "#78bdf6");
        //滚动条
        if ($(".divRecruitment_content .jobsList ul li").length > 10) {
            new TouchScroll({ id: 'wrapper', 'width': 5, 'opacity': 0.7, color: '#555', minLength: 20 });
        }
        new TouchScroll({ id: 'div_cont', 'width': 5, 'opacity': 0.7, color: '#555', minLength: 20 });

        //弹窗
        $(".divRecruitment .divRecruitment_content #wrapper ul li").each(function (index, element) {
            var li = $(this);
            li.click(function () {
                var pop = $(".div_To");
                pop.height($(document.body).height());
                pop.find("[name='Title']").text(li.find("[name='Title']").text());
                pop.find("[name='BeginDate']").text(li.find("[name='BeginDate']").text());
                pop.find("[name='EndDate']").text(li.find("[name='EndDate']").text());
                pop.find("[name='PersonCount']").text(li.find("[name='PersonCount']").text());
                pop.find("[name='Place']").text(li.find("[name='Place']").text());
                pop.find("[name='Content']").find(".touchscrollelement").html(li.find("[name='Content']").html());
                pop.find("[name='LinkUrl']").attr("href", li.find("[name='LinkUrl']").text());

                pop.css("z-index", "99");
            });
        });

        $(".div_To .close").click(function () {
            $(".div_To").css("z-index", "-999").height(0);
        });

        //应聘地址
        $(".Candidates_Address .Candidates_Address_content .TabList ul li").eq(0).addClass("on");
        $(".Candidates_Address .Candidates_Address_content .BanList .box").eq(0).css("left", "0");

        $(".Candidates_Address .Candidates_Address_content .TabList ul li").each(function (i) {
            $(this).find(".span").click(function () {
                $(this).parent("li").siblings("li").removeClass("on");
                $(this).parent("li").addClass("on");
                $(".Candidates_Address .Candidates_Address_content .BanList .box").eq(i).siblings(".box").css("left", "-760px");
                $(".Candidates_Address .Candidates_Address_content .BanList .box").eq(i).css("left", "0");
            });
        });

        //员工福利
        $(".Employee_benefits .Employee_benefits_content ul").each(function (index, element) {
            $(this).find("li:first").addClass("on");
            $(this).find("li:last").css("margin-right", "0");


            $(this).find("li").each(function (index, element) {
                $(this).hover(function () {
                    $(this).siblings("li").removeClass("on");
                    $(this).addClass("on");
                });
            });
        });


        whir.contact.showMaps(ops.maps);
    },
    //首页
    initIndex: function (options) {
        var ops = this.getNewObj(whir.index, options);
        ops.weClient();
        ops.weService();
        ops.banner();
        ops.weNews();
        ops.weContact();
    }
}

