// Copyright 2006 Google Inc.

//   http://www.apache.org/licenses/LICENSE-2.0

/*!
 * ZRender, a lightweight canvas library with a MVC architecture, data-driven 
 * and provides an event model like DOM.
 *  
 * Copyright (c) 2013, Baidu Inc.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with or 
 * without modification, are permitted provided that the following conditions 
 * are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Baidu Inc. nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific 
 * prior written permission of Baidu Inc.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*!
 * ECharts, a javascript interactive chart library.
 *  
 * Copyright (c) 2013, Baidu Inc.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with or 
 * without modification, are permitted provided that the following conditions 
 * are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Baidu Inc. nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific 
 * prior written permission of Baidu Inc.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

define("echarts/config",[],function(){var e={CHART_TYPE_LINE:"line",CHART_TYPE_BAR:"bar",CHART_TYPE_SCATTER:"scatter",CHART_TYPE_PIE:"pie",CHART_TYPE_RADAR:"radar",CHART_TYPE_MAP:"map",CHART_TYPE_K:"k",CHART_TYPE_ISLAND:"island",CHART_TYPE_FORCE:"force",COMPONENT_TYPE_TITLE:"title",COMPONENT_TYPE_LEGEND:"legend",COMPONENT_TYPE_DATARANGE:"dataRange",COMPONENT_TYPE_DATAVIEW:"dataView",COMPONENT_TYPE_DATAZOOM:"dataZoom",COMPONENT_TYPE_TOOLBOX:"toolbox",COMPONENT_TYPE_TOOLTIP:"tooltip",COMPONENT_TYPE_GRID:"grid",COMPONENT_TYPE_AXIS:"axis",COMPONENT_TYPE_X_AXIS:"xAxis",COMPONENT_TYPE_Y_AXIS:"yAxis",COMPONENT_TYPE_AXIS_CATEGORY:"categoryAxis",COMPONENT_TYPE_AXIS_VALUE:"valueAxis",color:["#ff7f50","#87cefa","#da70d6","#32cd32","#6495ed","#ff69b4","#ba55d3","#cd5c5c","#ffa500","#40e0d0","#1e90ff","#ff6347","#7b68ee","#00fa9a","#ffd700","#6b8e23","#ff00ff","#3cb371","#b8860b","#30e0e0"],title:{text:"",subtext:"",x:"left",y:"top",backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,textStyle:{fontSize:18,fontWeight:"bolder",color:"#333"},subtextStyle:{color:"#aaa"}},legend:{orient:"horizontal",x:"center",y:"top",selectedMode:!0,backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,itemWidth:20,itemHeight:14,textStyle:{color:"#333"}},dataRange:{orient:"vertical",x:"left",y:"bottom",backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,itemWidth:20,itemHeight:14,precision:0,splitNumber:5,calculable:!1,realtime:!0,color:["#1e90ff","#f0ffff"],textStyle:{color:"#333"}},toolbox:{show:!1,orient:"horizontal",x:"right",y:"top",color:["#1e90ff","#22bb22","#4b0082","#d2691e"],backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,itemSize:16,feature:{}},tooltip:{show:!0,trigger:"item",islandFormatter:"{a} <br/>{b} : {c}",transitionDuration:1,showDelay:30,hideDelay:100,backgroundColor:"rgba(0,0,0,0.7)",borderColor:"#333",borderRadius:4,borderWidth:0,padding:5,axisPointer:{type:"line",lineStyle:{color:"#48b",width:2,type:"solid"},areaStyle:{size:"auto",color:"rgba(150,150,150,0.3)"}},textStyle:{color:"#fff"}},dataZoom:{show:!1,realtime:!1,orient:"horizontal",backgroundColor:"#eee",dataBackgroundColor:"#ccc",fillerColor:"rgba(50,205,50,0.4)",handleColor:"rgba(70,130,180,0.8)"},grid:{x:80,y:60,backgroundColor:"#fff",borderWidth:1,borderColor:"#ccc"},categoryAxis:{position:"bottom",name:"",nameLocation:"end",boundaryGap:!0,axisLine:{show:!0,lineStyle:{color:"#48b",width:2,type:"solid"}},axisTick:{show:!1,length:4,lineStyle:{color:"#ccc",width:1}},axisLabel:{show:!0,interval:"auto",rotate:0,margin:8,textStyle:{color:"#333"}},splitLine:{show:!0,lineStyle:{color:["#ccc"],width:1,type:"solid"}},splitArea:{show:!1,areaStyle:{color:["rgba(250,250,250,0.3)","rgba(200,200,200,0.3)"],type:"default"}}},valueAxis:{position:"left",name:"",nameLocation:"end",boundaryGap:[0,0],precision:0,power:100,splitNumber:5,axisLine:{show:!0,lineStyle:{color:"#48b",width:2,type:"solid"}},axisTick:{show:!1,length:4,lineStyle:{color:"#ccc",width:1}},axisLabel:{show:!0,rotate:0,margin:8,textStyle:{color:"#333"}},splitLine:{show:!0,lineStyle:{color:["#ccc"],width:1,type:"solid"}},splitArea:{show:!1,areaStyle:{color:["rgba(250,250,250,0.3)","rgba(200,200,200,0.3)"],type:"default"}}},bar:{xAxisIndex:0,yAxisIndex:0,barMinHeight:20},line:{xAxisIndex:0,yAxisIndex:0,itemStyle:{normal:{lineStyle:{width:1,type:"solid",shadowColor:"rgba(0,0,0,0)",shadowBlur:5,shadowOffsetX:3,shadowOffsetY:3}},emphasis:{}},symbolSize:4},k:{xAxisIndex:0,yAxisIndex:0,itemStyle:{normal:{color:"#fff",color0:"#00aa11",lineStyle:{width:1,color:"#ff3200",color0:"#00aa11"}},emphasis:{}}},scatter:{xAxisIndex:0,yAxisIndex:0,symbolSize:4,large:!1,largeThreshold:2e3},pie:{startAngle:90,minAngle:5,selectedOffset:10,itemStyle:{normal:{label:{show:!0,position:"outer"},labelLine:{show:!0,length:30,lineStyle:{width:1,type:"solid"}}},emphasis:{label:{show:!1,position:"outer"},labelLine:{show:!1,length:40,lineStyle:{width:1,type:"solid"}}}}},map:{mapType:"china",mapLocation:{x:"center",y:"center"},itemStyle:{normal:{lineStyle:{width:2,color:"#fff"},areaStyle:{color:"#ccc"},label:{show:!1,textStyle:{color:"rgba(139,69,19,1)"}}},emphasis:{lineStyle:{width:2,color:"#fff"},areaStyle:{color:"rgba(255,215,0,0.8)"},label:{show:!1,textStyle:{color:"rgba(139,69,19,1)"}}}}},force:{minRadius:10,maxRadius:20,density:1,attractiveness:1,initSize:300,centripetal:1,coolDown:.99,categories:[],itemStyle:{normal:{label:{show:!1},nodeStyle:{brushType:"both",color:"#f08c2e",strokeColor:"#5182ab"},linkStyle:{strokeColor:"#5182ab"}},emphasis:{label:{show:!1},nodeStyle:{},linkStyle:{}}}},island:{r:15,calculateStep:.1},textStyle:{decoration:"none",fontFamily:"Arial, Verdana, sans-serif",fontSize:12,fontStyle:"normal",fontWeight:"normal"},EVENT:{REFRESH:"refresh",RESTORE:"restore",CLICK:"click",HOVER:"hover",MOUSEWHEEL:"mousewheel",DATA_CHANGED:"dataChanged",DATA_ZOOM:"dataZoom",DATA_RANGE:"dataRange",LEGEND_SELECTED:"legendSelected",MAP_SELECTED:"mapSelected",PIE_SELECTED:"pieSelected",MAGIC_TYPE_CHANGED:"magicTypeChanged",DATA_VIEW_CHANGED:"dataViewChanged"},calculable:!1,calculableColor:"rgba(255,165,0,0.6)",calculableHolderColor:"#ccc",nameConnector:" & ",valueConnector:" : ",animation:!0,animationDuration:2e3,animationEasing:"ExponentialOut"};return e}),define("zrender/tool/vector",[],function(){var e={add:function(e,t,n){return e[0]=t[0]+n[0],e[1]=t[1]+n[1],e},sub:function(e,t,n){return e[0]=t[0]-n[0],e[1]=t[1]-n[1],e},length:function(e){return Math.sqrt(this.lengthSquare(e))},lengthSquare:function(e){return e[0]*e[0]+e[1]*e[1]},mul:function(e,t,n){return e[0]=t[0]*n[0],e[1]=t[1]*n[1],e},dot:function(e,t){return e[0]*t[0]+e[1]*t[1]},scale:function(e,t,n){return e[0]=t[0]*n,e[1]=t[1]*n,e},normalize:function(t,n){var r=e.length(n);return r===0?(t[0]=0,t[1]=0):(t[0]=n[0]/r,t[1]=n[1]/r),t},distance:function(t,n){var r=[];return e.length(e.sub(r,t,n))},middle:function(e,t,n){return e[0]=(t[0]+n[0])/2,e[1]=(t[1]+n[1])/2,e}};return e}),define("zrender/lib/excanvas",["require"],function(e){return document.createElement("canvas").getContext?G_vmlCanvasManager=!1:function(){function f(){return this.context_||(this.context_=new I(this))}function c(e,t,n){var r=l.call(arguments,2);return function(){return e.apply(t,r.concat(l.call(arguments)))}}function h(e){return String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;")}function p(e,t,n){e.namespaces[t]||e.namespaces.add(t,n,"#default#VML")}function d(e){p(e,"g_vml_","urn:schemas-microsoft-com:vml"),p(e,"g_o_","urn:schemas-microsoft-com:office:office");if(!e.styleSheets.ex_canvas_){var t=e.createStyleSheet();t.owningElement.id="ex_canvas_",t.cssText="canvas{display:inline-block;overflow:hidden;text-align:left;width:300px;height:150px}"}}function m(e){var t=e.srcElement;switch(e.propertyName){case"width":t.getContext().clearRect(),t.style.width=t.attributes.width.nodeValue+"px",t.firstChild.style.width=t.clientWidth+"px";break;case"height":t.getContext().clearRect(),t.style.height=t.attributes.height.nodeValue+"px",t.firstChild.style.height=t.clientHeight+"px"}}function g(e){var t=e.srcElement;t.firstChild&&(t.firstChild.style.width=t.clientWidth+"px",t.firstChild.style.height=t.clientHeight+"px")}function E(){return[[1,0,0],[0,1,0],[0,0,1]]}function S(e,t){var n=E();for(var r=0;r<3;r++)for(var i=0;i<3;i++){var s=0;for(var o=0;o<3;o++)s+=e[r][o]*t[o][i];n[r][i]=s}return n}function x(e,t){t.fillStyle=e.fillStyle,t.lineCap=e.lineCap,t.lineJoin=e.lineJoin,t.lineWidth=e.lineWidth,t.miterLimit=e.miterLimit,t.shadowBlur=e.shadowBlur,t.shadowColor=e.shadowColor,t.shadowOffsetX=e.shadowOffsetX,t.shadowOffsetY=e.shadowOffsetY,t.strokeStyle=e.strokeStyle,t.globalAlpha=e.globalAlpha,t.font=e.font,t.textAlign=e.textAlign,t.textBaseline=e.textBaseline,t.arcScaleX_=e.arcScaleX_,t.arcScaleY_=e.arcScaleY_,t.lineScale_=e.lineScale_}function N(e){var t=e.indexOf("(",3),n=e.indexOf(")",t+1),r=e.substring(t+1,n).split(",");if(r.length!=4||e.charAt(3)!="a")r[3]=1;return r}function C(e){return parseFloat(e)/100}function k(e,t,n){return Math.min(n,Math.max(t,e))}function L(e){var t,n,r,i,s,o;i=parseFloat(e[0])/360%360,i<0&&i++,s=k(C(e[1]),0,1),o=k(C(e[2]),0,1);if(s==0)t=n=r=o;else{var u=o<.5?o*(1+s):o+s-o*s,a=2*o-u;t=A(a,u,i+1/3),n=A(a,u,i),r=A(a,u,i-1/3)}return"#"+y[Math.floor(t*255)]+y[Math.floor(n*255)]+y[Math.floor(r*255)]}function A(e,t,n){return n<0&&n++,n>1&&n--,6*n<1?e+(t-e)*6*n:2*n<1?t:3*n<2?e+(t-e)*(2/3-n)*6:e}function M(e){if(e in O)return O[e];var t,n=1;e=String(e);if(e.charAt(0)=="#")t=e;else if(/^rgb/.test(e)){var r=N(e),t="#",i;for(var s=0;s<3;s++)r[s].indexOf("%")!=-1?i=Math.floor(C(r[s])*255):i=+r[s],t+=y[k(i,0,255)];n=+r[3]}else if(/^hsl/.test(e)){var r=N(e);t=L(r),n=r[3]}else t=T[e]||e;return O[e]={color:t,alpha:n}}function P(e){if(D[e])return D[e];var t=document.createElement("div"),n=t.style;try{n.font=e}catch(r){}return D[e]={style:n.fontStyle||_.style,variant:n.fontVariant||_.variant,weight:n.fontWeight||_.weight,size:n.fontSize||_.size,family:n.fontFamily||_.family}}function H(e,t){var n={};for(var r in e)n[r]=e[r];var i=parseFloat(t.currentStyle.fontSize),s=parseFloat(e.size);return typeof e.size=="number"?n.size=e.size:e.size.indexOf("px")!=-1?n.size=s:e.size.indexOf("em")!=-1?n.size=i*s:e.size.indexOf("%")!=-1?n.size=i/100*s:e.size.indexOf("pt")!=-1?n.size=s/.75:n.size=i,n.size*=.981,n}function B(e){return e.style+" "+e.variant+" "+e.weight+" "+e.size+"px "+e.family}function F(e){return j[e]||"square"}function I(e){this.m_=E(),this.mStack_=[],this.aStack_=[],this.currentPath_=[],this.strokeStyle="#000",this.fillStyle="#000",this.lineWidth=1,this.lineJoin="miter",this.lineCap="butt",this.miterLimit=o*1,this.globalAlpha=1,this.font="10px sans-serif",this.textAlign="left",this.textBaseline="alphabetic",this.canvas=e;var t="width:"+e.clientWidth+"px;height:"+e.clientHeight+"px;overflow:hidden;position:absolute",n=e.ownerDocument.createElement("div");n.style.cssText=t,e.appendChild(n);var r=n.cloneNode(!1);r.style.backgroundColor="red",r.style.filter="alpha(opacity=0)",e.appendChild(r),this.element_=n,this.arcScaleX_=1,this.arcScaleY_=1,this.lineScale_=1}function R(e,t,n,r){e.currentPath_.push({type:"bezierCurveTo",cp1x:t.x,cp1y:t.y,cp2x:n.x,cp2y:n.y,x:r.x,y:r.y}),e.currentX_=r.x,e.currentY_=r.y}function U(e,t){var n=M(e.strokeStyle),r=n.color,i=n.alpha*e.globalAlpha,s=e.lineScale_*e.lineWidth;s<1&&(i*=s),t.push("<g_vml_:stroke",' opacity="',i,'"',' joinstyle="',e.lineJoin,'"',' miterlimit="',e.miterLimit,'"',' endcap="',F(e.lineCap),'"',' weight="',s,'px"',' color="',r,'" />')}function z(t,n,r,i){var s=t.fillStyle,u=t.arcScaleX_,a=t.arcScaleY_,f=i.x-r.x,l=i.y-r.y;if(s instanceof $){var c=0,h={x:0,y:0},p=0,d=1;if(s.type_=="gradient"){var v=s.x0_/u,m=s.y0_/a,g=s.x1_/u,y=s.y1_/a,b=W(t,v,m),w=W(t,g,y),E=w.x-b.x,S=w.y-b.y;c=Math.atan2(E,S)*180/Math.PI,c<0&&(c+=360),c<1e-6&&(c=0)}else{var b=W(t,s.x0_,s.y0_);h={x:(b.x-r.x)/f,y:(b.y-r.y)/l},f/=u*o,l/=a*o;var x=e.max(f,l);p=2*s.r0_/x,d=2*s.r1_/x-p}var T=s.colors_;T.sort(function(e,t){return e.offset-t.offset});var N=T.length,C=T[0].color,k=T[N-1].color,L=T[0].alpha*t.globalAlpha,A=T[N-1].alpha*t.globalAlpha,O=[];for(var _=0;_<N;_++){var D=T[_];O.push(D.offset*d+p+" "+D.color)}n.push('<g_vml_:fill type="',s.type_,'"',' method="none" focus="100%"',' color="',C,'"',' color2="',k,'"',' colors="',O.join(","),'"',' opacity="',A,'"',' g_o_:opacity2="',L,'"',' angle="',c,'"',' focusposition="',h.x,",",h.y,'" />')}else if(s instanceof J){if(f&&l){var P=-r.x,H=-r.y;n.push("<g_vml_:fill",' position="',P/f*u*u,",",H/l*a*a,'"',' type="tile"',' src="',s.src_,'" />')}}else{var B=M(t.fillStyle),j=B.color,F=B.alpha*t.globalAlpha;n.push('<g_vml_:fill color="',j,'" opacity="',F,'" />')}}function W(e,t,n){var r=e.m_;return{x:o*(t*r[0][0]+n*r[1][0]+r[2][0])-u,y:o*(t*r[0][1]+n*r[1][1]+r[2][1])-u}}function X(e){return isFinite(e[0][0])&&isFinite(e[0][1])&&isFinite(e[1][0])&&isFinite(e[1][1])&&isFinite(e[2][0])&&isFinite(e[2][1])}function V(e,t,n){if(!X(t))return;e.m_=t;if(n){var r=t[0][0]*t[1][1]-t[0][1]*t[1][0];e.lineScale_=s(i(r))}}function $(e){this.type_=e,this.x0_=0,this.y0_=0,this.r0_=0,this.x1_=0,this.y1_=0,this.r1_=0,this.colors_=[]}function J(e,t){Q(e);switch(t){case"repeat":case null:case"":this.repetition_="repeat";break;case"repeat-x":case"repeat-y":case"no-repeat":this.repetition_=t;break;default:K("SYNTAX_ERR")}this.src_=e.src,this.width_=e.width,this.height_=e.height}function K(e){throw new G(e)}function Q(e){(!e||e.nodeType!=1||e.tagName!="IMG")&&K("TYPE_MISMATCH_ERR"),e.readyState!="complete"&&K("INVALID_STATE_ERR")}function G(e){this.code=this[e],this.message=e+": DOM Exception "+this.code}var e=Math,t=e.round,n=e.sin,r=e.cos,i=e.abs,s=e.sqrt,o=10,u=o/2,a=+navigator.userAgent.match(/MSIE ([\d.]+)?/)[1],l=Array.prototype.slice;d(document);var v={init:function(e){var t=e||document;t.createElement("canvas"),t.attachEvent("onreadystatechange",c(this.init_,this,t))},init_:function(e){var t=e.getElementsByTagName("canvas");for(var n=0;n<t.length;n++)this.initElement(t[n])},initElement:function(e){if(!e.getContext){e.getContext=f,d(e.ownerDocument),e.innerHTML="",e.attachEvent("onpropertychange",m),e.attachEvent("onresize",g);var t=e.attributes;t.width&&t.width.specified?e.style.width=t.width.nodeValue+"px":e.width=e.clientWidth,t.height&&t.height.specified?e.style.height=t.height.nodeValue+"px":e.height=e.clientHeight}return e}};v.init();var y=[];for(var b=0;b<16;b++)for(var w=0;w<16;w++)y[b*16+w]=b.toString(16)+w.toString(16);var T={aliceblue:"#F0F8FF",antiquewhite:"#FAEBD7",aquamarine:"#7FFFD4",azure:"#F0FFFF",beige:"#F5F5DC",bisque:"#FFE4C4",black:"#000000",blanchedalmond:"#FFEBCD",blueviolet:"#8A2BE2",brown:"#A52A2A",burlywood:"#DEB887",cadetblue:"#5F9EA0",chartreuse:"#7FFF00",chocolate:"#D2691E",coral:"#FF7F50",cornflowerblue:"#6495ED",cornsilk:"#FFF8DC",crimson:"#DC143C",cyan:"#00FFFF",darkblue:"#00008B",darkcyan:"#008B8B",darkgoldenrod:"#B8860B",darkgray:"#A9A9A9",darkgreen:"#006400",darkgrey:"#A9A9A9",darkkhaki:"#BDB76B",darkmagenta:"#8B008B",darkolivegreen:"#556B2F",darkorange:"#FF8C00",darkorchid:"#9932CC",darkred:"#8B0000",darksalmon:"#E9967A",darkseagreen:"#8FBC8F",darkslateblue:"#483D8B",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",darkturquoise:"#00CED1",darkviolet:"#9400D3",deeppink:"#FF1493",deepskyblue:"#00BFFF",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1E90FF",firebrick:"#B22222",floralwhite:"#FFFAF0",forestgreen:"#228B22",gainsboro:"#DCDCDC",ghostwhite:"#F8F8FF",gold:"#FFD700",goldenrod:"#DAA520",grey:"#808080",greenyellow:"#ADFF2F",honeydew:"#F0FFF0",hotpink:"#FF69B4",indianred:"#CD5C5C",indigo:"#4B0082",ivory:"#FFFFF0",khaki:"#F0E68C",lavender:"#E6E6FA",lavenderblush:"#FFF0F5",lawngreen:"#7CFC00",lemonchiffon:"#FFFACD",lightblue:"#ADD8E6",lightcoral:"#F08080",lightcyan:"#E0FFFF",lightgoldenrodyellow:"#FAFAD2",lightgreen:"#90EE90",lightgrey:"#D3D3D3",lightpink:"#FFB6C1",lightsalmon:"#FFA07A",lightseagreen:"#20B2AA",lightskyblue:"#87CEFA",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#B0C4DE",lightyellow:"#FFFFE0",limegreen:"#32CD32",linen:"#FAF0E6",magenta:"#FF00FF",mediumaquamarine:"#66CDAA",mediumblue:"#0000CD",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",mediumseagreen:"#3CB371",mediumslateblue:"#7B68EE",mediumspringgreen:"#00FA9A",mediumturquoise:"#48D1CC",mediumvioletred:"#C71585",midnightblue:"#191970",mintcream:"#F5FFFA",mistyrose:"#FFE4E1",moccasin:"#FFE4B5",navajowhite:"#FFDEAD",oldlace:"#FDF5E6",olivedrab:"#6B8E23",orange:"#FFA500",orangered:"#FF4500",orchid:"#DA70D6",palegoldenrod:"#EEE8AA",palegreen:"#98FB98",paleturquoise:"#AFEEEE",palevioletred:"#DB7093",papayawhip:"#FFEFD5",peachpuff:"#FFDAB9",peru:"#CD853F",pink:"#FFC0CB",plum:"#DDA0DD",powderblue:"#B0E0E6",rosybrown:"#BC8F8F",royalblue:"#4169E1",saddlebrown:"#8B4513",salmon:"#FA8072",sandybrown:"#F4A460",seagreen:"#2E8B57",seashell:"#FFF5EE",sienna:"#A0522D",skyblue:"#87CEEB",slateblue:"#6A5ACD",slategray:"#708090",slategrey:"#708090",snow:"#FFFAFA",springgreen:"#00FF7F",steelblue:"#4682B4",tan:"#D2B48C",thistle:"#D8BFD8",tomato:"#FF6347",turquoise:"#40E0D0",violet:"#EE82EE",wheat:"#F5DEB3",whitesmoke:"#F5F5F5",yellowgreen:"#9ACD32"},O={},_={style:"normal",variant:"normal",weight:"normal",size:10,family:"sans-serif"},D={},j={butt:"flat",round:"round"},q=I.prototype;q.clearRect=function(){this.textMeasureEl_&&(this.textMeasureEl_.removeNode(!0),this.textMeasureEl_=null),this.element_.innerHTML=""},q.beginPath=function(){this.currentPath_=[]},q.moveTo=function(e,t){var n=W(this,e,t);this.currentPath_.push({type:"moveTo",x:n.x,y:n.y}),this.currentX_=n.x,this.currentY_=n.y},q.lineTo=function(e,t){var n=W(this,e,t);this.currentPath_.push({type:"lineTo",x:n.x,y:n.y}),this.currentX_=n.x,this.currentY_=n.y},q.bezierCurveTo=function(e,t,n,r,i,s){var o=W(this,i,s),u=W(this,e,t),a=W(this,n,r);R(this,u,a,o)},q.quadraticCurveTo=function(e,t,n,r){var i=W(this,e,t),s=W(this,n,r),o={x:this.currentX_+2/3*(i.x-this.currentX_),y:this.currentY_+2/3*(i.y-this.currentY_)},u={x:o.x+(s.x-this.currentX_)/3,y:o.y+(s.y-this.currentY_)/3};R(this,o,u,s)},q.arc=function(e,t,i,s,a,f){i*=o;var l=f?"at":"wa",c=e+r(s)*i-u,h=t+n(s)*i-u,p=e+r(a)*i-u,d=t+n(a)*i-u;c==p&&!f&&(c+=.125);var v=W(this,e,t),m=W(this,c,h),g=W(this,p,d);this.currentPath_.push({type:l,x:v.x,y:v.y,radius:i,xStart:m.x,yStart:m.y,xEnd:g.x,yEnd:g.y})},q.rect=function(e,t,n,r){this.moveTo(e,t),this.lineTo(e+n,t),this.lineTo(e+n,t+r),this.lineTo(e,t+r),this.closePath()},q.strokeRect=function(e,t,n,r){var i=this.currentPath_;this.beginPath(),this.moveTo(e,t),this.lineTo(e+n,t),this.lineTo(e+n,t+r),this.lineTo(e,t+r),this.closePath(),this.stroke(),this.currentPath_=i},q.fillRect=function(e,t,n,r){var i=this.currentPath_;this.beginPath(),this.moveTo(e,t),this.lineTo(e+n,t),this.lineTo(e+n,t+r),this.lineTo(e,t+r),this.closePath(),this.fill(),this.currentPath_=i},q.createLinearGradient=function(e,t,n,r){var i=new $("gradient");return i.x0_=e,i.y0_=t,i.x1_=n,i.y1_=r,i},q.createRadialGradient=function(e,t,n,r,i,s){var o=new $("gradientradial");return o.x0_=e,o.y0_=t,o.r0_=n,o.x1_=r,o.y1_=i,o.r1_=s,o},q.drawImage=function(n,r){var i,s,u,a,f,l,c,h,p=n.runtimeStyle.width,d=n.runtimeStyle.height;n.runtimeStyle.width="auto",n.runtimeStyle.height="auto";var v=n.width,m=n.height;n.runtimeStyle.width=p,n.runtimeStyle.height=d;if(arguments.length==3)i=arguments[1],s=arguments[2],f=l=0,c=u=v,h=a=m;else if(arguments.length==5)i=arguments[1],s=arguments[2],u=arguments[3],a=arguments[4],f=l=0,c=v,h=m;else{if(arguments.length!=9)throw Error("Invalid number of arguments");f=arguments[1],l=arguments[2],c=arguments[3],h=arguments[4],i=arguments[5],s=arguments[6],u=arguments[7],a=arguments[8]}var g=W(this,i,s),y=c/2,b=h/2,w=[],E=10,S=10;w.push(" <g_vml_:group",' coordsize="',o*E,",",o*S,'"',' coordorigin="0,0"',' style="width:',E,"px;height:",S,"px;position:absolute;");if(this.m_[0][0]!=1||this.m_[0][1]||this.m_[1][1]!=1||this.m_[1][0]){var x=[];x.push("M11=",this.m_[0][0],",","M12=",this.m_[1][0],",","M21=",this.m_[0][1],",","M22=",this.m_[1][1],",","Dx=",t(g.x/o),",","Dy=",t(g.y/o),"");var T=g,N=W(this,i+u,s),C=W(this,i,s+a),k=W(this,i+u,s+a);T.x=e.max(T.x,N.x,C.x,k.x),T.y=e.max(T.y,N.y,C.y,k.y),w.push("padding:0 ",t(T.x/o),"px ",t(T.y/o),"px 0;filter:progid:DXImageTransform.Microsoft.Matrix(",x.join(""),", sizingmethod='clip');")}else w.push("top:",t(g.y/o),"px;left:",t(g.x/o),"px;");w.push(' ">','<g_vml_:image src="',n.src,'"',' style="width:',o*u,"px;"," height:",o*a,'px"',' cropleft="',f/v,'"',' croptop="',l/m,'"',' cropright="',(v-f-c)/v,'"',' cropbottom="',(m-l-h)/m,'"'," />","</g_vml_:group>"),this.element_.insertAdjacentHTML("BeforeEnd",w.join(""))},q.stroke=function(e){var n=[],r=!1,i=10,s=10;n.push("<g_vml_:shape",' filled="',!!e,'"',' style="position:absolute;width:',i,"px;height:",s,'px;"',' coordorigin="0,0"',' coordsize="',o*i,",",o*s,'"',' stroked="',!e,'"',' path="');var u=!1,a={x:null,y:null},f={x:null,y:null};for(var l=0;l<this.currentPath_.length;l++){var c=this.currentPath_[l],h;switch(c.type){case"moveTo":h=c,n.push(" m ",t(c.x),",",t(c.y));break;case"lineTo":n.push(" l ",t(c.x),",",t(c.y));break;case"close":n.push(" x "),c=null;break;case"bezierCurveTo":n.push(" c ",t(c.cp1x),",",t(c.cp1y),",",t(c.cp2x),",",t(c.cp2y),",",t(c.x),",",t(c.y));break;case"at":case"wa":n.push(" ",c.type," ",t(c.x-this.arcScaleX_*c.radius),",",t(c.y-this.arcScaleY_*c.radius)," ",t(c.x+this.arcScaleX_*c.radius),",",t(c.y+this.arcScaleY_*c.radius)," ",t(c.xStart),",",t(c.yStart)," ",t(c.xEnd),",",t(c.yEnd))}if(c){if(a.x==null||c.x<a.x)a.x=c.x;if(f.x==null||c.x>f.x)f.x=c.x;if(a.y==null||c.y<a.y)a.y=c.y;if(f.y==null||c.y>f.y)f.y=c.y}}n.push(' ">'),e?z(this,n,a,f):U(this,n),n.push("</g_vml_:shape>"),this.element_.insertAdjacentHTML("beforeEnd",n.join(""))},q.fill=function(){this.stroke(!0)},q.closePath=function(){this.currentPath_.push({type:"close"})},q.save=function(){var e={};x(this,e),this.aStack_.push(e),this.mStack_.push(this.m_),this.m_=S(E(),this.m_)},q.restore=function(){this.aStack_.length&&(x(this.aStack_.pop(),this),this.m_=this.mStack_.pop())},q.translate=function(e,t){var n=[[1,0,0],[0,1,0],[e,t,1]];V(this,S(n,this.m_),!1)},q.rotate=function(e){var t=r(e),i=n(e),s=[[t,i,0],[-i,t,0],[0,0,1]];V(this,S(s,this.m_),!1)},q.scale=function(e,t){this.arcScaleX_*=e,this.arcScaleY_*=t;var n=[[e,0,0],[0,t,0],[0,0,1]];V(this,S(n,this.m_),!0)},q.transform=function(e,t,n,r,i,s){var o=[[e,t,0],[n,r,0],[i,s,1]];V(this,S(o,this.m_),!0)},q.setTransform=function(e,t,n,r,i,s){var o=[[e,t,0],[n,r,0],[i,s,1]];V(this,o,!0)},q.drawText_=function(e,n,r,i,s){var u=this.m_,a=1e3,f=0,l=a,c={x:0,y:0},p=[],d=H(P(this.font),this.element_),v=B(d),m=this.element_.currentStyle,g=this.textAlign.toLowerCase();switch(g){case"left":case"center":case"right":break;case"end":g=m.direction=="ltr"?"right":"left";break;case"start":g=m.direction=="rtl"?"right":"left";break;default:g="left"}switch(this.textBaseline){case"hanging":case"top":c.y=d.size/1.75;break;case"middle":break;default:case null:case"alphabetic":case"ideographic":case"bottom":c.y=-d.size/2.25}switch(g){case"right":f=a,l=.05;break;case"center":f=l=a/2}var y=W(this,n+c.x,r+c.y);p.push('<g_vml_:line from="',-f,' 0" to="',l,' 0.05" ',' coordsize="100 100" coordorigin="0 0"',' filled="',!s,'" stroked="',!!s,'" style="position:absolute;width:1px;height:1px;">'),s?U(this,p):z(this,p,{x:-f,y:0},{x:l,y:d.size});var b=u[0][0].toFixed(3)+","+u[1][0].toFixed(3)+","+u[0][1].toFixed(3)+","+u[1][1].toFixed(3)+",0,0",w=t(y.x/o)+","+t(y.y/o);p.push('<g_vml_:skew on="t" matrix="',b,'" ',' offset="',w,'" origin="',f,' 0" />','<g_vml_:path textpathok="true" />','<g_vml_:textpath on="true" string="',h(e),'" style="v-text-align:',g,";font:",h(v),'" /></g_vml_:line>'),this.element_.insertAdjacentHTML("beforeEnd",p.join(""))},q.fillText=function(e,t,n,r){this.drawText_(e,t,n,r,!1)},q.strokeText=function(e,t,n,r){this.drawText_(e,t,n,r,!0)},q.measureText=function(e){if(!this.textMeasureEl_){var t='<span style="position:absolute;top:-20000px;left:0;padding:0;margin:0;border:none;white-space:pre;"></span>';this.element_.insertAdjacentHTML("beforeEnd",t),this.textMeasureEl_=this.element_.lastChild}var n=this.element_.ownerDocument;return this.textMeasureEl_.innerHTML="",this.textMeasureEl_.style.font=this.font,this.textMeasureEl_.appendChild(n.createTextNode(e)),{width:this.textMeasureEl_.offsetWidth}},q.clip=function(){},q.arcTo=function(){},q.createPattern=function(e,t){return new J(e,t)},$.prototype.addColorStop=function(e,t){t=M(t),this.colors_.push({offset:e,color:t.color,alpha:t.alpha})};var Y=G.prototype=new Error;Y.INDEX_SIZE_ERR=1,Y.DOMSTRING_SIZE_ERR=2,Y.HIERARCHY_REQUEST_ERR=3,Y.WRONG_DOCUMENT_ERR=4,Y.INVALID_CHARACTER_ERR=5,Y.NO_DATA_ALLOWED_ERR=6,Y.NO_MODIFICATION_ALLOWED_ERR=7,Y.NOT_FOUND_ERR=8,Y.NOT_SUPPORTED_ERR=9,Y.INUSE_ATTRIBUTE_ERR=10,Y.INVALID_STATE_ERR=11,Y.SYNTAX_ERR=12,Y.INVALID_MODIFICATION_ERR=13,Y.NAMESPACE_ERR=14,Y.INVALID_ACCESS_ERR=15,Y.VALIDATION_ERR=16,Y.TYPE_MISMATCH_ERR=17,G_vmlCanvasManager=v,CanvasRenderingContext2D=I,CanvasGradient=$,CanvasPattern=J,DOMException=G}(),G_vmlCanvasManager}),define("zrender/tool/util",["require","./vector","../lib/excanvas"],function(e){function n(e){var t={"[object Function]":1,"[object RegExp]":1,"[object Date]":1,"[object Error]":1,"[object CanvasGradient]":1},n=e,r,i;if(!e||e instanceof Number||e instanceof String||e instanceof Boolean)return n;if(e instanceof Array){n=[];var s=0;for(r=0,i=e.length;r<i;r++)n[s++]=this.clone(e[r])}else if("object"==typeof e){if(t[Object.prototype.toString.call(e)]||e.__nonRecursion)return n;n={};for(r in e)e.hasOwnProperty(r)&&(n[r]=this.clone(e[r]))}return n}function s(){if(!i){e("../lib/excanvas");if(G_vmlCanvasManager){var t=document.createElement("div");t.style.position="absolute",t.style.top="-1000px",document.body.appendChild(t),i=G_vmlCanvasManager.initElement(t).getContext("2d")}else i=document.createElement("canvas").getContext("2d")}return i}function h(){return u||(o=document.createElement("canvas"),a=o.width,f=o.height,u=o.getContext("2d")),u}function p(e,t){var n=100,r=!1;e+l>a&&(a=e+l+n,o.width=a,r=!0),t+c>f&&(f=t+c+n,o.height=f,r=!0),e<-l&&(l=Math.ceil(-e/n)*n,a+=l,o.width=a,r=!0),t<-c&&(c=Math.ceil(-t/n)*n,f+=c,o.height=f,r=!0),r&&u.translate(l,c)}function d(){return{x:l,y:c}}function v(e,t){if(e.indexOf)return e.indexOf(t);for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}function m(e,t,n){if(e.length===0)return;var r=e[0][0],i=e[0][0],s=e[0][1],o=e[0][1];for(var u=1;u<e.length;u++){var a=e[u];a[0]<r&&(r=a[0]),a[0]>i&&(i=a[0]),a[1]<s&&(s=a[1]),a[1]>o&&(o=a[1])}t[0]=r,t[1]=s,n[0]=i,n[1]=o}function g(e,t,n,r,i,s){var o=y(e[0],t[0],n[0],r[0]),u=y(e[1],t[1],n[1],r[1]);o.push(e[0],r[0]),u.push(e[1],r[1]);var a=Math.min.apply(null,o),f=Math.max.apply(null,o),l=Math.min.apply(null,u),c=Math.max.apply(null,u);i[0]=a,i[1]=l,s[0]=f,s[1]=c}function y(e,t,n,r){var i=[],s=6*n-12*t+6*e,o=9*t+3*r-3*e-9*n,u=3*t-3*e,a=s*s-4*o*u;if(a>0){var f=Math.sqrt(a),l=(-s+f)/(2*o),c=(-s-f)/(2*o);i.push(l,c)}else a===0&&i.push(-s/(2*o));var h=[];for(var p=0;p<i.length;p++){var d=i[p];if(Math.abs(2*o*d+s)>1e-4&&d<1&&d>0){var v=1-d,m=v*v*v*e+3*v*v*d*t+3*v*d*d*n+d*d*d*r;h.push(m)}}return h}function b(e,t,n,r,i){var s=e[0]+n[0]-2*t[0],o;s===0?o=.5:o=(e[0]-t[0])/s,s=e[1]+n[1]-2*t[1];var u;s===0?u=.5:u=(e[1]-t[1])/s,o=Math.max(Math.min(o,1),0),u=Math.max(Math.min(u,1),0);var a=1-o,f=1-u,l=a*a*e[0]+2*a*o*t[0]+o*o*n[0],c=a*a*e[1]+2*a*o*t[1]+o*o*n[1],h=f*f*e[0]+2*f*u*t[0]+u*u*n[0],p=f*f*e[1]+2*f*u*t[1]+u*u*n[1];return m([e.slice(),n.slice(),[l,c],[h,p]],r,i)}var t=e("./vector"),r=function(){function t(t,n,i,s,o){if(n.hasOwnProperty(i))if(o&&typeof t[i]=="object"&&e[Object.prototype.toString.call(t[i])]!=1)r(t[i],n[i],{overwrite:s,recursive:o});else if(s||!(i in t))t[i]=n[i]}var e={"[object Function]":1,"[object RegExp]":1,"[object Date]":1,"[object Error]":1,"[object CanvasGradient]":1};return function(e,n,r){var i=0,s=r||{},o=s.overwrite,u=s.whiteList,a=s.recursive,f;if(u&&u.length){f=u.length;for(;i<f;++i)t(e,n,u[i],o,a)}else for(i in n)t(e,n,i,o,a);return e}}(),i,o,u,a,f,l=0,c=0,w=function(){var e=[],n=[],r=[[],[],[],[]];return function(i,s,o,u,a,f,l){a=a?1:-1,e[0]=Math.cos(o),e[1]=Math.sin(o)*a,t.scale(e,e,s),t.add(e,e,i),n[0]=Math.cos(u),n[1]=Math.sin(u)*a,t.scale(n,n,s),t.add(n,n,i),o%=Math.PI*2,o<0&&(o+=Math.PI*2),u%=Math.PI*2,u<0&&(u+=Math.PI*2),o>u&&(u+=Math.PI*2);var c=0;for(var h=0;h<u;h+=Math.PI/2)if(h>o){var p=r[c++];p[0]=Math.cos(h),p[1]=Math.sin(h)*a,t.scale(p,p,s),t.add(p,p,i)}var d=r.slice(0,c);d.push(e,n),m(d,f,l)}}();return{clone:n,merge:r,getContext:s,getPixelContext:h,getPixelOffset:d,adjustCanvasSize:p,computeBoundingBox:m,computeCubeBezierBoundingBox:g,computeQuadraticBezierBoundingBox:b,computeArcBoundingBox:w,indexOf:v}}),define("echarts/component/base",["require","../config","zrender/tool/util"],function(e){function t(t){function s(e){e=e||i.type+"";switch(e){case n.COMPONENT_TYPE_GRID:case n.COMPONENT_TYPE_AXIS_CATEGORY:case n.COMPONENT_TYPE_AXIS_VALUE:return 0;case n.CHART_TYPE_LINE:case n.CHART_TYPE_BAR:case n.CHART_TYPE_SCATTER:case n.CHART_TYPE_PIE:case n.CHART_TYPE_RADAR:case n.CHART_TYPE_MAP:case n.CHART_TYPE_K:return 2;case n.COMPONENT_TYPE_LEGEND:case n.COMPONENT_TYPE_DATARANGE:case n.COMPONENT_TYPE_DATAZOOM:return 4;case n.CHART_TYPE_ISLAND:return 5;case n.COMPONENT_TYPE_TOOLTIP:case n.COMPONENT_TYPE_TOOLBOX:case n.COMPONENT_TYPE_TITLE:return 6;default:return 0}}function o(e){return r.merge(e||{},n[i.type]||{},{overwrite:!1,recursive:!0})}function u(e){if(!(e instanceof Array))return[e,e,e,e];switch(e.length+""){case"4":return e;case"3":return[e[0],e[1],e[2],e[1]];case"2":return[e[0],e[1],e[0],e[1]];case"1":return[e[0],e[0],e[0],e[0]];case"0":return[0,0,0,0]}}function f(e){var t=r.merge(r.clone(e)||{},n.textStyle,{overwrite:!1});return t.fontStyle+" "+t.fontWeight+" "+t.fontSize+"px "+t.fontFamily}function l(){for(var e=0,t=i.shapeList.length;e<t;e++)i.zr.delShape(i.shapeList[e].id);i.shapeList=[]}function c(){i.clear(),i.shapeList=null,i=null}var n=e("../config"),r=e("zrender/tool/util"),i=this;i.zr=t,i.shapeList=[];var a=function(){function e(e,t){if(typeof e=="undefined")return undefined;if(!t)return e;t=t.split(".");var n=t.length,r=0;while(r<n){e=e[t[r]];if(typeof e=="undefined")return undefined;r++}return e}return function(t,n){var r;for(var i=0,s=t.length;i<s;i++){r=e(t[i],n);if(typeof r!="undefined")return r}return undefined}}();i.getZlevelBase=s,i.reformOption=o,i.reformCssArray=u,i.deepQuery=a,i.getFont=f,i.clear=l,i.dispose=c}return t}),define("echarts/util/ecData",[],function(){function e(e,t,n,r,i,s,o){var u;return typeof r!="undefined"&&(typeof r.value!="undefined"?r.value instanceof Array?u=r.value[2]:u=r.value:u=r),e._echartsData={_series:t,_seriesIndex:n,_data:r,_dataIndex:i,_name:s,_value:u,_special:o},e._echartsData}function t(e,t){var n=e._echartsData;if(!t)return n;switch(t){case"series":return n&&n._series;case"seriesIndex":return n&&n._seriesIndex;case"data":return n&&n._data;case"dataIndex":return n&&n._dataIndex;case"name":return n&&n._name;case"value":return n&&n._value;case"special":return n&&n._special}return null}function n(e,t,n){e._echartsData=e._echartsData||{};switch(t){case"series":e._echartsData._series=n;break;case"seriesIndex":e._echartsData._seriesIndex=n;break;case"data":e._echartsData._data=n;break;case"dataIndex":e._echartsData._dataIndex=n;break;case"name":e._echartsData._name=n;break;case"value":e._echartsData._value=n;break;case"special":e._echartsData._special=n}}return{pack:e,set:n,get:t}}),define("echarts/chart/calculableBase",["require","../util/ecData","zrender/tool/util"],function(e){function t(t,n){function o(e){return e.ondragover=s.shapeHandler.ondragover,e.ondragend=s.shapeHandler.ondragend,e.ondrop=s.shapeHandler.ondrop,e}function u(e,t){if(!s.isDrop||!e.target)return;var i=e.target,o=e.dragged,u=r.get(i,"seriesIndex"),a=r.get(i,"dataIndex"),f=n.series[u].data[a]||"-";f.value?f.value!="-"?n.series[u].data[a].value+=r.get(o,"value"):n.series[u].data[a].value=r.get(o,"value"):f!="-"?n.series[u].data[a]+=r.get(o,"value"):n.series[u].data[a]=r.get(o,"value"),t.dragIn=t.dragIn||!0,s.isDrop=!1;return}function a(e,t){if(!s.isDragend||!e.target)return;var i=e.target,o=r.get(i,"seriesIndex"),u=r.get(i,"dataIndex");n.series[o].data[u]="-",t.dragOut=!0,t.needRefresh=!0,s.isDragend=!1;return}function f(e,t){var n=e.selected;for(var r in s.selectedMap)if(s.selectedMap[r]!=n[r]){t.needRefresh=!0;return}}var r=e("../util/ecData"),i=e("zrender/tool/util"),s=this;s.selectedMap={},s.shapeHandler={onclick:function(){s.isClick=!0},ondragover:function(e){var t=i.clone(e.target);t.highlightStyle={text:"",r:t.style.r+5,brushType:"stroke",strokeColor:s.zr.getCalculableColor(),lineWidth:(t.style.lineWidth||1)+12},s.zr.addHoverShape(t)},ondrop:function(e){typeof r.get(e.dragged,"data")!="undefined"&&(s.isDrop=!0)},ondragend:function(){s.isDragend=!0}},s.setCalculable=o,s.ondrop=u,s.ondragend=a,s.onlegendSelected=f}return t}),define("zrender/tool/color",["require","../tool/util"],function(e){function f(e){r=e}function l(){r=i}function c(e,t){return e=+e||0,t=t||r,t[e%t.length]}function h(e){s=e}function p(){o=s}function d(){return s}function v(e,r,i,s,o,u,a){n||(n=t.getContext());var f=n.createRadialGradient(e,r,i,s,o,u);for(var l=0,c=a.length;l<c;l++)f.addColorStop(a[l][0],a[l][1]);return f.__nonRecursion=!0,f}function m(e,r,i,s,o){n||(n=t.getContext());var u=n.createLinearGradient(e,r,i,s);for(var a=0,f=o.length;a<f;a++)u.addColorStop(o[a][0],o[a][1]);return u.__nonRecursion=!0,u}function g(e,t,n){e=S(e),t=S(t),e=F(e),t=F(t);var r=[],i=(t[0]-e[0])/n,s=(t[1]-e[1])/n,o=(t[2]-e[2])/n;for(var u=0,a=e[0],f=e[1],l=e[2];u<n;u++)r[u]=b([R(Math.floor(a),[0,255]),R(Math.floor(f),[0,255]),R(Math.floor(l),[0,255])]),a+=i,f+=s,l+=o;return a=t[0],f=t[1],l=t[2],r[u]=b([a,f,l]),r}function y(e,t){var n=[],r=e.length;t===undefined&&(t=20);if(r===1)n=g(e[0],e[0],t);else if(r>1)for(var i=0,s=r-1;i<s;i++){var o=g(e[i],e[i+1],t);i<s-1&&o.pop(),n=n.concat(o)}return n}function b(e,t){t=t||"rgb";if(e&&(e.length===3||e.length===4)){e=q(e,function(e){return e>1?Math.ceil(e):e});if(t.indexOf("hex")>-1)return e=q(e.slice(0,3),function(e){return e=Number(e).toString(16),e.length===1?"0"+e:e}),"#"+e.join("");if(t.indexOf("hs")>-1){var n=q(e.slice(1,3),function(e){return e+"%"});e[1]=n[0],e[2]=n[1]}return t.indexOf("a")>-1?(e.length===3&&e.push(1),e[3]=R(e[3],[0,1]),t+"("+e.slice(0,4).join(",")+")"):t+"("+e.slice(0,3).join(",")+")"}}function w(e){e=_(e),e.indexOf("#")>-1&&(e=x(e));var t=e.replace(/[rgbahsvl%\(\)]/ig,"").split(",");return t=q(t,function(e){return Number(e)}),t}function E(e,t){var n=F(e),r=n[3];return typeof r=="undefined"&&(r=1),e.indexOf("hsb")>-1?n=U(n):e.indexOf("hsl")>-1&&(n=z(n)),t.indexOf("hsb")>-1||t.indexOf("hsv")>-1?n=X(n):t.indexOf("hsl")>-1&&(n=V(n)),n[3]=r,b(n,t)}function S(e){return E(e,"rgba")}function x(e){return E(e,"rgb")}function T(e){return E(e,"hex")}function N(e){return E(e,"hsva")}function C(e){return E(e,"hsv")}function k(e){return E(e,"hsba")}function L(e){return E(e,"hsb")}function A(e){return E(e,"hsla")}function O(e){return E(e,"hsl")}function M(e){for(var t in a)if(T(a[t])===T(e))return t;return null}function _(e){return e=String(e),e=e.replace(/(^\s*)|(\s*$)/g,""),/^[^#]*?$/i.test(e)&&(e=e.replace(/\s/g,"")),e}function D(e){a[e]&&(e=a[e]),e=_(e),e=e.replace(/hsv/i,"hsb");if(/^#[0-9a-f]{3}$/i.test(e)){var t=e.replace("#","").split("");e="#"+t[0]+t[0]+t[1]+t[1]+t[2]+t[2]}return e}function P(e,t){var n=t>0?1:-1;typeof t=="undefined"&&(t=0),t=Math.abs(t)>1?1:Math.abs(t),e=x(e);var r=F(e);for(var i=0;i<3;i++)n===1?r[i]=Math.floor(r[i]*(1-t)):r[i]=Math.floor((255-r[i])*t+r[i]);return"rgb("+r.join(",")+")"}function H(e){var t=F(S(e));return t=q(t,function(e){return 255-e}),b(t,"rgb")}function B(e,t,n){typeof n=="undefined"&&(n=.5),n=1-R(n,[0,1]);var r=n*2-1,i=F(S(e)),s=F(S(t)),o=i[3]-s[3],u=((r*o===-1?r:(r+o)/(1+r*o))+1)/2,a=1-u,f=[];for(var l=0;l<3;l++)f[l]=i[l]*u+s[l]*a;var c=i[3]*n+s[3]*(1-n);return c=Math.max(0,Math.min(1,c)),i[3]===1&&s[3]===1?b(f,"rgb"):(f[3]=c,b(f,"rgba"))}function j(){return T("rgb("+Math.round(Math.random()*256)+","+Math.round(Math.random()*256)+","+Math.round(Math.random()*256)+")")}function F(e){e=D(e);var t=e.match(u);if(t===null)throw new Error("The color format error");var n,r,i=[],s;if(t[2])n=t[2].replace("#","").split(""),s=[n[0]+n[1],n[2]+n[3],n[4]+n[5]],i=q(s,function(e){return R(parseInt(e,16),[0,255])});else if(t[4]){var o=t[4].split(",");r=o[3],s=o.slice(0,3),i=q(s,function(e){return e=Math.floor(e.indexOf("%")>0?parseInt(e,0)*2.55:e),R(e,[0,255])}),typeof r!="undefined"&&i.push(R(parseFloat(r),[0,1]))}else if(t[5]||t[6]){var a=(t[5]||t[6]).split(","),f=parseInt(a[0],0)/360,l=a[1],c=a[2];r=a[3],i=q([l,c],function(e){return R(parseFloat(e)/100,[0,1])}),i.unshift(f),typeof r!="undefined"&&i.push(R(parseFloat(r),[0,1]))}return i}function I(e,t){t===null&&(t=1);var n=F(S(e));return n[3]=R(Number(t).toFixed(4),[0,1]),b(n,"rgba")}function q(e,t){if(typeof t!="function")throw new TypeError;var n=e?e.length:0;for(var r=0;r<n;r++)e[r]=t(e[r]);return e}function R(e,t){return e<=t[0]?e=t[0]:e>=t[1]&&(e=t[1]),e}function U(e){var t=e[0],n=e[1],r=e[2],i,s,o;if(n===0)i=r*255,s=r*255,o=r*255;else{var u=t*6;u===6&&(u=0);var a=Math.floor(u),f=r*(1-n),l=r*(1-n*(u-a)),c=r*(1-n*(1-(u-a))),h=0,p=0,d=0;a===0?(h=r,p=c,d=f):a===1?(h=l,p=r,d=f):a===2?(h=f,p=r,d=c):a===3?(h=f,p=l,d=r):a===4?(h=c,p=f,d=r):(h=r,p=f,d=l),i=h*255,s=p*255,o=d*255}return[i,s,o]}function z(e){var t=e[0],n=e[1],r=e[2],i,s,o;if(n===0)i=r*255,s=r*255,o=r*255;else{var u;r<.5?u=r*(1+n):u=r+n-n*r;var a=2*r-u;i=255*W(a,u,t+1/3),s=255*W(a,u,t),o=255*W(a,u,t-1/3)}return[i,s,o]}function W(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),6*n<1?e+(t-e)*6*n:2*n<1?t:3*n<2?e+(t-e)*(2/3-n)*6:e}function X(e){var t=e[0]/255,n=e[1]/255,r=e[2]/255,i=Math.min(t,n,r),s=Math.max(t,n,r),o=s-i,u=s,a,f;if(o===0)a=0,f=0;else{f=o/s;var l=((s-t)/6+o/2)/o,c=((s-n)/6+o/2)/o,h=((s-r)/6+o/2)/o;t===s?a=h-c:n===s?a=1/3+l-h:r===s&&(a=2/3+c-l),a<0&&(a+=1),a>1&&(a-=1)}return a*=360,f*=100,u*=100,[a,f,u]}function V(e){var t=e[0]/255,n=e[1]/255,r=e[2]/255,i=Math.min(t,n,r),s=Math.max(t,n,r),o=s-i,u=(s+i)/2,a,f;if(o===0)a=0,f=0;else{u<.5?f=o/(s+i):f=o/(2-s-i);var l=((s-t)/6+o/2)/o,c=((s-n)/6+o/2)/o,h=((s-r)/6+o/2)/o;t===s?a=h-c:n===s?a=1/3+l-h:r===s&&(a=2/3+c-l),a<0&&(a+=1),a>1&&(a-=1)}return a*=360,f*=100,u*=100,[a,f,u]}var t=e("../tool/util"),n,r=["#ff9277"," #dddd00"," #ffc877"," #bbe3ff"," #d5ffbb","#bbbbff"," #ddb000"," #b0dd00"," #e2bbff"," #ffbbe3","#ff7777"," #ff9900"," #83dd00"," #77e3ff"," #778fff","#c877ff"," #ff77ab"," #ff6600"," #aa8800"," #77c7ff","#ad77ff"," #ff77ff"," #dd0083"," #777700"," #00aa00","#0088aa"," #8400dd"," #aa0088"," #dd0000"," #772e00"],i=r,s="rgba(255,255,0,0.5)",o=s,u=/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgba?\(\s*([\d\.]+%?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+%?)?)\s*\)|hsba?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\)|hsla?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\))\s*$/i,a={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#0ff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000",blanchedalmond:"#ffebcd",blue:"#00f",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#0ff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgrey:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#f0f",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#789",lightslategrey:"#789",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#0f0",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#f0f",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#f00",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#fff",whitesmoke:"#f5f5f5",yellow:"#ff0",yellowgreen:"#9acd32"};return{customPalette:f,resetPalette:l,getColor:c,getHighlightColor:d,customHighlight:h,resetHighlight:p,getRadialGradient:v,getLinearGradient:m,getGradientColors:y,getStepColors:g,reverse:H,mix:B,lift:P,trim:_,random:j,toRGB:x,toRGBA:S,toHex:T,toHSL:O,toHSLA:A,toHSB:L,toHSBA:k,toHSV:C,toHSVA:N,toName:M,toColor:b,toArray:w,alpha:I,getData:F}}),define("zrender/shape",[],function(){var e={},t={};return e.define=function(n,r){return t[n]=r,e},e.get=function(e){return t[e]},e}),define("echarts/chart",[],function(){var e={},t={};return e.define=function(n,r){return t[n]=r,e},e.get=function(e){return t[e]},e}),define("echarts/chart/line",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/color","zrender/shape","zrender/shape","../chart"],function(e){function t(t,r,i,s){function g(){c.selectedMap={};var e={top:[],bottom:[],left:[],right:[]},t,n,i,o;for(var u=0,f=h.length;u<f;u++)h[u].type==a.CHART_TYPE_LINE&&(h[u]=c.reformOption(h[u]),t=h[u].xAxisIndex,n=h[u].yAxisIndex,i=s.xAxis.getAxis(t),o=s.yAxis.getAxis(n),i.type==a.COMPONENT_TYPE_AXIS_CATEGORY?e[i.getPosition()].push(u):o.type==a.COMPONENT_TYPE_AXIS_CATEGORY&&e[o.getPosition()].push(u));for(var l in e)e[l].length>0&&y(l,e[l]);for(var u=0,f=c.shapeList.length;u<f;u++)c.shapeList[u].id=r.newShapeId(c.type),r.addShape(c.shapeList[u])}function y(e,t){var n=b(t),r=n.locationMap,i=n.maxDataLength;if(i===0||r.length===0)return;switch(e){case"bottom":case"top":w(i,r);break;case"left":case"right":E(i,r)}}function b(e){var t,n=0,i={},o="__kener__stack__",u,a,f=s.legend,l=[],p=0,g;for(var y=0,b=e.length;y<b;y++)t=h[e[y]],a=t.name,m[e[y]]=m[e[y]]||c.deepQuery([t],"symbol")||v[y%v.length],f?(c.selectedMap[a]=f.isSelected(a),d[e[y]]=f.getColor(a),g=f.getItemShape(a),g&&(g.shape="icon",g.style.iconType="legendLineIcon",g.style.symbol=m[e[y]],f.setItemShape(a,g))):(c.selectedMap[a]=!0,d[e[y]]=r.getColor(e[y])),c.selectedMap[a]&&(u=t.stack||o+e[y],typeof i[u]=="undefined"?(i[u]=n,l[n]=[e[y]],n++):l[i[u]].push(e[y])),p=Math.max(p,t.data.length);return{locationMap:l,maxDataLength:p}}function w(e,t){var n=t[0][0],r=h[n],o=r.xAxisIndex,u=s.xAxis.getAxis(o),a,f,l,p,d,v,m,g,y={},b={},w,E;for(var T=0,N=e;T<N;T++){if(typeof u.getNameByIndex(T)=="undefined")break;l=u.getCoordByIndex(T);for(var C=0,k=t.length;C<k;C++){a=h[t[C][0]].yAxisIndex||0,f=s.yAxis.getAxis(a),v=d=g=m=f.getCoord(0);for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[T],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-",b[n]=b[n]||[];if(E=="-"){b[n].length>0&&(y[n]=y[n]||[],y[n].push(b[n]),b[n]=[]);continue}p=f.getCoord(E),E>=0?(d-=v-p,p=d):E<0&&(m+=p-g,p=m),b[n].push([l,p,T,u.getNameByIndex(T),l,v])}}d=s.grid.getY();var O;for(var C=0,k=t.length;C<k;C++)for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[T],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-";if(E!="-")continue;c.deepQuery([w,r,i],"calculable")&&(O=c.deepQuery([w,r],"symbolSize"),d+=O*2+5,p=d,c.shapeList.push(x(n,T,u.getNameByIndex(T),l,p)))}}for(var M in b)b[M].length>0&&(y[M]=y[M]||[],y[M].push(b[M]),b[M]=[]);S(y,u,"horizontal")}function E(e,t){var n=t[0][0],r=h[n],o=r.yAxisIndex,u=s.yAxis.getAxis(o),a,f,l,p,d,v,m,g,y={},b={},w,E;for(var T=0,N=e;T<N;T++){if(typeof u.getNameByIndex(T)=="undefined")break;p=u.getCoordByIndex(T);for(var C=0,k=t.length;C<k;C++){a=h[t[C][0]].xAxisIndex||0,f=s.xAxis.getAxis(a),v=d=g=m=f.getCoord(0);for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[T],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-",b[n]=b[n]||[];if(E=="-"){b[n].length>0&&(y[n]=y[n]||[],y[n].push(b[n]),b[n]=[]);continue}l=f.getCoord(E),E>=0?(d+=l-v,l=d):E<0&&(m-=g-l,l=m),b[n].push([l,p,T,u.getNameByIndex(T),v,p])}}d=s.grid.getXend();var O;for(var C=0,k=t.length;C<k;C++)for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[T],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-";if(E!="-")continue;c.deepQuery([w,r,i],"calculable")&&(O=c.deepQuery([w,r],"symbolSize"),d-=O*2+5,l=d,c.shapeList.push(x(n,T,u.getNameByIndex(T),l,p)))}}for(var M in b)b[M].length>0&&(y[M]=y[M]||[],y[M].push(b[M]),b[M]=[]);S(y,u,"vertical")}function S(e,t,n){var r,s,o,u,f,v,m,g,y,b,w,E;for(var S=h.length-1;S>=0;S--){y=h[S],w=e[S];if(y.type==a.CHART_TYPE_LINE&&typeof w!="undefined"){r=d[S],s=c.deepQuery([y],"itemStyle.normal.lineStyle.width"),o=c.deepQuery([y],"itemStyle.normal.lineStyle.type"),u=c.deepQuery([y],"itemStyle.normal.lineStyle.color"),f=c.deepQuery([y],"itemStyle.normal.color"),v=c.deepQuery([y],"itemStyle.emphasis.color"),m=typeof c.deepQuery([y],"itemStyle.normal.areaStyle")!="undefined",g=c.deepQuery([y],"itemStyle.normal.areaStyle.color");for(var x=0,N=w.length;x<N;x++){E=w[x];for(var C=0,k=E.length;C<k;C++)b=y.data[E[C][2]],(t.isMainAxis(E[C][2])&&c.deepQuery([b,y],"symbol")!="none"||c.deepQuery([b,y,i],"calculable"))&&c.shapeList.push(T(S,E[C][2],E[C][3],E[C][0],E[C][1],c.deepQuery([b],"itemStyle.normal.color")||f||r,c.deepQuery([b],"itemStyle.emphasis.color")||v||f||r,s,c.deepQuery([b,y],"symbolRotate")));c.shapeList.push({shape:"brokenLine",zlevel:p,style:{pointList:E,strokeColor:u||f||r,lineWidth:s,lineType:o,shadowColor:c.deepQuery([y],"itemStyle.normal.lineStyle.shadowColor"),shadowBlur:c.deepQuery([y],"itemStyle.normal.lineStyle.shadowBlur"),shadowOffsetX:c.deepQuery([y],"itemStyle.normal.lineStyle.shadowOffsetX"),shadowOffsetY:c.deepQuery([y],"itemStyle.normal.lineStyle.shadowOffsetY")},hoverable:!1,_main:!0,_seriesIndex:S,_orient:n}),m&&c.shapeList.push({shape:"polygon",zlevel:p,style:{pointList:E.concat([[E[E.length-1][4],E[E.length-1][5]-2],[E[0][4],E[0][5]-2]]),brushType:"fill",color:g?g:l.alpha(r,.5)},hoverable:!1,_main:!0,_seriesIndex:S,_orient:n})}}}}function x(e,t,n,r,i){var s=h[e].calculableHolderColor||a.calculableHolderColor,o=T(e,t,n,r,i,s,d[e],2);return o.hoverable=!1,o.draggable=!1,o.highlightStyle.lineWidth=20,o}function T(e,t,n,r,s,o,u,a,l){var d=h[e],v=d.data[t],g=c.deepQuery([v],"symbol")||m[e]||"cricle",y=c.deepQuery([v,d],"symbolSize"),b={shape:"icon",zlevel:p+1,style:{iconType:g.replace("empty","").toLowerCase(),x:r-y,y:s-y,width:y*2,height:y*2,brushType:"both",color:g.match("empty")?"#fff":o,strokeColor:o,lineWidth:a*2},highlightStyle:{color:u,strokeColor:u},clickable:!0};return typeof l!="undefined"&&(b.rotation=[l*Math.PI/180,r,s]),g.match("star")&&(b.style.iconType="star",b.style.n=g.replace("empty","").replace("star","")-0||5),g=="none"&&(b.invisible=!0,b.hoverable=!1),c.deepQuery([v,d,i],"calculable")&&(c.setCalculable(b),b.draggable=!0),f.pack(b,h[e],e,h[e].data[t],t,n),b._x=r,b._y=s,b}function N(e,t){i=e,s=t,h=i.series,c.clear(),g()}function C(){c.clear(),g()}function k(){var e=c.deepQuery([i],"animationDuration"),t=c.deepQuery([i],"animationEasing"),n,s,o,u=0;for(var a=0,f=c.shapeList.length;a<f;a++)c.shapeList[a]._main?(o=h[c.shapeList[a]._seriesIndex],u+=1,n=c.shapeList[a].style.pointList[0][0],s=c.shapeList[a].style.pointList[0][1],c.shapeList[a]._orient=="horizontal"?r.modShape(c.shapeList[a].id,{scale:[0,1,n,s]}):r.modShape(c.shapeList[a].id,{scale:[1,0,n,s]}),r.animate(c.shapeList[a].id,"").when((c.deepQuery([o],"animationDuration")||e)+u*100,{scale:[1,1,n,s]},c.deepQuery([o],"animationEasing")||t).start()):(n=c.shapeList[a]._x||0,s=c.shapeList[a]._y||0,r.modShape(c.shapeList[a].id,{scale:[0,0,n,s]}),r.animate(c.shapeList[a].id,"").when(e,{scale:[1,1,n,s]},"QuinticOut").start())}var o=e("../component/base");o.call(this,r);var u=e("./calculableBase");u.call(this,r,i);var a=e("../config"),f=e("../util/ecData"),l=e("zrender/tool/color"),c=this;c.type=a.CHART_TYPE_LINE;var h,p=c.getZlevelBase(),d={},v=["circle","rectangle","triangle","diamond","emptyCircle","emptyRectangle","emptyTriangle","emptyDiamond"],m={};e("zrender/shape").get("icon").define("legendLineIcon",n),c.init=N,c.refresh=C,c.animation=k,N(i,s)}function n(t,n){var r=n.x,i=n.y,s=n.width,o=n.height,u=o/2;t.moveTo(r,i+u),t.lineTo(r+s,i+u),n.symbol.match("empty")&&(t.fillStyle="#fff"),n.brushType="both";var a=n.symbol.replace("empty","").toLowerCase();a.match("star")?(u=a.replace("star","")-0||5,i-=1,a="star"):a=="rectangle"&&(r+=(s-o)/2,s=o),a=e("zrender/shape").get("icon").get(a),a&&a(t,{x:r+3,y:i+3,width:s-6,height:o-6,n:u})}return e("../chart").define("line",t),t}),define("echarts/chart/bar",["require","../component/base","./calculableBase","../config","../util/ecData","../chart"],function(e){function t(t,n,r,i){function p(){f.selectedMap={};var e={top:[],bottom:[],left:[],right:[]},t,r,s,o;for(var a=0,c=l.length;a<c;a++)l[a].type==u.CHART_TYPE_BAR&&(l[a]=f.reformOption(l[a]),t=l[a].xAxisIndex,r=l[a].yAxisIndex,s=i.xAxis.getAxis(t),o=i.yAxis.getAxis(r),s.type==u.COMPONENT_TYPE_AXIS_CATEGORY?e[s.getPosition()].push(a):o.type==u.COMPONENT_TYPE_AXIS_CATEGORY&&e[o.getPosition()].push(a));for(var h in e)e[h].length>0&&d(h,e[h]);for(var a=0,c=f.shapeList.length;a<c;a++)f.shapeList[a].id=n.newShapeId(f.type),n.addShape(f.shapeList[a])}function d(e,t){var n=v(t),r=n.locationMap,i=n.maxDataLength;if(i===0||r.length===0)return;switch(e){case"bottom":case"top":m(i,r);break;case"left":case"right":g(i,r)}}function v(e){var t,r=0,s={},o="__kener__stack__",u,a,c=i.legend,p=[],d=0;for(var v=0,m=e.length;v<m;v++)t=l[e[v]],a=t.name,c?(f.selectedMap[a]=c.isSelected(a),h[e[v]]=c.getColor(a)):(f.selectedMap[a]=!0,h[e[v]]=n.getColor(e[v])),f.selectedMap[a]&&(u=t.stack||o+e[v],typeof s[u]=="undefined"?(s[u]=r,p[r]=[e[v]],r++):p[s[u]].push(e[v])),d=Math.max(d,t.data.length);return{locationMap:p,maxDataLength:d}}function m(e,t){var n=t[0][0],s=l[n],o=s.xAxisIndex,a=i.xAxis.getAxis(o),c,h,p=y(a,t),d=p.gap,v=p.barGap,m=p.barWidthMap,g=p.barWidth,w=p.barMinHeightMap,E,S,x,T,N,C,k,L,A,O;for(var M=0,_=e;M<_;M++){if(typeof a.getNameByIndex(M)=="undefined")break;S=a.getCoordByIndex(M)-d/2;for(var D=0,P=t.length;D<P;D++){c=l[t[D][0]].yAxisIndex||0,h=i.yAxis.getAxis(c),N=T=h.getCoord(0)-1,k=C=T+2;for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=l[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O=="-")continue;x=h.getCoord(O),O>0?(E=N-x,B==1&&w[n]>E&&(E=w[n]),T-=E,x=T,T-=.5):O<0?(E=x-k,B==1&&w[n]>E&&(E=w[n]),x=C,C+=E,C+=.5):(E=N-x,T-=E,x=T,T-=.5),L=b(n,M,a.getNameByIndex(M),S,x,m[n]||g,E),L._orient="vertical",f.shapeList.push(L)}for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=l[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O!="-")continue;f.deepQuery([A,s,r],"calculable")&&(T-=w[n],x=T,L=b(n,M,a.getNameByIndex(M),S+1,x,(m[n]||g)-2,w[n]),L.hoverable=!1,L.draggable=!1,L.style.brushType="stroke",L.style.strokeColor=s.calculableHolderColor||u.calculableHolderColor,f.shapeList.push(L))}S+=(m[n]||g)+v}}}function g(e,t){var n=t[0][0],s=l[n],o=s.yAxisIndex,a=i.yAxis.getAxis(o),c,h,p=y(a,t),d=p.gap,v=p.barGap,m=p.barWidthMap,g=p.barWidth,w=p.barMinHeightMap,E,S,x,T,N,C,k,L,A,O;for(var M=0,_=e;M<_;M++){if(typeof a.getNameByIndex(M)=="undefined")break;x=a.getCoordByIndex(M)+d/2;for(var D=0,P=t.length;D<P;D++){c=l[t[D][0]].xAxisIndex||0,h=i.xAxis.getAxis(c),N=T=h.getCoord(0)+1,k=C=T-2;for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=l[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O=="-")continue;S=h.getCoord(O),O>0?(E=S-N,B==1&&w[n]>E&&(E=w[n]),S=T,T+=E,T+=.5):O<0?(E=k-S,B==1&&w[n]>E&&(E=w[n]),C-=E,S=C,C-=.5):(E=S-N,S=T,T+=E,T+=.5),L=b(n,M,a.getNameByIndex(M),S,x-(m[n]||g),E,m[n]||g),L._orient="horizontal",f.shapeList.push(L)}for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=l[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O!="-")continue;f.deepQuery([A,s,r],"calculable")&&(S=T,T+=w[n],L=b(n,M,a.getNameByIndex(M),S,x+1-(m[n]||g),w[n],(m[n]||g)-2),L.hoverable=!1,L.draggable=!1,L.style.brushType="stroke",L.style.strokeColor=s.calculableHolderColor||u.calculableHolderColor,f.shapeList.push(L))}x-=(m[n]||g)+v}}}function y(e,t,n){var r={},i={},s,o=0,u=0,a,c;for(var h=0,p=t.length;h<p;h++){c=!1;for(var d=0,v=t[h].length;d<v;d++)seriesIndex=t[h][d],n||(c?r[seriesIndex]=s:(s=f.deepQuery([l[seriesIndex]],"barWidth"),typeof s!="undefined"&&(r[seriesIndex]=s,u+=s,o++,c=!0))),a=f.deepQuery([l[seriesIndex]],"barMinHeight"),typeof a!="undefined"&&(i[seriesIndex]=a)}var m,g,b;if(t.length!=o){m=Math.round(e.getGap()*4/5),g=Math.round((m-u)*3/(4*t.length-3*o-1)),b=Math.round(g/3);if(g<0)return y(e,t,!0)}else{g=0,b=Math.round(u/o/3),m=u+b*(o-1);if(Math.round(e.getGap()*4/5)<m)return y(e,t,!0)}return{barWidthMap:r,barMinHeightMap:i,gap:m,barWidth:g,barGap:b}}function b(e,t,n,i,s,o,u){var p,d=l[e],v=d.data[t],m=h[e],g=f.deepQuery([v,d],"itemStyle.normal.color"),y=f.deepQuery([v,d],"itemStyle.emphasis.color");return p={shape:"rectangle",zlevel:c,clickable:!0,style:{x:i,y:s,width:o,height:u,brushType:"both",color:g||m,strokeColor:"#fff"},highlightStyle:{color:y||g||m}},f.deepQuery([v,d,r],"calculable")&&(f.setCalculable(p),p.draggable=!0),a.pack(p,l[e],e,l[e].data[t],t,n),p}function w(e,t){r=e,i=t,l=r.series,f.clear(),p()}function E(){f.clear(),p()}function S(){var e,t,i,s,o,u,l,c,h;for(var p=0,d=f.shapeList.length;p<d;p++)f.shapeList[p].shape=="rectangle"&&(l=a.get(f.shapeList[p],"series"),c=a.get(f.shapeList[p],"dataIndex"),h=a.get(f.shapeList[p],"value"),e=f.deepQuery([l,r],"animationDuration"),t=f.deepQuery([l,r],"animationEasing"),f.shapeList[p]._orient=="horizontal"?(i=f.shapeList[p].style.width,o=f.shapeList[p].style.x,h<0?(n.modShape(f.shapeList[p].id,{style:{x:o+i,width:0}}),n.animate(f.shapeList[p].id,"style").when(e+c*100,{x:o,width:i},t).start()):(n.modShape(f.shapeList[p].id,{style:{width:0}}),n.animate(f.shapeList[p].id,"style").when(e+c*100,{width:i},t).start())):(s=f.shapeList[p].style.height,u=f.shapeList[p].style.y,h<0?(n.modShape(f.shapeList[p].id,{style:{height:0}}),n.animate(f.shapeList[p].id,"style").when(e+c*100,{height:s},t).start()):(n.modShape(f.shapeList[p].id,{style:{y:u+s,height:0}}),n.animate(f.shapeList[p].id,"style").when(e+c*100,{y:u,height:s},t).start())))}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=this;f.type=u.CHART_TYPE_BAR;var l,c=f.getZlevelBase(),h={};f.init=w,f.refresh=E,f.animation=S,w(r,i)}return e("../chart").define("bar",t),t}),define("zrender/tool/area",["require","../tool/util"],function(e){function r(e,r,u,a){if(!r||!e)return!1;var f=e.type;n||(n=t.getContext());if(!h(r.__rect||e.getRect(r),u,a))return!1;var l=i(f,r,u,a);if(typeof l!="undefined")return l;if(f!="beziercurve"&&e.buildPath&&n.isPointInPath)return s(e,n,r,u,a);if(n.getImageData)return o(e,r,u,a);switch(f){case"heart":return!0;case"droplet":return!0;case"ellipse":return!0;case"trochoid":var c=r.location=="out"?r.r1+r.r2+r.d:r.r1-r.r2+r.d;return p(r,u,a,c);case"rose":return p(r,u,a,r.maxr);default:return!1}}function i(e,t,n,r){switch(e){case"line":return f(t,n,r);case"brokenLine":return l(t,n,r);case"text":return!0;case"ring":return c(t,n,r);case"rectangle":return!0;case"circle":return p(t,n,r,t.r);case"sector":return d(t,n,r);case"path":return m(t,n,r);case"polygon":case"star":case"isogon":return v(t,n,r);case"image":return!0}}function s(e,t,n,r,i){return t.beginPath(),e.buildPath(t,n),t.closePath(),t.isPointInPath(r,i)}function o(e,n,r,i){var s=n.__rect||e.getRect(n),o=t.getPixelContext(),a=t.getPixelOffset();return t.adjustCanvasSize(r,i),o.clearRect(s.x,s.y,s.width,s.height),o.beginPath(),e.brush(o,{style:n}),o.closePath(),u(o,r+a.x,i+a.y)}function u(e,t,n,r){var i;typeof r!="undefined"?(r=Math.floor((r||1)/2),i=e.getImageData(t-r,n-r,r+r,r+r).data):i=e.getImageData(t,n,1,1).data;var s=i.length;while(s--)if(i[s]!==0)return!0;return!1}function a(e,t,n,i){return!r(e,t,n,i)}function f(e,t,n){var r=e.xStart,i=e.yStart,s=e.xEnd,o=e.yEnd,u=e.lineWidth,a=0,f=r;if(r===s)return Math.abs(t-r)<=u/2;a=(i-o)/(r-s),f=(r*o-s*i)/(r-s);var l=(a*t-n+f)*(a*t-n+f)/(a*a+1);return l<=u/2*u/2}function l(e,t,n){var r=e.pointList,i,s=!1;for(var o=0,u=r.length-1;o<u;o++){i={xStart:r[o][0],yStart:r[o][1],xEnd:r[o+1][0],yEnd:r[o+1][1],lineWidth:e.lineWidth};if(!h({x:Math.min(i.xStart,i.xEnd)-i.lineWidth,y:Math.min(i.yStart,i.yEnd)-i.lineWidth,width:Math.abs(i.xStart-i.xEnd)+i.lineWidth,height:Math.abs(i.yStart-i.yEnd)+i.lineWidth},t,n))continue;s=f(i,t,n);if(s)break}return s}function c(e,t,n){return p(e,t,n,e.r)&&!p({x:e.x,y:e.y},t,n,e.r0||0)?!0:!1}function h(e,t,n){return t>=e.x&&t<=e.x+e.width&&n>=e.y&&n<=e.y+e.height?!0:!1}function p(e,t,n,r){return(t-e.x)*(t-e.x)+(n-e.y)*(n-e.y)<r*r}function d(e,t,n){if(!p(e,t,n,e.r)||e.r0>0&&p({x:e.x,y:e.y},t,n,e.r0))return!1;var r=(360-Math.atan2(n-e.y,t-e.x)/Math.PI*180)%360,i=(360+e.endAngle)%360,s=(360+e.startAngle)%360;return i>s?r>=s&&r<=i:!(r>=i&&r<=s)}function v(e,t,n){var r,i,s=e.pointList,o=s.length,u=!1,a=!0,f;for(r=0;r<o;++r)if(s[r][0]==t&&s[r][1]==n){a=!1,u=!0;break}if(a){a=!1,u=!1;for(r=0,i=o-1;r<o;i=r++)if(s[r][1]<n&&n<s[i][1]||s[i][1]<n&&n<s[r][1]){if(t<=s[r][0]||t<=s[i][0]){f=(n-s[r][1])*(s[i][0]-s[r][0])/(s[i][1]-s[r][1])+s[r][0];if(t<f)u=!u;else if(t==f){u=!0;break}}}else if(n==s[r][1]){if(t<s[r][0]){s[r][1]>s[i][1]?--n:++n;break}}else if(s[r][1]==s[i][1]&&n==s[r][1]&&(s[r][0]<t&&t<s[i][0]||s[i][0]<t&&t<s[r][0])){u=!0;break}}return u}function m(e,t,n){var r=e.pointList,i=!1;for(var s=0,o=r.length;s<o;s++){i=v({pointList:r[s]},t,n);if(i)break}return i}function g(e,r){n||(n=t.getContext()),n.save(),r&&(n.font=r);var i=n.measureText(e).width;return n.restore(),i}var t=e("../tool/util"),n;return{isInside:r,isOutside:a,getTextWidth:g}}),define("zrender/tool/matrix",[],function(){var e={create:function(){return[1,0,0,1,0,0]},identity:function(e){e[0]=1,e[1]=0,e[2]=0,e[3]=1,e[4]=0,e[5]=0},mul:function(e,t,n){return e[0]=t[0]*n[0]+t[2]*n[1],e[1]=t[1]*n[0]+t[3]*n[1],e[2]=t[0]*n[2]+t[2]*n[3],e[3]=t[1]*n[2]+t[3]*n[3],e[4]=t[0]*n[4]+t[2]*n[5]+t[4],e[5]=t[1]*n[4]+t[3]*n[5]+t[5],e},translate:function(e,t,n){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4]+n[0],e[5]=t[5]+n[1],e},rotate:function(e,t,n){var r=t[0],i=t[2],s=t[4],o=t[1],u=t[3],a=t[5],f=Math.sin(n),l=Math.cos(n);return e[0]=r*l+o*f,e[1]=-r*f+o*l,e[2]=i*l+u*f,e[3]=-i*f+l*u,e[4]=l*s+f*a,e[5]=l*a-f*s,e},scale:function(e,t,n){var r=n[0],i=n[1];return e[0]=t[0]*r,e[1]=t[1]*i,e[2]=t[2]*r,e[3]=t[3]*i,e[4]=t[4]*r,e[5]=t[5]*i,e},invert:function(e,t){var n=t[0],r=t[2],i=t[4],s=t[1],o=t[3],u=t[5],a=n*o-s*r;return a?(a=1/a,e[0]=o*a,e[1]=-s*a,e[2]=-r*a,e[3]=n*a,e[4]=(r*u-o*i)*a,e[5]=(s*i-n*u)*a,e):null},mulVector:function(e,t,n){var r=t[0],i=t[2],s=t[4],o=t[1],u=t[3],a=t[5];return e[0]=n[0]*r+n[1]*i+s,e[1]=n[0]*o+n[1]*u+a,e}};return e}),define("zrender/shape/base",["require","../tool/area","../tool/matrix","../tool/color"],function(e){function i(e){var n=["brush","setContext","drawText","getHighlightStyle","getHighlightZoom","drift","isCover","updateTransform"],r=n.length,i=e.prototype,s=0,o;for(;s<r;s++)o=n[s],i[o]||(i[o]=t[o])}function s(e,t,n){var r=t.style||{};this.brushTypeOnly&&(r.brushType=this.brushTypeOnly),n&&(r=this.getHighlightStyle(r,t.highlightStyle||{},this.brushTypeOnly)),this.brushTypeOnly=="stroke"&&(r.strokeColor=r.strokeColor||r.color),e.save(),this.setContext(e,r),t.__needTransform&&e.transform.apply(e,this.updateTransform(t)),e.beginPath(),this.buildPath(e,r),this.brushTypeOnly!="stroke"&&e.closePath();switch(r.brushType){case"fill":e.fill();break;case"stroke":e.stroke();break;case"both":e.stroke(),e.fill();break;default:e.fill()}r.text&&this.drawText(e,r,t.style),e.restore();return}function o(e,t){t.color&&(e.fillStyle=t.color),t.strokeColor&&(e.strokeStyle=t.strokeColor),typeof t.opacity!="undefined"&&(e.globalAlpha=t.opacity),t.lineCap&&(e.lineCap=t.lineCap),t.lineJoin&&(e.lineJoin=t.lineJoin),t.miterLimit&&(e.miterLimit=t.miterLimit),typeof t.lineWidth!="undefined"&&(e.lineWidth=t.lineWidth),typeof t.shadowBlur!="undefined"&&(e.shadowBlur=t.shadowBlur),t.shadowColor&&(e.shadowColor=t.shadowColor),typeof t.shadowOffsetX!="undefined"&&(e.shadowOffsetX=t.shadowOffsetX),typeof t.shadowOffsetY!="undefined"&&(e.shadowOffsetY=t.shadowOffsetY)}function u(e,t,n){t.textColor=t.textColor||t.color||t.strokeColor,e.fillStyle=t.textColor,t.textPosition=="inside"&&(e.shadowColor="rgba(0,0,0,0)");var r=10,i,s,o,u,a=t.textPosition||this.textPosition||"top";if(a!="inside"&&a!="top"&&a!="bottom"&&a!="left"&&a!="right"||!this.getRect)if(a=="start"||a=="end"){var l,c,h,p;if(typeof t.pointList!="undefined"){var d=t.pointList;if(d.length<2)return;var v=d.length;switch(a){case"start":l=d[0][0],c=d[1][0],h=d[0][1],p=d[1][1];break;case"end":l=d[v-2][0],c=d[v-1][0],h=d[v-2][1],p=d[v-1][1]}}else l=t.xStart||0,c=t.xEnd||0,h=t.yStart||0,p=t.yEnd||0;switch(a){case"start":i=l<c?"end":"start",s=h<p?"bottom":"top",o=l,u=h;break;case"end":i=l<c?"start":"end",s=h<p?"top":"bottom",o=c,u=p}r-=4,l!=c?o-=i=="end"?r:-r:i="center",h!=p?u-=s=="bottom"?r:-r:s="middle"}else a=="specific"&&(o=t.textX||0,u=t.textY||0,i="start",s="middle");else{var f=(n||t).__rect||this.getRect(n||t);switch(a){case"inside":o=f.x+f.width/2,u=f.y+f.height/2,i="center",s="middle",t.brushType!="stroke"&&t.textColor==t.color&&(e.fillStyle="#fff");break;case"left":o=f.x-r,u=f.y+f.height/2,i="end",s="middle";break;case"right":o=f.x+f.width+r,u=f.y+f.height/2,i="start",s="middle";break;case"top":o=f.x+f.width/2,u=f.y-r,i="center",s="bottom";break;case"bottom":o=f.x+f.width/2,u=f.y+f.height+r,i="center",s="top"}}typeof o!="undefined"&&typeof u!="undefined"&&(t.textFont&&(e.font=t.textFont),e.textAlign=t.textAlign||i,e.textBaseline=t.textBaseLine||s,e.fillText(t.text,o,u))}function a(t,n,r){var i={};for(var s in t)i[s]=t[s];var o=e("../tool/color"),u=o.getHighlightColor();t.brushType!="stroke"?(i.strokeColor=u,i.lineWidth=(t.lineWidth||1)+this.getHighlightZoom(),i.brushType="both"):r!="stroke"?(i.strokeColor=u,i.lineWidth=(t.lineWidth||1)+this.getHighlightZoom()):i.strokeColor=n.strokeColor||o.mix(t.strokeColor,o.toRGB(u));for(var s in n)i[s]=n[s];return i}function f(){return this.type!="text"?6:2}function l(e,t,n){e.position[0]+=t,e.position[1]+=n}function c(e,t,i){if(e.__needTransform&&e._transform){var s=[];r.invert(s,e._transform);var o=[t,i];r.mulVector(o,s,[t,i,1]),t==o[0]&&i==o[1]&&(Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1),t=o[0],i=o[1]}var u;return e.style.__rect?u=e.style.__rect:(u=this.getRect(e.style),e.style.__rect=u),t>=u.x&&t<=u.x+u.width&&i>=u.y&&i<=u.y+u.height?n.isInside(this,e.style,t,i):!1}function h(e){var t=e._transform||r.create();r.identity(t);if(e.scale&&(e.scale[0]!==1||e.scale[1]!==1)){var n=e.scale[2]||0,i=e.scale[3]||0;(n||i)&&r.translate(t,t,[-n,-i]),r.scale(t,t,e.scale),(n||i)&&r.translate(t,t,[n,i])}if(e.rotation)if(e.rotation instanceof Array){if(e.rotation[0]!==0){var n=e.rotation[1]||0,i=e.rotation[2]||0;(n||i)&&r.translate(t,t,[-n,-i]),r.rotate(t,t,e.rotation[0]),(n||i)&&r.translate(t,t,[n,i])}}else e.rotation!==0&&r.rotate(t,t,e.rotation);return e.position&&(e.position[0]!==0||e.position[1]!==0)&&r.translate(t,t,e.position),e._transform=t,t}var t,n=e("../tool/area"),r=e("../tool/matrix");return t={derive:i,brush:s,setContext:o,drawText:u,getHighlightStyle:a,getHighlightZoom:f,drift:l,isCover:c,updateTransform:h},t}),define("echarts/util/shape/symbol",["require","zrender/tool/color","zrender/shape","zrender/shape/base","zrender/shape"],function(e){function t(){this.type="symbol"}return t.prototype={_buildSinglePoint:function(e,t){switch(t[3]){case"circle":case"emptyCircle":e.arc(t[0],t[1],t[2],0,Math.PI*2,!0);break;case"rectangle":case"emptyRectangle":e.rect(t[0]-t[2],t[1]-t[2],t[2]*2,t[2]*2);break;case"triangle":case"emptyTriangle":itemShape={shape:"polygon",style:{pointList:[[x,y-symbolSize],[x+symbolSize,y+symbolSize],[x-symbolSize,y+symbolSize]],brushType:symbolType=="triangle"?"fill":"stroke"}};break;case"diamond":case"emptyDiamond":itemShape={shape:"polygon",style:{pointList:[[x,y-symbolSize],[x+symbolSize,y],[x,y+symbolSize],[x-symbolSize,y]],brushType:symbolType=="diamond"?"fill":"stroke"}};break;default:itemShape={shape:"circle",style:{x:x,y:y,r:symbolSize,brushType:"fill"}}}},buildPath:function(t,n){var r=n.pointList,i=this.getRect(n),s=window.devicePixelRatio||1,o=t.getImageData(i.x*s,i.y*s,i.width*s,i.height*s),u=o.data,a,f=e("zrender/tool/color"),l=f.toArray(n.color),c=l[0],h=l[1],p=l[2],d=i.width;for(var v=1,m=r.length;v<m;v++)a=((r[v][0]-i.x)*s+(r[v][1]-i.y)*d*s*s)*4,u[a]=c,u[a+1]=h,u[a+2]=p,u[a+3]=255;t.putImageData(o,i.x*s,i.y*s);return},getRect:function(t){var n=e("zrender/shape");return n.get("polygon").getRect(t)},isCover:function(){return!1}},e("zrender/shape/base").derive(t),e("zrender/shape").define("symbol",new t),t}),define("echarts/chart/scatter",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/color","../util/shape/symbol","../chart"],function(e){function t(t,n,r,i){function m(){l.selectedMap={};var e=i.legend,t=[],r,s,o;for(var a=0,h=c.length;a<h;a++)r=c[a],s=r.name,r.type==u.CHART_TYPE_SCATTER&&(c[a]=l.reformOption(c[a]),v[a]=l.deepQuery([r],"symbol")||d[a%d.length],e?(l.selectedMap[s]=e.isSelected(s),p[a]=f.alpha(e.getColor(s),.5),o=e.getItemShape(s),o&&(o.shape="icon",o.style.iconType=v[a],e.setItemShape(s,o))):(l.selectedMap[s]=!0,p[a]=n.getColor(a)),l.selectedMap[s]&&t.push(a));if(t.length===0)return;g(t);for(var a=0,h=l.shapeList.length;a<h;a++)l.shapeList[a].id=n.newShapeId(l.type),n.addShape(l.shapeList[a])}function g(e){var t,n,r,s,o,u,a={},f,h,p;for(var d=0,m=e.length;d<m;d++){t=e[d],n=c[t];if(n.data.length===0)continue;o=i.xAxis.getAxis(n.xAxisIndex||0),u=i.yAxis.getAxis(n.yAxisIndex||0),p=l.deepQuery([n],"symbolSize"),a[t]=[];for(var g=0,b=n.data.length;g<b;g++){r=n.data[g],s=typeof r!="undefined"?typeof r.value!="undefined"?r.value:r:"-";if(s=="-"||s.length<2)continue;f=o.getCoord(s[0]),h=u.getCoord(s[1]),a[t].push([f,h,typeof p=="function"?p(s):p,v[t],g,r.name||""])}}y(a)}function y(e){var t=i.dataRange,n,r,s,o,u,a,f,h,d,v,m;for(var g in e){a=c[g],d=e[g],f=[a],r=l.deepQuery(f,"itemStyle.normal.color")||p[g],s=l.deepQuery(f,"itemStyle.normal.lineStyle.width"),o=l.deepQuery(f,"itemStyle.emphasis.color"),u=l.deepQuery(f,"itemStyle.emphasis.lineStyle.width"),m=l.deepQuery(f,"symbolRotate");if(a.large&&a.data.length>a.largeThreshold){l.shapeList.push(w(d,r,o));continue}for(var y=0,E=d.length;y<E;y++){v=d[y],h=a.data[v[4]];if(t){if(isNaN(h[2]))continue;n=t.getColor(h[2]);if(!n)continue}else n=r;f=[h],l.shapeList.push(b(g,v[4],v[5],v[0],v[1],l.deepQuery(f,"symbolSize")||v[2],l.deepQuery(f,"symbolRotate")||m,l.deepQuery(f,"symbol")||v[3],l.deepQuery(f,"itemStyle.normal.color")||n,l.deepQuery(f,"itemStyle.normal.lineStyle.width")||s,l.deepQuery(f,"itemStyle.emphasis.color")||o||r,l.deepQuery(f,"itemStyle.emphasis.lineStyle.width")||u||s))}}}function b(e,t,n,r,i,s,o,u,f,l,p,d){var v={shape:"icon",zlevel:h,style:{iconType:u.replace("empty","").toLowerCase(),x:r-s,y:i-s,width:s*2,height:s*2,brushType:u.match("empty")?"stroke":"fill",color:f,strokeColor:f,lineWidth:l},highlightStyle:{color:p,strokeColor:p,lineWidth:d},clickable:!0};return typeof o!="undefined"&&(v.rotation=[o*Math.PI/180,r,i]),u.match("star")&&(v.style.iconType="star",v.style.n=u.replace("empty","").replace("star","")-0||5),u=="none"&&(v.invisible=!0,v.hoverable=!1),a.pack(v,c[e],e,c[e].data[t],t,n),v._x=r,v._y=i,v}function w(e,t,n){return{shape:"symbol",zlevel:h,hoverable:!1,style:{pointList:e,color:t,strokeColor:t},highlightStyle:{color:n,strokeColor:n}}}function E(e,t){r=e,i=t,c=r.series,l.clear(),m()}function S(){l.clear(),m()}function x(e,t){i.dataRange&&(S(),t.needRefresh=!0);return}function T(){var e=l.deepQuery([r],"animationDuration"),t=l.deepQuery([r],"animationEasing"),i,s,o;for(var u=0,a=l.shapeList.length;u<a;u++)i=l.shapeList[u]._x||0,s=l.shapeList[u]._y||0,n.modShape(l.shapeList[u].id,{scale:[0,0,i,s]}),n.animate(l.shapeList[u].id,"").when(l.deepQuery([o],"animationDuration")||e,{scale:[1,1,i,s]},l.deepQuery([o],"animationEasing")||t).start()}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=e("zrender/tool/color"),l=this;l.type=u.CHART_TYPE_SCATTER;var c,h=l.getZlevelBase(),p={},d=["circle","rectangle","triangle","diamond","emptyCircle","emptyRectangle","emptyTriangle","emptyDiamond"],v={};l.init=E,l.refresh=S,l.ondataRange=x,l.animation=T,E(r,i)}return e("../util/shape/symbol"),e("../chart").define("scatter",t),t}),define("echarts/util/shape/candle",["require","zrender/tool/matrix","zrender/shape/base","zrender/shape"],function(e){function n(){this.type="candle"}var t=e("zrender/tool/matrix");return n.prototype={_numberOrder:function(e,t){return t-e},buildPath:function(e,t){t.y.sort(this._numberOrder),e.moveTo(t.x,t.y[3]),e.lineTo(t.x,t.y[2]),e.moveTo(t.x-t.width/2,t.y[2]),e.rect(t.x-t.width/2,t.y[2],t.width,t.y[1]-t.y[2]),e.moveTo(t.x,t.y[1]),e.lineTo(t.x,t.y[0]);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.width/2-t/2),y:Math.round(e.y[3]-t/2),width:e.width+t,height:e.y[0]-e.y[3]+t}},isCover:function(e,n,r){if(e.__needTransform&&e._transform){var i=[];t.invert(i,e._transform);var s=[n,r];t.mulVector(s,i,[n,r,1]),n==s[0]&&r==s[1]&&(Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1),n=s[0],r=s[1]}var o;return e.style.__rect?o=e.style.__rect:(o=this.getRect(e.style),o=[o.x,o.x+o.width,o.y,o.y+o.height],e.style.__rect=o),n>=o[0]&&n<=o[1]&&r>=o[2]&&r<=o[3]?!0:!1}},e("zrender/shape/base").derive(n),e("zrender/shape").define("candle",new n),n}),define("echarts/chart/k",["require","../component/base","./calculableBase","../config","../util/ecData","../util/shape/candle","../chart"],function(e){function t(t,n,r,i){function h(){f.selectedMap={};var e={top:[],bottom:[]},t;for(var r=0,s=l.length;r<s;r++)l[r].type==u.CHART_TYPE_K&&(l[r]=f.reformOption(l[r]),t=i.xAxis.getAxis(l[r].xAxisIndex),t.type==u.COMPONENT_TYPE_AXIS_CATEGORY&&e[t.getPosition()].push(r));for(var o in e)e[o].length>0&&p(o,e[o]);for(var r=0,s=f.shapeList.length;r<s;r++)f.shapeList[r].id=n.newShapeId(f.type),n.addShape(f.shapeList[r])}function p(e,t){var n=d(t),r=n.locationMap,i=n.maxDataLength;if(i===0||r.length===0)return;v(i,r)}function d(e){var t,n,r=i.legend,s=[],o=0;for(var u=0,a=e.length;u<a;u++)t=l[e[u]],n=t.name,r?f.selectedMap[n]=r.isSelected(n):f.selectedMap[n]=!0,f.selectedMap[n]&&s.push(e[u]),o=Math.max(o,t.data.length);return{locationMap:s,maxDataLength:o}}function v(e,t){var n,r,s,o,u,a,f={},c,h,p;for(var d=0,v=t.length;d<v;d++){n=t[d],r=l[n],s=r.xAxisIndex||0,o=i.xAxis.getAxis(s),c=Math.floor(o.getGap()/2),u=r.yAxisIndex||0,a=i.yAxis.getAxis(u),f[n]=[];for(var g=0,y=e;g<y;g++){if(typeof o.getNameByIndex(g)=="undefined")break;h=r.data[g],p=typeof h!="undefined"?typeof h.value!="undefined"?h.value:h:"-";if(p=="-"||p.length!=4)continue;f[n].push([o.getCoordByIndex(g),c,a.getCoord(p[0]),a.getCoord(p[1]),a.getCoord(p[2]),a.getCoord(p[3]),g,o.getNameByIndex(g)])}}m(f)}function m(e){var t,n,r,i,s,o,a,c,h,p,d,v,m,y,b,w;for(var E=0,S=l.length;E<S;E++){d=l[E],y=e[E];if(d.type==u.CHART_TYPE_K&&typeof y!="undefined"){v=[d],t=f.deepQuery(v,"itemStyle.normal.lineStyle.width"),n=f.deepQuery(v,"itemStyle.normal.lineStyle.color"),r=f.deepQuery(v,"itemStyle.normal.lineStyle.color0"),i=f.deepQuery(v,"itemStyle.normal.color"),s=f.deepQuery(v,"itemStyle.normal.color0"),o=f.deepQuery(v,"itemStyle.emphasis.lineStyle.width"),a=f.deepQuery(v,"itemStyle.emphasis.lineStyle.color"),c=f.deepQuery(v,"itemStyle.emphasis.lineStyle.color0"),h=f.deepQuery(v,"itemStyle.emphasis.color"),p=f.deepQuery(v,"itemStyle.emphasis.color0");for(var x=0,T=y.length;x<T;x++)b=y[x],m=d.data[b[6]],v=[m],w=b[3]>b[2],f.shapeList.push(g(E,b[6],b[7],b[0],b[1],b[2],b[3],b[4],b[5],w?f.deepQuery(v,"itemStyle.normal.color")||i:f.deepQuery(v,"itemStyle.normal.color0")||s,f.deepQuery(v,"itemStyle.normal.lineStyle.width")||t,w?f.deepQuery(v,"itemStyle.normal.lineStyle.color")||n:f.deepQuery(v,"itemStyle.normal.lineStyle.color0")||r,w?f.deepQuery(v,"itemStyle.emphasis.color")||h||i:f.deepQuery(v,"itemStyle.emphasis.color0")||p||s,f.deepQuery(v,"itemStyle.emphasis.lineStyle.width")||o||t,w?f.deepQuery(v,"itemStyle.emphasis.lineStyle.color")||a||n:f.deepQuery(v,"itemStyle.emphasis.lineStyle.color0")||c||r))}}}function g(e,t,n,r,i,s,o,u,f,h,p,d,v,m,g){var y={shape:"candle",zlevel:c,clickable:!0,style:{x:r,y:[s,o,u,f],width:i,color:h,strokeColor:d,lineWidth:p,brushType:"both"},highlightStyle:{color:v,strokeColor:g,lineWidth:m},_serieIndex:e};return a.pack(y,l[e],e,l[e].data[t],t,n),y}function y(e,t){r=e,i=t,l=r.series,f.clear(),h()}function b(){f.clear(),h()}function w(){var e=f.deepQuery([r],"animationDuration"),t=f.deepQuery([r],"animationEasing"),i,s,o;for(var u=0,a=f.shapeList.length;u<a;u++)f.shapeList[u].shape=="candle"&&(o=l[f.shapeList[u]._serieIndex],i=f.shapeList[u].style.x,s=f.shapeList[u].style.y[0],n.modShape(f.shapeList[u].id,{scale:[1,0,i,s]}),n.animate(f.shapeList[u].id,"").when(f.deepQuery([o],"animationDuration")||e,{scale:[1,1,i,s]},f.deepQuery([o],"animationEasing")||t).start())}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=this;f.type=u.CHART_TYPE_K;var l,c=f.getZlevelBase();f.init=y,f.refresh=b,f.animation=w,y(r,i)}return e("../util/shape/candle"),e("../chart").define("k",t),t}),define("zrender/tool/math",[],function(){function n(n,r){return n=(r?n*t:n).toFixed(4),typeof e.sin[n]=="undefined"&&(e.sin[n]=Math.sin(n)),e.sin[n]}function r(n,r){return n=(r?n*t:n).toFixed(4),typeof e.cos[n]=="undefined"&&(e.cos[n]=Math.cos(n)),e.cos[n]}function i(e){return e*t}function s(e){return e/t}var e={sin:{},cos:{}},t=Math.PI/180;return{sin:n,cos:r,degreeToRadian:i,radianToDegree:s}}),define("echarts/chart/pie",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/math","zrender/tool/util","../chart"],function(e){function t(t,n,r,i){function m(){c.selectedMap={},v={};var e;d=!1;for(var t=0,i=h.length;t<i;t++)h[t].type==u.CHART_TYPE_PIE&&(h[t]=c.reformOption(h[t]),d=d||h[t].selectedMode,v[t]=[],c.deepQuery([h[t],r],"calculable")&&(e={shape:h[t].radius[0]<=10?"circle":"ring",zlevel:p,hoverable:!1,style:{x:h[t].center[0],y:h[t].center[1],r0:h[t].radius[0]<=10?0:h[t].radius[0]-10,r:h[t].radius[1]+10,brushType:"stroke",strokeColor:h[t].calculableHolderColor||u.calculableHolderColor}},a.pack(e,h[t],t,undefined,-1),c.setCalculable(e),c.shapeList.push(e)),g(t));for(var t=0,i=c.shapeList.length;t<i;t++)c.shapeList[t].id=n.newShapeId(c.type),n.addShape(c.shapeList[t])}function g(e){var t=h[e],r=t.data,s=i.legend,o,u=0,a=0;for(var f=0,l=r.length;f<l;f++)o=r[f].name,s?c.selectedMap[o]=s.isSelected(o):c.selectedMap[o]=!0,c.selectedMap[o]&&(u++,a+=+r[f].value);var p,d=t.startAngle.toFixed(2)-0,v,m=t.minAngle,g=360-m*u,b;for(var f=0,l=r.length;f<l;f++){o=r[f].name;if(!c.selectedMap[o])continue;s?b=s.getColor(o):b=n.getColor(f),p=r[f].value/a,v=(p*g+d+m).toFixed(2)-0,p=(p*100).toFixed(2),y(e,f,p,r[f].selected,d,v,b),d=v}}function y(e,t,n,r,i,s,o){var u=b(e,t,n,r,i,s,o);a.pack(u,h[e],e,h[e].data[t],t,h[e].data[t].name,n),c.shapeList.push(u);var f=w(e,t,n,i,s,o,!1);f&&(f._dataIndex=t,c.shapeList.push(f));var l=S(e,t,i,s,o,!1);l&&(l._dataIndex=t,c.shapeList.push(l))}function b(e,t,n,i,s,o,u){var a=h[e],l=a.data[t],m=c.deepQuery([l,a],"itemStyle.normal.color"),g=c.deepQuery([l,a],"itemStyle.emphasis.color"),y={shape:"sector",zlevel:p,clickable:!0,style:{x:a.center[0],y:a.center[1],r0:a.radius[0],r:a.radius[1],startAngle:s,endAngle:o,brushType:"both",color:m||u,strokeColor:"#fff",lineWidth:1},highlightStyle:{color:g||m||u}};if(i){var b=((y.style.startAngle+y.style.endAngle)/2).toFixed(2)-0;y.style._hasSelected=!0,y.style._x=y.style.x,y.style._y=y.style.y;var w=c.deepQuery([a],"selectedOffset");y.style.x+=f.cos(b,!0)*w,y.style.y-=f.sin(b,!0)*w,v[e][t]=!0}else v[e][t]=!1;d&&(y.onclick=c.shapeHandler.onclick),c.deepQuery([l,a,r],"calculable")&&(c.setCalculable(y),y.draggable=!0),x(a,l,!1)&&c.deepQuery([l,a],"itemStyle.normal.label.position")=="inner"&&(y.style.text=E(e,t,n,"normal"),y.style.textPosition="specific",y.style.textColor=c.deepQuery([l,a],"itemStyle.normal.label.textStyle.color")||"#fff",y.style.textAlign=c.deepQuery([l,a],"itemStyle.normal.label.textStyle.align")||"center",y.style.textBaseLine=c.deepQuery([l,a],"itemStyle.normal.label.textStyle.baseline")||"middle",y.style.textX=Math.round(a.center[0]+(a.radius[1]+a.radius[0])/2*f.cos((s+o)/2,!0)),y.style.textY=Math.round(a.center[1]-(a.radius[1]+a.radius[0])/2*f.sin((s+o)/2,!0)),y.style.textFont=c.getFont(c.deepQuery([l,a],"itemStyle.normal.label.textStyle"))),x(a,l,!0)&&c.deepQuery([l,a],"itemStyle.emphasis.label.position")=="inner"&&(y.highlightStyle.text=E(e,t,n,"emphasis"),y.highlightStyle.textPosition="specific",y.highlightStyle.textColor=c.deepQuery([l,a],"itemStyle.emphasis.label.textStyle.color")||"#fff",y.highlightStyle.textAlign=c.deepQuery([l,a],"itemStyle.emphasis.label.textStyle.align")||"center",y.highlightStyle.textBaseLine=c.deepQuery([l,a],"itemStyle.normal.label.textStyle.baseline")||"middle",y.highlightStyle.textX=Math.round(a.center[0]+(a.radius[1]+a.radius[0])/2*f.cos((s+o)/2,!0)),y.highlightStyle.textY=Math.round(a.center[1]-(a.radius[1]+a.radius[0])/2*f.sin((s+o)/2,!0)),y.highlightStyle.textFont=c.getFont(c.deepQuery([l,a],"itemStyle.emphasis.label.textStyle")));if(x(a,l,!0)||T(a,l,!0))y.onmouseover=c.shapeHandler.onmouserover;return y}function w(e,t,n,r,i,s,o){var u=h[e],a=u.data[t];if(x(u,a,o)){var d=o?"emphasis":"normal",v=l.merge(l.clone(a.itemStyle)||{},u.itemStyle,{overwrite:!1,recursive:!0}),m=v[d].label,g=m.textStyle||{},y=u.center[0],b=u.center[1],w=(i+r)/2%360,S,T;if(m.position=="outer")return S=u.radius[1]+v[d].labelLine.length+g.fontSize,T=w>=150&&w<=210?"right":w<=30||w>=330?"left":"center",{shape:"text",zlevel:p+1,hoverable:!1,style:{x:y+S*f.cos(w,!0),y:b-S*f.sin(w,!0),color:g.color||s,text:E(e,t,n,d),textAlign:g.align||T,textBaseline:g.baseline||"middle",textFont:c.getFont(g)},highlightStyle:{brushType:"fill"}};if(m.position=="center")return{shape:"text",zlevel:p+1,hoverable:!1,style:{x:y,y:b,color:g.color||s,text:E(e,t,n,d),textAlign:g.align||"center",textBaseline:g.baseline||"middle",textFont:c.getFont(g)},highlightStyle:{brushType:"fill"}};return}return}function E(e,t,n,r){var i=h[e],s=i.data[t],o=c.deepQuery([s,i],"itemStyle."+r+".label.formatter");if(!o)return s.name;if(typeof o=="function")return o(i.name,s.name,s.value,n);if(typeof o=="string")return o=o.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}").replace("{d}","{d0}"),o=o.replace("{a0}",i.name).replace("{b0}",s.name).replace("{c0}",s.value).replace("{d0}",n),o}function S(e,t,n,r,i,s){var o=h[e],u=o.data[t];if(T(o,u,s)){var a=s?"emphasis":"normal",c=l.merge(l.clone(u.itemStyle)||{},o.itemStyle,{overwrite:!1,recursive:!0}),d=c[a].labelLine,v=d.lineStyle||{},m=o.center[0],g=o.center[1],y=o.radius[1],b=y+d.length,w=(r+n)/2%360,E=f.cos(w,!0),S=f.sin(w,!0);return{shape:"line",zlevel:p+1,hoverable:!1,style:{xStart:m+y*E,yStart:g-y*S,xEnd:m+b*E,yEnd:g-b*S,strokeColor:v.color||i,lineType:v.type,lineWidth:v.width}}}return}function x(e,t,n){return c.deepQuery([t,e],"itemStyle."+(n?"emphasis":"normal")+".label.show")}function T(e,t,n){return c.deepQuery([t,e],"itemStyle."+(n?"emphasis":"normal")+".labelLine.show")}function N(e){var t=l.merge;return e=t(e||{},u.pie,{overwrite:!1,recursive:!0}),!e.center||e.center&&!(e.center instanceof Array)?e.center=[Math.round(n.getWidth()/2),Math.round(n.getHeight()/2)]:(typeof e.center[0]=="undefined"&&(e.center[0]=Math.round(n.getWidth()/2)),typeof e.center[1]=="undefined"&&(e.center[1]=Math.round(n.getHeight()/2))),typeof e.radius=="undefined"?e.radius=[0,Math.round(Math.min(n.getWidth(),n.getHeight())/2-50)]:e.radius instanceof Array||(e.radius=[0,e.radius]),e.itemStyle.normal.label.textStyle=t(e.itemStyle.normal.label.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),e.itemStyle.emphasis.label.textStyle=t(e.itemStyle.emphasis.label.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),e}function C(e,t){r=e,i=t,h=r.series,c.clear(),m()}function k(){c.clear(),m()}function L(){var e=c.deepQuery([r],"animationDuration"),t=c.deepQuery([r],"animationEasing"),i,s,o,u,f,l;for(var h=0,p=c.shapeList.length;h<p;h++)c.shapeList[h].shape=="sector"||c.shapeList[h].shape=="circle"||c.shapeList[h].shape=="ring"?(i=c.shapeList[h].style.x,s=c.shapeList[h].style.y,o=c.shapeList[h].style.r0,u=c.shapeList[h].style.r,n.modShape(c.shapeList[h].id,{rotation:[Math.PI*2,i,s],style:{r0:0,r:0}}),f=a.get(c.shapeList[h],"series"),l=a.get(c.shapeList[h],"dataIndex"),n.animate(c.shapeList[h].id,"style").when((c.deepQuery([f],"animationDuration")||e)+l*10,{r0:o,r:u},"QuinticOut").start(),n.animate(c.shapeList[h].id,"").when((c.deepQuery([f],"animationDuration")||e)+l*100,{rotation:[0,i,s]},c.deepQuery([f],"animationEasing")||t).start()):(l=c.shapeList[h]._dataIndex,n.modShape(c.shapeList[h].id,{scale:[0,0,i,s]}),n.animate(c.shapeList[h].id,"").when(e+l*100,{scale:[1,1,i,s]},"QuinticOut").start())}function A(e){if(!c.isClick||!e.target)return;var r,i=e.target,s=i.style,o=a.get(i,"seriesIndex"),l=a.get(i,"dataIndex");for(var p=0,m=c.shapeList.length;p<m;p++)if(c.shapeList[p].id==i.id){o=a.get(i,"seriesIndex"),l=a.get(i,"dataIndex");if(!s._hasSelected){var g=((s.startAngle+s.endAngle)/2).toFixed(2)-0;i.style._hasSelected=!0,v[o][l]=!0,i.style._x=i.style.x,i.style._y=i.style.y,r=c.deepQuery([h[o]],"selectedOffset"),i.style.x+=f.cos(g,!0)*r,i.style.y-=f.sin(g,!0)*r}else i.style.x=i.style._x,i.style.y=i.style._y,i.style._hasSelected=!1,v[o][l]=!1;n.modShape(i.id,i)}else c.shapeList[p].style._hasSelected&&d=="single"&&(o=a.get(c.shapeList[p],"seriesIndex"),l=a.get(c.shapeList[p],"dataIndex"),c.shapeList[p].style.x=c.shapeList[p].style._x,c.shapeList[p].style.y=c.shapeList[p].style._y,c.shapeList[p].style._hasSelected=!1,v[o][l]=!1,n.modShape(c.shapeList[p].id,c.shapeList[p]));t.dispatch(u.EVENT.PIE_SELECTED,e.event,{selected:v}),n.refresh()}function O(e,t){if(!c.isDrop||!e.target)return;var n=e.target,s=e.dragged,o=a.get(n,"seriesIndex"),u=a.get(n,"dataIndex"),f,l=i.legend;u==-1?(f={value:a.get(s,"value"),name:a.get(s,"name")},f.value<0&&(f.value=0),h[o].data.push(f),l.add(f.name,s.style.color||s.style.strokeColor)):(f=h[o].data[u],l.del(f.name),f.name+=r.nameConnector+a.get(s,"name"),f.value+=a.get(s,"value"),l.add(f.name,s.style.color||s.style.strokeColor)),t.dragIn=t.dragIn||!0,c.isDrop=!1;return}function M(e,t){if(!c.isDragend||!e.target)return;var n=e.target,r=a.get(n,"seriesIndex"),s=a.get(n,"dataIndex");i.legend.del(h[r].data[s].name),h[r].data.splice(s,1),t.dragOut=!0,t.needRefresh=!0,c.isDragend=!1;return}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=e("zrender/tool/math"),l=e("zrender/tool/util"),c=this;c.type=u.CHART_TYPE_PIE;var h,p=c.getZlevelBase(),d,v={};c.shapeHandler.onmouserover=function(e){var t=e.target,r=a.get(t,"seriesIndex"),i=a.get(t,"dataIndex"),s=a.get(t,"special"),o=t.style.startAngle,u=t.style.endAngle,f=t.highlightStyle.color,l=w(r,i,s,o,u,f,!0);l&&n.addHoverShape(l);var c=S(r,i,o,u,f,!0);c&&n.addHoverShape(c)},c.reformOption=N,c.init=C,c.refresh=k,c.animation=L,c.onclick=A,c.ondrop=O,c.ondragend=M,C(r,i)}return e("../chart").define("pie",t),t}),define("zrender/config",{loadingEffect:"spin",EVENT:{RESIZE:"resize",CLICK:"click",MOUSEWHEEL:"mousewheel",MOUSEMOVE:"mousemove",MOUSEOVER:"mouseover",MOUSEOUT:"mouseout",MOUSEDOWN:"mousedown",MOUSEUP:"mouseup",DRAGSTART:"dragstart",DRAGEND:"dragend",DRAGENTER:"dragenter",DRAGOVER:"dragover",DRAGLEAVE:"dragleave",DROP:"drop",touchClickDelay:300}}),define("zrender/tool/event",[],function(){function e(e){return typeof e.zrenderX!="undefined"&&e.zrenderX||typeof e.offsetX!="undefined"&&e.offsetX||typeof e.layerX!="undefined"&&e.layerX||typeof e.clientX!="undefined"&&e.clientX}function t(e){return typeof e.zrenderY!="undefined"&&e.zrenderY||typeof e.offsetY!="undefined"&&e.offsetY||typeof e.layerY!="undefined"&&e.layerY||typeof e.clientY!="undefined"&&e.clientY}function n(e){return typeof e.wheelDelta!="undefined"&&e.wheelDelta||typeof e.detail!="undefined"&&-e.detail}function r(e){e.preventDefault?(e.preventDefault(),e.stopPropagation()):e.returnValue=!1}function i(){function n(n,r){return!r||!n?e:(t[n]||(t[n]=[]),t[n].push({h:r,one:!0}),e)}function r(n,r){return!r||!n?e:(t[n]||(t[n]=[]),t[n].push({h:r,one:!1}),e)}function i(n,r){if(!n)return t={},e;if(r){if(t[n]){var i=[];for(var s=0,o=t[n].length;s<o;s++)t[n][s]["h"]!=r&&i.push(t[n][s]);t[n]=i}t[n]&&t[n].length===0&&delete t[n]}else delete t[n];return e}function s(n,r,i){if(t[n]){var s=[],o=i||{};o.type=n,o.event=r;for(var u=0,a=t[n].length;u<a;u++)t[n][u].h(o),t[n][u].one||s.push(t[n][u]);s.length!=t[n].length&&(t[n]=s)}return e}var e=this,t={};e.one=n,e.bind=r,e.unbind=i,e.dispatch=s}return{getX:e,getY:t,getDelta:n,stop:r,Dispatcher:i}}),define("echarts/chart/force",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/config","zrender/tool/event","zrender/tool/util","zrender/tool/vector","../chart"],function(e){function t(t,o,u,a){function J(){var e=a.legend;B=1,z=o.getWidth(),W=o.getHeight(),X=[z/2,W/2];for(var t=0,n=y.length;t<n;t++){var r=y[t];if(r.type===c.CHART_TYPE_FORCE){y[t]=g.reformOption(y[t]),b=r;var i=g.deepQuery([r],"minRadius"),s=g.deepQuery([r],"maxRadius");R=g.deepQuery([r],"attractiveness"),F=g.deepQuery([r],"density"),initSize=g.deepQuery([r],"initSize"),q=g.deepQuery([r],"centripetal"),I=g.deepQuery([r],"coolDown"),S=g.deepQuery([r],"categories");for(var u=0,f=S.length;u<f;u++)S[u].name&&(e?g.selectedMap[u]=e.isSelected(S[u].name):g.selectedMap[u]=!0);N=g.deepQuery([r],"itemStyle.normal.linkStyle"),C=g.deepQuery([r],"itemStyle.emphasis.linkStyle"),x=g.deepQuery([r],"itemStyle.normal.nodeStyle"),T=g.deepQuery([r],"itemStyle.emphasis.nodeStyle"),K(v.clone(g.deepQuery([r],"nodes")),v.clone(g.deepQuery([r],"links"))),D=[],P=[],H=[],A=[],O=[],H=[],w=[],E=[];var l=z*W;j=.5/R*Math.sqrt(l/k.length),G(k,L),Q(k,i,s)}}}function K(e,t){var n=[],r=0;k=s(e,function(e,t){if(!e)return;if(g.selectedMap[e.category])return n[t]=r++,!0;n[t]=-1});var i,o,u;L=s(t,function(e){return i=e.source,o=e.target,u=!0,n[i]>=0?e.source=n[i]:u=!1,n[o]>=0?e.target=n[o]:u=!1,u})}function Q(e,t,s){var u=[],a=e.length;for(var f=0;f<a;f++){var l=e[f];u.push(l.value)}n(u,u,t,s),r(A,u);for(var f=0;f<a;f++){var l=e[f],c,p,d=u[f],m=i(z/2,W/2,initSize);c=typeof l.initial=="undefined"?m.x:l.initial.x,p=typeof l.initial=="undefined"?m.y:l.initial.y,D[f]=[c,p],P[f]=[c,p],M[f]=[0,0],_[f]=[0,0],H[f]=d*d*F*.035;var y={id:o.newShapeId(g.type),shape:"circle",style:{r:d,x:0,y:0},highlightStyle:{},position:[c,p],__forceIndex:f},E;g.deepQuery([b],"itemStyle.normal.label.show")&&(y.style.text=l.name,y.style.textPosition="inside",E=g.deepQuery([b],"itemStyle.normal.label.textStyle")||{},y.style.textColor=E.color||"#fff",y.style.textAlign=E.align||"center",y.style.textBaseLine=E.baseline||"middle",y.style.textFont=g.getFont(E)),g.deepQuery([b],"itemStyle.emphasis.label.show")&&(y.highlightStyle.text=l.name,y.highlightStyle.textPosition="inside",E=g.deepQuery([b],"itemStyle.emphasis.label.textStyle")||{},y.highlightStyle.textColor=E.color||"#fff",y.highlightStyle.textAlign=E.align||"center",y.highlightStyle.textBaseLine=E.baseline||"middle",y.highlightStyle.textFont=g.getFont(E)),v.merge(y.style,x),v.merge(y.highlightStyle,T);if(typeof l.category!="undefined"){var N=S[l.category];if(N){var C=N.itemStyle;C&&(C.normal&&v.merge(y.style,C.normal,{overwrite:!0}),C.emphasis&&v.merge(y.highlightStyle,C.emphasis,{overwrite:!0}))}}if(typeof l.itemStyle!="undefined"){var C=l.itemStyle;C.normal&&v.merge(y.style,C.normal,{overwrite:!0}),C.normal&&v.merge(y.highlightStyle,C.emphasis,{overwrite:!0})}g.setCalculable(y),y.ondragstart=g.shapeHandler.ondragstart,y.draggable=!0,w.push(y),g.shapeList.push(y),o.addShape(y);var k="";if(typeof l.category!="undefined"){var N=S[l.category];k=N&&N.name||""}h.pack(y,{name:k},0,l,0,l.name||"")}}function G(e,t){var n=t.length;for(var i=0;i<n;i++){var s=t[i],u=s.weight||1;O.push(u);var a={id:o.newShapeId(g.type),shape:"line",style:{xStart:0,yStart:0,xEnd:0,yEnd:0},highlightStyle:{}};v.merge(a.style,N),v.merge(a.highlightStyle,C),typeof s.itemStyle!="undefined"&&(s.itemStyle.normal&&v.merge(a.style,s.itemStyle.normal,{overwrite:!0}),s.itemStyle.emphasis&&v.merge(a.highlightStyle,s.itemStyle.emphasis,{overwrite:!0})),E.push(a),g.shapeList.push(a),o.addShape(a)}r(O,O)}function Y(){for(var e=0,t=L.length;e<t;e++){var n=L[e],r=E[e],i=w[n.source],s=w[n.target];r.style.xStart=i.position[0],r.style.yStart=i.position[1],r.style.xEnd=s.position[0],r.style.yEnd=s.position[1]}}function Z(e){var t=D.length,n=[],r=j*j;for(var i=0;i<t;i++)M[i][0]=0,M[i][1]=0;for(var i=0;i<t;i++)for(var s=i+1;s<t;s++){var o=A[i],u=A[s],a=D[i],f=D[s];m.sub(n,f,a);var l=m.length(n);if(l>500)continue;l<5&&(l=5),m.scale(n,n,1/l);var c=1*(o+u)*r/l;m.scale(n,n,c),m.sub(M[i],M[i],n),m.add(M[s],M[s],n)}for(var i=0,h=L.length;i<h;i++){var p=L[i],d=O[i],v=p.source,g=p.target,a=D[v],f=D[g];m.sub(n,f,a);var y=m.lengthSquare(n);m.normalize(n,n);var c=d*y/j;m.scale(n,n,c),m.add(M[v],M[v],n),m.sub(M[g],M[g],n)}for(var i=0,h=k.length;i<h;i++){var b=D[i];m.sub(n,X,b);var y=m.lengthSquare(n);m.normalize(n,n);var c=y/100*q;m.scale(n,n,c),m.add(M[i],M[i],n)}for(var i=0,h=_.length;i<h;i++)m.scale(_[i],M[i],1/H[i]);var E=[],S=[];for(var i=0,h=D.length;i<h;i++){if(k[i].fixed){D[i][0]=V,D[i][1]=$,P[i][0]=V,P[i][1]=$,w[i].position[0]=V,w[i].position[1]=$;continue}var b=D[i],x=P[i];m.sub(E,b,x),x[0]=b[0],x[1]=b[1],m.add(E,E,m.scale(S,_[i],e)),m.scale(E,E,B),E[0]=Math.max(Math.min(E[0],100),-100),E[1]=Math.max(Math.min(E[1],100),-100),m.add(b,b,E),w[i].position[0]=b[0],w[i].position[1]=b[1];if(isNaN(b[0])||isNaN(b[1]))throw new Error("NaN")}}function et(){if(B<.01)return;Z(U),Y();for(var e=0;e<w.length;e++){var t=w[e];o.modShape(t.id,t)}for(var e=0;e<E.length;e++){var t=E[e];o.modShape(t.id,t)}o.refresh(),B*=I}function nt(e,t){function n(){tt&&(et(),setTimeout(n,U*1e3))}u=e,a=t,y=u.series,g.clear(),J(),tt=!0,setTimeout(n,U*1e3)}function rt(){g.clear(),J(),B=1}function it(){tt=!1}function st(e){if(!g.isDragstart||!e.target)return;var t=e.target,n=t.__forceIndex,r=k[n];r.fixed=!0,g.isDragstart=!1,o.on(p.EVENT.MOUSEMOVE,ut)}function ot(e,t){if(!g.isDragend||!e.target)return;var n=e.target,r=n.__forceIndex,i=k[r];i.fixed=!1,t.dragIn=!0,t.needRefresh=!1,g.isDragend=!1,o.un(p.EVENT.MOUSEMOVE,ut)}function ut(e){B=.8,V=d.getX(e.event),$=d.getY(e.event)}var f=e("../component/base");f.call(this,o);var l=e("./calculableBase");l.call(this,o,u);var c=e("../config"),h=e("../util/ecData"),p=e("zrender/config"),d=e("zrender/tool/event"),v=e("zrender/tool/util"),m=e("zrender/tool/vector"),g=this;g.type=c.CHART_TYPE_FORCE;var y,b,w=[],E=[],S=[],x,T,N,C,k=[],L=[],A=[],O=[],M=[],_=[],D=[],P=[],H=[],B,j,F,I,q,R,U=1/60,z,W,X=[],V,$,tt;g.shapeHandler.ondragstart=function(){g.isDragstart=!0},g.init=nt,g.refresh=rt,g.ondragstart=st,g.ondragend=ot,g.dispose=it,nt(u,a)}function n(e,t,n,r){var i=t[0],s=t[0],o=t.length;for(var u=1;u<o;u++){var a=t[u];a<i&&(i=a),a>s&&(s=a)}var f=s-i,l=r-n;for(var u=0;u<o;u++)if(f===0)e[u]=n;else{var a=t[u],c=(a-i)/f;e[u]=l*c+n}}function r(e,t){var n=t.length,r=t[0];for(var i=1;i<n;i++)t[i]>r&&(r=t[i]);for(var i=0;i<n;i++)e[i]=t[i]/r}function i(e,t,n){return{x:(Math.random()-.5)*n+e,y:(Math.random()-.5)*n+t}}function s(e,t){var n=e.length,r=[];for(var i=0;i<n;i++)t(e[i],i)&&r.push(e[i]);return r}return e("../chart").define("force",t),t}),define("zrender/shape/circle",["require","./base","../shape"],function(e){function t(){this.type="circle"}t.prototype={buildPath:function(e,t){e.arc(t.x,t.y,t.r,0,Math.PI*2,!0);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("circle",new t),t}),define("zrender/shape/ellipse",["require","./base","../shape"],function(e){function t(){this.type="ellipse"}t.prototype={buildPath:function(e,t){var n=t.a>t.b?t.a:t.b,r=t.a/n,i=t.b/n;e.scale(r,i),e.arc(t.x/r,t.y/i,n,0,Math.PI*2,!0),e.scale(1/r,1/i);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.a-t/2),y:Math.round(e.y-e.b-t/2),width:e.a*2+t,height:e.b*2+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("ellipse",new t),t}),define("zrender/shape/line",["require","./base","../shape"],function(e){function t(){this.type="line",this.brushTypeOnly="stroke",this.textPosition="end"}t.prototype={buildPath:function(e,t){if(!t.lineType||t.lineType=="solid")e.moveTo(t.xStart,t.yStart),e.lineTo(t.xEnd,t.yEnd);else if(t.lineType=="dashed"||t.lineType=="dotted"){var n=t.lineWidth||1,r=[n*(t.lineType=="dashed"?6:1),n*4],i=t.xStart,s=t.xEnd,o=t.yStart,u=t.yEnd,a=s-i,f=u-o,l=Math.atan2(f,a),c=i,h=o,p=0,d=!0,v,m,g;e.moveTo(i,o);while(!(a<0?c<=s:c>=s)||!(f<0?h<=u:h>=u))v=r[p++%r.length],m=c+Math.cos(l)*v,c=a<0?Math.max(s,m):Math.min(s,m),g=h+Math.sin(l)*v,h=f<0?Math.max(u,g):Math.min(u,g),d?e.lineTo(c,h):e.moveTo(c,h),d=!d}},getRect:function(e){var t=e.lineWidth||1;return{x:Math.min(e.xStart,e.xEnd)-t,y:Math.min(e.yStart,e.yEnd)-t,width:Math.abs(e.xStart-e.xEnd)+t,height:Math.abs(e.yStart-e.yEnd)+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("line",new t),t}),define("zrender/shape/polygon",["require","./base","../shape"],function(e){function t(){this.type="polygon"}t.prototype={buildPath:function(e,t){var n=t.pointList;e.moveTo(n[0][0],n[0][1]);for(var r=1,i=n.length;r<i;r++)e.lineTo(n[r][0],n[r][1]);e.lineTo(n[0][0],n[0][1]);return},getRect:function(e){var t=Number.MAX_VALUE,n=Number.MIN_VALUE,r=Number.MAX_VALUE,i=Number.MIN_VALUE,s=e.pointList;for(var o=0,u=s.length;o<u;o++)s[o][0]<t&&(t=s[o][0]),s[o][0]>n&&(n=s[o][0]),s[o][1]<r&&(r=s[o][1]),s[o][1]>i&&(i=s[o][1]);var a;return e.brushType=="stroke"||e.brushType=="fill"?a=e.lineWidth||1:a=0,{x:Math.round(t-a/2),y:Math.round(r-a/2),width:n-t+a,height:i-r+a}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("polygon",new t),t}),define("zrender/shape/brokenLine",["require","../shape","./base","../shape"],function(e){function t(){this.type="brokenLine",this.brushTypeOnly="stroke",this.textPosition="end"}t.prototype={buildPath:function(e,t){var n=t.pointList;if(n.length<2)return;if(!t.lineType||t.lineType=="solid"){e.moveTo(n[0][0],n[0][1]);for(var r=1,i=n.length;r<i;r++)e.lineTo(n[r][0],n[r][1])}else if(t.lineType=="dashed"||t.lineType=="dotted"){var s=t.lineWidth||1,o=[s*(t.lineType=="dashed"?6:1),s*4];e.moveTo(n[0][0],n[0][1]);for(var r=1,i=n.length;r<i;r++){var u=n[r-1][0],a=n[r][0],f=n[r-1][1],l=n[r][1],c=a-u,h=l-f,p=Math.atan2(h,c),d=u,v=f,m=0,g=!0,y,b,w;while(!(c<0?d<=a:d>=a)||!(h<0?v<=l:v>=l))y=o[m++%o.length],b=d+Math.cos(p)*y,d=c<0?Math.max(a,b):Math.min(a,b),w=v+Math.sin(p)*y,v=h<0?Math.max(l,w):Math.min(l,w),g?e.lineTo(d,v):e.moveTo(d,v),g=!g}}return},getRect:function(t){var n=e("../shape");return n.get("polygon").getRect(t)}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("brokenLine",new t),t}),define("zrender/shape/rectangle",["require","./base","../shape"],function(e){function t(){this.type="rectangle"}t.prototype={_buildRadiusPath:function(e,t){var n=t.x,r=t.y,i=t.width,s=t.height,o=t.radius,u,a,f,l;typeof o=="number"?u=a=f=l=o:o instanceof Array?o.length===1?u=a=f=l=o[0]:o.length===2?(u=f=o[0],a=l=o[1]):o.length===3?(u=o[0],a=l=o[1],f=o[2]):(u=o[0],a=o[1],f=o[2],l=o[3]):u=a=f=l=0,e.moveTo(n+u,r),e.lineTo(n+i-a,r),a!==0&&e.quadraticCurveTo(n+i,r,n+i,r+a),e.lineTo(n+i,r+s-f),f!==0&&e.quadraticCurveTo(n+i,r+s,n+i-f,r+s),e.lineTo(n+l,r+s),l!==0&&e.quadraticCurveTo(n,r+s,n,r+s-l),e.lineTo(n,r+u),u!==0&&e.quadraticCurveTo(n,r,n+u,r)},buildPath:function(e,t){t.radius?this._buildRadiusPath(e,t):(e.moveTo(t.x,t.y),e.lineTo(t.x+t.width,t.y),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x,t.y));return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-t/2),y:Math.round(e.y-t/2),width:e.width+t,height:e.height+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("rectangle",new t),t}),define("zrender/shape/ring",["require","../shape","./base","../shape"],function(e){function t(){this.type="ring"}t.prototype={buildPath:function(t,n){var r=e("../shape");r.get("sector").buildPath(t,{x:n.x,y:n.y,r0:n.r0,r:n.r,startAngle:0,endAngle:360});return},brush:function(e,t,n){var r=t.style||{};n&&(r=this.getHighlightStyle(r,t.highlightStyle||{})),e.save(),this.setContext(e,r),t.__needTransform&&e.transform.apply(e,this.updateTransform(t)),e.beginPath(),this.buildPath(e,r),e.closePath(),r.brushType=r.brushType||"fill",(r.brushType=="fill"||r.brushType=="both")&&e.fill();if(r.brushType=="stroke"||r.brushType=="both")e.beginPath(),e.moveTo(r.r0+r.x,r.y),e.arc(r.x,r.y,r.r0,0,Math.PI*2,!0),e.moveTo(r.r+r.x,r.y),e.arc(r.x,r.y,r.r,0,Math.PI*2,!0),e.closePath(),e.stroke();r.text&&this.drawText(e,r,t.style),e.restore();return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("ring",new t),t}),define("zrender/shape/sector",["require","../tool/math","../shape","./base","../shape"],function(e){function n(){this.type="sector"}var t=e("../tool/math");n.prototype={buildPath:function(e,n){var r=n.x,i=n.y,s=typeof n.r0=="undefined"?0:n.r0,o=n.r,u=n.startAngle,a=n.endAngle,f=Math.PI*2;u=t.degreeToRadian(u),a=t.degreeToRadian(a),e.moveTo(t.cos(u)*s+r,i-t.sin(u)*s),e.lineTo(t.cos(u)*o+r,i-t.sin(u)*o),e.arc(r,i,o,f-u,f-a,!0),e.lineTo(t.cos(a)*s+r,i-t.sin(a)*s),s!==0&&e.arc(r,i,s,f-a,f-u,!1);return},getRect:function(n){var r=n.x,i=n.y,s=typeof n.r0=="undefined"?0:n.r0,o=n.r,u=n.startAngle,a=n.endAngle,f=[];u<90&&a>90&&f.push([r,i-o]),u<180&&a>180&&f.push([r-o,i]),u<270&&a>270&&f.push([r,i+o]),u<360&&a>360&&f.push([r+o,i]),u=t.degreeToRadian(u),a=t.degreeToRadian(a),f.push([t.cos(u)*s+r,i-t.sin(u)*s]),f.push([t.cos(u)*o+r,i-t.sin(u)*o]),f.push([t.cos(a)*o+r,i-t.sin(a)*o]),f.push([t.cos(a)*s+r,i-t.sin(a)*s]);var l=e("../shape");return l.get("polygon").getRect({brushType:n.brushType,lineWidth:n.lineWidth,pointList:f})}};var r=e("./base");r.derive(n);var i=e("../shape");return i.define("sector",new n),n}),define("zrender/shape/text",["require","../tool/area","./base","../shape"],function(e){function t(){this.type="text"}t.prototype={brush:function(e,t,n){var r=t.style||{};n&&(r=this.getHighlightStyle(r,t.highlightStyle||{})),e.save(),this.setContext(e,r),t.__needTransform&&e.transform.apply(e,this.updateTransform(t)),r.textFont&&(e.font=r.textFont),e.textAlign=r.textAlign||"start",e.textBaseline=r.textBaseline||"middle";if(r.maxWidth)switch(r.brushType){case"fill":e.fillText(r.text,r.x,r.y,r.maxWidth);break;case"stroke":e.strokeText(r.text,r.x,r.y,r.maxWidth);break;case"both":e.strokeText(r.text,r.x,r.y,r.maxWidth),e.fillText(r.text,r.x,r.y,r.maxWidth);break;default:e.fillText(r.text,r.x,r.y,r.maxWidth)}else switch(r.brushType){case"fill":e.fillText(r.text,r.x,r.y);break;case"stroke":e.strokeText(r.text,r.x,r.y);break;case"both":e.strokeText(r.text,r.x,r.y),e.fillText(r.text,r.x,r.y);break;default:e.fillText(r.text,r.x,r.y)}e.restore();return},getRect:function(t){var n=e("../tool/area"),r=n.getTextWidth(t.text,t.textFont),i=n.getTextWidth("国",t.textFont),s=t.x;t.textAlign=="end"||t.textAlign=="right"?s-=r:t.textAlign=="center"&&(s-=r/2);var o=t.y-i/2;return t.textBaseline=="top"?o+=i/2:t.textBaseline=="bottom"&&(s-=i/2),{x:s,y:o,width:r,height:i}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("text",new t),t}),define("zrender/shape/heart",["require","./base","../shape"],function(e){function t(){this.type="heart"}t.prototype={buildPath:function(e,t){e.moveTo(t.x,t.y),e.bezierCurveTo(t.x+t.a/2,t.y-t.b*2/3,t.x+t.a*2,t.y+t.b/3,t.x,t.y+t.b),e.bezierCurveTo(t.x-t.a*2,t.y+t.b/3,t.x-t.a/2,t.y-t.b*2/3,t.x,t.y);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.a-t/2),y:Math.round(e.y-e.b/4-t/2),width:e.a*2+t,height:e.b*5/4+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("heart",new t),t}),define("zrender/shape/droplet",["require","./base","../shape"],function(e){function t(){this.type="droplet"}t.prototype={buildPath:function(e,t){e.moveTo(t.x,t.y+t.a),e.bezierCurveTo(t.x+t.a,t.y+t.a,t.x+t.a*3/2,t.y-t.a/3,t.x,t.y-t.b),e.bezierCurveTo(t.x-t.a*3/2,t.y-t.a/3,t.x-t.a,t.y+t.a,t.x,t.y+t.a);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.a-t/2),y:Math.round(e.y-e.b-t/2),width:e.a*2+t,height:e.a+e.b+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("droplet",new t),t}),define("zrender/shape/path",["require","./base","../shape"],function(e){function t(){this.type="path"}t.prototype={_parsePathData:function(e){if(!e)return[];var t=e,n=["m","M","l","L","v","V","h","H","z","Z","c","C","q","Q","t","T","s","S","a","A"];t=t.replace(/  /g," "),t=t.replace(/ /g,","),t=t.replace(/,,/g,",");var r;for(r=0;r<n.length;r++)t=t.replace(new RegExp(n[r],"g"),"|"+n[r]);var i=t.split("|"),s=[],o=0,u=0;for(r=1;r<i.length;r++){var a=i[r],f=a.charAt(0);a=a.slice(1),a=a.replace(new RegExp("e,-","g"),"e-");var l=a.split(",");l.length>0&&l[0]===""&&l.shift();for(var c=0;c<l.length;c++)l[c]=parseFloat(l[c]);while(l.length>0){if(isNaN(l[0]))break;var h=null,p=[],d,v,m,g,y,b,w,E,S=o,x=u;switch(f){case"l":o+=l.shift(),u+=l.shift(),h="L",p.push(o,u);break;case"L":o=l.shift(),u=l.shift(),p.push(o,u);break;case"m":o+=l.shift(),u+=l.shift(),h="M",p.push(o,u),f="l";break;case"M":o=l.shift(),u=l.shift(),h="M",p.push(o,u),f="L";break;case"h":o+=l.shift(),h="L",p.push(o,u);break;case"H":o=l.shift(),h="L",p.push(o,u);break;case"v":u+=l.shift(),h="L",p.push(o,u);break;case"V":u=l.shift(),h="L",p.push(o,u);break;case"C":p.push(l.shift(),l.shift(),l.shift(),l.shift()),o=l.shift(),u=l.shift(),p.push(o,u);break;case"c":p.push(o+l.shift(),u+l.shift(),o+l.shift(),u+l.shift()),o+=l.shift(),u+=l.shift(),h="C",p.push(o,u);break;case"S":d=o,v=u,m=s[s.length-1],m.command==="C"&&(d=o+(o-m.points[2]),v=u+(u-m.points[3])),p.push(d,v,l.shift(),l.shift()),o=l.shift(),u=l.shift(),h="C",p.push(o,u);break;case"s":d=o,v=u,m=s[s.length-1],m.command==="C"&&(d=o+(o-m.points[2]),v=u+(u-m.points[3])),p.push(d,v,o+l.shift(),u+l.shift()),o+=l.shift(),u+=l.shift(),h="C",p.push(o,u);break;case"Q":p.push(l.shift(),l.shift()),o=l.shift(),u=l.shift(),p.push(o,u);break;case"q":p.push(o+l.shift(),u+l.shift()),o+=l.shift(),u+=l.shift(),h="Q",p.push(o,u);break;case"T":d=o,v=u,m=s[s.length-1],m.command==="Q"&&(d=o+(o-m.points[0]),v=u+(u-m.points[1])),o=l.shift(),u=l.shift(),h="Q",p.push(d,v,o,u);break;case"t":d=o,v=u,m=s[s.length-1],m.command==="Q"&&(d=o+(o-m.points[0]),v=u+(u-m.points[1])),o+=l.shift(),u+=l.shift(),h="Q",p.push(d,v,o,u);break;case"A":g=l.shift(),y=l.shift(),b=l.shift(),w=l.shift(),E=l.shift(),S=o,x=u,o=l.shift(),u=l.shift(),h="A",p=this._convertPoint(S,x,o,u,w,E,g,y,b);break;case"a":g=l.shift(),y=l.shift(),b=l.shift(),w=l.shift(),E=l.shift(),S=o,x=u,o+=l.shift(),u+=l.shift(),h="A",p=this._convertPoint(S,x,o,u,w,E,g,y,b)}s.push({command:h||f,points:p})}(f==="z"||f==="Z")&&s.push({command:"z",points:[]})}return s},_convertPoint:function(e,t,n,r,i,s,o,u,a){var f=a*(Math.PI/180),l=Math.cos(f)*(e-n)/2+Math.sin(f)*(t-r)/2,c=-1*Math.sin(f)*(e-n)/2+Math.cos(f)*(t-r)/2,h=l*l/(o*o)+c*c/(u*u);h>1&&(o*=Math.sqrt(h),u*=Math.sqrt(h));var p=Math.sqrt((o*o*u*u-o*o*c*c-u*u*l*l)/(o*o*c*c+u*u*l*l));i===s&&(p*=-1),isNaN(p)&&(p=0);var d=p*o*c/u,v=p*-u*l/o,m=(e+n)/2+Math.cos(f)*d-Math.sin(f)*v,g=(t+r)/2+Math.sin(f)*d+Math.cos(f)*v,y=function(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])},b=function(e,t){return(e[0]*t[0]+e[1]*t[1])/(y(e)*y(t))},w=function(e,t){return(e[0]*t[1]<e[1]*t[0]?-1:1)*Math.acos(b(e,t))},E=w([1,0],[(l-d)/o,(c-v)/u]),S=[(l-d)/o,(c-v)/u],x=[(-1*l-d)/o,(-1*c-v)/u],T=w(S,x);return b(S,x)<=-1&&(T=Math.PI),b(S,x)>=1&&(T=0),s===0&&T>0&&(T-=2*Math.PI),s===1&&T<0&&(T+=2*Math.PI),[m,g,o,u,E,T,f,s]},buildPath:function(e,t){var n=t.path,r=this._parsePathData(n),i=t.x||0,s=t.y||0,o,u=t.pointList=[],a=[];for(var f=0,l=r.length;f<l;f++){r[f].command.toUpperCase()=="M"&&(a.length>0&&u.push(a),a=[]),o=r[f].points;for(var c=0,h=o.length;c<h;c+=2)a.push([o[c]+i,o[c+1]+s])}a.length>0&&u.push(a);var p;for(var f=0,l=r.length;f<l;f++){p=r[f].command,o=r[f].points;for(var c=0,h=o.length;c<h;c++)c%2===0?o[c]+=i:o[c]+=s;switch(p){case"L":e.lineTo(o[0],o[1]);break;case"M":e.moveTo(o[0],o[1]);break;case"C":e.bezierCurveTo(o[0],o[1],o[2],o[3],o[4],o[5]);break;case"Q":e.quadraticCurveTo(o[0],o[1],o[2],o[3]);break;case"A":var d=o[0],v=o[1],m=o[2],g=o[3],y=o[4],b=o[5],w=o[6],E=o[7],S=m>g?m:g,x=m>g?1:m/g,T=m>g?g/m:1;e.translate(d,v),e.rotate(w),e.scale(x,T),e.arc(0,0,S,y,y+b,1-E),e.scale(1/x,1/T),e.rotate(-w),e.translate(-d,-v);break;case"z":e.closePath()}}return},getRect:function(e){var t;e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0;var n=Number.MAX_VALUE,r=Number.MIN_VALUE,i=Number.MAX_VALUE,s=Number.MIN_VALUE,o=e.x||0,u=e.y||0,a=this._parsePathData(e.path);for(var f=0;f<a.length;f++){var l=a[f].points;for(var c=0;c<l.length;c++)c%2===0?(l[c]+o<n&&(n=l[c]+o),l[c]+o>r&&(r=l[c]+o)):(l[c]+u<i&&(i=l[c]+u),l[c]+u>s&&(s=l[c]+u))}var h;return n===Number.MAX_VALUE||r===Number.MIN_VALUE||i===Number.MAX_VALUE||s===Number.MIN_VALUE?h={x:0,y:0,width:0,height:0}:h={x:Math.round(n-t/2),y:Math.round(i-t/2),width:r-n+t,height:s-i+t},h}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("path",new t),t}),define("zrender/shape/image",["require","./base","../shape"],function(e){function i(){this.type="image"}var t={},n=[],r;i.prototype={brush:function(e,i,s,o){var u=i.style||{};s&&(u=this.getHighlightStyle(u,i.highlightStyle||{}));var a=u.image;if(typeof a=="string"){var f=a;t[f]?a=t[f]:(a=document.createElement("image"),a.onload=function(){a.onload=null,clearTimeout(r),n.push(i),r=setTimeout(function(){o(n),n=[]},10)},t[f]=a,a.src=f)}if(a){if(window.ActiveXObject){if(a.readyState!="complete")return}else if(!a.complete)return;e.save(),this.setContext(e,u),i.__needTransform&&e.transform.apply(e,this.updateTransform(i));var l=u.width||a.width,c=u.height||a.height,h=u.x,p=u.y;if(u.sWidth&&u.sHeight){var d=u.sx||0,v=u.sy||0;e.drawImage(a,d,v,u.sWidth,u.sHeight,h,p,l,c)}else if(u.sx&&u.sy){var d=u.sx,v=u.sy,m=l-d,g=c-v;e.drawImage(a,d,v,m,g,h,p,l,c)}else e.drawImage(a,h,p,l,c);u.width=l,u.height=c,i.style.width=l,i.style.height=c,u.text&&this.drawText(e,u,i.style),e.restore()}return},buildPath:function(e,t){e.rect(t.x,t.y,t.width,t.height);return},getRect:function(e){return{x:e.x,y:e.y,width:e.width,height:e.height}}};var s=e("./base");s.derive(i);var o=e("../shape");return o.define("image",new i),i}),define("zrender/shape/beziercurve",["require","./base","../shape"],function(e){function t(){this.type="beziercurve",this.brushTypeOnly="stroke",this.textPosition="end"}t.prototype={buildPath:function(e,t){e.moveTo(t.xStart,t.yStart),typeof t.cpX2!="undefined"&&typeof t.cpY2!="undefined"?e.bezierCurveTo(t.cpX1,t.cpY1,t.cpX2,t.cpY2,t.xEnd,t.yEnd):e.quadraticCurveTo(t.cpX1,t.cpY1,t.xEnd,t.yEnd)},getRect:function(e){var t=Math.min(e.xStart,e.xEnd,e.cpX1),n=Math.min(e.yStart,e.yEnd,e.cpY1),r=Math.max(e.xStart,e.xEnd,e.cpX1),i=Math.max(e.yStart,e.yEnd,e.cpY1),s=e.cpX2,o=e.cpY2;typeof s!="undefined"&&typeof o!="undefined"&&(t=Math.min(t,s),n=Math.min(n,o),r=Math.max(r,s),i=Math.max(i,o));var u=e.lineWidth||1;return{x:t-u,y:n-u,width:r-t+u,height:i-n+u}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("beziercurve",new t),t}),define("zrender/shape/star",["require","../tool/math","./base","../shape"],function(e){function s(){this.type="heart"}var t=e("../tool/math"),n=t.sin,r=t.cos,i=Math.PI;s.prototype={buildPath:function(e,t){var s=t.n;if(!s||s<2)return;var o=t.x,u=t.y,a=t.r,f=t.r0;f==null&&(f=s>4?a*r(2*i/s)/r(i/s):a/3);var l=i/s,c=-i/2,h=o+a*r(c),p=u+a*n(c);c+=l;var d=t.pointList=[];d.push([h,p]);for(var v=0,m=s*2-1,g;v<m;v++)g=v%2===0?f:a,d.push([o+g*r(c),u+g*n(c)]),c+=l;d.push([h,p]),e.moveTo(d[0][0],d[0][1]);for(var v=0;v<d.length;v++)e.lineTo(d[v][0],d[v][1]);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var o=e("./base");o.derive(s);var u=e("../shape");return u.define("star",new s),s}),define("zrender/shape/isogon",["require","../tool/math","./base","../shape"],function(e){function s(){this.type="isogon"}var t=e("../tool/math"),n=t.sin,r=t.cos,i=Math.PI;s.prototype={buildPath:function(e,t){var s=t.n;if(!s||s<2)return;var o=t.x,u=t.y,a=t.r,f=2*i/s,l=-i/2,c=o+a*r(l),h=u+a*n(l);l+=f;var p=t.pointList=[];p.push([c,h]);for(var d=0,v=s-1;d<v;d++)p.push([o+a*r(l),u+a*n(l)]),l+=f;p.push([c,h]),e.moveTo(p[0][0],p[0][1]);for(var d=0;d<p.length;d++)e.lineTo(p[d][0],p[d][1]);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var o=e("./base");o.derive(s);var u=e("../shape");return u.define("isogon",new s),s}),define("zrender/animation/easing",[],function(){var e={Linear:function(e){return e},QuadraticIn:function(e){return e*e},QuadraticOut:function(e){return e*(2-e)},QuadraticInOut:function(e){return(e*=2)<1?.5*e*e:-0.5*(--e*(e-2)-1)},CubicIn:function(e){return e*e*e},CubicOut:function(e){return--e*e*e+1},CubicInOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)},QuarticIn:function(e){return e*e*e*e},QuarticOut:function(e){return 1- --e*e*e*e},QuarticInOut:function(e){return(e*=2)<1?.5*e*e*e*e:-0.5*((e-=2)*e*e*e-2)},QuinticIn:function(e){return e*e*e*e*e},QuinticOut:function(e){return--e*e*e*e*e+1},QuinticInOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)},SinusoidalIn:function(e){return 1-Math.cos(e*Math.PI/2)},SinusoidalOut:function(e){return Math.sin(e*Math.PI/2)},SinusoidalInOut:function(e){return.5*(1-Math.cos(Math.PI*e))},ExponentialIn:function(e){return e===0?0:Math.pow(1024,e-1)},ExponentialOut:function(e){return e===1?1:1-Math.pow(2,-10*e)},ExponentialInOut:function(e){return e===0?0:e===1?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(-Math.pow(2,-10*(e-1))+2)},CircularIn:function(e){return 1-Math.sqrt(1-e*e)},CircularOut:function(e){return Math.sqrt(1- --e*e)},CircularInOut:function(e){return(e*=2)<1?-0.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)},ElasticIn:function(e){var t,n=.1,r=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,t=r/4):t=r*Math.asin(1/n)/(2*Math.PI),-(n*Math.pow(2,10*(e-=1))*Math.sin((e-t)*2*Math.PI/r)))},ElasticOut:function(e){var t,n=.1,r=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,t=r/4):t=r*Math.asin(1/n)/(2*Math.PI),n*Math.pow(2,-10*e)*Math.sin((e-t)*2*Math.PI/r)+1)},ElasticInOut:function(e){var t,n=.1,r=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,t=r/4):t=r*Math.asin(1/n)/(2*Math.PI),(e*=2)<1?-0.5*n*Math.pow(2,10*(e-=1))*Math.sin((e-t)*2*Math.PI/r):n*Math.pow(2,-10*(e-=1))*Math.sin((e-t)*2*Math.PI/r)*.5+1)},BackIn:function(e){var t=1.70158;return e*e*((t+1)*e-t)},BackOut:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},BackInOut:function(e){var t=2.5949095;return(e*=2)<1?.5*e*e*((t+1)*e-t):.5*((e-=2)*e*((t+1)*e+t)+2)},BounceIn:function(t){return 1-e.BounceOut(1-t)},BounceOut:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},BounceInOut:function(t){return t<.5?e.BounceIn(t*2)*.5:e.BounceOut(t*2-1)*.5+.5}};return e}),define("zrender/animation/controller",["require","./easing"],function(e){var t=e("./easing"),n=function(e){this._targetPool=e.target||{},this._targetPool.constructor!=Array&&(this._targetPool=[this._targetPool]),this._life=e.life||1e3,this._delay=e.delay||0,this._startTime=(new Date).getTime()+this._delay,this._endTime=this._startTime+this._life*1e3,this.loop=typeof e.loop=="undefined"?!1:e.loop,this.gap=e.gap||0,this.easing=e.easing||"Linear",this.onframe=e.onframe||null,this.ondestroy=e.ondestroy||null,this.onrestart=e.onrestart||null};return n.prototype={step:function(e){var n=(e-this._startTime)/this._life;if(n<0)return;n=Math.min(n,1);var r=typeof this.easing=="string"?t[this.easing]:this.easing,i;return typeof r=="function"?i=r(n):i=n,this.fire("frame",i),n==1?this.loop?(this.restart(),"restart"):(this._needsRemove=!0,"destroy"):null},restart:function(){this._startTime=(new Date).getTime()+this.gap},fire:function(e,t){for(var n=0,r=this._targetPool.length;n<r;n++)this["on"+e]&&this["on"+e](this._targetPool[n],t)}},n.prototype.constructor=n,n}),define("zrender/animation/animation",["require","./controller","../tool/util"],function(e){function s(e,t){return e[t]}function o(e,t,n){e[t]=n}function u(e,t,n,r,i,s,o){if(e instanceof Array&&t instanceof Array){var a=Math.min(e.length,t.length),f,l,c=[];a===e.length?(l=t.length,f=t):(l=e.length,f=e.length);for(var h=0;h<a;h++)c.push(u(e[h],t[h],n,s(r,i),h,s,o));for(var h=a;h<l;h++)c.push(f[h]);o(r,i,c)}else{e=parseFloat(e),t=parseFloat(t);if(!isNaN(e)&&!isNaN(t)){var p=(t-e)*n+e;return o(r,i,p),p}}}function a(e,t,n,r){this._tracks={},this._target=e,this._loop=t||!1,this._getter=n||s,this._setter=r||o,this._controllerCount=0,this._delay=0,this._doneList=[],this._onframeList=[],this._controllerList=[]}function f(e){return e&&e instanceof Array?Array.prototype.slice.call(e):e}var t=e("./controller"),n=e("../tool/util"),r=window.requrestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||function(e){window.setTimeout(e,1e3/60)},i=function(e){e=e||{},this.stage=e.stage||{},this.onframe=e.onframe||function(){},this._controllerPool=[],this._running=!1};return i.prototype={add:function(e){this._controllerPool.push(e)},remove:function(e){var t=n.indexOf(this._controllerPool,e);t>=0&&this._controllerPool.splice(t,1)},update:function(){var e=(new Date).getTime(),t=this._controllerPool,n=t.length,r=[],i=[];for(var s=0;s<n;s++){var o=t[s],u=o.step(e);u&&(r.push(u),i.push(o))}this.stage&&this.stage.update&&this._controllerPool.length&&this.stage.update();var a=[];for(var s=0;s<n;s++)t[s]._needsRemove||(a.push(t[s]),t[s]._needsRemove=!1);this._controllerPool=a,n=r.length;for(var s=0;s<n;s++)i[s].fire(r[s]);this.onframe()},start:function(){function t(){e._running&&(e.update(),r(t))}var e=this;this._running=!0,r(t)},stop:function(){this._running=!1},clear:function(){this._controllerPool=[]},animate:function(e,t,n,r){var i=new a(e,t,n,r);return i.animation=this,i}},i.prototype.constructor=i,a.prototype={when:function(e,t,n){for(var r in t)this._tracks[r]||(this._tracks[r]=[],this._tracks[r].push({time:0,value:this._getter(this._target,r)})),this._tracks[r].push({time:e,value:t[r],easing:n});return this},during:function(e){return this._onframeList.push(e),this},start:function(){function s(t,n,r){var i=f(t.value),s=f(n.value);return function(t,n){u(i,s,n,t,r,e._getter,e._setter);for(var o=0;o<e._onframeList.length;o++)e._onframeList[o](t,n)}}function o(){e._controllerCount--;if(e._controllerCount===0){var t=e._doneList.length;for(var n=0;n<t;n++)e._doneList[n].call(e)}}var e=this,n,r,i;for(var a in this._tracks){n=this._delay,r=this._tracks[a];if(!r.length)continue;i=r[r.length-1].time;for(var l=0;l<r.length-1;l++){var c=r[l],h=r[l+1],p=new t({target:e._target,life:h.time-c.time,delay:n,loop:e._loop,gap:i-(h.time-c.time),easing:h.easing,onframe:s(c,h,a),ondestroy:o});this._controllerList.push(p),this._controllerCount++,n=h.time+this._delay,e.animation.add(p)}}return this},stop:function(){for(var e=0;e<this._controllerList.length;e++){var t=this._controllerList[e];this.animation.remove(t)}},delay:function(e){return this._delay=e,this},done:function(e){return this._doneList.push(e),this}},i}),define("zrender/tool/loadingEffect",["require","./util","./color","./color","./color","./color","./color","./math"],function(e){function u(e,t){n[e]=t}function a(e){return{shape:"text",highlightStyle:t.merge({x:s/2,y:o/2,text:r,textAlign:"center",textBaseline:"middle",textFont:i,color:"#333",brushType:"fill"},e,{overwrite:!0,recursive:!0})}}function f(e){return{shape:"rectangle",highlightStyle:{x:0,y:0,width:s,height:o,brushType:"fill",color:e}}}function l(e,t){return e<=t[0]?e=t[0]:e>=t[1]&&(e=t[1]),e}function c(n,r,i){var u=e("./color");n=t.merge(n,{textStyle:{color:"#888"},backgroundColor:"rgba(250, 250, 250, 0.8)",effectOption:{x:0,y:o/2-30,width:s,height:5,brushType:"fill",timeInterval:100}},{overwrite:!1,recursive:!0});var c=a(n.textStyle),h=f(n.backgroundColor),p=n.effectOption,d={shape:"rectangle",highlightStyle:t.clone(p)};d.highlightStyle.color=p.color||u.getLinearGradient(p.x,p.y,p.x+p.width,p.y+p.height,[[0,"#ff6400"],[.5,"#ffe100"],[1,"#b1ff00"]]);if(typeof n.progress!="undefined"){r(h),d.highlightStyle.width=l(n.progress,[0,1])*n.effectOption.width,r(d),r(c),i();return}return d.highlightStyle.width=0,setInterval(function(){r(h),d.highlightStyle.width<n.effectOption.width?d.highlightStyle.width+=8:d.highlightStyle.width=0,r(d),r(c),i()},p.timeInterval)}function h(e,n,r){e.effectOption=t.merge(e.effectOption||{},{x:s/2-80,y:o/2,r:18,colorIn:"#fff",colorOut:"#555",colorWhirl:"#6cf",timeInterval:50});var i=e.effectOption;e=t.merge(e,{textStyle:{color:"#888",x:i.x+i.r+10,y:i.y,textAlign:"start"},backgroundColor:"rgba(250, 250, 250, 0.8)"},{overwrite:!1,recursive:!0});var u=a(e.textStyle),l=f(e.backgroundColor),c={shape:"droplet",highlightStyle:{a:Math.round(i.r/2),b:Math.round(i.r-i.r/6),brushType:"fill",color:i.colorWhirl}},h={shape:"circle",highlightStyle:{r:Math.round(i.r/6),brushType:"fill",color:i.colorIn}},p={shape:"ring",highlightStyle:{r0:Math.round(i.r-i.r/3),r:i.r,brushType:"fill",color:i.colorOut}},d=[0,i.x,i.y];return c.highlightStyle.x=h.highlightStyle.x=p.highlightStyle.x=d[1],c.highlightStyle.y=h.highlightStyle.y=p.highlightStyle.y=d[2],setInterval(function(){n(l),n(p),d[0]-=.3,c.rotation=d,n(c),n(h),n(u),r()},i.timeInterval)}function p(n,r,i){var u=e("./color");n=t.merge(n,{textStyle:{color:"#fff"},backgroundColor:"rgba(0, 0, 0, 0.8)",effectOption:{n:30,lineWidth:1,color:"random",timeInterval:100}},{overwrite:!1,recursive:!0});var l=a(n.textStyle),c=f(n.backgroundColor),h=n.effectOption,p=h.n,d=h.lineWidth,v=[],m,g,y,b;for(var w=0;w<p;w++)y=-Math.ceil(Math.random()*1e3),g=Math.ceil(Math.random()*400),m=Math.ceil(Math.random()*o),h.color=="random"?b=u.random():b=h.color,v[w]={shape:"line",highlightStyle:{xStart:y,yStart:m,xEnd:y+g,yEnd:m,strokeColor:b,lineWidth:d},animationX:Math.ceil(Math.random()*100),len:g};return setInterval(function(){r(c);var e;for(var t=0;t<p;t++)e=v[t].highlightStyle,e.xStart>=s&&(v[t].len=Math.ceil(Math.random()*400),v[t].highlightStyle.xStart=-400,v[t].highlightStyle.xEnd=-400+v[t].len,v[t].highlightStyle.yStart=Math.ceil(Math.random()*o),v[t].highlightStyle.yEnd=v[t].highlightStyle.yStart),v[t].highlightStyle.xStart+=v[t].animationX,v[t].highlightStyle.xEnd+=v[t].animationX,r(v[t]);r(l),i()},h.timeInterval)}function d(n,r,i){var u=e("./color");n=t.merge(n,{textStyle:{color:"#888"},backgroundColor:"rgba(250, 250, 250, 0.8)",effectOption:{n:50,lineWidth:2,brushType:"stroke",color:"random",timeInterval:100}},{overwrite:!1,recursive:!0});var l=a(n.textStyle),c=f(n.backgroundColor),h=n.effectOption,p=h.n,d=h.brushType,v=h.lineWidth,m=[],g;for(var y=0;y<p;y++)h.color=="random"?g=u.alpha(u.random(),.3):g=h.color,m[y]={shape:"circle",highlightStyle:{x:Math.ceil(Math.random()*s),y:Math.ceil(Math.random()*o),r:Math.ceil(Math.random()*40),brushType:d,color:g,strokeColor:g,lineWidth:v},animationY:Math.ceil(Math.random()*20)};return setInterval(function(){r(c);var e;for(var t=0;t<p;t++)e=m[t].highlightStyle,e.y-m[t].animationY+e.r<=0&&(m[t].highlightStyle.y=o+e.r,m[t].highlightStyle.x=Math.ceil(Math.random()*s)),m[t].highlightStyle.y-=m[t].animationY,r(m[t]);r(l),i()},h.timeInterval)}function v(n,r,i){var u=e("./color");n.effectOption=t.merge(n.effectOption||{},{x:s/2-80,y:o/2,r0:9,r:15,n:18,color:"#fff",timeInterval:100});var l=n.effectOption;n=t.merge(n,{textStyle:{color:"#fff",x:l.x+l.r+10,y:l.y,textAlign:"start"},backgroundColor:"rgba(0, 0, 0, 0.8)"},{overwrite:!1,recursive:!0});var c=a(n.textStyle),h=f(n.backgroundColor),p=l.n,d=l.x,v=l.y,m=l.r0,g=l.r,y=l.color,b=[],w=Math.round(180/p);for(var E=0;E<p;E++)b[E]={shape:"sector",highlightStyle:{x:d,y:v,r0:m,r:g,startAngle:w*E*2,endAngle:w*E*2+w,color:u.alpha(y,(E+1)/p),brushType:"fill"}};var S=[0,d,v];return setInterval(function(){r(h),S[0]-=.3;for(var e=0;e<p;e++)b[e].rotation=S,r(b[e]);r(c),i()},l.timeInterval)}function m(n,r,i){var u=e("./color"),c=e("./math");n=t.merge(n,{textStyle:{color:"#07a"},backgroundColor:"rgba(250, 250, 250, 0.8)",effectOption:{x:s/2,y:o/2,r0:60,r:100,color:"#bbdcff",brushType:"fill",textPosition:"inside",textFont:"normal 30px verdana",textColor:"rgba(30, 144, 255, 0.6)",timeInterval:100}},{overwrite:!1,recursive:!0});var h=n.effectOption,p=n.textStyle;p.x=typeof p.x!="undefined"?p.x:h.x,p.y=typeof p.y!="undefined"?p.y:h.y+(h.r0+h.r)/2-5;var d=a(n.textStyle),v=f(n.backgroundColor),m=h.x,g=h.y,y=h.r0+6,b=h.r-6,w=h.color,E=u.lift(w,.1),S={shape:"ring",highlightStyle:t.clone(h)},x=[],T=u.getGradientColors(["#ff6400","#ffe100","#97ff00"],25),N=15,C=240;for(var k=0;k<16;k++)x.push({shape:"sector",highlightStyle:{x:m,y:g,r0:y,r:b,startAngle:C-N,endAngle:C,brushType:"fill",color:E},_color:u.getLinearGradient(m+y*c.cos(C,!0),g-y*c.sin(C,!0),m+y*c.cos(C-N,!0),g-y*c.sin(C-N,!0),[[0,T[k*2]],[1,T[k*2+1]]])}),C-=N;C=360;for(var k=0;k<4;k++)x.push({shape:"sector",highlightStyle:{x:m,y:g,r0:y,r:b,startAngle:C-N,endAngle:C,brushType:"fill",color:E},_color:u.getLinearGradient(m+y*c.cos(C,!0),g-y*c.sin(C,!0),m+y*c.cos(C-N,!0),g-y*c.sin(C-N,!0),[[0,T[k*2+32]],[1,T[k*2+33]]])}),C-=N;var L=0;if(typeof n.progress!="undefined"){r(v),L=l(n.progress,[0,1]).toFixed(2)*100/5,S.highlightStyle.text=L*5+"%",r(S);for(var k=0;k<20;k++)x[k].highlightStyle.color=k<L?x[k]._color:E,r(x[k]);r(d),i();return}return setInterval(function(){r(v),L+=L>=20?-20:1,r(S);for(var e=0;e<20;e++)x[e].highlightStyle.color=e<L?x[e]._color:E,r(x[e]);r(d),i()},h.timeInterval)}function g(e,t,r){var i=n.ring;return typeof e.effect=="function"?i=e.effect:typeof n[e.effect]=="function"&&(i=n[e.effect]),s=e.canvasSize.width,o=e.canvasSize.height,i(e,t,r)}function y(e){clearInterval(e)}var t=e("./util"),n,r="Loading...",i="normal 16px Arial",s,o;return n={getBackgroundShape:f,getTextShape:a,define:u,bar:c,whirling:h,dynamicLine:p,bubble:d,spin:v,ring:m,start:g,stop:y},n}),define("zrender/zrender",["require","./lib/excanvas","./shape","./shape/circle","./shape/ellipse","./shape/line","./shape/polygon","./shape/brokenLine","./shape/rectangle","./shape/ring","./shape/sector","./shape/text","./shape/heart","./shape/droplet","./shape/path","./shape/image","./shape/beziercurve","./shape/star","./shape/isogon","./animation/animation","./tool/util","./tool/util","./config","./tool/loadingEffect","./tool/loadingEffect","./config","./tool/event"],function(e){function s(t,r,i){var s=this,f=e("./shape");e("./shape/circle"),e("./shape/ellipse"),e("./shape/line"),e("./shape/polygon"),e("./shape/brokenLine"),e("./shape/rectangle"),e("./shape/ring"),e("./shape/sector"),e("./shape/text"),e("./shape/heart"),e("./shape/droplet"),e("./shape/path"),e("./shape/image"),e("./shape/beziercurve"),e("./shape/star"),e("./shape/isogon");var l;if(typeof i.shape=="undefined")l=f;else{l={};for(var c in i.shape)l[c]=i.shape[c];l.get=function(e){return l[e]||f.get(e)}}var h=new o(l),p=new u(r,h,l),d=new a(r,h,p,l),v=e("./animation/animation"),m=[],g=new v({stage:{update:function(){s.update(m)}}});g.start(),s.getId=function(){return t},s.addShape=function(e){return h.add(e),s},s.delShape=function(e){return h.del(e),s},s.modShape=function(e,t){return h.mod(e,t),s},s.addHoverShape=function(e){return h.addHover(e),s},s.render=function(e){return p.render(e),s},s.refresh=function(e){return p.refresh(e),s},s.update=function(e,t){return p.update(e,t),s},s.resize=function(){return p.resize(),s},s.animate=function(t,r,i){var s=e("./tool/util"),o=h.get(t);if(o){var u;if(r){var a=r.split("."),f=o;for(var l=0,c=a.length;l<c;l++){if(!f)continue;f=f[a[l]]}f&&(u=f)}else u=o;if(!u){n.log('Property "'+r+'" is not existed in shape '+t);return}return typeof o.__aniCount=="undefined"&&(o.__aniCount=0),o.__aniCount===0&&m.push(o),o.__aniCount++,g.animate(u,i).done(function(){o.__aniCount--;if(o.__aniCount===0){var e=s.indexOf(m,o);m.splice(e,1)}})}n.log('Shape "'+t+'" not existed')},s.showLoading=function(e){return p.showLoading(e),s},s.hideLoading=function(){return p.hideLoading(),s},s.newShapeId=function(e){return h.newShapeId(e)},s.getWidth=function(){return p.getWidth()},s.getHeight=function(){return p.getHeight()},s.toDataURL=function(e,t){return p.toDataURL(e,t)},s.on=function(e,t){return d.on(e,t),s},s.un=function(e,t){return d.un(e,t),s},s.clear=function(){return h.del(),p.clear(),s},s.dispose=function(){g.stop(),g=null,m=null,s.clear(),s=null,h.dispose(),h=null,p.dispose(),p=null,d.dispose(),d=null,n.delInstance(t);return}}function o(t){function c(e){e.hoverable||e.onclick||e.draggable||e.onmousemove||e.onmouseover||e.onmouseout||e.onmousedown||e.onmouseup||e.ondragenter||e.ondragover||e.ondragleave||e.ondrop?e.__silent=!1:e.__silent=!0,Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1,e.style=e.style||{},e.style.__rect=null}function h(e){return(e||"")+ ++s}function p(e){var t={shape:"circle",id:e.id||i.newShapeId(),zlevel:0,draggable:!1,clickable:!1,hoverable:!0,position:[0,0],rotation:[0,0,0],scale:[1,1,0,0]};return r.merge(t,e,{overwrite:!0,recursive:!0}),c(t),o[t.id]=t,u[t.zlevel]=u[t.zlevel]||[],u[t.zlevel].push(t),f=Math.max(f,t.zlevel),l[t.zlevel]=!0,i}function d(e){return o[e]}function v(e){if(typeof e!="undefined"){if(o[e]){l[o[e].zlevel]=!0;var t=u[o[e].zlevel],n=[];for(var r=0,s=t.length;r<s;r++)t[r].id!=e&&n.push(t[r]);u[o[e].zlevel]=n,delete o[e]}}else o={},u=[],a=[],f=0,l={all:!0};return i}function m(e,t){var n=o[e];return n&&(l[n.zlevel]=!0,r.merge(n,t,{overwrite:!0,recursive:!0}),c(n),l[n.zlevel]=!0,f=Math.max(f,n.zlevel)),i}function g(e,r,s){var u=o[e];u.__needTransform=!0;if(!u.ondrift||u.ondrift&&!u.ondrift(u,r,s))if(n.catchBrushException)try{t.get(u.shape).drift(u,r,s)}catch(a){n.log(a,"drift error of "+u.shape,u)}else t.get(u.shape).drift(u,r,s);return l[u.zlevel]=!0,i}function y(e){return e.rotation&&Math.abs(e.rotation[0])>1e-4||e.position&&(Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4)||e.scale&&(Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4)?e.__needTransform=!0:e.__needTransform=!1,a.push(e),i}function b(){return a=[],i}function w(){return a.length>0}function E(e,t){t||(t={hover:!1,normal:"down"});if(t.hover)for(var n=0,r=a.length;n<r;n++)if(e(a[n]))return i;var s,f;if(typeof t.normal!="undefined")switch(t.normal){case"down":for(var r=u.length-1;r>=0;r--){s=u[r];if(s){f=s.length;while(f--)if(e(s[f]))return i}}break;case"up":for(var n=0,r=u.length;n<r;n++){s=u[n];if(s){f=s.length;for(var l=0;l<f;l++)if(e(s[l]))return i}}break;default:for(var n in o)if(e(o[n]))return i}return i}function S(){return f}function x(){return l}function T(){return l={},i}function N(e){return l[e]=!0,i}function C(){o=null,u=null,a=null,i=null;return}var r=e("./tool/util"),i=this,s=0,o={},u=[],a=[],f=0,l={};i.newShapeId=h,i.add=p,i.get=d,i.del=v,i.addHover=y,i.delHover=b,i.hasHoverShape=w,i.mod=m,i.drift=g,i.iterShape=E,i.getMaxZlevel=S,i.getChangedZlevel=x,i.clearChangedZlevel=T,i.setChangedZlevle=N,i.dispose=C}function u(t,r,i){function v(){var e=t.currentStyle||document.defaultView.getComputedStyle(t);return t.clientWidth-e.paddingLeft.replace(/\D/g,"")-e.paddingRight.replace(/\D/g,"")}function m(){var e=t.currentStyle||document.defaultView.getComputedStyle(t);return t.clientHeight-e.paddingTop.replace(/\D/g,"")-e.paddingBottom.replace(/\D/g,"")}function g(){c.innerHTML="",t.innerHTML="",h=v(),p=m(),c.style.position="relative",c.style.overflow="hidden",c.style.width=h+"px",c.style.height=p+"px",t.appendChild(c),u={},a={},f=r.getMaxZlevel(),u.bg=b("bg","div"),c.appendChild(u.bg);for(var e=0;e<=f;e++)u[e]=b(e,"canvas"),c.appendChild(u[e]),G_vmlCanvasManager&&G_vmlCanvasManager.initElement(u[e]),a[e]=u[e].getContext("2d"),d!=1&&a[e].scale(d,d);u.hover=b("hover","canvas"),u.hover.id="_zrender_hover_",c.appendChild(u.hover),G_vmlCanvasManager&&G_vmlCanvasManager.initElement(u.hover),a.hover=u.hover.getContext("2d"),d!=1&&a.hover.scale(d,d)}function y(){var e=r.getMaxZlevel();if(f<e){for(var t=f+1;t<=e;t++)u[t]=b(t,"canvas"),c.insertBefore(u[t],u.hover),G_vmlCanvasManager&&G_vmlCanvasManager.initElement(u[t]),a[t]=u[t].getContext("2d"),d!=1&&a[t].scale(d,d);f=e}}function b(e,t){var n=document.createElement(t);return n.style.position="absolute",n.style.width=h+"px",n.style.height=p+"px",n.setAttribute("width",h*d),n.setAttribute("height",p*d),n.setAttribute("data-id",e),n}function w(e){return function(t){if((e.all||e[t.zlevel])&&!t.invisible){var r=a[t.zlevel];if(r){if(!t.onbrush||t.onbrush&&!t.onbrush(r,t,!1))if(n.catchBrushException)try{i.get(t.shape).brush(r,t,!1,T)}catch(s){n.log(s,"brush error of "+t.shape,t)}else i.get(t.shape).brush(r,t,!1,T)}else n.log("can not find the specific zlevel canvas!")}}}function E(e){var t=a.hover;if(!e.onbrush||e.onbrush&&!e.onbrush(t,e,!0))if(n.catchBrushException)try{i.get(e.shape).brush(t,e,!0,T)}catch(r){n.log(r,"hoverBrush error of "+e.shape,e)}else i.get(e.shape).brush(t,e,!0,T)}function S(e){return O()&&A(),y(),r.iterShape(w({all:!0}),{normal:"up"}),r.clearChangedZlevel(),typeof e=="function"&&e(),o}function x(e){y();var t=r.getChangedZlevel();if(t.all)N();else for(var n in t)a[n]&&a[n].clearRect(0,0,h*d,p*d);return r.iterShape(w(t),{normal:"up"}),r.clearChangedZlevel(),typeof e=="function"&&e(),o}function T(e,t){var n;for(var i=0,s=e.length;i<s;i++)n=e[i],r.mod(n.id,n);return x(t),o}function N(){for(var e in a){if(e=="hover")continue;a[e].clearRect(0,0,h*d,p*d)}return o}function C(){return k(),r.iterShape(E,{hover:!0}),r.delHover(),o}function k(){return a&&a.hover&&a.hover.clearRect(0,0,h*d,p*d),o}function L(t){var n=e("./tool/loadingEffect");return n.stop(l),t=t||{},t.effect=t.effect||s.loadingEffect,t.canvasSize={width:h,height:p},l=n.start(t,r.addHover,C),o.loading=!0,o}function A(){var t=e("./tool/loadingEffect");return t.stop(l),k(),o.loading=!1,o}function O(){return o.loading}function M(){return h}function _(){return p}function D(){var e,t,n;c.style.display="none",e=v(),t=m(),c.style.display="";if(h!=e||t!=p){h=e,p=t,c.style.width=h+"px",c.style.height=p+"px";for(var i in u)n=u[i],n.setAttribute("width",h),n.setAttribute("height",p),n.style.width=h+"px",n.style.height=p+"px";r.setChangedZlevle("all"),x()}return o}function P(){O()&&A(),t.innerHTML="",t=null,r=null,i=null,c=null,u=null,a=null,o=null;return}function H(){return u.hover}function B(e,t){if(G_vmlCanvasManager)return null;var s=b("image","canvas");u.bg.appendChild(s);var o=s.getContext("2d");d!=1&&o.scale(d,d),o.fillStyle="#fff",o.rect(0,0,h*d,p*d),o.fill(),r.iterShape(function(e){if(!e.invisible)if(!e.onbrush||e.onbrush&&!e.onbrush(o,e,!1))if(n.catchBrushException)try{i.get(e.shape).brush(o,e,!1,T)}catch(t){n.log(t,"brush error of "+e.shape,e)}else i.get(e.shape).brush(o,e,!1,T)},{normal:"up"});var a=s.toDataURL(e,t);return o=null,u.bg.removeChild(s),a}var s=e("./config"),o=this,u={},a={},f=0,l,c=document.createElement("div");c.onselectstart=function(){return!1};var h,p,d=window.devicePixelRatio||1;o.render=S,o.refresh=x,o.update=T,o.clear=N,o.refreshHover=C,o.clearHover=k,o.showLoading=L,o.hideLoading=A,o.isLoading=O,o.getWidth=M,o.getHeight=_,o.resize=D,o.dispose=P,o.getDomHover=H,o.toDataURL=B,g()}function a(t,n,r,i){function x(){window.addEventListener?(window.addEventListener("resize",T),t.addEventListener("click",N),t.addEventListener("mousewheel",C),t.addEventListener("DOMMouseScroll",C),t.addEventListener("mousemove",k),t.addEventListener("mouseout",L),t.addEventListener("mousedown",M),t.addEventListener("mouseup",_),t.addEventListener("touchstart",D),t.addEventListener("touchmove",P),t.addEventListener("touchend",H)):(window.attachEvent("onresize",T),t.attachEvent("onclick",N),t.attachEvent("onmousewheel",C),t.attachEvent("onmousemove",k),t.attachEvent("onmouseout",L),t.attachEvent("onmousedown",M),t.attachEvent("onmouseup",_))}function T(e){l=e||window.event,h=null,v=!1,u.dispatch(s.EVENT.RESIZE,l)}function N(e){l=W(e),h?h&&h.clickable&&U(h,s.EVENT.CLICK):U(h,s.EVENT.CLICK),k(l)}function C(e){l=W(e),U(h,s.EVENT.MOUSEWHEEL),k(l)}function k(e){if(r.isLoading())return;l=W(e),y=w,b=E,w=a(l),E=f(l),B(),c=!1,n.iterShape(z,{normal:"down"});if(!c){if(!d||h&&h.id!=d.id)O(),I();h=null,n.delHover(),r.clearHover()}d&&(n.drift(d.id,w-y,E-b),n.addHover(d)),U(h,s.EVENT.MOUSEMOVE),(d||c||n.hasHoverShape())&&r.refreshHover(),d||c&&h.draggable?t.style.cursor="move":c&&h.clickable?t.style.cursor="pointer":t.style.cursor="default"}function L(e){l=W(e);var n=l.toElement||l.relatedTarget;if(n!=t)while(n&&n.nodeType!=9){if(n==t){k(e);return}n=n.parentNode}l.zrenderX=y,l.zrenderY=b,t.style.cursor="default",v=!1,O(),q(),R(),r.isLoading()||r.refreshHover()}function A(){U(h,s.EVENT.MOUSEOVER)}function O(){U(h,s.EVENT.MOUSEOUT)}function M(e){l=W(e),v=!0,p=h,U(h,s.EVENT.MOUSEDOWN)}function _(e){l=W(e),t.style.cursor="default",v=!1,p=null,U(h,s.EVENT.MOUSEUP),q(),R()}function D(e){o.stop(e),l=W(e,!0),g=new Date,M(l)}function P(e){o.stop(e),l=W(e,!0),k(l)}function H(e){o.stop(e),l=W(e,!0),_(l),r.clearHover(),new Date-g<s.EVENT.touchClickDelay&&(h=null,w=l.zrenderX,E=l.zrenderY,n.iterShape(z,{normal:"down"}),h||(w+=10,n.iterShape(z,{normal:"down"})),h||(w-=20,n.iterShape(z,{normal:"down"})),h||(w+=10,E+=10,n.iterShape(z,{normal:"down"})),h||(E-=20,n.iterShape(z,{normal:"down"})),h&&(l.zrenderX=w,l.zrenderY=E),N(l))}function B(){v&&h&&h.draggable&&!d&&p==h&&(d=h,m=!0,d.invisible=!0,n.mod(d.id,d),U(d,s.EVENT.DRAGSTART),r.refresh())}function j(){d&&U(h,s.EVENT.DRAGENTER,d)}function F(){d&&U(h,s.EVENT.DRAGOVER,d)}function I(){d&&U(h,s.EVENT.DRAGLEAVE,d)}function q(){d&&(d.invisible=!1,n.mod(d.id,d),r.refresh(),U(h,s.EVENT.DROP,d))}function R(){d&&(U(d,s.EVENT.DRAGEND),h=null),m=!1,d=null}function U(e,t,n){var r="on"+t,i={type:t,event:l,target:e};n&&(i.dragged=n),e?(!e[r]||!e[r](i))&&u.dispatch(t,l,i):n||u.dispatch(t,l)}function z(e){if(d&&d.id==e.id)return!1;if(e.__silent)return!1;var t=i.get(e.shape);return t.isCover(e,w,E)?(e.hoverable&&n.addHover(e),h!=e&&(O(),I(),h=e,j()),A(),F(),c=!0,!0):!1}function W(e,n){if(!n){l=e||window.event;var r=l.toElement||l.relatedTarget||l.srcElement||l.target;r&&r!=S&&(l.zrenderX=(typeof l.offsetX!="undefined"?l.offsetX:l.layerX)+r.offsetLeft,l.zrenderY=(typeof l.offsetY!="undefined"?l.offsetY:l.layerY)+r.offsetTop)}else{l=e;var i=l.type!="touchend"?l.targetTouches[0]:l.changedTouches[0];i&&(l.zrenderX=i.clientX-t.offsetLeft+document.body.scrollLeft,l.zrenderY=i.clientY-t.offsetTop+document.body.scrollTop)}return l}function X(e,t){return u.bind(e,t),u}function V(e,t){return u.unbind(e,t),u}function $(){window.removeEventListener?(window.removeEventListener("resize",T),t.removeEventListener("click",N),t.removeEventListener("mousewheel",C),t.removeEventListener("DOMMouseScroll",C),t.removeEventListener("mousemove",k),t.removeEventListener("mouseout",L),t.removeEventListener("mousedown",M),t.removeEventListener("mouseup",_),t.removeEventListener("touchstart",D),t.removeEventListener("touchmove",P),t.removeEventListener("touchend",H)):(window.detachEvent("onresize",T),t.detachEvent("onclick",N),t.detachEvent("onmousewheel",C),t.detachEvent("onmousemove",k),t.detachEvent("onmouseout",L),t.detachEvent("onmousedown",M),t.detachEvent("onmouseup",_)),t=null,S=null,n=null,r=null,i=null,V(),u=null;return}var s=e("./config"),o=e("./tool/event");o.Dispatcher.call(this);var u=this,a=o.getX,f=o.getY,l,c=!1,h=null,p=null,d=null,v=!1,m=!1,g,y=0,b=0,w=0,E=0,S=r.getDomHover();u.on=X,u.un=V,u.dispose=$,x()}e("./lib/excanvas");var t={},n=t,r=0,i={};return t.init=function(e,t){var n=new s(++r+"",e,t||{});return i[r]=n,n},t.dispose=function(e){if(e)e.dispose();else{for(var n in i)i[n].dispose();i={}}return t},t.getInstance=function(e){return i[e]},t.delInstance=function(e){return i[e]&&(i[e]=null,delete i[e]),t},t.catchBrushException=!1,t.debugMode=0,t.log=function(){if(t.debugMode===0)return;if(t.debugMode==1)for(var e in arguments)throw new Error(arguments[e]);else if(t.debugMode>1)for(var e in arguments)console.log(arguments[e]);return t},t}),define("zrender",["zrender/zrender"],function(e){return e}),define("echarts/util/shape/icon",["require","zrender/tool/matrix","zrender/shape","zrender/shape/base","zrender/shape"],function(e){function n(){this.type="icon",this._iconLibrary={mark:r,markUndo:i,markClear:s,dataZoom:o,dataZoomReset:u,restore:a,lineChart:f,barChart:l,dataView:c,saveAsImage:h,cross:p,circle:d,rectangle:v,triangle:m,diamond:g,star:y}}function r(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y+t.height),e.lineTo(t.x+5*n,t.y+14*r),e.lineTo(t.x+t.width,t.y+3*r),e.lineTo(t.x+13*n,t.y),e.lineTo(t.x+2*n,t.y+11*r),e.lineTo(t.x,t.y+t.height),e.moveTo(t.x+6*n,t.y+10*r),e.lineTo(t.x+14*n,t.y+2*r),e.moveTo(t.x+10*n,t.y+13*r),e.lineTo(t.x+t.width,t.y+13*r),e.moveTo(t.x+13*n,t.y+10*r),e.lineTo(t.x+13*n,t.y+t.height)}function i(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y+t.height),e.lineTo(t.x+5*n,t.y+14*r),e.lineTo(t.x+t.width,t.y+3*r),e.lineTo(t.x+13*n,t.y),e.lineTo(t.x+2*n,t.y+11*r),e.lineTo(t.x,t.y+t.height),e.moveTo(t.x+6*n,t.y+10*r),e.lineTo(t.x+14*n,t.y+2*r),e.moveTo(t.x+10*n,t.y+13*r),e.lineTo(t.x+t.width,t.y+13*r)}function s(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x+4*n,t.y+15*r),e.lineTo(t.x+9*n,t.y+13*r),e.lineTo(t.x+14*n,t.y+8*r),e.lineTo(t.x+11*n,t.y+5*r),e.lineTo(t.x+6*n,t.y+10*r),e.lineTo(t.x+4*n,t.y+15*r),e.moveTo(t.x+5*n,t.y),e.lineTo(t.x+11*n,t.y),e.moveTo(t.x+5*n,t.y+r),e.lineTo(t.x+11*n,t.y+r),e.moveTo(t.x,t.y+2*r),e.lineTo(t.x+t.width,t.y+2*r),e.moveTo(t.x,t.y+5*r),e.lineTo(t.x+3*n,t.y+t.height),e.lineTo(t.x+13*n,t.y+t.height),e.lineTo(t.x+t.width,t.y+5*r)}function o(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y+3*r),e.lineTo(t.x+6*n,t.y+3*r),e.moveTo(t.x+3*n,t.y),e.lineTo(t.x+3*n,t.y+6*r),e.moveTo(t.x+3*n,t.y+8*r),e.lineTo(t.x+3*n,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x+t.width,t.y+3*r),e.lineTo(t.x+8*n,t.y+3*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function u(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x+6*n,t.y),e.lineTo(t.x+2*n,t.y+3*r),e.lineTo(t.x+6*n,t.y+6*r),e.moveTo(t.x+2*n,t.y+3*r),e.lineTo(t.x+14*n,t.y+3*r),e.lineTo(t.x+14*n,t.y+11*r),e.moveTo(t.x+2*n,t.y+5*r),e.lineTo(t.x+2*n,t.y+13*r),e.lineTo(t.x+14*n,t.y+13*r),e.moveTo(t.x+10*n,t.y+10*r),e.lineTo(t.x+14*n,t.y+13*r),e.lineTo(t.x+10*n,t.y+t.height),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function a(e,t){var n=t.width/16,r=t.height/16,i=t.width/2;e.arc(t.x+i,t.y+i,i-n,0,Math.PI*2/3),e.moveTo(t.x+3*n,t.y+t.height),e.lineTo(t.x+0*n,t.y+12*r),e.lineTo(t.x+5*n,t.y+11*r),e.moveTo(t.x,t.y+8*r),e.arc(t.x+i,t.y+i,i-n,Math.PI,Math.PI*5/3),e.moveTo(t.x+13*n,t.y),e.lineTo(t.x+t.width,t.y+4*r),e.lineTo(t.x+11*n,t.y+5*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function f(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.moveTo(t.x+2*n,t.y+14*r),e.lineTo(t.x+7*n,t.y+6*r),e.lineTo(t.x+11*n,t.y+11*r),e.lineTo(t.x+15*n,t.y+2*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function l(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.moveTo(t.x+3*n,t.y+14*r),e.lineTo(t.x+3*n,t.y+6*r),e.lineTo(t.x+4*n,t.y+6*r),e.lineTo(t.x+4*n,t.y+14*r),e.moveTo(t.x+7*n,t.y+14*r),e.lineTo(t.x+7*n,t.y+2*r),e.lineTo(t.x+8*n,t.y+2*r),e.lineTo(t.x+8*n,t.y+14*r),e.moveTo(t.x+11*n,t.y+14*r),e.lineTo(t.x+11*n,t.y+9*r),e.lineTo(t.x+12*n,t.y+9*r),e.lineTo(t.x+12*n,t.y+14*r)}function c(e,t){var n=t.width/16;e.moveTo(t.x+n,t.y),e.lineTo(t.x+n,t.y+t.height),e.lineTo(t.x+15*n,t.y+t.height),e.lineTo(t.x+15*n,t.y),e.lineTo(t.x+n,t.y),e.moveTo(t.x+3*n,t.y+3*n),e.lineTo(t.x+13*n,t.y+3*n),e.moveTo(t.x+3*n,t.y+6*n),e.lineTo(t.x+13*n,t.y+6*n),e.moveTo(t.x+3*n,t.y+9*n),e.lineTo(t.x+13*n,t.y+9*n),e.moveTo(t.x+3*n,t.y+12*n),e.lineTo(t.x+9*n,t.y+12*n)}function h(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x+t.width,t.y),e.lineTo(t.x,t.y),e.moveTo(t.x+4*n,t.y),e.lineTo(t.x+4*n,t.y+8*r),e.lineTo(t.x+12*n,t.y+8*r),e.lineTo(t.x+12*n,t.y),e.moveTo(t.x+6*n,t.y+11*r),e.lineTo(t.x+6*n,t.y+13*r),e.lineTo(t.x+10*n,t.y+13*r),e.lineTo(t.x+10*n,t.y+11*r),e.lineTo(t.x+6*n,t.y+11*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function p(e,t){var n=t.x,r=t.y,i=t.width,s=t.height;e.moveTo(n,r+s/2),e.lineTo(n+i,r+s/2),e.moveTo(n+i/2,r),e.lineTo(n+i/2,r+s)}function d(e,t){var n=t.width/2,r=t.height/2;e.arc(t.x+n,t.y+r,Math.min(n,r),0,Math.PI*2)}function v(e,t){e.rect(t.x,t.y,t.width,t.height)}function m(e,t){var n=t.width/2,r=t.height/2,i=t.x+n,s=t.y+r,o=Math.min(n,r);e.moveTo(i,s-o),e.lineTo(i+o,s+o),e.lineTo(i-o,s+o),e.lineTo(i,s-o)}function g(e,t){var n=t.width/2,r=t.height/2,i=t.x+n,s=t.y+r,o=Math.min(n,r);e.moveTo(i,s-o),e.lineTo(i+o,s),e.lineTo(i,s+o),e.lineTo(i-o,s),e.lineTo(i,s-o)}function y(t,n){var r=n.width/2,i=n.height/2,s=e("zrender/shape").get("star");s.buildPath(t,{x:n.x+r,y:n.y+i,r:Math.min(r,i),n:n.n||5})}var t=e("zrender/tool/matrix");return n.prototype={buildPath:function(e,t){this._iconLibrary[t.iconType]?this._iconLibrary[t.iconType](e,t):(e.moveTo(t.x,t.y),e.lineTo(t.x+t.width,t.y),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x,t.y));return},getRect:function(e){return{x:Math.round(e.x),y:Math.round(e.y),width:e.width,height:e.height}},isCover:function(e,n,r){if(e.__needTransform&&e._transform){var i=[];t.invert(i,e._transform);var s=[n,r];t.mulVector(s,i,[n,r,1]),n==s[0]&&r==s[1]&&(Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1),n=s[0],r=s[1]}var o;return e.style.__rect?o=e.style.__rect:(o=this.getRect(e.style),o=[o.x,o.x+o.width,o.y,o.y+o.height],e.style.__rect=o),n>=o[0]&&n<=o[1]&&r>=o[2]&&r<=o[3]?!0:!1},define:function(e,t){this._iconLibrary[e]=t},get:function(e){return this._iconLibrary[e]}},e("zrender/shape/base").derive(n),e("zrender/shape").define("icon",new n),n}),define("echarts/chart/island",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/event","zrender/tool/color","../chart"],function(e){function t(t,n){function v(t,n){var r=e("zrender/tool/color"),i=o.get(t,"value")+o.get(n,"value"),s=o.get(t,"name")+c+o.get(n,"name");t.style.text=s+h+i,o.set(t,"value",i),o.set(t,"name",s),t.style.r=f.island.r,t.style.color=r.mix(t.style.color,n.style.color)}function m(e){e.island=a.reformOption(e.island),f=e,c=f.nameConnector,h=f.valueConnector;for(var t=0,r=a.shapeList.length;t<r;t++)n.addShape(a.shapeList[t])}function g(){return f}function y(){var e=n.getWidth(),t=n.getHeight(),r=e/(d||e),i=t/(p||t);if(r==1&&i==1)return;d=e,p=t;for(var s=0,o=a.shapeList.length;s<o;s++)n.modShape(a.shapeList[s].id,{style:{x:Math.round(a.shapeList[s].style.x*r),y:Math.round(a.shapeList[s].style.y*i)}})}function b(e){var t=o.get(e,"name"),r=o.get(e,"value"),i=typeof o.get(e,"series")!="undefined"?o.get(e,"series").name:"",s=a.getFont(f.island.textStyle),u={shape:"circle",id:n.newShapeId(a.type),zlevel:l,style:{x:e.style.x,y:e.style.y,r:f.island.r,color:e.style.color||e.style.strokeColor,text:t+h+r,textFont:s},draggable:!0,hoverable:!0,onmousewheel:a.shapeHandler.onmousewheel,_type:"island"};u.style.color=="#fff"&&(u.style.color=e.style.strokeColor),a.setCalculable(u),o.pack(u,{name:i},-1,r,-1,t),a.shapeList.push(u),n.addShape(u)}function w(e){n.delShape(e.id);var t=[];for(var r=0,i=a.shapeList.length;r<i;r++)a.shapeList[r].id!=e.id&&t.push(a.shapeList[r]);a.shapeList=t}function E(e,t){if(!a.isDrop||!e.target)return;var r=e.target,i=e.dragged;v(r,i),n.modShape(r.id,r),t.dragIn=!0,a.isDrop=!1;return}function S(e,t){var n=e.target;a.isDragend?t.dragIn&&(w(n),t.needRefresh=!0):t.dragIn||(n.style.x=u.getX(e.event),n.style.y=u.getY(e.event),b(n),t.needRefresh=!0),a.isDragend=!1;return}var r=e("../component/base");r.call(this,n);var i=e("./calculableBase");i.call(this,n);var s=e("../config"),o=e("../util/ecData"),u=e("zrender/tool/event"),a=this;a.type=s.CHART_TYPE_ISLAND;var f,l=a.getZlevelBase(),c,h,p=n.getHeight(),d=n.getWidth();a.shapeHandler.onmousewheel=function(e){var t=e.target,r=e.event,i=u.getDelta(r);i=i>0?-1:1,t.style.r-=i,t.style.r=t.style.r<5?5:t.style.r;var s=o.get(t,"value"),a=s*f.island.calculateStep;a>1?s=Math.round(s-a*i):s=(s-a*i).toFixed(2)-0;var l=o.get(t,"name");t.style.text=l+":"+s,o.set(t,"value",s),o.set(t,"name",l),n.modShape(t.id,t),n.refresh(),u.stop(r)},a.render=m,a.resize=y,a.getOption=g,a.add=b,a.del=w,a.ondrop=E,a.ondragend=S}return e("../chart").define("island",t),t}),define("echarts/component",[],function(){var e={},t={};return e.define=function(n,r){return t[n]=r,e},e.get=function(e){return t[e]},e}),define("echarts/component/title",["require","./base","../config","zrender/tool/area","zrender/tool/util","../component"],function(e){function t(t,n,r){function h(){c=v(),d(),p();for(var e=0,t=a.shapeList.length;e<t;e++)a.shapeList[e].id=n.newShapeId(a.type),n.addShape(a.shapeList[e])}function p(){var e=f.text,t=f.subtext,n=a.getFont(f.textStyle),r=a.getFont(f.subtextStyle),i=c.x,s=c.y,o=c.width,u=c.height,h={shape:"text",zlevel:l,style:{y:s,color:f.textStyle.color,text:e,textFont:n,textBaseline:"top"},hoverable:!1},p={shape:"text",zlevel:l,style:{y:s+u,color:f.subtextStyle.color,text:t,textFont:r,textBaseline:"bottom"},hoverable:!1};switch(f.x){case"center":h.style.x=p.style.x=i+o/2,h.style.textAlign=p.style.textAlign="center";break;case"left":h.style.x=p.style.x=i,h.style.textAlign=p.style.textAlign="left";break;case"right":h.style.x=p.style.x=i+o,h.style.textAlign=p.style.textAlign="right";break;default:i=f.x-0,i=isNaN(i)?0:i,h.style.x=p.style.x=i}f.textAlign&&(h.style.textAlign=p.style.textAlign=f.textAlign),a.shapeList.push(h),t!==""&&a.shapeList.push(p)}function d(){var e=f.padding[0],t=f.padding[1],n=f.padding[2],r=f.padding[3];a.shapeList.push({shape:"rectangle",zlevel:l,hoverable:!1,style:{x:c.x-r,y:c.y-e,width:c.width+r+t,height:c.height+e+n,brushType:f.borderWidth===0?"fill":"both",color:f.backgroundColor,strokeColor:f.borderColor,lineWidth:f.borderWidth}})}function v(){var e=f.text,t=f.subtext,r=a.getFont(f.textStyle),i=a.getFont(f.subtextStyle),s=Math.max(o.getTextWidth(e,r),o.getTextWidth(t,i)),u=o.getTextWidth("国",r)+(t===""?0:f.itemGap+o.getTextWidth("国",i)),l,c=n.getWidth();switch(f.x){case"center":l=Math.floor((c-s)/2);break;case"left":l=f.padding[3]+f.borderWidth;break;case"right":l=c-s-f.padding[1]-f.borderWidth;break;default:l=f.x-0,l=isNaN(l)?0:l}var h,p=n.getHeight();switch(f.y){case"top":h=f.padding[0]+f.borderWidth;break;case"bottom":h=p-u-f.padding[2]-f.borderWidth;break;case"center":h=Math.floor((p-u)/2);break;default:h=f.y-0,h=isNaN(h)?0:h}return{x:l,y:h,width:s,height:u}}function m(e){r=e,r.title=a.reformOption(r.title),r.title.padding=a.reformCssArray(r.title.padding),f=r.title,f.textStyle=u.merge(f.textStyle,s.textStyle,{overwrite:!1,recursive:!1}),f.subtextStyle=u.merge(f.subtextStyle,s.textStyle,{overwrite:!1,recursive:!1}),a.clear(),h()}function g(){m(r)}var i=e("./base");i.call(this,n);var s=e("../config"),o=e("zrender/tool/area"),u=e("zrender/tool/util"),a=this;a.type=s.COMPONENT_TYPE_TITLE;var f,l=a.getZlevelBase(),c={};a.init=m,a.refresh=g,m(r)}return e("../component").define("title",t),t}),define("echarts/component/categoryAxis",["require","./base","../config","zrender/tool/util","zrender/tool/area","../component"],function(e){function t(t,n,r,i){function d(){var e=u.clone(r.data),t=r.axisLabel.formatter,n;for(var i=0,s=e.length;i<s;i++)n=e[i].formatter||t,n&&(typeof n=="function"?typeof e[i].value!="undefined"?e[i].value=n(e[i].value):e[i]=n(e[i]):typeof n=="string"&&(typeof e[i].value!="undefined"?e[i].value=n.replace("{value}",e[i].value):e[i]=n.replace("{value}",e[i])));return e}function v(){var e=r.axisLabel.interval;if(e=="auto"){var t=r.axisLabel.textStyle.fontSize,n=f.getFont(r.axisLabel.textStyle),i=r.data,s=r.data.length;if(r.position=="bottom"||r.position=="top")if(s>3){var o=N(i[1])-N(i[0]),l=!1,c,h;e=0;while(!l&&e<s){e++,l=!0,c=o*e-10;for(var d=0;d<s;d+=e){r.axisLabel.rotate!==0?h=t:i[d].textStyle?h=a.getTextWidth(p[d].value||p[d],f.getFont(u.merge(i[d].textStyle,r.axisLabel.textStyle,{overwrite:!1,recursive:!0}))):h=a.getTextWidth(p[d].value||p[d],n);if(c<h){l=!1;break}}}}else e=1;else if(s>3){var o=N(i[0])-N(i[1]);e=1;while(o*e-6<t&&e<s)e++}else e=1}else e+=1;return e}function m(){p=d(),h=v(),r.splitArea.show&&E(),r.splitLine.show&&w(),r.axisLine.show&&g(),r.axisTick.show&&y(),r.axisLabel.show&&b();for(var e=0,t=f.shapeList.length;e<t;e++)f.shapeList[e].id=n.newShapeId(f.type),n.addShape(f.shapeList[e])}function g(){var e={shape:"line",zlevel:c+1,hoverable:!1};switch(r.position){case"left":e.style={xStart:l.getX(),yStart:l.getY(),xEnd:l.getX(),yEnd:l.getYend()};break;case"right":e.style={xStart:l.getXend(),yStart:l.getY(),xEnd:l.getXend(),yEnd:l.getYend()};break;case"bottom":e.style={xStart:l.getX(),yStart:l.getYend(),xEnd:l.getXend(),yEnd:l.getYend()};break;case"top":e.style={xStart:l.getX(),yStart:l.getY(),xEnd:l.getXend(),yEnd:l.getY()}}e.style.strokeColor=r.axisLine.lineStyle.color,e.style.lineWidth=r.axisLine.lineStyle.width,e.style.lineType=r.axisLine.lineStyle.type,f.shapeList.push(e)}function y(){var e,t=r.data,n=r.data.length,i=r.axisTick.length,s=r.axisTick.lineStyle.color,o=r.axisTick.lineStyle.width;if(r.position=="bottom"||r.position=="top"){var u=r.position=="bottom"?l.getYend():l.getY()-i;for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:N(t[a].value||t[a]),yStart:u,xEnd:N(t[a].value||t[a]),yEnd:u+i,strokeColor:s,lineWidth:o}},f.shapeList.push(e)}else{var h=r.position=="left"?l.getX()-i:l.getXend();for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:h,yStart:N(t[a].value||t[a]),xEnd:h+i,yEnd:N(t[a].value||t[a]),strokeColor:s,lineWidth:o}},f.shapeList.push(e)}}function b(){var e,t=r.data,n=r.data.length,i=r.axisLabel.rotate,s=r.axisLabel.margin,o=r.axisLabel.textStyle,a;if(r.position=="bottom"||r.position=="top"){var d,v;r.position=="bottom"?(d=l.getYend()+s,v="top"):(d=l.getY()-s,v="bottom");for(var m=0;m<n;m+=h)a=u.merge(t[m].textStyle||{},o,{overwrite:!1}),e={shape:"text",zlevel:c,hoverable:!1,style:{x:N(t[m].value||t[m]),y:d,color:a.color,text:p[m].value||p[m],textFont:f.getFont(a),textAlign:"center",textBaseline:v}},i&&(e.style.textAlign=i>0?r.position=="bottom"?"right":"left":r.position=="bottom"?"left":"right",e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}else{var g,y;r.position=="left"?(g=l.getX()-s,y="right"):(g=l.getXend()+s,y="left");for(var m=0;m<n;m+=h)a=u.merge(t[m].textStyle||{},o,{overwrite:!1}),e={shape:"text",zlevel:c,hoverable:!1,style:{x:g,y:N(t[m].value||t[m]),color:a.color,text:p[m].value||p[m],textFont:f.getFont(a),textAlign:y,textBaseline:"middle"}},i&&(e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}}function w(){var e,t=r.data,n=r.data.length,i=r.splitLine.lineStyle.color;i=i instanceof Array?i:[i];var s=i.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getYend(),a;for(var p=0;p<n;p+=h)a=N(t[p].value||t[p]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:a,yStart:o,xEnd:a,yEnd:u,strokeColor:i[p%s],lineType:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}else{var d=l.getX(),v=l.getXend(),m;for(var p=0;p<n;p+=h)m=N(t[p].value||t[p]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:d,yStart:m,xEnd:v,yEnd:m,strokeColor:i[p%s],linetype:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}}function E(){var e,t=r.splitArea.areaStyle.color;t=t instanceof Array?t:[t];var n=t.length,i=r.data,s=r.data.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getHeight(),a=l.getX(),h;for(var p=0;p<=s;p++)h=p<s?N(i[p].value||i[p]):l.getXend(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:a,y:o,width:h-a,height:u,color:t[p%n]}},f.shapeList.push(e),a=h}else{var d=l.getX(),v=l.getWidth(),m=l.getYend(),g;for(var p=0;p<=s;p++)g=p<s?N(i[p].value||i[p]):l.getY(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:d,y:g,width:v,height:m-g,color:t[p%n]}},f.shapeList.push(e),m=g}}function S(e,t){if(e.data.length<1)return;r=f.reformOption(e),r.axisLabel.textStyle=u.merge(r.axisLabel.textStyle||{},o.textStyle,{overwrite:!1,recursive:!0}),r.axisLabel.textStyle=u.merge(r.axisLabel.textStyle||{},o.textStyle,{overwrite:!1,recursive:!0}),l=t,f.clear(),m()}function x(){f.clear(),m()}function T(){var e=r.data.length,t=r.position=="bottom"||r.position=="top"?l.getWidth():l.getHeight();return r.boundaryGap?t/(e+1):t/(e>1?e-1:1)}function N(e){var t=r.data,n=t.length,i=T(),s=r.boundaryGap?i:0;for(var o=0;o<n;o++){if(t[o]==e||t[o].value&&t[o].value==e)return r.position=="bottom"||r.position=="top"?s=l.getX()+s:s=l.getYend()-s,o===0||o==n-1?s:Math.floor(s);s+=i}}function C(e){return e<0?r.position=="bottom"||r.position=="top"?l.getX():l.getYend():e>=r.data.length?r.position=="bottom"||r.position=="top"?l.getXend():l.getY():N(r.data[e])}function k(e){return r.data[e]}function L(e){return e%h===0}function A(){return r.position}var s=e("./base");s.call(this,n);var o=e("../config"),u=e("zrender/tool/util"),a=e("zrender/tool/area"),f=this;f.type=o.COMPONENT_TYPE_AXIS_CATEGORY;var l=i.grid,c=f.getZlevelBase(),h,p;f.init=S,f.refresh=x,f.getGap=T,f.getCoord=N,f.getCoordByIndex=C,f.getNameByIndex=k,f.isMainAxis=L,f.getPosition=A,S(r,l)}return e("../component").define("categoryAxis",t),t}),define("echarts/component/valueAxis",["require","./base","../config","zrender/tool/util","../component"],function(e){function t(t,n,r,i,s){function g(){d=!1,x();if(!d)return;r.splitArea.show&&S(),r.splitLine.show&&E(),r.axisLine.show&&y(),r.axisTick.show&&b(),r.axisLabel.show&&w();for(var e=0,t=f.shapeList.length;e<t;e++)f.shapeList[e].id=n.newShapeId(f.type),n.addShape(f.shapeList[e])}function y(){var e={shape:"line",zlevel:c+1,hoverable:!1};switch(r.position){case"left":e.style={xStart:l.getX(),yStart:l.getYend(),xEnd:l.getX(),yEnd:l.getY()};break;case"right":e.style={xStart:l.getXend(),yStart:l.getYend(),xEnd:l.getXend(),yEnd:l.getY()};break;case"bottom":e.style={xStart:l.getX(),yStart:l.getYend(),xEnd:l.getXend(),yEnd:l.getYend()};break;case"top":e.style={xStart:l.getX(),yStart:l.getY(),xEnd:l.getXend(),yEnd:l.getY()}}r.name!==""&&(e.style.text=r.name,e.style.textPosition=r.nameLocation),e.style.strokeColor=r.axisLine.lineStyle.color,e.style.lineWidth=r.axisLine.lineStyle.width,e.style.lineType=r.axisLine.lineStyle.type,f.shapeList.push(e)}function b(){var e,t=v,n=v.length,i=r.axisTick.length,s=r.axisTick.lineStyle.color,o=r.axisTick.lineStyle.width;if(r.position=="bottom"||r.position=="top"){var u=r.position=="bottom"?l.getYend():l.getY()-i;for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:A(t[a]),yStart:u,xEnd:A(t[a]),yEnd:u+i,strokeColor:s,lineWidth:o}},f.shapeList.push(e)}else{var h=r.position=="left"?l.getX()-i:l.getXend();for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:h,yStart:A(t[a]),xEnd:h+i,yEnd:A(t[a]),strokeColor:s,lineWidth:o}},f.shapeList.push(e)}}function w(){var e,t=v,n=v.length,i=r.axisLabel.rotate,s=r.axisLabel.margin,o=r.axisLabel.textStyle;if(r.position=="bottom"||r.position=="top"){var u,a;r.position=="bottom"?(u=l.getYend()+s,a="top"):(u=l.getY()-s,a="bottom");for(var h=0;h<n;h++)e={shape:"text",zlevel:c,hoverable:!1,style:{x:A(t[h]),y:u,color:o.color,text:m[h],textFont:f.getFont(o),textAlign:h===0&&r.name!==""?"left":h==n-1&&r.name!==""?"right":"center",textBaseline:a}},i&&(e.style.textAlign=i>0?r.position=="bottom"?"right":"left":r.position=="bottom"?"left":"right",e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}else{var p,d;r.position=="left"?(p=l.getX()-s,d="right"):(p=l.getXend()+s,d="left");for(var h=0;h<n;h++)e={shape:"text",zlevel:c,hoverable:!1,style:{x:p,y:A(t[h]),color:o.color,text:m[h],textFont:f.getFont(o),textAlign:d,textBaseline:h===0&&r.name!==""?"bottom":h==n-1&&r.name!==""?"top":"middle"}},i&&(e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}}function E(){var e,t=v,n=v.length,i=r.splitLine.lineStyle.color;i=i instanceof Array?i:[i];var s=i.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getYend(),a;for(var h=0;h<n;h++)a=A(t[h]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:a,yStart:o,xEnd:a,yEnd:u,strokeColor:i[h%s],lineType:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}else{var p=l.getX(),d=l.getXend(),m;for(var h=0;h<n;h++)m=A(t[h]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:p,yStart:m,xEnd:d,yEnd:m,strokeColor:i[h%s],lineType:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}}function S(){var e,t=r.splitArea.areaStyle.color;if(t instanceof Array){var n=t.length,i=v,s=v.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getHeight(),a=l.getX(),h;for(var p=0;p<=s;p++)h=p<s?A(i[p]):l.getXend(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:a,y:o,width:h-a,height:u,color:t[p%n]}},f.shapeList.push(e),a=h}else{var d=l.getX(),m=l.getWidth(),g=l.getYend(),y;for(var p=0;p<=s;p++)y=p<s?A(i[p]):l.getY(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:d,y:y,width:m,height:g-y,color:t[p%n]}},f.shapeList.push(e),g=y}}else e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:l.getX(),y:l.getY(),width:l.getWidth(),height:l.getHeight(),color:t}},f.shapeList.push(e)}function x(){if(isNaN(r.min)||isNaN(r.max)){var e,t={},n,o,a,f=i.legend;for(var l=0,c=s.length;l<c;l++){if(s[l].type!=u.CHART_TYPE_LINE&&s[l].type!=u.CHART_TYPE_BAR&&s[l].type!=u.CHART_TYPE_SCATTER&&s[l].type!=u.CHART_TYPE_K)continue;if(f&&!f.isSelected(s[l].name))continue;o=s[l].xAxisIndex||0,a=s[l].yAxisIndex||0;if(r.xAxisIndex!=o&&r.yAxisIndex!=a)continue;if(!s[l].stack){var v=s[l].name||"";t[v]=[],e=s[l].data;for(var m=0,g=e.length;m<g;m++)n=typeof e[m].value!="undefined"?e[m].value:e[m],s[l].type==u.CHART_TYPE_SCATTER?(r.xAxisIndex!=-1&&t[v].push(n[0]),r.yAxisIndex!=-1&&t[v].push(n[1])):s[l].type==u.CHART_TYPE_K?(t[v].push(n[0]),t[v].push(n[1]),t[v].push(n[2]),t[v].push(n[3])):t[v].push(n)}else{var y="__Magic_Key_Positive__"+s[l].stack,b="__Magic_Key_Negative__"+s[l].stack;t[y]=t[y]||[],t[b]=t[b]||[],e=s[l].data;for(var m=0,g=e.length;m<g;m++){n=typeof e[m].value!="undefined"?e[m].value:e[m];if(n=="-")continue;n-=0,n>=0?typeof t[y][m]!="undefined"?t[y][m]+=n:t[y][m]=n:typeof t[b][m]!="undefined"?t[b][m]+=n:t[b][m]=n}}}for(var l in t){e=t[l];for(var m=0,g=e.length;m<g;m++)if(!isNaN(e[m])){d=!0,h=e[m],p=e[m];break}if(d)break}for(var l in t){e=t[l];for(var m=0,g=e.length;m<g;m++)isNaN(e[m])||(h=Math.min(h,e[m]),p=Math.max(p,e[m]))}}else d=!0;h=isNaN(r.min)?h-Math.abs(h*r.boundaryGap[0]):r.min,p=isNaN(r.max)?p+Math.abs(p*r.boundaryGap[1]):r.max,T(r.scale)}function T(e){var t=r.splitNumber,n=r.precision,i,s;n===0?s=r.power:(s=Math.pow(10,n),h*=s,p*=s,s=r.power);var o;if(h>=0&&p>=0){e||(h=0);while(p/s<t&&s!=1)s/=10;o=p-h,i=Math.ceil(o/t/s)*s,e&&(n===0&&(h=Math.floor(h/i)*i),h+i*t<p&&(i=Math.ceil((p-h)/t/s)*s)),p=h+i*t}else if(h<=0&&p<=0){e||(p=0),s=-s;while(h/s<t&&s!=-1)s/=10;o=h-p,i=-Math.ceil(o/t/s)*s,e&&(n===0&&(p=Math.ceil(p/i)*i),p-i*t>h&&(i=Math.ceil((h-p)/t/s)*s)),h=-i*t+p}else{o=p-h;while(o/s<t&&s!=1)s/=10;var u=Math.round(p/o*t);u-=u==t?1:0,u+=u===0?1:0,i=Math.ceil(Math.max(p/u,h/(u-t))/s)*s,p=i*u,h=i*(u-t)}v=[];for(var a=0;a<=t;a++)v.push(h+i*a);if(n!==0){s=Math.pow(10,n),h=(h/s).toFixed(n)-0,p=(p/s).toFixed(n)-0;for(var a=0;a<=t;a++)v[a]=(v[a]/s).toFixed(n)}N()}function N(){m=[];var e=r.axisLabel.formatter;if(e)for(var t=0,n=v.length;t<n;t++)typeof e=="function"?m.push(e(v[t])):typeof e=="string"&&m.push(e.replace("{value}",v[t]));else m=v}function C(){return x(),{min:h,max:p}}function k(e,t,i){if(!i||i.length===0)return;r=f.reformOption(e),r.axisLabel.textStyle=a.merge(r.axisLabel.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),r.axisLabel.textStyle=a.merge(r.axisLabel.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),l=t,s=i,f.clear(),n&&g()}function L(){f.clear(),g()}function A(e){e=e<h?h:e,e=e>p?p:e;var t=p-h,n,i;return r.position=="left"||r.position=="right"?(n=l.getHeight(),i=l.getYend()-(e-h)/t*n):(n=l.getWidth(),i=(e-h)/t*n+l.getX()),e==h||e==p?i:Math.floor(i)}function O(){return r.position}var o=e("./base");o.call(this,n);var u=e("../config"),a=e("zrender/tool/util"),f=this;f.type=u.COMPONENT_TYPE_AXIS_VALUE;var l=i.grid,c=f.getZlevelBase(),h,p,d,v,m;f.init=k,f.refresh=L,f.getExtremum=C,f.getCoord=A,f.getPosition=O,k(r,l,s)}return e("../component").define("valueAxis",t),t}),define("echarts/component/axis",["require","./base","../config","./categoryAxis","./valueAxis","../component"],function(e){function t(t,n,r,i,s){function l(e){!e||e instanceof Array&&e.length===0?e=[{type:u.COMPONENT_TYPE_AXIS_VALUE}]:e instanceof Array||(e=[e]),e.length>2&&(e=[e[0],e[1]]);if(s=="xAxis"){if(!e[0].position||e[0].position!="bottom"&&e[0].position!="top")e[0].position="bottom";e.length>1&&(e[1].position=e[0].position=="bottom"?"top":"bottom");for(var t=0,n=e.length;t<n;t++)e[t].type=e[t].type||"category",e[t].xAxisIndex=t,e[t].yAxisIndex=-1}else{if(!e[0].position||e[0].position!="left"&&e[0].position!="right")e[0].position="left";e.length>1&&(e[1].position=e[0].position=="left"?"right":"left");for(var t=0,n=e.length;t<n;t++)e[t].type=e[t].type||"value",e[t].xAxisIndex=-1,e[t].yAxisIndex=t}return e}function c(o,u,c){i=u,s=c,a.clear();var h;s=="xAxis"?(r.xAxis=a.reformOption(o.xAxis),h=r.xAxis):(r.yAxis=l(o.yAxis),h=r.yAxis);var p=e("./categoryAxis"),d=e("./valueAxis");for(var v=0,m=h.length;v<m;v++)f.push(h[v].type=="category"?new p(t,n,h[v],i):new d(t,n,h[v],i,r.series))}function h(){for(var e=0,t=f.length;e<t;e++)f[e].refresh&&f[e].refresh()}function p(e){return f[e]}function d(){for(var e=0,t=f.length;e<t;e++)f[e].dispose&&f[e].dispose();f=[]}var o=e("./base");o.call(this,n);var u=e("../config"),a=this;a.type=u.COMPONENT_TYPE_AXIS;var f=[];a.clear=d,a.reformOption=l,a.init=c,a.refresh=h,a.getAxis=p,c(r,i,s)}return e("../component").define("axis",t),t}),define("echarts/component/grid",["require","./base","../config","../component"],function(e){function t(t,n,r){function h(e){r=e,r.grid=o.reformOption(r.grid);var t=r.grid;a=t.x,f=t.y,typeof t.width=="undefined"?l=n.getWidth()-a*2:l=t.width,typeof t.height=="undefined"?c=n.getHeight()-f*2:c=t.height,o.shapeList.push({shape:"rectangle",id:n.newShapeId("grid"),zlevel:u,hoverable:!1,style:{x:a,y:f,width:l,height:c,brushType:"both",color:t.backgroundColor,strokeColor:t.borderColor,lineWidth:t.borderWidth}}),n.addShape(o.shapeList[0])}function p(){return a}function d(){return f}function v(){return l}function m(){return c}function g(){return a+l}function y(){return f+c}function b(){return{x:a,y:f,width:l,height:c}}function w(){o.clear(),h(r)}var i=e("./base");i.call(this,n);var s=e("../config"),o=this;o.type=s.COMPONENT_TYPE_GRID;var u=o.getZlevelBase(),a,f,l,c;o.init=h,o.getX=p,o.getY=d,o.getWidth=v,o.getHeight=m,o.getXend=g,o.getYend=y,o.getArea=b,o.refresh=w,h(r)}return e("../component").define("grid",t),t}),define("echarts/component/dataZoom",["require","./base","../config","../component","zrender/tool/util","../component"],function(e){function t(t,n,r,i){function b(){T(),N(),C(),k();for(var e=0,t=u.shapeList.length;e<t;e++)u.shapeList[e].id=n.newShapeId(u.type),n.addShape(u.shapeList[e]);_()}function w(){var e,t,r,s,o=i.grid;return f.orient=="horizontal"?(r=f.width||o.getWidth(),s=f.height||l,e=typeof f.x!="undefined"?f.x:o.getX(),t=typeof f.y!="undefined"?f.y:n.getHeight()-s):(r=f.width||l,s=f.height||o.getHeight(),e=typeof f.x!="undefined"?f.x:0,t=typeof f.y!="undefined"?f.y:o.getY()),{x:e,y:t,width:r,height:s}}function E(){var e=r.series,t=r.xAxis;t&&!(t instanceof Array)&&(t=[t],r.xAxis=t);var n=r.yAxis;n&&!(n instanceof Array)&&(n=[n],r.yAxis=n);var i=[],s,u,a=f.xAxisIndex;if(t&&typeof a=="undefined"){s=[];for(var l=0,c=t.length;l<c;l++)(t[l].type=="category"||typeof t[l].type=="undefined")&&s.push(l)}else a instanceof Array?s=a:typeof a!="undefined"?s=[a]:s=[];a=f.yAxisIndex;if(n&&typeof a=="undefined"){u=[];for(var l=0,c=n.length;l<c;l++)n[l].type=="category"&&u.push(l)}else a instanceof Array?u=a:typeof a!="undefined"?u=[a]:u=[];for(var l=0,c=e.length;l<c;l++){if(e[l].type!=o.CHART_TYPE_LINE&&e[l].type!=o.CHART_TYPE_BAR&&e[l].type!=o.CHART_TYPE_SCATTER&&e[l].type!=o.CHART_TYPE_K)continue;for(var p=0,d=s.length;p<d;p++)if(s[p]==(e[l].xAxisIndex||0)){i.push(l);break}for(var p=0,d=u.length;p<d;p++)if(u[p]==(e[l].yAxisIndex||0)){i.push(l);break}e[l].type==o.CHART_TYPE_SCATTER&&typeof f.xAxisIndex=="undefined"&&typeof f.yAxisIndex=="undefined"&&i.push(l)}var v=typeof f.start!="undefined"&&f.start>=0&&f.start<=100?f.start:0,m=typeof f.end!="undefined"&&f.end>=0&&f.end<=100?f.end:100;v>m&&(v+=m,m=v-m,v-=m);var g=Math.round((m-v)/100*(f.orient=="horizontal"?h.width:h.height));return{start:v,end:m,start2:0,end2:100,size:g,xAxisIndex:s,yAxisIndex:u,seriesIndex:i}}function S(){y={xAxis:{},yAxis:{},series:{}};var e=r.xAxis,t=p.xAxisIndex;for(var n=0,i=t.length;n<i;n++)y.xAxis[t[n]]=e[t[n]].data;var s=r.yAxis,u=p.yAxisIndex;for(var n=0,i=u.length;n<i;n++)y.yAxis[u[n]]=s[u[n]].data;var a=r.series,f=p.seriesIndex,l;for(var n=0,i=f.length;n<i;n++)l=a[f[n]],y.series[f[n]]=l.data,l.type==o.CHART_TYPE_SCATTER&&x(f[n])}function x(t){p.scatterMap=p.scatterMap||{},p.scatterMap[t]=p.scatterMap[t]||{};var n=e("../component"),s=e("zrender/tool/util"),o=n.get("axis"),u=s.clone(r.xAxis);u instanceof Array?(u[0].type="value",u[1]&&(u[1].type="value")):u.type="value";var a=new o(null,!1,{xAxis:u,series:r.series},i,"xAxis"),f=r.series[t].xAxisIndex||0;p.scatterMap[t].x=a.getAxis(f).getExtremum(),a.dispose(),u=s.clone(r.yAxis),u instanceof Array?(u[0].type="value",u[1]&&(u[1].type="value")):u.type="value",a=new o(null,!1,{yAxis:u,series:r.series},i,"yAxis"),f=r.series[t].yAxisIndex||0,p.scatterMap[t].y=a.getAxis(f).getExtremum(),a.dispose()}function T(){u.shapeList.push({shape:"rectangle",zlevel:a,hoverable:!1,style:{x:h.x,y:h.y,width:h.width,height:h.height,color:f.backgroundColor}})}function N(){u.shapeList.push({shape:"rectangle",zlevel:a,hoverable:!1,style:{x:h.x,y:h.y,width:h.width,height:h.height,color:f.backgroundColor}});var e=0,t=r.xAxis,n=p.xAxisIndex;for(var i=0,s=n.length;i<s;i++)e=Math.max(e,t[n[i]].data.length);var l=r.yAxis,c=p.yAxisIndex;for(var i=0,s=c.length;i<s;i++)e=Math.max(e,l[c[i]].data.length);var d=r.series[p.seriesIndex[0]].data,v=Number.MIN_VALUE,m=Number.MAX_VALUE,g;for(var i=0,s=d.length;i<s;i++)g=typeof d[i]!="undefined"?typeof d[i].value!="undefined"?d[i].value:d[i]:0,r.series[p.seriesIndex[0]].type==o.CHART_TYPE_K&&(g=g[1]),isNaN(g)&&(g=0),v=Math.max(v,g),m=Math.min(m,g);var y=[],b=h.width/e,w=h.height/e;for(var i=0,s=e;i<s;i++)g=typeof d[i]!="undefined"?typeof d[i].value!="undefined"?d[i].value:d[i]:0,r.series[p.seriesIndex[0]].type==o.CHART_TYPE_K&&(g=g[1]),isNaN(g)&&(g=0),f.orient=="horizontal"?y.push([h.x+b*i,h.y+h.height-5-Math.round((g-m)/(v-m)*(h.height-10))]):y.push([h.x+5+Math.round((g-m)/(v-m)*(h.width-10)),h.y+w*i]);f.orient=="horizontal"?(y.push([h.x+h.width,h.y+h.height]),y.push([h.x,h.y+h.height])):(y.push([h.x,h.y+h.height]),y.push([h.x,h.y])),u.shapeList.push({shape:"polygon",zlevel:a,style:{pointList:y,color:f.dataBackgroundColor},hoverable:!1})}function C(){d={shape:"rectangle",zlevel:a,draggable:!0,ondrift:L,ondragend:P,_type:"filler"},f.orient=="horizontal"?d.style={x:h.x+Math.round(p.start/100*h.width)+c,y:h.y+3,width:p.size-c*2,height:h.height-6,color:f.fillerColor,text:":::",textPosition:"inside"}:d.style={x:h.x+3,y:h.y+Math.round(p.start/100*h.height)+c,width:h.width-6,height:p.size-c*2,color:f.fillerColor,text:"=",textPosition:"inside"},u.shapeList.push(d)}function k(){v={shape:"rectangle",zlevel:a},m={shape:"rectangle",zlevel:a},f.zoomLock||(v.draggable=!0,v.ondrift=L,v.ondragend=P,m.draggable=!0,m.ondrift=L,m.ondragend=P),f.orient=="horizontal"?(v.style={x:d.style.x-c,y:h.y,width:c,height:h.height,color:f.handleColor,text:"|",textPosition:"inside"},m.style={x:d.style.x+d.style.width,y:h.y,width:c,height:h.height,color:f.handleColor,text:"|",textPosition:"inside"}):(v.style={x:h.x,y:d.style.y-c,width:h.width,height:c,color:f.handleColor,text:"—",textPosition:"inside"},m.style={x:h.x,y:d.style.y+d.style.height,width:h.width,height:c,color:f.handleColor,text:"—",textPosition:"inside"}),u.shapeList.push(v),u.shapeList.push(m)}function L(e,t,n){var r=e._type=="filler"?c:0;return f.orient=="horizontal"?e.style.x+t-r<=h.x?e.style.x=h.x+r:e.style.x+t+e.style.width+r>=h.x+h.width?e.style.x=h.x+h.width-e.style.width-r:e.style.x+=t:e.style.y+n-r<=h.y?e.style.y=h.y+r:e.style.y+n+e.style.height+r>=h.y+h.height?e.style.y=h.y+h.height-e.style.height-r:e.style.y+=n,e._type=="filler"?A():O(),f.realtime?_():(clearTimeout(g),g=setTimeout(_,200)),!0}function A(){f.orient=="horizontal"?(v.style.x=d.style.x-c,m.style.x=d.style.x+d.style.width,p.start=Math.floor((v.style.x-h.x)/h.width*100),p.end=Math.ceil((m.style.x+c-h.x)/h.width*100)):(v.style.y=d.style.y-c,m.style.y=d.style.y+d.style.height,p.start=Math.floor((v.style.y-h.y)/h.height*100),p.end=Math.ceil((m.style.y+c-h.y)/h.height*100)),n.modShape(v.id,v),n.modShape(m.id,m),n.refresh()}function O(){var e,t;f.orient=="horizontal"?(e=v.style.x,t=m.style.x,d.style.x=Math.min(e,t)+c,d.style.width=Math.abs(e-t)-c,p.start=Math.floor((Math.min(e,t)-h.x)/h.width*100),p.end=Math.ceil((Math.max(e,t)+c-h.x)/h.width*100)):(e=v.style.y,t=m.style.y,d.style.y=Math.min(e,t)+c,d.style.height=Math.abs(e-t)-c,p.start=Math.floor((Math.min(e,t)-h.y)/h.height*100),p.end=Math.ceil((Math.max(e,t)+c-h.y)/h.height*100)),n.modShape(d.id,d),n.refresh()}function M(){if(!f.show)return;f.orient=="horizontal"?(v.style.x=h.x+p.start/100*h.width,m.style.x=h.x+p.end/100*h.width-c,d.style.x=v.style.x+c,d.style.width=m.style.x-v.style.x-c):(v.style.y=h.y+p.start/100*h.height,m.style.y=h.y+p.end/100*h.height-c,d.style.y=v.style.y+c,d.style.height=m.style.y-v.style.y-c),n.modShape(v.id,v),n.modShape(m.id,m),n.modShape(d.id,d),n.refresh()}function _(e){var n,i,s,u,a;for(var l in y){n=y[l];for(var c in n)a=n[c],u=a.length,i=Math.floor(p.start/100*u),s=Math.ceil(p.end/100*u),r[l][c].type!=o.CHART_TYPE_SCATTER?r[l][c].data=a.slice(i,s):r[l][c].data=D(c,a)}(f.realtime||e)&&t.dispatch(o.EVENT.DATA_ZOOM,null,{zoom:p}),f.start=p.start,f.end=p.end}function D(e,t){var n=[],r=p.scatterMap[e],i,s,o,u,a;f.orient=="horizontal"?(i=r.x.max-r.x.min,s=p.start/100*i+r.x.min,o=p.end/100*i+r.x.min,i=r.y.max-r.y.min,u=p.start2/100*i+r.y.min,a=p.end2/100*i+r.y.min):(i=r.x.max-r.x.min,s=p.start2/100*i+r.x.min,o=p.end2/100*i+r.x.min,i=r.y.max-r.y.min,u=p.start/100*i+r.y.min,a=p.end/100*i+r.y.min);for(var l=0,c=t.length;l<c;l++)t[l][0]>=s&&t[l][0]<=o&&t[l][1]>=u&&t[l][1]<=a&&n.push(t[l]);return n}function P(){u.isDragend=!0}function H(e,n){if(!u.isDragend||!e.target)return;_(),n.dragOut=!0,n.dragIn=!0,f.realtime||t.dispatch(o.EVENT.DATA_ZOOM,null,{zoom:p}),n.needRefresh=!1,u.isDragend=!1;return}function B(e,t){t.needRefresh=!0;return}function j(e){f.start=p.start=e.start,f.end=p.end=e.end,f.start2=p.start2=e.start2,f.end2=p.end2=e.end2,M(),_(!0);return}function F(e){if(!e)return f.start=f.start2=p.start=p.start2=0,f.end=f.end2=p.end=p.end2=100,M(),_(!0),p;var t=i.grid.getArea(),n={x:e.x,y:e.y,width:e.width,height:e.height};n.width<0&&(n.x+=n.width,n.width=-n.width),n.height<0&&(n.y+=n.height,n.height=-n.height);if(n.x>t.x+t.width||n.y>t.y+t.height)return!1;n.x<t.x&&(n.x=t.x),n.x+n.width>t.x+t.width&&(n.width=t.x+t.width-n.x),n.y+n.height>t.y+t.height&&(n.height=t.y+t.height-n.y);var r,s=(n.x-t.x)/t.width,o=1-(n.x+n.width-t.x)/t.width,u=1-(n.y+n.height-t.y)/t.height,a=(n.y-t.y)/t.height;return f.orient=="horizontal"?(r=p.end-p.start,p.start+=r*s,p.end-=r*o,r=p.end2-p.start2,p.start2+=r*u,p.end2-=r*a):(r=p.end-p.start,p.start+=r*u,p.end-=r*a,r=p.end2-p.start2,p.start2+=r*s,p.end2-=r*o),f.start=p.start,f.end=p.end,f.start2=p.start2,f.end2=p.end2,M(),_(!0),p}function I(e,t){var n,r=y.series,i=e.series,s;for(var o=0,u=i.length;o<u;o++){s=i[o].data,r[o]?n=Math.floor(p.start/100*r[o].length):n=0;for(var a=0,f=s.length;a<f;a++)typeof t.series[o].data[a+n].value!="undefined"?(t.series[o].data[a+n].value=s[a].value,r[o]&&(r[o][a+n].value=s[a].value)):(t.series[o].data[a+n]=s[a],r[o]&&(r[o][a+n]=s[a]))}}function q(e){r=e,r.dataZoom=u.reformOption(r.dataZoom),f=r.dataZoom,u.clear();if(r.dataZoom.show||u.deepQuery([r],"toolbox.show")&&u.deepQuery([r],"toolbox.feature.dataZoom"))h=w(),p=E(),S();r.dataZoom.show&&b()}var s=e("./base");s.call(this,n);var o=e("../config"),u=this;u.type=o.COMPONENT_TYPE_DATAZOOM;var a=u.getZlevelBase(),f,l=30,c=10,h,p,d,v,m,g,y;u.init=q,u.syncBackupData=I,u.absoluteZoom=j,u.rectZoom=F,u.ondragend=H,u.ondataZoom=B,q(r)}return e("../component").define("dataZoom",t),t}),define("echarts/component/legend",["require","./base","../config","zrender/tool/area","zrender/shape","zrender/shape","zrender/shape","zrender/shape","../component"],function(e){function t(t,r,i,s){function y(){h=E(),w(),b();for(var e=0,t=f.shapeList.length;e<t;e++)f.shapeList[e].id=r.newShapeId(f.type),r.addShape(f.shapeList[e])}function b(){var e=l.data,t=e.length,n,i,s,o,u=f.getFont(l.textStyle),p=r.getWidth(),d=h.x,m=h.y,g=l.itemWidth,y=l.itemHeight,b=l.itemGap,w;l.orient=="vertical"&&l.x=="right"&&(d=h.x+h.width-g);for(var E=0;E<t;E++)n=e[E],i=S(n),i?i=i.type:i="bar",w=L(n),l.orient=="horizontal"&&p-d<200&&g+5+a.getTextWidth(n,u)+(E<t-1?b:0)>=p-d&&(d=0,m+=y+b),s=x(d,m,g,y,v[n]?w:"#ccc",i),s._name=n,l.selectedMode&&(s.onclick=T),f.shapeList.push(s),o={shape:"text",zlevel:c,style:{x:d+g+5,y:m,color:v[n]?l.textStyle.color:"#ccc",text:n,textFont:u,textBaseline:"top"},hoverable:l.selectedMode,clickable:l.selectedMode},l.orient=="vertical"&&l.x=="right"&&(o.style.x-=g+10,o.style.textAlign="right"),o._name=n,l.selectedMode&&(o.onclick=T),f.shapeList.push(o),l.orient=="horizontal"?d+=g+5+a.getTextWidth(n,u)+b:m+=y+b}function w(){var e=l.padding[0],t=l.padding[1],n=l.padding[2],r=l.padding[3];f.shapeList.push({shape:"rectangle",zlevel:c,hoverable:!1,style:{x:h.x-r,y:h.y-e,width:h.width+r+t,height:h.height+e+n,brushType:l.borderWidth===0?"fill":"both",color:l.backgroundColor,strokeColor:l.borderColor,lineWidth:l.borderWidth}})}function E(){var e=l.data,t=e.length,n=l.itemGap,i=l.itemWidth+5,s=l.itemHeight,o=f.getFont(l.textStyle),u=0,c=0;if(l.orient=="horizontal"){for(var h=0;h<t;h++)u+=i+a.getTextWidth(e[h],o)+n;u-=n,c=s}else{c=(s+n)*t,c-=n;var p=0;for(var h=0;h<t;h++)p=Math.max(p,a.getTextWidth(e[h],o));u=i+p}var d,v=r.getWidth();switch(l.x){case"center":d=Math.floor((v-u)/2);break;case"left":d=l.padding[3]+l.borderWidth;break;case"right":d=v-u-l.padding[1]-l.borderWidth;break;default:d=l.x-0,d=isNaN(d)?0:d}var m,g=r.getHeight();switch(l.y){case"top":m=l.padding[0]+l.borderWidth;break;case"bottom":m=g-c-l.padding[2]-l.borderWidth;break;case"center":m=Math.floor((g-c)/2);break;default:m=l.y-0,m=isNaN(m)?0:m}return l.orient=="horizontal"&&u>v&&(u=v,d<0&&(d=0),c+=c+10),{x:d,y:m,width:u,height:c}}function S(e){var t=i.series,n,r;for(var s=0,o=t.length;s<o;s++){if(t[s].name==e)return t[s];if(t[s].type==u.CHART_TYPE_PIE){n=!1,r=t[s].data;for(var a=0,f=r.length;a<f;a++)if(r[a].name==e){n=!0;break}if(n)return t[s]}else if(t[s].type==u.CHART_TYPE_FORCE){n=!1,r=t[s].categories;for(var a=0,f=r.length;a<f;a++)if(r[a].name==e){r=r[a],r.type=u.CHART_TYPE_FORCE,n=!0;break}if(n)return r}}return}function x(e,t,n,r,i,s){var o={shape:"icon",zlevel:c,style:{iconType:"legendicon"+s,x:e,y:t,width:n,height:r,color:i,strokeColor:i,lineWidth:3},hoverable:l.selectedMode,clickable:l.selectedMode};switch(s){case"line":o.style.brushType="stroke";break;case"k":o.style.brushType="both",o.style.color=f.deepQuery([u],"k.itemStyle.normal.color")||"#fff",o.style.strokeColor=i!="#ccc"?f.deepQuery([u],"k.itemStyle.normal.lineStyle.color")||"#ff3200":i}return o}function T(e){var n=e.target._name;v[n]=!v[n],t.dispatch(u.EVENT.LEGEND_SELECTED,e.event,{selected:v})}function N(e){if(!f.deepQuery([e],"legend.data"))return;i=e,i.legend=f.reformOption(i.legend),i.legend.padding=f.reformCssArray(i.legend.padding),l=i.legend,f.clear(),v={};var t=l.data||[],n,r,o;for(var u=0,a=t.length;u<a;u++)n=t[u],r=S(n),r?(o=f.deepQuery([r],"itemStyle.normal.color"),o&&k(n,o),v[n]=!0):v[n]=!1;if(s)for(var c in s)v[c]=s[c];y()}function C(){l=i.legend,f.clear(),y()}function k(e,t){d[e]=t}function L(e){return d[e]||(d[e]=r.getColor(p++)),d[e]}function A(e){return d[e]?d[e]:!1}function O(e,t){l.data.push(e),k(e,t),v[e]=!0}function M(e){var t=l.data,n=[],r=!1;for(var i=0,s=t.length;i<s;i++){if(!r&&t[i]==e){r=!0;continue}n.push(t[i])}l.data=n}function _(e){var t;for(var n=0,r=f.shapeList.length;n<r;n++){t=f.shapeList[n];if(t._name==e&&t.shape!="text")return t}}function D(e,t){var n;for(var i=0,s=f.shapeList.length;i<s;i++)n=f.shapeList[i],n._name==e&&n.shape!="text"&&(v[e]||(t.style.color="#ccc",t.style.strokeColor="#ccc"),r.modShape(n.id,t))}function P(e){return typeof v[e]!="undefined"?v[e]:!0}var o=e("./base");o.call(this,r);var u=e("../config"),a=e("zrender/tool/area"),f=this;f.type=u.COMPONENT_TYPE_LEGEND;var l,c=f.getZlevelBase(),h={},p=0,d={},v={},m=e("zrender/shape").get("icon");for(var g in n)m.define("legendicon"+g,n[g]);f.init=N,f.refresh=C,f.setColor=k,f.getColor=L,f.hasColor=A,f.add=O,f.del=M,f.getItemShape=_,f.setItemShape=D,f.isSelected=P,N(i)}var n={line:function(e,t){var n=t.height/2;e.moveTo(t.x,t.y+n),e.lineTo(t.x+t.width,t.y+n)},pie:function(t,n){var r=n.x,i=n.y,s=n.width,o=n.height,u=e("zrender/shape").get("sector");u.buildPath(t,{x:r+s/2,y:i+o+2,r:o+2,r0:6,startAngle:45,endAngle:135})},k:function(t,n){var r=n.x,i=n.y,s=n.width,o=n.height,u=e("zrender/shape").get("candle");u.buildPath(t,{x:r+s/2,y:[i+1,i+1,i+o-6,i+o],width:s-6})},bar:function(e,t){e.rect(t.x,t.y+1,t.width,t.height-2)},force:function(t,n){e("zrender/shape").get("icon").get("circle")(t,n)}};return e("../component").define("legend",t),t}),define("echarts/component/dataRange",["require","./base","../config","zrender/tool/area","zrender/tool/color","zrender/tool/color","../component"],function(e){function t(t,n,r){function T(){l=M(),O(),a.splitNumber<=0||a.calculable?C():N();for(var e=0,t=u.shapeList.length;e<t;e++)u.shapeList[e].id=n.newShapeId(u.type),n.addShape(u.shapeList[e])}function N(){var e=S,t=e.length,n,r,i,s=u.getFont(a.textStyle),c=l.x,h=l.y,p=a.itemWidth,d=a.itemHeight,v=a.itemGap,m=o.getTextWidth("国",s),g;a.orient=="vertical"&&a.x=="right"&&(c=l.x+l.width-p);var y=!0;a.text&&(y=!1,a.text[0]&&(i=_(c,h,a.text[0]),a.orient=="horizontal"?c+=o.getTextWidth(a.text[0],s)+b:h+=m+b,u.shapeList.push(i)));for(var E=0;E<t;E++)n=e[E],g=W((t-E)*w+a.min),r=D(c,h,p,d,x[E]?g:"#ccc"),r._idx=E,r.onclick=R,u.shapeList.push(r),y&&(i={shape:"text",zlevel:f,style:{x:c+p+5,y:h,color:x[E]?a.textStyle.color:"#ccc",text:e[E],textFont:s,textBaseline:"top"},clickable:!0},a.orient=="vertical"&&a.x=="right"&&(i.style.x-=p+10,i.style.textAlign="right"),i._idx=E,i.onclick=R,u.shapeList.push(i)),a.orient=="horizontal"?c+=p+(y?5:0)+(y?o.getTextWidth(n,s):0)+v:h+=d+v;!y&&a.text[1]&&(a.orient=="horizontal"?c=c-v+b:h=h-v+b,i=_(c,h,a.text[1]),u.shapeList.push(i))}function C(){var t,n,r=u.getFont(a.textStyle),i=l.x,s=l.y,h=a.itemWidth,p=a.itemHeight,d=o.getTextWidth("国",r),v=!0;a.text&&(v=!1,a.text[0]&&(n=_(i,s,a.text[0]),a.orient=="horizontal"?i+=o.getTextWidth(a.text[0],r)+b:s+=d+b,u.shapeList.push(n)));var m=e("zrender/tool/color"),g=1/(a.color.length-1),y=[];for(var w=0,E=a.color.length;w<E;w++)y.push([w*g,a.color[w]]);a.orient=="horizontal"?(t={shape:"rectangle",zlevel:f,style:{x:i,y:s,width:h*10,height:p,color:m.getLinearGradient(i,s,i+h*10,s,y)},hoverable:!1},i+=h*10+b):(t={shape:"rectangle",zlevel:f,style:{x:i,y:s,width:h,height:p*10,color:m.getLinearGradient(i,s,i,s+p*10,y)},hoverable:!1},s+=p*10+b),u.shapeList.push(t),a.calculable&&(c=t.style,k(),A(),L()),!v&&a.text[1]&&(n=_(i,s,a.text[1]),u.shapeList.push(n))}function k(){m={shape:"rectangle",zlevel:f+1,style:{x:c.x,y:c.y,width:c.width,height:c.height,color:"rgba(255,255,255,0.2)"},draggable:!0,ondrift:P,ondragend:H,_type:"filler"},u.shapeList.push(m)}function L(){var e=c.x,t=c.y,n=c.width,r=c.height,i=u.getFont(a.textStyle),s=o.getTextWidth("国",i)+2,l=Math.max(o.getTextWidth(a.precision===0?a.max:a.max.toFixed(a.precision),i),o.getTextWidth(a.precision===0?a.min:a.min.toFixed(a.precision),i))+2,p,v,m,g,y,b;a.orient=="horizontal"?a.y!="bottom"?(p=[[e,t],[e,t+r+s/2*3],[e-l,t+r+s/2*3],[e-l,t+r+s/2],[e-s/2,t+r+s/2],[e-1,t+r],[e-1,t]],v=e-l/2,m=t+r+s,g=[[e+n,t],[e+n,t+r+s/2*3],[e+n+l,t+r+s/2*3],[e+n+l,t+r+s/2],[e+n+s/2,t+r+s/2],[e+n+1,t+r],[e+n+1,t]],y=e+n+l/2,b=m):(p=[[e,t+r],[e,t-s/2*3],[e-l,t-s/2*3],[e-l,t-s/2],[e-s/2,t-s/2],[e-1,t],[e-1,t+r]],v=e-l/2,m=t-s,g=[[e+n,t+r],[e+n,t-s/2*3],[e+n+l,t-s/2*3],[e+n+l,t-s/2],[e+n+s/2,t-s/2],[e+n+1,t],[e+n+1,t+r]],y=e+n+l/2,b=m):(l+=s,a.x!="right"?(p=[[e,t],[e+n+l,t],[e+n+l,t-s],[e+n+s,t-s],[e+n,t-1],[e,t-1]],v=e+n+l/2+s/2,m=t-s/2,g=[[e,t+r],[e+n+l,t+r],[e+n+l,t+s+r],[e+n+s,t+s+r],[e+n,t+1+r],[e,t+r+1]],y=v,b=t+r+s/2):(p=[[e+n,t],[e-l,t],[e-l,t-s],[e-s,t-s],[e,t-1],[e+n,t-1]],v=e-l/2-s/2,m=t-s/2,g=[[e+n,t+r],[e-l,t+r],[e-l,t+s+r],[e-s,t+s+r],[e,t+1+r],[e+n,t+r+1]],y=v,b=t+r+s/2)),h={shape:"polygon",zlevel:f+1,style:{pointList:p,text:a.max+"",textX:v,textY:m,textPosition:"specific",textAlign:"center",textBaseline:"middle ",textColor:a.textStyle.color,color:W(a.max),width:0,height:0,x:p[0][0],y:p[0][1],_x:p[0][0],_y:p[0][1]},draggable:!0,ondrift:P,ondragend:H},d={shape:"polygon",zlevel:f+1,style:{pointList:g,text:a.min+"",textX:y,textY:b,textPosition:"specific",textAlign:"center",textBaseline:"middle ",textColor:a.textStyle.color,color:W(a.min),width:0,height:0,x:g[0][0],y:g[0][1],_x:g[0][0],_y:g[0][1]},draggable:!0,ondrift:P,ondragend:H},u.shapeList.push(h),u.shapeList.push(d)}function A(){var e=c.x,t=c.y,n=c.width,r=c.height;p={shape:"rectangle",zlevel:f+1,style:{x:e,y:t,width:a.orient=="horizontal"?0:n,height:a.orient=="horizontal"?r:0,color:"#ccc"},hoverable:!1},v={shape:"rectangle",zlevel:f+1,style:{x:a.orient=="horizontal"?e+n:e,y:a.orient=="horizontal"?t:t+r,width:a.orient=="horizontal"?0:n,height:a.orient=="horizontal"?r:0,color:"#ccc"},hoverable:!1},u.shapeList.push(p),u.shapeList.push(v)}function O(){var e=a.padding[0],t=a.padding[1],n=a.padding[2],r=a.padding[3];u.shapeList.push({shape:"rectangle",zlevel:f,hoverable:!1,style:{x:l.x-r,y:l.y-e,width:l.width+r+t,height:l.height+e+n,brushType:a.borderWidth===0?"fill":"both",color:a.backgroundColor,strokeColor:a.borderColor,lineWidth:a.borderWidth}})}function M(){var e=S,t=e.length,r=a.itemGap,i=a.itemWidth,s=a.itemHeight,f=0,l=0,c=u.getFont(a.textStyle),h=o.getTextWidth("国",c);if(a.orient=="horizontal"){if(a.text||a.splitNumber<=0||a.calculable)f=(a.splitNumber<=0||a.calculable?i*10+r:t*(i+r))+(a.text&&typeof a.text[0]!="undefined"?o.getTextWidth(a.text[0],c)+b:0)+(a.text&&typeof a.text[1]!="undefined"?o.getTextWidth(a.text[1],c)+b:0);else{i+=5;for(var p=0;p<t;p++)f+=i+o.getTextWidth(e[p],c)+r}f-=r,l=Math.max(h,s)}else{var d;if(a.text||a.splitNumber<=0||a.calculable)l=(a.splitNumber<=0||a.calculable?s*10+r:t*(s+r))+(a.text&&typeof a.text[0]!="undefined"?b+h:0)+(a.text&&typeof a.text[1]!="undefined"?b+h:0),d=Math.max(o.getTextWidth(a.text&&a.text[0]||"",c),o.getTextWidth(a.text&&a.text[1]||"",c)),f=Math.max(i,d);else{l=(s+r)*t,i+=5,d=0;for(var p=0;p<t;p++)d=Math.max(d,o.getTextWidth(e[p],c));f=i+d}l-=r}var v,m=n.getWidth();switch(a.x){case"center":v=Math.floor((m-f)/2);break;case"left":v=a.padding[3]+a.borderWidth;break;case"right":v=m-f-a.padding[1]-a.borderWidth;break;default:v=a.x-0,v=isNaN(v)?0:v}var g,y=n.getHeight();switch(a.y){case"top":g=a.padding[0]+a.borderWidth;break;case"bottom":g=y-l-a.padding[2]-a.borderWidth;break;case"center":g=Math.floor((y-l)/2);break;default:g=a.y-0,g=isNaN(g)?0:g}if(a.calculable){var w=Math.max(o.getTextWidth(a.max,c),o.getTextWidth(a.min,c));a.orient=="horizontal"?(v<w&&(v=w+5),v+f+w>m&&(v-=w+5)):(g<h&&(g=h+5),g+l+h>y&&(g-=h+5))}return{x:v,y:g,width:f,height:l}}function _(e,t,n){return{shape:"text",zlevel:f,style:{x:a.orient=="horizontal"?e:l.x+l.width/2,y:a.orient=="horizontal"?l.y+l.height/2:t,color:a.textStyle.color,text:n,textFont:u.getFont(a.textStyle),textBaseline:a.orient=="horizontal"?"middle":"top",textAlign:a.orient=="horizontal"?"left":"center"}}}function D(e,t,n,r,i){return{shape:"rectangle",zlevel:f,style:{x:e,y:t+1,width:n,height:r-2,color:i},clickable:!0}}function P(e,t,n){var r=c.x,i=c.y,s=c.width,o=c.height;return a.orient=="horizontal"?e.style.x+t<=r?e.style.x=r:e.style.x+t+e.style.width>=r+s?e.style.x=r+s-e.style.width:e.style.x+=t:e.style.y+n<=i?e.style.y=i:e.style.y+n+e.style.height>=i+o?e.style.y=i+o-e.style.height:e.style.y+=n,e._type=="filler"?j():F(e),a.realtime?q():(clearTimeout(y),y=setTimeout(q,200)),!0}function H(){u.isDragend=!0}function B(e,n){if(!u.isDragend||!e.target)return;q(),n.dragOut=!0,n.dragIn=!0,a.realtime||t.dispatch(s.EVENT.DATA_RANGE),n.needRefresh=!1,u.isDragend=!1;return}function j(){var e=c.x,t=c.y,n=c.width,r=c.height;a.orient=="horizontal"?(h.style.x=m.style.x,p.style.width=h.style.x-e,d.style.x=m.style.x+m.style.width,v.style.x=d.style.x,v.style.width=e+n-d.style.x,g.start=Math.ceil(100-(h.style.x-e)/n*100),g.end=Math.floor(100-(d.style.x-e)/n*100)):(h.style.y=m.style.y,p.style.height=h.style.y-t,d.style.y=m.style.y+m.style.height,v.style.y=d.style.y,v.style.height=t+r-d.style.y,g.start=Math.ceil(100-(h.style.y-t)/r*100),g.end=Math.floor(100-(d.style.y-t)/r*100)),I(!1)}function F(e){var t=c.x,n=c.y,r=c.width,i=c.height,s,o;a.orient=="horizontal"?(s=h.style.x,o=d.style.x,e.id==h.id&&s>=o?(o=s,d.style.x=s):e.id==d.id&&s>=o&&(s=o,h.style.x=s),m.style.x=s,m.style.width=o-s,p.style.width=s-t,v.style.x=o,v.style.width=t+r-o,g.start=Math.ceil(100-(s-t)/r*100),g.end=Math.floor(100-(o-t)/r*100)):(s=h.style.y,o=d.style.y,e.id==h.id&&s>=o?(o=s,d.style.y=s):e.id==d.id&&s>=o&&(s=o,h.style.y=s),m.style.y=s,m.style.height=o-s,p.style.height=s-n,v.style.y=o,v.style.height=n+i-o,g.start=Math.ceil(100-(s-n)/i*100),g.end=Math.floor(100-(o-n)/i*100)),I(!0)}function I(e){h.position=[h.style.x-h.style._x,h.style.y-h.style._y],a.precision===0?h.style.text=Math.round(w*g.start+a.min)+"":h.style.text=(w*g.start+a.min).toFixed(a.precision),h.style.color=W(w*g.start+a.min),n.modShape(h.id,h),d.position=[d.style.x-d.style._x,d.style.y-d.style._y],a.precision===0?d.style.text=Math.round(w*g.end+a.min)+"":d.style.text=(w*g.end+a.min).toFixed(a.precision),d.style.color=W(w*g.end+a.min),n.modShape(d.id,d),n.modShape(p.id,p),n.modShape(v.id,v),e&&n.modShape(m.id,m),n.refresh()}function q(){a.realtime&&t.dispatch(s.EVENT.DATA_RANGE)}function R(e){var n=e.target._idx;x[n]=!x[n],t.dispatch(s.EVENT.REFRESH)}function U(t){if(typeof u.deepQuery([t],"dataRange.min")=="undefined"||typeof u.deepQuery([t],"dataRange.max")=="undefined")return;r=t,r.dataRange=u.reformOption(r.dataRange),r.dataRange.padding=u.reformCssArray(r.dataRange.padding),a=r.dataRange,u.clear(),x={};var n=e("zrender/tool/color"),i=a.splitNumber<=0||a.calculable?100:a.splitNumber;E=n.getGradientColors(a.color,(i-a.color.length)/(a.color.length-1)+1),E=E.slice(0,i),a.precision===0?w=Math.round((a.max-a.min)/i)||1:(w=(a.max-a.min)/i,w=w.toFixed(a.precision)-0),S=[];for(var s=0;s<i;s++)x[s]=!0,S.unshift((s*w+a.min).toFixed(a.precision)+" - "+((s+1)*w+a.min).toFixed(a.precision));g={start:100,end:0},T()}function z(){a=r.dataRange,g={start:100,end:0},u.clear(),T()}function W(e){if(isNaN(e))return null;e<a.min?e=a.min:e>a.max&&(e=a.max);if(a.calculable)if(e>w*g.start+a.min||e<w*g.end+a.min)return null;var t=E.length-Math.ceil((e-a.min)/(a.max-a.min)*E.length);return t==E.length&&t--,x[t]?E[t]:null}var i=e("./base");i.call(this,n);var s=e("../config"),o=e("zrender/tool/area"),u=this;u.type=s.COMPONENT_TYPE_DATARANGE;var a,f=u.getZlevelBase(),l={},c,h,p,d,v,m,g,y,b=10,w,E,S,x={};u.init=U,u.refresh=z,u.getColor=W,u.ondragend=B,U(r)}return e("../component").define("dataRange",t),t}),define("echarts/component/tooltip",["require","./base","../config","../util/ecData","zrender/config","zrender/shape","zrender/tool/event","zrender/tool/area","zrender/tool/color","zrender/tool/util","../component"],function(e){function t(t,n,r,i){function B(e){if(!e)return"";cssText=[];if(e.transitionDuration){var t="left "+e.transitionDuration+"s,"+"top "+e.transitionDuration+"s";cssText.push("transition:"+t),cssText.push("-moz-transition:"+t),cssText.push("-webkit-transition:"+t),cssText.push("-o-transition:"+t)}e.backgroundColor&&(cssText.push("background-Color:"+h.toHex(e.backgroundColor)),cssText.push("filter:alpha(opacity=70)"),cssText.push("background-Color:"+e.backgroundColor)),typeof e.borderWidth!="undefined"&&cssText.push("border-width:"+e.borderWidth+"px"),typeof e.borderColor!="undefined"&&cssText.push("border-color:"+e.borderColor),typeof e.borderRadius!="undefined"&&(cssText.push("border-radius:"+e.borderRadius+"px"),cssText.push("-moz-border-radius:"+e.borderRadius+"px"),cssText.push("-webkit-border-radius:"+e.borderRadius+"px"),cssText.push("-o-border-radius:"+e.borderRadius+"px"));var n=e.textStyle;n&&(n.color&&cssText.push("color:"+n.color),n.decoration&&cssText.push("text-decoration:"+n.decoration),n.align&&cssText.push("text-align:"+n.align),n.fontFamily&&cssText.push("font-family:"+n.fontFamily),n.fontSize&&cssText.push("font-size:"+n.fontSize+"px"),n.fontSize&&cssText.push("line-height:"+Math.round(n.fontSize*3/2)+"px"),n.fontStyle&&cssText.push("font-style:"+n.fontStyle),n.fontWeight&&cssText.push("font-weight:"+n.fontWeight));var r=e.padding;return typeof r!="undefined"&&(r=v.reformCssArray(r),cssText.push("padding:"+r[0]+"px "+r[1]+"px "+r[2]+"px "+r[3]+"px")),cssText=cssText.join(";")+";",cssText}function j(){E&&(E.style.display="none");var e=!1;P.invisible||(P.invisible=!0,n.modShape(P.id,P),e=!0),H.invisible||(H.invisible=!0,n.modShape(H.id,H),e=!0),e&&n.refresh()}function F(e,t,n){var r=E.offsetHeight,i=E.offsetWidth;e+i>D&&(e=D-i),t+r>_&&(t=_-r),t<20&&(t=0),E.style.cssText=S+x+(n?n:"")+"left:"+e+"px;top:"+t+"px;",(D-e<100||_-t<100)&&setTimeout(I,20)}function I(){if(E){var e="",t=E.offsetHeight,n=E.offsetWidth;E.offsetLeft+n>D&&(e+="left:"+(D-n)+"px;"),E.offsetTop+t>_&&(e+="top:"+(_-t)+"px;"),e!==""&&(E.style.cssText+=e)}}function q(){var e,t;if(!A)R();else{if(A._type=="island"&&v.deepQuery([r],"tooltip.show")){W();return}var n=u.get(A,"series"),i=u.get(A,"data");e=v.deepQuery([i,n,r],"tooltip.show"),typeof n=="undefined"||typeof i=="undefined"||e===!1?(clearTimeout(N),clearTimeout(k),N=setTimeout(j,C)):(t=v.deepQuery([i,n,r],"tooltip.trigger"),t=="axis"?z(n.xAxisIndex,n.yAxisIndex,u.get(A,"dataIndex")):W())}}function R(){var e=r.series,t,n;if(!b||!w){N=setTimeout(j,C);return}for(var i=0,s=e.length;i<s;i++)if(v.deepQuery([e[i],r],"tooltip.trigger")=="axis"){t=e[i].xAxisIndex||0,n=e[i].yAxisIndex||0;if(b.getAxis(t)&&b.getAxis(t).type==o.COMPONENT_TYPE_AXIS_CATEGORY){z(t,n,U("x",b.getAxis(t)));return}if(w.getAxis(n)&&w.getAxis(n).type==o.COMPONENT_TYPE_AXIS_CATEGORY){z(t,n,U("y",w.getAxis(n)));return}}}function U(e,t){var n=-1,r=l.getX(O),i=l.getY(O);if(e=="x"){var s,o,u=y.getXend(),a=t.getCoordByIndex(n);while(a<u){a<=r&&(s=a);if(a>=r)break;a=t.getCoordByIndex(++n),o=a}return r-s<o-r?n-=1:typeof t.getNameByIndex(n)=="undefined"&&(n=-1),n}var f,c,h=y.getY(),a=t.getCoordByIndex(n);while(a>h){a>=i&&(c=a);if(a<=i)break;a=t.getCoordByIndex(++n),f=a}return i-f>c-i?n-=1:typeof t.getNameByIndex(n)=="undefined"&&(n=-1),n}function z(e,t,n){if(typeof b=="undefined"||typeof w=="undefined"||typeof e=="undefined"||typeof t=="undefined"||n<0){clearTimeout(N),clearTimeout(k),N=setTimeout(j,C);return}var s=r.series,u=[],a,f,c,h,p="";if(v.deepQuery([r],"tooltip.trigger")=="axis"){if(v.deepQuery([r],"tooltip.show")===!1)return;h=v.deepQuery([r],"tooltip.formatter")}if(e!=-1&&b.getAxis(e).type==o.COMPONENT_TYPE_AXIS_CATEGORY){a=b.getAxis(e);for(var d=0,m=s.length;d<m;d++)s[d].xAxisIndex==e&&v.deepQuery([s[d],r],"tooltip.trigger")=="axis"&&(h=v.deepQuery([s[d]],"tooltip.formatter")||h,p+=B(v.deepQuery([s[d]],"tooltip")),u.push(s[d]));c=l.getY(O)+10,f=a.getCoordByIndex(n),X(u,f,y.getY(),f,y.getYend(),a.getGap()),f+=10}else if(t!=-1&&w.getAxis(t).type==o.COMPONENT_TYPE_AXIS_CATEGORY){a=w.getAxis(t);for(var d=0,m=s.length;d<m;d++)s[d].yAxisIndex==t&&v.deepQuery([s[d],r],"tooltip.trigger")=="axis"&&(h=v.deepQuery([s[d]],"tooltip.formatter")||h,p+=B(v.deepQuery([s[d]],"tooltip")),u.push(s[d]));f=l.getX(O)+10,c=a.getCoordByIndex(n),X(u,y.getX(),c,y.getXend(),c,a.getGap()),c+=10}if(u.length>0){var g;if(typeof h=="function"){var S=[];for(var d=0,m=u.length;d<m;d++)g=u[d].data[n],g=typeof g!="undefined"?typeof g.value!="undefined"?g.value:g:"-",S.push([u[d].name,a.getNameByIndex(n),g]);M="axis:"+n,E.innerHTML=h(S,M,$)}else if(typeof h=="string"){h=h.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}");for(var d=0,m=u.length;d<m;d++)h=h.replace("{a"+d+"}",u[d].name),h=h.replace("{b"+d+"}",a.getNameByIndex(n)),g=u[d].data[n],g=typeof g!="undefined"?typeof g.value!="undefined"?g.value:g:"-",h=h.replace("{c"+d+"}",g);E.innerHTML=h}else{h=a.getNameByIndex(n);for(var d=0,m=u.length;d<m;d++)h+="<br/>"+u[d].name+" : ",g=u[d].data[n],g=g=typeof g!="undefined"?typeof g.value!="undefined"?g.value:g:"-",h+=g;E.innerHTML=h}v.hasAppend||(E.style.left=D/2+"px",E.style.top=_/2+"px",i.firstChild.appendChild(E),v.hasAppend=!0),F(f,c,p)}}function W(){var e=u.get(A,"series"),t=u.get(A,"data"),s=u.get(A,"name"),a=u.get(A,"value"),f=u.get(A,"special"),c,h="";A._type!="island"?(v.deepQuery([r],"tooltip.trigger")=="item"&&(c=v.deepQuery([r],"tooltip.formatter")||c),v.deepQuery([e],"tooltip.trigger")=="item"&&(c=v.deepQuery([e],"tooltip.formatter")||c,h+=B(v.deepQuery([e],"tooltip"))),c=v.deepQuery([t],"tooltip.formatter")||c,h+=B(v.deepQuery([t],"tooltip"))):c=v.deepQuery([t,e,r],"tooltip.islandFormatter"),typeof c=="function"?(M=e.name+":"+u.get(A,"dataIndex"),E.innerHTML=c([e.name,s,a,f],M,$)):typeof c=="string"?(c=c.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}").replace("{d}","{d0}"),c=c.replace("{a0}",e.name).replace("{b0}",s).replace("{c0}",a),typeof f!="undefined"&&(c=c.replace("{d0}",f)),E.innerHTML=c):e.type!=o.CHART_TYPE_SCATTER?E.innerHTML=e.name+"<br/>"+s+" : "+a+(typeof f=="undefined"?"":" ("+f+")"):E.innerHTML=e.name+"<br/>"+(s===""?"":s+" : ")+a+(typeof f=="undefined"?"":" ("+f+")"),v.hasAppend||(E.style.left=D/2+"px",E.style.top=_/2+"px",i.firstChild.appendChild(E),v.hasAppend=!0),F(l.getX(O)+20,l.getY(O)-20,h),P.invisible||(P.invisible=!0,n.modShape(P.id,P),n.refresh())}function X(e,t,i,s,o,u){if(e.length>0){var a,f,l=r.tooltip.axisPointer,c=l.type,h=l.lineStyle.color,p=l.lineStyle.width,d=l.lineStyle.type,m=l.areaStyle.size,g=l.areaStyle.color;for(var b=0,w=e.length;b<w;b++)v.deepQuery([e[b],r],"tooltip.trigger")=="axis"&&(a=[e[b]],f=v.deepQuery(a,"tooltip.axisPointer.type"),c=f||c,f=="line"?(h=v.deepQuery(a,"tooltip.axisPointer.lineStyle.color")||h,p=v.deepQuery(a,"tooltip.axisPointer.lineStyle.width")||p,d=v.deepQuery(a,"tooltip.axisPointer.lineStyle.type")||d):f=="shadow"&&(m=v.deepQuery(a,"tooltip.axisPointer.areaStyle.size")||m,g=v.deepQuery(a,"tooltip.axisPointer.areaStyle.color")||g));c=="line"?(P.style={xStart:t,yStart:i,xEnd:s,yEnd:o,strokeColor:h,lineWidth:p,lineType:d},P.invisible=!1,n.modShape(P.id,P)):c=="shadow"&&(typeof m=="undefined"||m=="auto"||isNaN(m)?p=u:p=m,t==s?Math.abs(y.getX()-t)<2?(p/=2,t=s+=p/2):Math.abs(y.getXend()-t)<2&&(p/=2,t=s-=p/2):i==o&&(Math.abs(y.getY()-i)<2?(p/=2,i=o+=p/2):Math.abs(y.getYend()-i)<2&&(p/=2,i=o-=p/2)),H.style={xStart:t,yStart:i,xEnd:s,yEnd:o,strokeColor:g,lineWidth:p},H.invisible=!1,n.modShape(H.id,H)),n.refresh()}}function V(e){clearTimeout(N),clearTimeout(k);var t=e.target;!t&&y?T&&c.isInside(d,y.getArea(),l.getX(e.event),l.getY(e.event))?(A=!1,O=e.event,O._target=O.target||O.toElement,O.zrenderX=l.getX(O),O.zrenderY=l.getY(O),k=setTimeout(q,L)):N=setTimeout(j,C):(A=t,O=e.event,O._target=O.target||O.toElement,O.zrenderX=l.getX(O),O.zrenderY=l.getY(O),k=setTimeout(q,L))}function $(e,t){e==M&&(E.innerHTML=t);var n="",r=E.offsetHeight,i=E.offsetWidth;E.offsetLeft+i>D&&(n+="left:"+(D-i)+"px;"),E.offsetTop+r>_&&(n+="top:"+(_-r)+"px;"),n!==""&&(E.style.cssText+=n),(D-E.offsetLeft<100||_-E.offsetTop<100)&&setTimeout(I,20)}function J(e){g=e,y=g.grid,b=g.xAxis,w=g.yAxis}function K(e,t){r=e,i=t,r.tooltip=v.reformOption(r.tooltip),r.tooltip.textStyle=p.merge(r.tooltip.textStyle,o.textStyle,{overwrite:!1,recursive:!0}),r.tooltip.padding=v.reformCssArray(r.tooltip.padding),T=!1,r.tooltip.trigger=="axis"&&(T=!0);var n=r.series;for(var s=0,u=n.length;s<u;s++)if(v.deepQuery([n[s]],"tooltip.trigger")=="axis"){T=!0;break}L=r.tooltip.showDelay,C=r.tooltip.hideDelay,x=B(r.tooltip),E.style.position="absolute",v.hasAppend=!1}function Q(){_=n.getHeight(),D=n.getWidth()}function G(){clearTimeout(N),clearTimeout(k),n.un(a.EVENT.MOUSEMOVE,V),v.hasAppend&&i.firstChild.removeChild(E),E=null,v.shapeList=null,v=null}var s=e("./base");s.call(this,n);var o=e("../config"),u=e("../util/ecData"),a=e("zrender/config"),f=e("zrender/shape"),l=e("zrender/tool/event"),c=e("zrender/tool/area"),h=e("zrender/tool/color"),p=e("zrender/tool/util"),d=f.get("rectangle"),v=this;v.type=o.COMPONENT_TYPE_TOOLTIP;var m=v.getZlevelBase(),g={},y,b,w,E=document.createElement("div"),S="position:absolute;display:block;border-style:solid;white-space:nowrap;",x,T,N,C,k,L,A,O,M,_=n.getHeight(),D=n.getWidth(),P={shape:"line",id:n.newShapeId("tooltip"),zlevel:m,invisible:!0,hoverable:!1,style:{}},H={shape:"line",id:n.newShapeId("tooltip"),zlevel:1,invisible:!0,hoverable:!1,style:{}};n.addShape(P),n.addShape(H),n.on(a.EVENT.MOUSEMOVE,V),v.dispose=G,v.init=K,v.resize=Q,v.setComponent=J,K(r,i)}return e("../component").define("tooltip",t),t}),define("echarts/component/toolbox",["require","./base","../config","zrender/config","zrender/tool/event","../component","../component"],function(e){function t(t,n,r){function L(){d=[];var e=a.toolbox.feature;for(var t in e)if(e[t])switch(t){case"mark":d.push("mark"),d.push("markUndo"),d.push("markClear");break;case"magicType":for(var r=0,i=e[t].length;r<i;r++)d.push(e[t][r]+"Chart");break;case"dataZoom":d.push("dataZoom"),d.push("dataZoomReset");break;case"saveAsImage":G_vmlCanvasManager||d.push("saveAsImage");break;default:d.push(t)}if(d.length>0){m=M(),O(),A();for(var r=0,i=l.shapeList.length;r<i;r++)l.shapeList[r].id=n.newShapeId(l.type),n.addShape(l.shapeList[r]);v.mark&&(z(v.markUndo),z(v.markClear)),v.dataZoomReset&&C.length===0&&z(v.dataZoomReset)}}function A(){var i=a.toolbox,s=d.length,o=m.x,u=m.y,f=i.itemSize,p=i.itemGap,y,w=i.color instanceof Array?i.color:[i.color];v={};for(var E=0;E<s;E++){y={shape:"icon",zlevel:c,style:{x:o,y:u,width:f,height:f,iconType:d[E],strokeColor:w[E%w.length],shadowColor:"#ccc",shadowBlur:2,shadowOffsetX:2,shadowOffsetY:2,brushType:"stroke"},highlightStyle:{lineWidth:2,shadowBlur:5,strokeColor:w[E%w.length]},hoverable:!0,clickable:!0};switch(d[E]){case"mark":y.onclick=_,b=y.style.strokeColor;break;case"markUndo":y.onclick=F;break;case"markClear":y.onclick=I;break;case"dataZoom":y.onclick=D;break;case"dataZoomReset":y.onclick=q;break;case"dataView":if(!k){var S=e("../component"),x=S.get("dataView");k=new x(t,n,a,r)}y.onclick=X;break;case"restore":y.onclick=V;break;case"saveAsImage":y.onclick=$;break;default:d[E].match("Chart")&&(y._name=d[E].replace("Chart",""),y._name==h&&(y.style.strokeColor=g),y.onclick=J)}l.shapeList.push(y),v[d[E]]=y,i.orient=="horizontal"?o+=f+p:u+=f+p}}function O(){var e=a.toolbox,t=e.padding[0],n=e.padding[1],r=e.padding[2],i=e.padding[3];l.shapeList.push({shape:"rectangle",zlevel:c,hoverable:!1,style:{x:m.x-i,y:m.y-t,width:m.width+i+n,height:m.height+t+r,brushType:e.borderWidth===0?"fill":"both",color:e.backgroundColor,strokeColor:e.borderColor,lineWidth:e.borderWidth}})}function M(){var e=a.toolbox,t=d.length,r=e.itemGap,i=e.itemSize,s=0,o=0;e.orient=="horizontal"?(s=(i+r)*t-r,o=i):(o=(i+r)*t-r,s=i);var u,f=n.getWidth();switch(e.x){case"center":u=Math.floor((f-s)/2);break;case"left":u=e.padding[3]+e.borderWidth;break;case"right":u=f-s-e.padding[1]-e.borderWidth;break;default:u=e.x-0,u=isNaN(u)?0:u}var l,c=n.getHeight();switch(e.y){case"top":l=e.padding[0]+e.borderWidth;break;case"bottom":l=c-o-e.padding[2]-e.borderWidth;break;case"center":l=Math.floor((c-o)/2);break;default:l=e.y-0,l=isNaN(l)?0:l}return{x:u,y:l,width:s,height:o}}function _(e){var t=e.target;return E||w?(R(),n.refresh()):(U(),n.modShape(t.id,{style:{strokeColor:g}}),n.refresh(),w=!0,setTimeout(function(){n&&n.on(o.EVENT.CLICK,j)&&n.on(o.EVENT.MOUSEMOVE,P)},10)),!0}function D(e){var t=e.target;return T||x?(U(),n.refresh()):(R(),n.modShape(t.id,{style:{strokeColor:g}}),n.refresh(),x=!0,setTimeout(function(){n&&n.on(o.EVENT.MOUSEDOWN,H)&&n.on(o.EVENT.MOUSEUP,B)&&n.on(o.EVENT.MOUSEMOVE,P)},10)),!0}function P(e){E&&(S.style.xEnd=u.getX(e.event),S.style.yEnd=u.getY(e.event),n.addHoverShape(S)),T&&(N.style.width=u.getX(e.event)-N.style.x,N.style.height=u.getY(e.event)-N.style.y,n.addHoverShape(N))}function H(e){if(e.target)return;T=!0;var t=u.getX(e.event),r=u.getY(e.event),i=a.dataZoom||{};return N={shape:"rectangle",id:n.newShapeId("zoom"),zlevel:c,style:{x:t,y:r,width:1,height:1,brushType:"both"},highlightStyle:{lineWidth:2,color:i.fillerColor||s.dataZoom.fillerColor,strokeColor:i.handleColor||s.dataZoom.handleColor,brushType:"both"}},n.addHoverShape(N),!0}function B(){if(!N||Math.abs(N.style.width)<10||Math.abs(N.style.height)<10)return T=!1,!0;if(T&&f.dataZoom){T=!1;var e=f.dataZoom.rectZoom(N.style);e&&(C.push({start:e.start,end:e.end,start2:e.start2,end2:e.end2}),W(v.dataZoomReset),n.refresh())}return!0}function j(e){if(E)E=!1,l.shapeList.push(S),W(v.markUndo),W(v.markClear),n.addShape(S),n.refresh();else if(w){E=!0;var t=u.getX(e.event),r=u.getY(e.event);S={shape:"line",id:n.newShapeId("mark"),zlevel:c,style:{xStart:t,yStart:r,xEnd:t,yEnd:r,lineWidth:l.deepQuery([a],"toolbox.feature.mark.lineStyle.width")||2,strokeColor:l.deepQuery([a],"toolbox.feature.mark.lineStyle.color")||b,lineType:l.deepQuery([a],"toolbox.feature.mark.lineStyle.type")||"dashed"}},n.addHoverShape(S)}}function F(){if(E)E=!1;else{var e=l.shapeList.length-1;d.length==e-1&&(z(v.markUndo),z(v.markClear));if(d.length<e){var t=l.shapeList[l.shapeList.length-1];n.delShape(t.id),n.refresh(),l.shapeList.pop()}}return!0}function I(){E&&(E=!1);var e=l.shapeList.length-d.length-1,t=!1;while(e--)n.delShape(l.shapeList.pop().id),t=!0;return t&&(z(v.markUndo),z(v.markClear),n.refresh()),!0}function q(){return T&&(T=!1),C.pop(),C.length>0?f.dataZoom.absoluteZoom(C[C.length-1]):(f.dataZoom.rectZoom(),z(v.dataZoomReset),n.refresh()),!0}function R(){E=!1,w&&(w=!1,v.mark&&n.modShape(v.mark.id,{style:{strokeColor:v.mark.highlightStyle.strokeColor}}),n.un(o.EVENT.CLICK,j),n.un(o.EVENT.MOUSEMOVE,P))}function U(){T=!1,x&&(x=!1,v.dataZoom&&n.modShape(v.dataZoom.id,{style:{strokeColor:v.dataZoom.highlightStyle.strokeColor}}),n.un(o.EVENT.MOUSEDOWN,H),n.un(o.EVENT.MOUSEUP,B),n.un(o.EVENT.MOUSEMOVE,P))}function z(e){n.modShape(e.id,{hoverable:!1,clickable:!1,style:{strokeColor:y}})}function W(e){n.modShape(e.id,{hoverable:!0,clickable:!0,style:{strokeColor:e.highlightStyle.strokeColor}})}function X(){return k.show(a),!0}function V(){return R(),U(),t.dispatch(s.EVENT.RESTORE),!0}function $(){function o(){var e=document.getElementById("__echarts_download_wrap__");e.onclick=null,e.innerHTML="",document.body.removeChild(e),e=null}var e=a.toolbox.feature.saveAsImage,t=e.type||"png";t!="png"&&t!="jpeg"&&(t="png");var r=n.toDataURL("image/"+t),i=document.createElement("div");i.id="__echarts_download_wrap__",i.style.cssText="position:fixed;z-index:99999;display:block;top:0;left:0;background-color:rgba(33,33,33,0.5);text-align:center;width:100%;height:100%;line-height:"+document.documentElement.clientHeight+"px;",i.onclick=o;var s=document.createElement("a");s.href=r,s.setAttribute("download",(e.name?e.name:a.title&&(a.title.text||a.title.subtext)?a.title.text||a.title.subtext:"ECharts")+"."+t),s.innerHTML='<img src="'+r+'" title="'+(!window.attachEvent||navigator.userAgent.indexOf("Opera")!==-1?e.lang?e.lang:"点击保存":"右键->图片另存为")+'"/>',i.appendChild(s),document.body.appendChild(i),s=null,i=null;return}function J(e){R();var n=e.target._name;return n==h?h=!1:h=n,t.dispatch(s.EVENT.MAGIC_TYPE_CHANGED,e.event,{magicType:h}),!0}function K(e){if(e.toolbox&&e.toolbox.show&&e.toolbox.feature.magicType&&e.toolbox.feature.magicType.length>0){var t=e.toolbox.feature.magicType,n=t.length;p={};while(n--)p[t[n]]=!0;n=e.series.length;var r,i;while(n--)r=e.series[n].type,p[r]&&(i=e.xAxis instanceof Array?e.xAxis[e.series[n].xAxisIndex||0]:e.xAxis,i&&i.type=="category"&&(i.__boundaryGap=typeof i.boundaryGap!="undefined"?i.boundaryGap:!0),i=e.yAxis instanceof Array?e.yAxis[e.series[n].yAxisIndex||0]:e.yAxis,i&&i.type=="category"&&(i.__boundaryGap=typeof i.boundaryGap!="undefined"?i.boundaryGap:!0),e.series[n].__type=r)}h=!1;var s=e.dataZoom;if(s&&s.show){var o=typeof s.start!="undefined"&&s.start>=0&&s.start<=100?s.start:0,u=typeof s.end!="undefined"&&s.end>=0&&s.end<=100?s.end:100;o>u&&(o+=u,u=o-u,o-=u),C=[{start:o,end:u,start2:0,end2:100}]}else C=[]}function Q(){if(h){for(var e=0,t=a.series.length;e<t;e++)p[a.series[e].type]&&(a.series[e].type=h);var n=h==s.CHART_TYPE_LINE?!1:!0,r;if(a.xAxis instanceof Array){r=a.xAxis.length;while(r--)(a.xAxis[r].type||"category")=="category"&&(a.xAxis[r].boundaryGap=n)}else a.xAxis&&(a.xAxis.type||"category")=="category"&&(a.xAxis.boundaryGap=n);if(a.yAxis instanceof Array){r=a.yAxis.length;while(r--)a.yAxis[r].type=="category"&&(a.yAxis[r].boundaryGap=n)}else a.yAxis&&a.yAxis.type=="category"&&(a.yAxis.boundaryGap=n)}else{var i;for(var e=0,t=a.series.length;e<t;e++)p[a.series[e].type]&&(a.series[e].type=a.series[e].__type,a.xAxis instanceof Array?(i=a.xAxis[a.series[e].xAxisIndex||0],i.type=="category"&&(i.boundaryGap=i.__boundaryGap)):(i=a.xAxis,i&&i.type=="category"&&(i.boundaryGap=i.__boundaryGap)),a.yAxis instanceof Array?(i=a.yAxis[a.series[e].yAxisIndex||0],i.type=="category"&&(i.boundaryGap=i.__boundaryGap)):(i=a.yAxis,i&&i.type=="category"&&(i.boundaryGap=i.__boundaryGap)))}return a}function G(e,t){R(),U(),e.toolbox=l.reformOption(e.toolbox),e.toolbox.padding=l.reformCssArray(e.toolbox.padding),a=e,f=t,l.shapeList=[],e.toolbox.show&&L(),Z()}function Y(){R(),l.clear(),a.toolbox.show&&L(),k&&k.resize()}function Z(){k&&k.hide()}function et(){k&&k.dispose(),l.clear(),l.shapeList=null,l=null}var i=e("./base");i.call(this,n);var s=e("../config"),o=e("zrender/config"),u=e("zrender/tool/event"),a,f,l=this;l.type=s.COMPONENT_TYPE_TOOLBOX;var c=l.getZlevelBase(),h,p,d,v={},m,g="red",y="#ccc",b,w,E,S,x,T,N,C,k;l.dispose=et,l.render=G,l.resize=Y,l.hideDataView=Z,l.getMagicOption=Q,l.reset=K}return e("../component").define("toolbox",t),t}),define("echarts/component/dataView",["require","./base","../config","../component"],function(e){function t(t,n,r,i){function b(){v="width:"+y+"px;"+"height:"+0+"px;"+"background-color:#f0ffff;",f.style.cssText=d+v,i.onselectstart=function(){return!1}}function w(e){p=!0;var t=u.deepQuery([r],"toolbox.feature.dataView.lang")||a;r=e,f.innerHTML='<p style="padding:8px 0;margin:0 0 10px 0;border-bottom:1px solid #eee">'+(t[0]||a[0])+"</p>",l.style.cssText="display:block;margin:0 0 8px 0;padding:4px 6px;overflow:auto;width:"+(y-15)+"px;"+"height:"+(g-100)+"px;";var n=u.deepQuery([r],"toolbox.feature.dataView.optionToContent");typeof n!="function"?l.value=E():l.value=n(r),f.appendChild(l),h.style.cssText="float:right;padding:1px 6px;",h.innerHTML=t[1]||a[1],h.onclick=b,f.appendChild(h),u.deepQuery([r],"toolbox.feature.dataView.readOnly")===!1?(c.style.cssText="float:right;margin-right:10px;padding:1px 6px;",c.innerHTML=t[2]||a[2],c.onclick=S,f.appendChild(c),l.readOnly=!1,l.style.cursor="default"):(l.readOnly=!0,l.style.cursor="text"),v="width:"+y+"px;"+"height:"+g+"px;"+"background-color:#fff;",f.style.cssText=d+v,i.onselectstart=function(){return!0}}function E(){var e,t,n,i,s,u,a=[],f="";if(r.xAxis){r.xAxis instanceof Array?a=r.xAxis:a=[r.xAxis];for(e=0,i=a.length;e<i;e++)if((a[e].type||"category")=="category"){u=[];for(t=0,n=a[e].data.length;t<n;t++)s=a[e].data[t],u.push(typeof s.value!="undefined"?s.value:s);f+=u.join(", ")+"\n\n"}}if(r.yAxis){r.yAxis instanceof Array?a=r.yAxis:a=[r.yAxis];for(e=0,i=a.length;e<i;e++)if(a[e].type=="category"){u=[];for(t=0,n=a[e].data.length;t<n;t++)s=a[e].data[t],u.push(typeof s.value!="undefined"?s.value:s);f+=u.join(", ")+"\n\n"}}var l=r.series,c;for(e=0,i=l.length;e<i;e++){u=[];for(t=0,n=l[e].data.length;t<n;t++)s=l[e].data[t],l[e].type==o.CHART_TYPE_PIE||l[e].type==o.CHART_TYPE_MAP?c=(s.name||"-")+":":c="",l[e].type==o.CHART_TYPE_SCATTER&&(s=typeof s.value!="undefined"?s.value:s,s=s.join(", ")),u.push(c+(typeof s.value!="undefined"?s.value:s));f+=(l[e].name||"-")+" : \n",f+=u.join(l[e].type==o.CHART_TYPE_SCATTER?"\n":", "),f+="\n\n"}return f}function S(){var e=l.value,n=u.deepQuery([r],"toolbox.feature.dataView.contentToOption");if(typeof n!="function"){e=e.split("\n");var i=[];for(var s=0,a=e.length;s<a;s++)e[s]=T(e[s]),e[s]!==""&&i.push(e[s]);x(i)}else n(e,r);b(),setTimeout(function(){t&&t.dispatch(o.EVENT.DATA_VIEW_CHANGED,null,{option:r})},G_vmlCanvasManager?100:800)}function x(e){var t,n,i,s,u,a=[],f=0,l,c;if(r.xAxis){r.xAxis instanceof Array?a=r.xAxis:a=[r.xAxis];for(t=0,s=a.length;t<s;t++)if((a[t].type||"category")=="category"){l=e[f].split(",");for(n=0,i=a[t].data.length;n<i;n++)c=T(l[n]||""),u=a[t].data[n],typeof a[t].data[n].value!="undefined"?a[t].data[n].value=c:a[t].data[n]=c;f++}}if(r.yAxis){r.yAxis instanceof Array?a=r.yAxis:a=[r.yAxis];for(t=0,s=a.length;t<s;t++)if(a[t].type=="category"){l=e[f].split(",");for(n=0,i=a[t].data.length;n<i;n++)c=T(l[n]||""),u=a[t].data[n],typeof a[t].data[n].value!="undefined"?a[t].data[n].value=c:a[t].data[n]=c;f++}}var h=r.series;for(t=0,s=h.length;t<s;t++){f++;if(h[t].type==o.CHART_TYPE_SCATTER)for(var n=0,i=h[t].data.length;n<i;n++)l=e[f],c=l.replace(" ","").split(","),typeof h[t].data[n].value!="undefined"?h[t].data[n].value=c:h[t].data[n]=c,f++;else{l=e[f].split(",");for(var n=0,i=h[t].data.length;n<i;n++)c=(l[n]||"").replace(/.*:/,""),c=T(c),c=c!="-"&&c!==""?c-0:"-",typeof h[t].data[n].value!="undefined"?h[t].data[n].value=c:h[t].data[n]=c;f++}}}function T(e){var t=new RegExp("(^[\\s\\t\\xa0\\u3000]+)|([\\u3000\\xa0\\s\\t]+$)","g");return e.replace(t,"")}function N(e){e=e||window.event,e.stopPropagation?e.stopPropagation():e.cancelBubble=!0}function C(){f.className=m,b(),i.firstChild.appendChild(f),window.addEventListener?(f.addEventListener("click",N),f.addEventListener("mousewheel",N),f.addEventListener("mousemove",N),f.addEventListener("mousedown",N),f.addEventListener("mouseup",N),f.addEventListener("touchstart",N),f.addEventListener("touchmove",N),f.addEventListener("touchend",N)):(f.attachEvent("onclick",N),f.attachEvent("onmousewheel",N),f.attachEvent("onmousemove",N),f.attachEvent("onmousedown",N),f.attachEvent("onmouseup",N))}function k(){g=n.getHeight(),y=n.getWidth(),f.offsetHeight>10&&(v="width:"+y+"px;"+"height:"+g+"px;"+"background-color:#fff;",f.style.cssText=d+v,l.style.cssText="display:block;margin:0 0 8px 0;padding:4px 6px;overflow:auto;width:"+(y-15)+"px;"+"height:"+(g-100)+"px;")}function L(){window.removeEventListener?(f.removeEventListener("click",N),f.removeEventListener("mousewheel",N),f.removeEventListener("mousemove",N),f.removeEventListener("mousedown",N),f.removeEventListener("mouseup",N),f.removeEventListener("touchstart",N),f.removeEventListener("touchmove",N),f.removeEventListener("touchend",N)):(f.detachEvent("onclick",N),f.detachEvent("onmousewheel",N),f.detachEvent("onmousemove",N),f.detachEvent("onmousedown",N),f.detachEvent("onmouseup",N)),c.onclick=null,h.onclick=null,p&&(f.removeChild(l),f.removeChild(c),f.removeChild(h)),l=null,c=null,h=null,i.firstChild.removeChild(f),f=null,u=null}var s=e("./base");s.call(this,n);var o=e("../config"),u=this;u.type=o.COMPONENT_TYPE_DATAVIEW;var a=["Data View","close","refresh"],f=document.createElement("div"),l=document.createElement("textArea"),c=document.createElement("button"),h=document.createElement("button"),p=!1,d="position:absolute;display:block;overflow:hidden;transition:height 0.8s,background-color 1s;;-moz-transition:height 0.8s,background-color 1s;-webkit-transition:height 0.8s,background-color 1s;-o-transition:height 0.8s,background-color 1s;z-index:1;left:0;top:0;",v,m="echarts-dataview",g=n.getHeight(),y=n.getWidth();u.dispose=L,u.resize=k,u.show=w,u.hide=b,C()}return e("../component").define("dataView",t),t}),define("echarts/echarts",["require","./chart/line","./chart/bar","./chart/scatter","./chart/k","./chart/pie","./chart/force","./config","zrender","zrender/tool/util","zrender/tool/event","zrender/config","./util/shape/icon","./chart","./chart/island","./component","./component/title","./component/axis","./component/categoryAxis","./component/valueAxis","./component/grid","./component/dataZoom","./component/legend","./component/dataRange","./component/tooltip","./component/toolbox","./component/dataView","./util/ecData","./chart","./component","zrender/tool/util","zrender/tool/util","zrender/tool/color","zrender/tool/util"],function(e){function n(t,n){function v(){var i=e("zrender");s=i.init(t);var u=e("zrender/tool/util");o=u.clone(n||{}),f=[],l={};var a=e("zrender/tool/event");a.Dispatcher.call(l),l.bind(r.EVENT.LEGEND_SELECTED,N),l.bind(r.EVENT.DATA_ZOOM,C),l.bind(r.EVENT.DATA_RANGE,k),l.bind(r.EVENT.MAGIC_TYPE_CHANGED,L),l.bind(r.EVENT.DATA_VIEW_CHANGED,A),l.bind(r.EVENT.RESTORE,O),l.bind(r.EVENT.REFRESH,M);var c=e("zrender/config");s.on(c.EVENT.CLICK,m),s.on(c.EVENT.MOUSEOVER,g),s.on(c.EVENT.MOUSEWHEEL,y),s.on(c.EVENT.DRAGSTART,b),s.on(c.EVENT.DRAGEND,T),s.on(c.EVENT.DRAGENTER,w),s.on(c.EVENT.DRAGOVER,E),s.on(c.EVENT.DRAGLEAVE,S),s.on(c.EVENT.DROP,x),e("./util/shape/icon");var h=e("./chart");e("./chart/island");var v=h.get("island");p=new v(l,s);var _=e("./component");e("./component/title"),e("./component/axis"),e("./component/categoryAxis"),e("./component/valueAxis"),e("./component/grid"),e("./component/dataZoom"),e("./component/legend"),e("./component/dataRange"),e("./component/tooltip"),e("./component/toolbox"),e("./component/dataView");var D=_.get("toolbox");d=new D(l,s,t)}function m(e){var t=f.length;while(t--)f[t]&&f[t].onclick&&f[t].onclick(e);if(e.target){var n=D(e.target);n&&typeof n.seriesIndex!="undefined"&&l.dispatch(r.EVENT.CLICK,e.event,n)}}function g(e){if(e.target){var t=D(e.target);t&&typeof t.seriesIndex!="undefined"&&l.dispatch(r.EVENT.HOVER,e.event,t)}}function y(e){l.dispatch(r.EVENT.MOUSEWHEEL,e.event,D(e.target))}function b(e){c={dragIn:!1,dragOut:!1,needRefresh:!1};var t=f.length;while(t--)f[t]&&f[t].ondragstart&&f[t].ondragstart(e)}function w(e){var t=f.length;while(t--)f[t]&&f[t].ondragenter&&f[t].ondragenter(e)}function E(e){var t=f.length;while(t--)f[t]&&f[t].ondragover&&f[t].ondragover(e)}function S(e){var t=f.length;while(t--)f[t]&&f[t].ondragleave&&f[t].ondragleave(e)}function x(e){var t=f.length;while(t--)f[t]&&f[t].ondrop&&f[t].ondrop(e,c);p.ondrop(e,c)}function T(e){var t=f.length;while(t--)f[t]&&f[t].ondragend&&f[t].ondragend(e,c);p.ondragend(e,c),c.needRefresh&&(_(p.getOption()),l.dispatch(r.EVENT.DATA_CHANGED,e.event,D(e.target)),l.dispatch(r.EVENT.REFRESH))}function N(e){c.needRefresh=!1;var t=f.length;while(t--)f[t]&&f[t].onlegendSelected&&f[t].onlegendSelected(e,c);h=e.selected,c.needRefresh&&l.dispatch(r.EVENT.REFRESH)}function C(e){c.needRefresh=!1;var t=f.length;while(t--)f[t]&&f[t].ondataZoom&&f[t].ondataZoom(e,c);c.needRefresh&&l.dispatch(r.EVENT.REFRESH)}function k(e){c.needRefresh=!1;var t=f.length;while(t--)f[t]&&f[t].ondataRange&&f[t].ondataRange(e,c);c.needRefresh&&s.refresh()}function L(){var e=d.getMagicOption(),t;if(u.xAxis)if(u.xAxis instanceof Array){t=u.xAxis.length;while(t--)e.xAxis[t].data=u.xAxis[t].data}else e.xAxis.data=u.xAxis.data;if(u.yAxis)if(u.yAxis instanceof Array){t=u.yAxis.length;while(t--)e.yAxis[t].data=u.yAxis[t].data}else e.yAxis.data=u.yAxis.data;t=e.series.length;while(t--)e.series[t].data=u.series[t].data;P(e)}function A(e){_(e.option),l.dispatch(r.EVENT.DATA_CHANGED,null,e),l.dispatch(r.EVENT.REFRESH)}function O(){H()}function M(){B()}function _(e){if(e.dataZoom&&e.dataZoom.show||e.toolbox&&e.toolbox.show&&e.toolbox.feature&&e.toolbox.feature.dataZoom)for(var t=0,n=f.length;t<n;t++)if(f[t].type==r.COMPONENT_TYPE_DATAZOOM){f[t].syncBackupData(e,u);return}var i=e.series,s;for(var t=0,n=i.length;t<n;t++){s=i[t].data;for(var o=0,a=s.length;o<a;o++)typeof u.series[t].data[o].value!="undefined"?u.series[t].data[o].value=s[o].value:u.series[t].data[o]=s[o]}}function D(t){if(t){var n=e("./util/ecData");return{seriesIndex:n.get(t,"seriesIndex"),dataIndex:n.get(t,"dataIndex")}}return}function P(n){j(),s.clear();var r=e("./chart"),i=e("./component"),o;if(n.title){var u=new i.get("title");o=new u(l,s,n),f.push(o)}var a;if(n.tooltip){var c=i.get("tooltip");a=new c(l,s,n,t),f.push(a)}var v;if(n.legend){var m=new i.get("legend");v=new m(l,s,n,h),f.push(v)}var g;if(n.dataRange){var y=new i.get("dataRange");g=new y(l,s,n),f.push(g)}var b,w,E,S;if(n.grid||n.xAxis||n.yAxis){var x=i.get("grid");b=new x(l,s,n),f.push(b);var T=i.get("dataZoom");w=new T(l,s,n,{legend:v,grid:b}),f.push(w);var N=i.get("axis");E=new N(l,s,n,{legend:v,grid:b},"xAxis"),f.push(E),S=new N(l,s,n,{legend:v,grid:b},"yAxis"),f.push(S),a&&a.setComponent({grid:b,xAxis:E,yAxis:S})}var C,k,L,A={};for(var O=0,M=n.series.length;O<M;O++){k=n.series[O].type;if(!k)continue;A[k]||(A[k]=!0,C=r.get(k),C&&(L=new C(l,s,n,{tooltip:a,legend:v,dataRange:g,grid:b,xAxis:E,yAxis:S}),f.push(L)))}p.render(n),d.render(n,{dataZoom:w});if(n.animation){var _=f.length;while(_--)f[_]&&f[_].animation&&f[_].animation()}s.render()}function H(){var t=e("zrender/tool/util");a.legend&&a.legend.selected?h=a.legend.selected:h={},u=t.clone(a),o=t.clone(a),p.clear(),d.reset(o),P(o)}function B(){for(var e=0,t=f.length;e<t;e++)f[e].refresh&&f[e].refresh();s.refresh()}function j(){var e=f.length;while(e--)f[e]&&f[e].dispose&&f[e].dispose();f=[]}function F(t,n){var f=e("zrender/tool/util");n?o=f.clone(t):f.merge(o,f.clone(t),{overwrite:!0,recursive:!0});if(!t.series||t.series.length===0)return;typeof o.calculable=="undefined"&&(o.calculable=r.calculable),typeof o.nameConnector=="undefined"&&(o.nameConnector=r.nameConnector),typeof o.valueConnector=="undefined"&&(o.valueConnector=r.valueConnector),typeof o.animation=="undefined"&&(o.animation=r.animation),typeof o.animationDuration=="undefined"&&(o.animationDuration=r.animationDuration),typeof o.animationEasing=="undefined"&&(o.animationEasing=r.animationEasing);var l=e("zrender/tool/color");return o.color&&o.color.length>0?s.getColor=function(e){return l.getColor(e,o.color)}:s.getColor=function(e){return l.getColor(e,r.color)},s.getCalculableColor=function(){return o.calculableColor||r.calculableColor},u=f.clone(o),a=f.clone(o),o.legend&&o.legend.selected?h=o.legend.selected:h={},p.clear(),d.reset(o),P(o),i}function I(e,t){return t?(o.series=e,i.setOption(o,t)):i.setOption({series:e}),i}function q(){return s}function R(e,t){return l.bind(e,t),i}function U(e,t){return l.unbind(e,t),i}function z(t){d.hideDataView();var n=e("zrender/tool/util");t=t||{},t.textStyle=t.textStyle||{};var o=n.merge(n.clone(t.textStyle),r.textStyle,{overwrite:!1});return t.textStyle.textFont=o.fontStyle+" "+o.fontWeight+" "+o.fontSize+"px "+o.fontFamily,t.textStyle.text=t.text||"Loading...",typeof t.x!="undefined"&&(t.textStyle.x=t.x),typeof t.y!="undefined"&&(t.textStyle.y=t.y),s.showLoading(t),i}function W(){return s.hideLoading(),i}function X(){s.resize();for(var e=0,t=f.length;e<t;e++)f[e].resize&&f[e].resize(),f[e].refresh&&f[e].refresh();p.resize(),d.resize(),s.refresh()}function V(){return s.clear(),i}function $(){p.dispose(),d.dispose(),j(),l.unbind(),s.dispose(),i=null;return}var r=e("./config"),i=this,s,o,u,a,f,l,c={dragIn:!1,dragOut:!1,needRefresh:!1},h,p,d;v(),i.setOption=F,i.setSeries=I,i.getZrender=q,i.on=R,i.un=U,i.showLoading=z,i.hideLoading=W,i.resize=X,i.refresh=B,i.restore=H,i.clear=V,i.dispose=$}e("./chart/line"),e("./chart/bar"),e("./chart/scatter"),e("./chart/k"),e("./chart/pie"),e("./chart/force");var t={};return t.init=function(e,t){t=t||{type:"canvas"};if(t.type=="canvas")return new n(e);t.type=="flash"&&alert("未配置")},t}),define("echarts",["echarts/echarts"],function(e){return e});