﻿var canvas = document.getElementById('roomlayer');
var stage = new JTopo.Stage(canvas);
var scene = new JTopo.Scene(stage);


var color = [ "255,0,255", "238,44,44 ", "0,139,139", "100,138,100", "0,197,205"]

var nodes = [];

function linkNode(nodeA, nodeZ) {
    var link = new JTopo.Link(nodeA, nodeZ);
    link.lineWidth = 1;
    link.alpha =0.3;
    scene.add(link);
    return link;
}

function node(x, y) {
    var node = new JTopo.Node();
    node.width = 2;
    node.height = 2;
    node.alpha = 0.3;
    node.setLocation(x, y);
    scene.add(node);
    return node;
}

function InitRoom(text, x, y, color) {
    node = new JTopo.Node(text);
    node.setLocation(x, y);
    node.textPosition = "Middle_Center";
    node.fillColor = color;
    node.width = 100;
    node.height = 60;
    node.shadow = "false";
    node.borderRadius = 5;
    node.borderWidth = 2;
    node.borderColor = '255,255,255';
    scene.add(node);
}

for (var i = 0; i <8; i++) {
    var row = [];
    for (var j = 0; j <11; j++) {
        var n = node(0 + j *90, 0 + i * 60);

        row.push(n);
        if (j > 0) {
            linkNode(n, row[j - 1]);
            if (i > 0) {
                linkNode(nodes[i - 1][j], row[j]);
            }
        } if (i > 0 && j == 0) {
            linkNode(nodes[i - 1][j], row[j]);
        }
    }
    nodes.push(row);
}

stage.add(scene);


function AddOffice() {
    node = new JTopo.Node("办公室Office");
    node.setLocation(160, 90);
    node.textPosition = "Middle_Center";
    node.fillColor = "1,1,1";
    node.width = 100;
    node.height = 60;
    node.shadow = "false";
    node.borderRadius = 5;
    node.borderWidth = 2;
    node.borderColor = '255,255,255';
    scene.add(node);
}

function AddRoom(id, text) {
    colorIndex = id % 5; 
    node = new JTopo.Node(text);
    node.setLocation(160, 90);
    node.textPosition = "Middle_Center";
    node.fillColor = color[colorIndex];
    node.width =100;
    node.height = 60;
    node.borderRadius = 5;
    node.borderWidth = 2;
    node.borderColor = '255,255,255';
    scene.add(node);
}