﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using QiZhanBang.Core.Common;
using QiZhanBang.Core.Factory;
using QiZhanBang.Core.Model;
namespace QiZhanBang.Web.backend
{
    public partial class linkedit : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            QiZhanBang.Core.Business.Security.CheckAdministerAndRedirect();
            if (!Page.IsPostBack)
            {
                LoadData();
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            int categoryid = HYRequest.GetInt("categoryid", 0); 

            if (this.Action == "add")
            {
                Link info = new Link();
                info.includepic = this.txtincludepic.Text.Trim();
                info.linkurl = this.txtlinkurl.Text.Trim();
                info.orderno = Int32.Parse(this.txtorderno.Text.Trim());
                info.linkname = this.txttitle.Text.Trim();
                info.categoryid = categoryid ;
                info.createtime = DateTime.Now;

                LinkFactory.Add(info);

                ClientScript.RegisterStartupScript(this.GetType(), "AddEditTips", "<script language=\"javascript\">alert('添加成功！');window.location='linklist.aspx?categoryid=" + categoryid + "';</script>");
            }
            else if (this.Action == "edit")
            {
                int linkid = HYRequest.GetInt("linkid", 0);
                Link info = LinkFactory.Get(linkid);

                info.includepic = this.txtincludepic.Text.Trim();
                info.linkurl = this.txtlinkurl.Text.Trim();
                info.orderno = Int32.Parse(this.txtorderno.Text.Trim());
                info.linkname = this.txttitle.Text.Trim();

                LinkFactory.Update(info);
                ClientScript.RegisterStartupScript(this.GetType(), "AddEditTips", "<script language=\"javascript\">alert('修改成功！');window.location='linklist.aspx?categoryid=" + categoryid + "';</script>");
            }
        }

        private void LoadData()
        {
            if (this.Action == "edit")
            {
                int linkid = HYRequest.GetInt("linkid", 0);
                Link info = LinkFactory.Get(linkid);

                this.txtincludepic.Text = info.includepic;
                this.txtlinkurl.Text = info.linkurl;
                this.txtorderno.Text = info.orderno.ToString();
                this.txttitle.Text = info.linkname;
            }
        }

        private string Action
        {
            get
            {
                return HYRequest.GetString("action");
            }
        }
    }
}
