﻿using System;
using System.Collections.Generic;
using System.Text;
using Spring.Data.NHibernate.Support;
using System.Collections;
using NHibernate;
using System.Data;

namespace DAO
{
    public class SpringDaoHelper : HibernateDaoSupport
    {
        ISession iSession = null;

        public int ExecuteNonQuery(string sql)
        {
            IDbConnection conn = Connection;
            IDbCommand cmd = conn.CreateCommand();
            cmd.CommandText = sql;
            int i = cmd.ExecuteNonQuery();
            CloseISession();
            return i;
        } 

        public bool ExecuteNonQueryTransaction(ArrayList sqls)
        {
            IDbConnection conn = Connection;
            IDbTransaction idbt = conn.BeginTransaction();
            int sql_count = sqls.Count;
            IDbCommand cmd;
            List<IDbCommand> cmds = new List<IDbCommand>();
            for (int i = 0; i < sql_count; i++)
            {
                cmd = conn.CreateCommand();
                cmd.CommandText = sqls[i].ToString();
                cmd.Transaction = idbt;
                cmds.Add(cmd);
            }

            bool isOK;
            try
            {
                for (int i = 0; i < sql_count; i++)
                {
                    cmds[i].ExecuteNonQuery();
                }
                idbt.Commit();
                isOK = true;
            }
            catch
            {
                idbt.Rollback();
                isOK = false;
            }
            CloseISession();
            return isOK;
        } 
                
        public void Save(object obj)
        {
            HibernateTemplate.Save(obj);
        }

        public void Delete(object obj)
        {
            HibernateTemplate.Delete(obj);
        }

        public void Update(object obj)
        {
            HibernateTemplate.Update(obj);
        }

        public ArrayList select(string sql)
        {
            IQuery query = isession.CreateQuery(sql);
            IList list = query.List();
            CloseISession();
            return (ArrayList)list;
        } 

        public ArrayList select(string sql, int top)
        {
            IQuery query = isession.CreateQuery(sql);
            query.SetFirstResult(0);
            query.SetMaxResults(top);
            IList list = query.List();
            CloseISession();
            return (ArrayList)list;
        } 

        public ArrayList select(string sql, int pageIndex, int pageSize)
        {
            IQuery query = isession.CreateQuery(sql);
            int first = (pageIndex - 1) * pageSize;
            query.SetFirstResult(first);
            query.SetMaxResults(pageSize);
            IList list = query.List();
            CloseISession();
            return (ArrayList)list;
        } 

        public object model(string table, string where)
        {
            IList list = isession.CreateQuery("from " + table + " where " + where).List();
            CloseISession();
            return list[0];
        } 

        public int Scalar(string table, string func, string fid)
        {
            IDbConnection conn = Connection;
            IDbCommand cmd = conn.CreateCommand();
            cmd.CommandText = "select " + func + "(" + fid + ") from " + table;
            int i = (int)cmd.ExecuteScalar();
            CloseISession();
            return i;
        } 

        public int Scalar(string table, string func, string fid, string where)
        {
            IDbConnection conn = Connection;
            IDbCommand cmd = conn.CreateCommand();
            cmd.CommandText = "select " + func + "(" + fid + ") from " + table + " where " + where;
            int i = (int)cmd.ExecuteScalar();
            CloseISession();
            return i;
        } 

        protected IDbConnection Connection
        {
            get
            {
                return isession.Connection;
            }
        }
        protected ISession isession
        {
            get
            {
                iSession = Session;
                return iSession;
            }
        }
        protected void CloseISession()
        {
            iSession.Clear();
            iSession.Close();
            iSession.Dispose();
        }

    }
}
