﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using DAO;

public partial class View : System.Web.UI.Page
{
    int pageIndex = 1;
    SpringDaoHelper dao = WebCommon.GetSpringBeanObject();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Title = ConfigurationManager.AppSettings["Web"] + " - 建站心得";

            //左边作品数据源
            Repeater3.DataSource = dao.select("from Work order by id desc", 15);
            Repeater3.DataBind();

            DataList1.DataSource = dao.select("from Class order by sort asc");
            DataList1.DataBind();

            AspNetPager1.RecordCount = dao.Scalar("[View]", "count", "id");
            Bind(pageIndex);
        }
        
    }

    void Bind(int p)
    {
        ArrayList list = dao.select("from View order by id desc", p, AspNetPager1.PageSize);
        Repeater2.DataSource = list;
        Repeater2.DataBind();
    }

    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        Bind(AspNetPager1.CurrentPageIndex);
    }

    /// <summary>
    /// 字符截断
    /// </summary>
    /// <param name="scatitle"></param>
    /// <param name="cid"></param>
    /// <returns></returns>
    public static string getleft(string scatitle, int cid)
    {  
        string rtn = "";
        if (scatitle.Trim().Length > cid)
        {
            rtn = scatitle.Substring(0, cid) + "...";
        }
        else
        {
            rtn = scatitle;
        }
        return rtn;
    }

}
