﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using LZBS.DAL;
using LZBS.Model;

namespace LZBS.BLL
{
    public class B_GuestBook
    {
        D_GuestBook dal = new D_GuestBook();
        /// <summary>
        /// 获取留言列表
        /// </summary>
        /// <returns></returns>
        public DataTable GetGuestBook()
        {
            return dal.GetGuestBook();
        }
        /// <summary>
        /// 根据留言的编号删除留言
        /// </summary>
        /// <param name="model"></param>
        public int DeleteGuestBook(M_GuestBook model)
        {
            return dal.DeleteGuestBook(model);
        }
        /// <summary>
        /// 根据BookID获取留言信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetGuestBookByBookID(M_Reply model)
        {
            return dal.GetGuestBookByBookID(model);
        }
        /// <summary>
        /// 根据BookID获取留言信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetGuestBookByBookID(M_GuestBook model)
        {
            return dal.GetGuestBookByBookID(model);
        }
        /// <summary>
        /// 为登陆的用户添加留言
        /// </summary>
        /// <param name="model"></param>
        public int AddGuestBookLogined(M_GuestBook model)
        {
            return dal.AddGuestBookLogined(model);
        }
        /// <summary>
        /// 为未登陆的用户添加留言
        /// </summary>
        /// <param name="model"></param>
        public int AddGuestBook(M_GuestBook model)
        {
            return dal.AddGuestBook(model);
        }
        /// <summary>
        /// 根据MemberID获取留言信息
        /// </summary>
        /// <param name="model"></param>
        public DataTable GetGuestBookByMemberID(M_GuestBook model)
        {
            return dal.GetGuestBookByMemberID(model);
        }
    }
}
