﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using LZBS.DAL;
using System.Data;

namespace LZBS.BLL
{
    public class B_News
    {
        D_News dal = new D_News();
        /// <summary>
        /// 添加新闻
        /// </summary>
        /// <param name="modle"></param>
        /// <returns></returns>
        public int AddNews(M_News model)
        {
            return dal.AddNews(model);
        }
        /// <summary>
        /// 获取所有新闻列表
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllNewsList()
        {
            return dal.GetAllNewsList();
        }
        /// <summary>
        /// 根据新闻类别获取新闻列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable GetNewsList(M_News model)
        {
            return dal.GetNewsList(model);
        }
        /// <summary>
        /// 根据新闻编号返回该条新闻
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetNewsInfo(M_News model)
        {
            return dal.GetNewInfo(model);
        }
        /// <summary>
        /// 修改点击量
        /// </summary>
        /// <param name="number"></param>
        public int ChangeNumbers(M_News model)
        {
            return dal.ChangeNumbers(model);
        }
        /// <summary>
        /// 根据新闻编号删除新闻
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteNews(M_News model)
        {
            return dal.DeleteNews(model);
        }
        /// <summary>
        /// 根据新闻编号修改新闻
        /// </summary>
        /// <param name="model"></param>
        public int UpdateNews(M_News model)
        {
            return dal.UpdateNews(model);
        }
        /// <summary>
        /// 获取系统中最新的新闻
        /// </summary>
        /// <param name="top">获取新闻的条数</param>
        /// <returns></returns>
        public DataTable GetTopNews(int top)
        {
            return new D_News().GetTopNews(top);
        }
    }
}
