﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.DAL;
using LZBS.Model;
using LZBS.Common;
using System.Data;

namespace LZBS.BLL
{
    public class B_Product
    {
        D_Product dal = new D_Product();
        /// <summary>
        /// 获取所有产品
        /// </summary>
        /// <returns></returns>
        public DataTable GetProductList()
        {
            return dal.GetProductList();
        }
        /// <summary>
        /// 通过产品编号获取产品信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetProductInfo(M_Product model)
        {
            return dal.GetProductInfo(model);
        }
        /// <summary>
        /// 添加产品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddProduct(M_Product model)
        {
            return dal.AddProduct(model);
        }
        /// <summary>
        /// 通过产品编号删除产品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteProductByProductID(M_Product model)
        {
            return dal.DeleteProductByProductID(model);
        }
        /// <summary>
        /// 根据产品编号修改产品信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int UpdateProductInfo(M_Product model)
        {
            return dal.UpdateProductInfo(model);
        }
        /// <summary>
        /// 获取指定数目的最新产品
        /// </summary>
        /// <param name="top"></param>
        /// <returns></returns>
        public object GetTopProduct(int top)
        {
            return dal.GetTopProduct(top);
        }
    }
}
