﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.DAL;
using LZBS.Model;
using LZBS.Common;
using System.Data;

namespace LZBS.BLL
{
    public class B_User
    {
        D_User dal = new D_User();
        M_User model = new M_User();
        /// <summary>
        /// 根据用户名和密码判断用户的输入是否正确
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool CheckUser(LZBS.Model.M_User model)
        {
            model.Password = Md5Encrypt.GetMd5Hash(model.Password);
            if (dal.CheckUser(model).Rows.Count > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// 修改密码
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int ChangePassword(M_User model)
        {
            model.Password = Md5Encrypt.GetMd5Hash(model.Password);
            return dal.ChangePassword(model);
        }
        /// <summary>
        /// 添加用户
        /// </summary>
        /// <param name="model"></param>
        public int AddUser(M_User model)
        {
            model.Password = Md5Encrypt.GetMd5Hash(model.Password);
            return dal.AddUser(model);
        }
        /// <summary>
        /// 判断用户是否存在，存在返回true，否则返回false
        /// </summary>
        /// <returns></returns>
        public bool IsExistUser(M_User model)
        {
            if (dal.GetUserByUserID(model).Rows.Count > 0)
                return true;
            else
                return false;
        }
        /// <summary>
        /// 获取用户信息
        /// </summary>
        public DataTable GetUserInfo()
        {
            return dal.GetUserInfo();
        }
        /// <summary>
        /// 删除用户
        /// </summary>
        /// <param name="model"></param>
        public int DeleteUser(M_User model)
        {
            return dal.DeleteUser(model);
        }
        /// <summary>
        /// 更新用户信息
        /// </summary>
        /// <param name="model"></param>
        public int UpdateUser(M_User model)
        {
            return dal.UpdateUser(model);
        }
    }
}
