﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;

namespace LZBS.Common
{
    public class MyMessageBox
    {
        /// <summary>
        /// 在页面弹出对话框
        /// </summary>
        /// <param name="message">输出的内容</param>
        /// <param name="page">在那个页面显示内容，一般为 this.Page  即当前页面</param>
        public static void MessageBox(String message, Page page)
        {
            String str = "<script language=javascript>";
            str += "alert(\"" + message + "\");";
            str += "</script>";
            page.ClientScript.RegisterClientScriptBlock(typeof(string), "titles", str);
        }

        /// <summary>
        /// 在页面弹出对话框
        /// </summary>
        /// <param name="message">输出的内容</param>
        /// <param name="page">在那个页面显示内容，一般为 this.Page  即当前页面</param>
        /// <param name="ifback">是否返回前一页面，一般为 true</param>
        public static void MessageBox(String message, Page page, bool ifback)
        {
            String str = "<script language=javascript>";
            str += "alert(\"" + message + "\");";
            if (ifback)
                str += "history.go(-1);";
            str += "</script>";
            page.ClientScript.RegisterClientScriptBlock(typeof(string), "titles", str);
        }

        /// <summary>
        /// 在页面弹出对话框
        /// </summary>
        /// <param name="message">输出的内容</param>
        /// <param name="page">在那个页面显示内容，一般为 this.Page  即当前页面</param>
        /// <param name="NewPage">转到的新页面</param>
        public static void MessageBox(String message, Page page, string NewPage)
        {
            String str = "<script language=javascript>";
            str += "alert(\"" + message + "\");";
            if (NewPage.Length > 0)
                str += "location.href='" + NewPage + "';";
            str += "</script>";
            page.ClientScript.RegisterClientScriptBlock(typeof(string), "titles", str);
        }
    }
}
