﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;
using LZBS.Model;

namespace LZBS.DAL
{
    public class D_GuestBook
    {
        /// <summary>
        /// 获取留言列表
        /// </summary>
        /// <returns></returns>
        public DataTable GetGuestBook()
        {
            string sqlString = "select * from GuestBook order by BookID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 根据留言的编号删除留言
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteGuestBook(M_GuestBook model)
        {
            string sqlString = "delete from GuestBook where BookID=@BookID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@BookID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.BookID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 根据BookID获取留言信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetGuestBookByBookID(M_Reply model)
        {
            string sqlString = "select * from GuestBook where BookID=@BookID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@BookID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.BookID;
            return SqlHelp.GetFirstRow(sqlString, paremeters);
        }

        /// <summary>
        /// 根据BookID获取留言信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetGuestBookByBookID(M_GuestBook model)
        {
            string sqlString = "select * from GuestBook where BookID=@BookID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@BookID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.BookID;
            return SqlHelp.GetFirstRow(sqlString, paremeters);
        }
        /// <summary>
        /// 为登陆的用户添加留言
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddGuestBookLogined(M_GuestBook model)
        {
            string sqlString = "Insert Into GuestBook (Title,Content,MemberID) Values (@Title,@Content,@MemberID)";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@Title",SqlDbType.NVarChar,100),
                                          new SqlParameter("@Content",SqlDbType.Text),
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50)
                                       };
            paremeters[0].Value = model.Title;
            paremeters[1].Value = model.Content;
            paremeters[2].Value = model.MemberID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 为未登陆的用户添加留言
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddGuestBook(M_GuestBook model)
        {
            string sqlString = "Insert Into GuestBook (Title,Content) Values (@Title,@Content)";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@Title",SqlDbType.NVarChar,100),
                                          new SqlParameter("@Content",SqlDbType.Text),
                                       };
            paremeters[0].Value = model.Title;
            paremeters[1].Value = model.Content;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 根据MemberID获取留言信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable GetGuestBookByMemberID(M_GuestBook model)
        {
            string sqlString = "select * from GuestBook where MemberID=@MemberID order by LeaveDate desc";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50)
                                        };
            paremeters[0].Value = model.MemberID;
            return SqlHelp.GetDataTable(sqlString, paremeters);
        }
    }
}
