﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;

namespace LZBS.DAL
{
    public class D_News
    {
        /// <summary>
        /// 添加新闻
        /// </summary>
        /// <param name="modle"></param>
        /// <returns></returns>
        public int AddNews(M_News model)
        {
            string sqlString = "Insert Into News(Title,Content,TypeID)Values(@Title,@Content,@TypeID)";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@Title",SqlDbType.NVarChar,30),
                                          new SqlParameter("@Content",SqlDbType.Text),
                                          new SqlParameter("@TypeID",SqlDbType.Int)
                                      };
            paremeters[0].Value = model.Title;
            paremeters[1].Value = model.Content;
            paremeters[2].Value = model.TypeID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 获取所有新闻列表
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllNewsList()
        {
            string sqlString = @"select NewsID,Title,Numbers,PublishTime,TypeName
                                 from News,NewsType
                                 where News.TypeID=NewsType.TypeID
                                 order by NewsID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 根据新闻类别获取新闻列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable GetNewsList(M_News model)
        {
            string sqlString = "select NewsID,Title,Numbers,PublishTime from News where TypeID=@TypeID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@TypeID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.TypeID;
            return SqlHelp.GetDataTable(sqlString, paremeters);
        }
        /// <summary>
        /// 根据新闻编号返回该条新闻
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetNewInfo(M_News model)
        {
            string sqlString = "select Title,Content,Numbers,TypeID,PublishTime from News where NewsID=@NewsID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@NewsID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.NewsID;
            return SqlHelp.GetFirstRow(sqlString, paremeters);
        }
        /// <summary>
        /// 修改点击量
        /// </summary>
        /// <param name="number"></param>
        /// <returns></returns>
        public int ChangeNumbers(M_News model)
        {
            string sqlString = "Update News Set Numbers=@Numbers where NewsID=@NewsID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@NewsID",SqlDbType.Int),
                                          new SqlParameter("@Numbers",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.NewsID;
            paremeters[1].Value = model.Numbers;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
            //string sqlString = "Update News Set Numbers=" + model.Numbers + " where NewsID=" + model.NewsID;
            //return SqlHelp.ExecuteSQL(sqlString);
        }
        /// <summary>
        /// 根据新闻编号删除新闻
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteNews(M_News model)
        {
            string sqlString = "delete from News where NewsID=@NewsID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@NewsID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.NewsID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 根据新闻编号修改新闻
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int UpdateNews(M_News model)
        {
            string sqlString = "Update News Set Title=@Title,Content=@Content,TypeID=@TypeID where NewsID=@NewsID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@NewsID",SqlDbType.Int),
                                          new SqlParameter("@Title",SqlDbType.NVarChar,30),
                                          new SqlParameter("@TypeID",SqlDbType.Int),         
                                          new SqlParameter("@Content",SqlDbType.Text)
                                      };
            paremeters[0].Value = model.NewsID;
            paremeters[1].Value = model.Title;
            paremeters[2].Value = model.TypeID;
            paremeters[3].Value = model.Content;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 获取系统中最近的新闻
        /// </summary>
        /// <param name="top">获取新闻的条数</param>
        /// <returns></returns>
        public DataTable GetTopNews(int top)
        {
            string sqlString = "select Top " + top + " NewsID,Title,Numbers,PublishTime from News Order By NewsID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
    }
}
