﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;

namespace LZBS.DAL
{
    public class D_User
    {
        /// <summary>
        /// 根据账号和密码查询用户，返回一个DataTable
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable CheckUser(LZBS.Model.M_User model)
        {
            string sqlString = "select * from Users where UserID=@UserID and Password=@Password";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@UserID",SqlDbType.VarChar,50),
                                          new SqlParameter("@Password",SqlDbType.Char,32)
                                        };
            paremeters[0].Value = model.UserID;
            paremeters[1].Value = model.Password;
            return SqlHelp.GetDataTable(sqlString, paremeters);
        }
        /// <summary>
        /// 修改密码
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int ChangePassword(M_User model)
        {
            string sqlString = "Update Users Set Password=@Password where UserID=@UserID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@UserID",SqlDbType.VarChar,50),
                                          new SqlParameter("@Password",SqlDbType.Char,32)
                                        };
            paremeters[0].Value = model.UserID;
            paremeters[1].Value = model.Password;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 添加用户
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddUser(M_User model)
        {
            string sqlString = "Insert Into Users(UserID,Password,UserName) Values(@UserID,@Password,@UserName)";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@UserID",SqlDbType.VarChar,50),
                                          new SqlParameter("@Password",SqlDbType.Char,32),
                                          new SqlParameter("@UserName",SqlDbType.NVarChar,4)
                                        };
            paremeters[0].Value = model.UserID;
            paremeters[1].Value = model.Password;
            paremeters[2].Value = model.UserName;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 通过用户账号获取用户信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable GetUserByUserID(M_User model)
        {
            string sqlString = "select * from Users where UserID=@UserID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@UserID",SqlDbType.VarChar,50)
                                        };
            paremeters[0].Value = model.UserID;
            return SqlHelp.GetDataTable(sqlString, paremeters);
        }
        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetUserInfo()
        {
            string sqlString = "select UserID,UserName from Users";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 删除用户
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteUser(M_User model)
        {
            string sqlString = "delete from Users where UserID=@UserID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@UserID",SqlDbType.VarChar,50)
                                        };
            paremeters[0].Value = model.UserID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 更新用户信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int UpdateUser(M_User model)
        {
            string sqlString = "Update Users Set UserName=@UserName where UserID=@UserID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@UserID",SqlDbType.VarChar,50),
                                          new SqlParameter("@UserName",SqlDbType.NVarChar,4)
                                        };
            paremeters[0].Value = model.UserID;
            paremeters[1].Value = model.UserName;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
    }
}
