﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.IO;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class DownLoadManage : System.Web.UI.Page
    {
        B_Download bll = new B_Download();
        M_Download model = new M_Download();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            anpPager.RecordCount = bll.GetFileList().Rows.Count;
            RptBind();
        }
        /// <summary>
        /// 数据绑定
        /// </summary>
        private void RptBind()
        {
            PagedDataSource pdsList = new PagedDataSource();
            //对PagedDataSource 对象的相关属性赋值        
            pdsList.DataSource = bll.GetFileList().DefaultView;
            pdsList.AllowPaging = true;
            pdsList.PageSize = anpPager.PageSize;
            //pdsList.AllowCustomPaging = true;
            pdsList.CurrentPageIndex = anpPager.CurrentPageIndex - 1;
            rptDownLoad.DataSource = pdsList;
            rptDownLoad.DataBind();
        }

        protected void anpPager_PageChanged(object sender, EventArgs e)
        {
            RptBind();
        }

        protected void lbDelete_Command(object sender, CommandEventArgs e)
        {
            M_SysLog mLog = new M_SysLog();
            B_SysLog bLog = new B_SysLog();
            model.FileID = Convert.ToInt32(e.CommandName.ToString());
            DataRow dr = bll.GetFileInfo(model);
            string FileName = dr["FileName"].ToString();
            string NewFileName = dr["NewFileName"].ToString();
            string FilePath = Server.MapPath("~/DownLoad/" + dr["NewFileName"].ToString());//路径
            File.Delete(FilePath);

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            if (bll.DeleteFile(model) > 0)
                mLog.OPInfo = "删除" + dr["FileName"].ToString() + "文件成功";
            else
                mLog.OPInfo = "删除" + dr["FileName"].ToString() + "文件失败";
            bLog.AddLog(mLog);
            RptBind();
        }
    }
}
