﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class FAQManage : System.Web.UI.Page
    {
        B_FAQ bll = new B_FAQ();
        M_FAQ model = new M_FAQ();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
                ftbContent.Text = bll.GetFAQContent();
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            model.FAQContent = ftbContent.Text.ToString();

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            if (bll.UpdateFAQ(model) > 0)
            {
                mLog.OPInfo = "成功修改常见问题";
                MyMessageBox.MessageBox("修改成功", this.Page);
            }
            else
            {
                mLog.OPInfo = "修改常见问题失败";
                MyMessageBox.MessageBox("修改失败", this.Page);
            }
            bLog.AddLog(mLog);
        }
    }
}
