﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class MemberManage : System.Web.UI.Page
    {
        M_Member model = new M_Member();
        B_Member bll = new B_Member();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                BindToGridView();
            }
        }

        private void BindToGridView()
        {
            gvMember.DataSource = bll.GetAllMembers();
            gvMember.DataBind();
        }
        /// <summary>
        /// GridView编辑事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvMember_RowEditing(object sender, GridViewEditEventArgs e)
        {
            gvMember.EditIndex = e.NewEditIndex;
            BindToGridView();
        }
        /// <summary>
        /// GridView取消编辑事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvMember_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            gvMember.EditIndex = -1;
            BindToGridView();
        }
        /// <summary>
        /// GridView更新事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvMember_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.MemberID = gvMember.DataKeys[Index].Value.ToString();
            model.MemberName = ((TextBox)gvMember.Rows[Index].Cells[1].FindControl("txtName")).Text.Trim();
            model.Sex = ((DropDownList)gvMember.Rows[Index].Cells[2].FindControl("ddlSex")).SelectedValue;
            model.Phone = ((TextBox)gvMember.Rows[Index].Cells[3].FindControl("txtPhone")).Text.Trim();
            model.Tel = ((TextBox)gvMember.Rows[Index].Cells[4].FindControl("txtTel")).Text.Trim();
            model.Email = ((TextBox)gvMember.Rows[Index].Cells[5].FindControl("txtEmail")).Text.Trim();
            model.QQ = ((TextBox)gvMember.Rows[Index].Cells[6].FindControl("txtEmail")).Text.Trim();
            if (bll.ChangeInfo(model) > 0)
            {
                mLog.OPInfo = "更新账号为" + gvMember.DataKeys[Index].Value.ToString() + "会员信息成功";
                MyMessageBox.MessageBox("更新成功", this.Page);
            }
            else
            {
                mLog.OPInfo = "更新账号为" + gvMember.DataKeys[Index].Value.ToString() + "会员信息失败";
                MyMessageBox.MessageBox("更新失败", this.Page);
            }
            bLog.AddLog(mLog);
            gvMember.EditIndex = -1;
            BindToGridView();
        }
        /// <summary>
        /// GridView删除事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvMember_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.MemberID = gvMember.DataKeys[Index].Value.ToString();
            if (bll.DeleteMember(model) > 0)
            {
                mLog.OPInfo = "删除账号为" + gvMember.DataKeys[Index].Value.ToString() + "会员信息成功";
                MyMessageBox.MessageBox("删除成功", this.Page);
            }
            else
            {
                mLog.OPInfo = "删除账号为" + gvMember.DataKeys[Index].Value.ToString() + "会员信息失败";
                MyMessageBox.MessageBox("删除失败", this.Page);
            }
            bLog.AddLog(mLog);
            BindToGridView();
        }
        /// <summary>
        /// GridView处理分页事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvMember_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            gvMember.PageIndex = e.NewPageIndex;
            BindToGridView();
        }
        /// <summary>
        /// 性别绑定事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ddlSex_DataBinding(object sender, EventArgs e)
        {
            //获取发生事件的控件sender，默认sender为object
            //强制转换成DropDownList
            DropDownList ddl = (DropDownList)sender;
            ddl.Items.Add(new ListItem("男"));
            ddl.Items.Add(new ListItem("女"));
        }
    }
}
