﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class NewsEdit : System.Web.UI.Page
    {
        B_NewsType type = new B_NewsType();
        B_News bll = new B_News();
        M_News model = new M_News();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                ddlNewsType.DataSource = type.GetNewsType();
                ddlNewsType.DataTextField = "TypeName";
                ddlNewsType.DataValueField = "TypeID";
                ddlNewsType.DataBind();
                if (Request.QueryString["NewsID"] == null)
                {
                    MyMessageBox.MessageBox("非法传值", this.Page, "Right.aspx");
                    //Response.Redirect("Index.aspx",true);
                    //Response.Write("<b style='font-weight:bold; color:red; '>非法传值 <a href='NewsManage.aspx'>返回新闻管理</a></div>");
                    //Response.End();
                }
                else
                {
                    model.NewsID = Convert.ToInt32(Request.QueryString["NewsID"].ToString());
                    DataRow dr = bll.GetNewsInfo(model);
                    ddlNewsType.SelectedValue = dr["TypeID"].ToString();
                    txtTitle.Text = dr["Title"].ToString();
                    ftbContent.Text = dr["Content"].ToString();
                    hfTitle.Value = dr["Title"].ToString();
                }
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            model.NewsID = Convert.ToInt32(Request.QueryString["NewsID"].ToString());
            model.Title = txtTitle.Text.Trim();
            model.TypeID = Convert.ToInt32(ddlNewsType.SelectedItem.Value);
            model.Content = ftbContent.Text.ToString();

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            if (bll.UpdateNews(model) > 0)
            {
                mLog.OPInfo = "修改标题为" + hfTitle.Value + "的新闻成功";
                MyMessageBox.MessageBox("新闻修改成功", this.Page, "NewsManage.aspx");
                //Response.Write("<script type='text/javascript'>alert('修改成功');location.href='NewsManage.aspx'</script>");
            }
            else
            {
                mLog.OPInfo = "修改标题为" + hfTitle.Value + "的新闻失败";
                MyMessageBox.MessageBox("新闻修改失败", this.Page);
            }
            bLog.AddLog(mLog);
        }
    }
}
