﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class NewsInsert : System.Web.UI.Page
    {
        B_NewsType type = new B_NewsType();
        B_News bll = new B_News();
        M_News model = new M_News();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Session["UserID"] == null)
                {
                    Response.Redirect("Login.aspx", true);
                }
                ddlNewsType.DataSource = type.GetNewsType();
                ddlNewsType.DataTextField = "TypeName";
                ddlNewsType.DataValueField = "TypeID";
                ddlNewsType.DataBind();
            }
        }
 
       protected void btnSave_Click(object sender, EventArgs e)
       {
            model.Title = txtTitle.Text.Trim();
            model.TypeID = Convert.ToInt32(ddlNewsType.SelectedItem.Value);
            model.Content = ftbContent.Text.ToString();

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;

            if (bll.AddNews(model) > 0)
            {
                mLog.OPInfo = "标题为" + txtTitle.Text.Trim() + "的新闻发布成功";
                if (chkAddContinue.Checked == true)
                {
                    MyMessageBox.MessageBox("新闻已经成功发布", this.Page, "NewsInsert.aspx");
                }
                else
                    //必须转到Right.aspx这一页，不能转到Index.aspx
                    MyMessageBox.MessageBox("新闻已经成功发布", this.Page, "Right.aspx");
            }
            else
            {
                mLog.OPInfo = "标题为" + txtTitle.Text.Trim() + "的新闻发布失败";
                MyMessageBox.MessageBox("新闻发布失败", this.Page);
            }
            bLog.AddLog(mLog);
       }
    }
}
