﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class Password : System.Web.UI.Page
    {
        M_User model = new M_User();
        B_User bll = new B_User();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            lblUserID.Text = Session["UserID"].ToString();
        }

        protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
        {
            model.UserID = Session["UserID"].ToString();
            model.Password = txtOldPwd.Text.Trim();
            args.IsValid = bll.CheckUser(model);
        }

        protected void btnConfirm_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                M_SysLog mLog = new M_SysLog();
                B_SysLog bLog = new B_SysLog();
                mLog.UserIP = ClientInfo.GetUserIP();
                mLog.URL = Request.Url.AbsoluteUri.ToString();
                mLog.Account = Session["UserID"].ToString();
                mLog.UserType = 0;

                model.UserID = lblUserID.Text;
                model.Password = txtNewPwd.Text.Trim();
                if (bll.ChangePassword(model) > 0)
                {
                    mLog.OPInfo = "密码修改成功";
                    MyMessageBox.MessageBox("密码修改成功", this.Page);
                }

                else
                {
                    mLog.OPInfo = "密码修改失败";
                    MyMessageBox.MessageBox("密码修改失败", this.Page);
                }
                bLog.AddLog(mLog);
            }
        }
    }
}
