﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class ProductInsert : System.Web.UI.Page
    {
        M_Product model = new M_Product();
        B_Product bll = new B_Product();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            string Filename = "";
            string Suffix = "";
            string NewFileName = "";
            //定义上传文件的类型字符串
            string Filetype = ".gif,.jpg";

            if (FileUploadImageUrl.FileName != "")
            {
                //获取文件名
                Filename = FileUploadImageUrl.FileName;
                //获取上传文件的扩展名比如.gif
                Suffix = Filename.Substring(Filename.LastIndexOf(".")).ToLower();

                //构造新文件路径和名称
                NewFileName = ReName.GetFilename() + Suffix;
                model.ImageUrl = NewFileName;
                if (Filetype.Contains(Suffix))
                {
                    //表示类型正确
                    FileUploadImageUrl.PostedFile.SaveAs(Server.MapPath("~/Admin/UploadFiles/Product/" + NewFileName));
                }
                else
                {
                    MyMessageBox.MessageBox("产品图片类型选择错误", this.Page);
                }
            }
            else
            {
                MyMessageBox.MessageBox("请选择要上传的产品图片", this.Page);
            }

            if (FileUploadBigImage.FileName != "")
            {
                //获取文件名
                Filename = FileUploadBigImage.FileName;
                //获取上传文件的扩展名比如.gif
                Suffix = Filename.Substring(Filename.LastIndexOf(".")).ToLower();
                //构造新文件路径和名称
                NewFileName = ReName.GetFilename() + Suffix;
                model.BigImage = NewFileName;
                if (Filetype.Contains(Suffix))
                {
                    //表示类型正确
                    FileUploadBigImage.PostedFile.SaveAs(Server.MapPath("~/Admin/UploadFiles/Product/" + NewFileName));
                }
                else
                {
                    MyMessageBox.MessageBox("产品大图片类型选择错误", this.Page);
                }
            }
            else
            {
                MyMessageBox.MessageBox("请选择要上传的产品大图片", this.Page);
            }
            model.ProductName = txtName.Text.Trim();
            model.Version = txtVersion.Text.Trim();
            model.Brand = txtBrand.Text.Trim();
            model.Description = txtDescription.Text.Trim();
            model.Price = Convert.ToInt32(txtPrice.Text.Trim());
            model.MOQ = Convert.ToInt32(txtMOQ.Text.Trim());

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            if (bll.AddProduct(model) > 0)
            {
                mLog.OPInfo = "产品名称为 " + txtName.Text.Trim() + " 添加成功";
                MyMessageBox.MessageBox("产品成功添加", this.Page, "ProductInsert.aspx");
            }
            else
            {
                mLog.OPInfo = "产品名称为 " + txtName.Text.Trim() + " 添加失败";
                MyMessageBox.MessageBox("产品添加失败", this.Page);
            }
            bLog.AddLog(mLog);
        }
    }
}
