﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;
namespace LZBS.Web.Admin
{
    public partial class ProductManage : System.Web.UI.Page
    {
        M_Product model = new M_Product();
        B_Product bll = new B_Product();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                BindToGridView();
            }
        }
        /// <summary>
        /// 给GridView绑定数据信息
        /// </summary>
        private void BindToGridView()
        {
            gvProduct.DataSource = bll.GetProductList();
            gvProduct.DataBind();
        }
        protected void gvProduct_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;

            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.ProductID = Convert.ToInt32(gvProduct.DataKeys[Index].Value.ToString());
            DataRow dr = bll.GetProductInfo(model);
            if (bll.DeleteProductByProductID(model) > 0)
            {
                mLog.OPInfo = "删除标题为 " + dr["ProductName"].ToString() + " 的产品信息成功";
                MyMessageBox.MessageBox("成功删除", this.Page);
            }
            else
            {
                mLog.OPInfo = "删除标题为 " + dr["ProductName"].ToString() + " 的产品信息失败";
                MyMessageBox.MessageBox("成功失败", this.Page);
            }
            bLog.AddLog(mLog);
            BindToGridView();
        }
        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvProduct_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            gvProduct.PageIndex = e.NewPageIndex;
            BindToGridView();
        }
    }
}
