﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class RecruitManage : System.Web.UI.Page
    {
        B_Recruit bll = new B_Recruit();
        M_Recruit model = new M_Recruit();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            BindToGridView(); 
        }
        /// <summary>
        /// 给GridView绑定数据信息
        /// </summary>
        private void BindToGridView()
        {
            GridView1.DataSource = bll.GetRecruitInfo();
            GridView1.DataBind();
        }
        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridView1.PageIndex = e.NewPageIndex;
            BindToGridView();
        }
        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.RecruitID = Convert.ToInt32(GridView1.DataKeys[Index].Value.ToString());

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;

            DataRow dr = bll.GetRecruitInfoByRecruitID(model);
            if (bll.DeleteRecruit(model) > 0)
            {
                mLog.OPInfo = "删除招聘  " + dr["RecruitObject"].ToString() + "  的信息成功";
                MyMessageBox.MessageBox("成功删除", this.Page);
            }
            else
            {
                mLog.OPInfo = "删除招聘  " + dr["RecruitObject"].ToString() + "  的信息失败";
                MyMessageBox.MessageBox("删除失败，请重试", this.Page);
            }
            bLog.AddLog(mLog);
            BindToGridView();
        }
    }
}
