﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class SysLogManage : System.Web.UI.Page
    {
        B_SysLog bll = new B_SysLog();
        M_SysLog model = new M_SysLog();
        //bool flag = false;//默认为管理全部，为true时表示检索的结果
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                BindToGridView();
            }
        }
        /// <summary>
        /// 
        /// </summary>
        private void BindToGridView()
        {
            if (ViewState["flag"] == null)
            {
                ViewState["flag"] = false;
            }
            if (Convert.ToBoolean(ViewState["flag"]) == false)
                GridView1.DataSource = bll.GetAllSysLog();
            else
            {
                model.StartTime = Convert.ToDateTime(txtStartTime.Text.Trim());
                model.EndTime = Convert.ToDateTime(txtEndTime.Text.Trim()).AddDays(1);
                model.UserType = Convert.ToInt32(ddlUserType.SelectedValue);
                GridView1.DataSource = bll.GetSysLogByCondition(model);
            }
            GridView1.DataBind();
        }
        /// <summary>
        /// 删除被选择的项
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btnDelete_Click(object sender, EventArgs e)
        {
            CheckBox cb = new CheckBox();
            model.UserIP = ClientInfo.GetUserIP();
            model.URL = Request.Url.AbsoluteUri.ToString();
            model.Account = Session["UserID"].ToString();
            model.UserType = 0;
            for (int i = 0; i < GridView1.Rows.Count; i++)
            {
                cb = (CheckBox)GridView1.Rows[i].FindControl("cbSingle");
                if (cb.Checked == true)
                {
                    model.LogID = Convert.ToInt32(GridView1.DataKeys[i].Value.ToString());
                    DataRow dr = bll.GetSysLogByLogID(model);
                    if (bll.DeleteLog(model) > 0)
                        model.OPInfo = "删除了" + dr["Account"].ToString() + "的" + dr["OPInfo"].ToString() + "操作信息";
                    else
                        model.OPInfo = "删除" + dr["Account"].ToString() + "的" + dr["OPInfo"].ToString() + "操作信息时出错";
                }
                bll.DeleteLog(model);
            }
            BindToGridView();
        }
        //在AutoPostBack="True"的条件下才可以触发oncheckedchanged事件
        /// <summary>
        /// 复选框变化时出发的事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void cbAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox cb = new CheckBox();
            //for (int i = 0; i <= GridView1.Rows.Count - 1; i++)
            //{
            //    cb = (CheckBox)GridView1.Rows[i].FindControl("cbSingle");
            //    if (cbAll.Checked == true)
            //    {
            //        cb.Checked = true;
            //    }
            //    else
            //    {
            //        cb.Checked = false;
            //    }
            //}

            if (cbAll.Checked == true)
            {
                for (int i = 0; i < GridView1.Rows.Count; i++)
                {
                    cb = (CheckBox)GridView1.Rows[i].FindControl("cbSingle");
                    cb.Checked = true;
                }
            }
            else
            {
                for (int i = 0; i < GridView1.Rows.Count; i++)
                {
                    cb = (CheckBox)GridView1.Rows[i].FindControl("cbSingle");
                    cb.Checked = false;
                }
            }
        }
        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            //保存CheckBox的状态
            RememberOldValues();
            GridView1.PageIndex = e.NewPageIndex;
            BindToGridView();
            //还原CheckBox的状态
            RePopulateValues();
            cbAll.Checked = false;
        }
        /// <summary>
        /// 保存CheckBox的状态
        /// </summary>
        private void RememberOldValues()
        {
            ArrayList LogIDList = new ArrayList();
            int index = -1;
            foreach (GridViewRow row in GridView1.Rows)
            {
                index = (int)GridView1.DataKeys[row.RowIndex].Value;
                bool result = ((CheckBox)row.FindControl("cbSingle")).Checked;
                if (ViewState["Status"] != null)
                {
                    LogIDList = (ArrayList)ViewState["Status"];
                }
                if (result == true)
                {
                    if(!LogIDList.Contains(index))
                        LogIDList.Add(index);
                }
                else
                {
                    LogIDList.Remove(index);
                }
            }
            if (LogIDList != null && LogIDList.Count > 0)
                ViewState["Status"] = LogIDList;
        }
        /// <summary>
        /// 还原CheckBox的状态
        /// </summary>
        private void RePopulateValues()
        {
            int index = -1;
            CheckBox cb = new CheckBox();
            ArrayList LogIDList = (ArrayList)ViewState["Status"];
            if (LogIDList != null && LogIDList.Count > 0)
            {
                foreach (GridViewRow row in GridView1.Rows)
                {
                    index = (int)GridView1.DataKeys[row.RowIndex].Value;
                    if (LogIDList.Contains(index))
                    {
                        cb = (CheckBox)row.FindControl("cbSingle");
                        cb.Checked = true;
                    }
                }
            }
        }
        /// <summary>
        /// 检索日志
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (string.Compare(txtEndTime.Text.Trim(), txtStartTime.Text.Trim()) < 0)
                MyMessageBox.MessageBox("起始时间必须小于结束时间", this.Page);
            else
                //Flag.flag = true;
                ViewState["flag"] = true;
            //model.StartTime = Convert.ToDateTime(txtStartTime.Text.Trim());
            //model.EndTime = Convert.ToDateTime(txtEndTime.Text.Trim()).AddDays(1);
            //model.UserType = Convert.ToInt32(ddlUserType.SelectedValue);
            //bll.GetSysLogByCondition(model);
            BindToGridView();
        }

        protected void btnAll_Click(object sender, EventArgs e)
        {
            //Flag.flag = false;
            ViewState["flag"] = false;
            BindToGridView();
        }

    }
}
