﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using System.IO;

namespace LZBS.Web
{
    public partial class DownLoad : System.Web.UI.Page
    {
        B_Download bll = new B_Download();
        M_Download model = new M_Download();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                anpPager.RecordCount = bll.GetFileList().Rows.Count;
                RptBind();
            }
        }
        /// <summary>
        /// 数据绑定
        /// </summary>
        private void RptBind()
        {
            PagedDataSource pdsList = new PagedDataSource();
            //对PagedDataSource 对象的相关属性赋值        
            pdsList.DataSource = bll.GetFileList().DefaultView;
            pdsList.AllowPaging = true;
            pdsList.PageSize = anpPager.PageSize;
            //pdsList.AllowCustomPaging = true;
            pdsList.CurrentPageIndex = anpPager.CurrentPageIndex - 1;
            rptDownLoad.DataSource = pdsList;
            rptDownLoad.DataBind();
        }
        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void anpPager_PageChanged(object sender, EventArgs e)
        {
            RptBind();
        }
        /// <summary>
        /// 下载
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void lbDown_Command(object sender, CommandEventArgs e)
        {
            model.FileID = Convert.ToInt32(e.CommandName.ToString());
            DataRow dr = bll.GetFileInfo(model);
            //string fileName = "My97DatePicker.rar";//客户端保存的文件名
            //string filePath = Server.MapPath("DownLoad/My97DatePicker.rar");//路径
            string fileName = dr["FileName"].ToString();//客户端保存的文件名
            string filePath = Server.MapPath("DownLoad/" + dr["NewFileName"].ToString());//路径

            //以字符流的形式下载文件
            FileStream fs = new FileStream(filePath, FileMode.Open);
            byte[] bytes = new byte[(int)fs.Length];
            fs.Read(bytes, 0, bytes.Length);
            fs.Close();
            Response.ContentType = "application/octet-stream";
            //通知浏览器下载文件而不是打开
            Response.AddHeader("Content-Disposition", "attachment;   filename=" + HttpUtility.UrlEncode(fileName, System.Text.Encoding.UTF8));
            Response.BinaryWrite(bytes);
            Response.Flush();
            Response.End();
        }
    }
}
